$ v=f$v('v')
$!+
$! DCL_ROUTINES.COM		Didier Trarieux-Lumiere (PRSIS3::DTL)
$!
$! X0.1 12-feb-1986	create, paste
$! X0.2 22-mar-1986	unpaste,put_char
$! X0.3 29-mar-1986	rewrite unpaste code to restore automatically any
$! 			part of other display which could be behind.
$!-			(debugging not completed...)
$ set noon
$ esc[0,8] = %O33
$ gr_on = esc + "(0"
$ gr_off = esc + "(B"
$ gr_line = -
"qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq"
$ blanks = -
"                                                                             "
$ stars = -
"*****************************************************************************"
$ if f$type(display_stack_pointer) .eqs. "" then -
  display_stack_pointer == 0					!init stack
$ service = "''p1'"						!what is asked
$ if service .eqs. "" then goto CALL_ERROR			!nothing
$ if f$locate("DCL$",service) .ne. 0 then goto SYNTAX_ERROR	!error
$ if f$extract(4,4,service) .eqs. "SMG$" then goto SMG		!SMG routines
$ goto UNKNOWN_SERVICE						!not yet impl.
$!+
$! window management ala SMG$
$!-
$SMG:
$ on error then goto UNKNOWN_ROUTINE				!syntax error
$ routine = f$extract(8,99,service)				!extract name
$ goto 'routine'						!branch
$!+
$! clear screen
$!-
$CLEAR_SCREEN:
$
$ write sys$output esc,"[H",esc,"[J"
$ exit
$!+
$! create display in memory, using global symbols
$!-
$CREATE_VIRTUAL_DISPLAY:
$
$ nrows  = 'P2							!nr of rows
$ if nrows .lt. 10 then nrows = "0" + "''nrows'"		!2chars please
$ ncols  = 'P3
$ if ncols .lt. 10 then ncols = "0" + "''ncols'"
$ d_name = P4							!display name
$ border = P5							!with/out
$ label  = P6							!NOT YET IMPL.
$ if nrows  .eqs. "" then goto SMG_CREATE_VIRTUAL_DISPLAY_ERROR
$ if ncols  .eqs. "" then goto SMG_CREATE_VIRTUAL_DISPLAY_ERROR
$ if d_name .eqs. "" then goto SMG_CREATE_VIRTUAL_DISPLAY_ERROR
$ if border .eqs. "" then border = "0"				!default
$ if label  .eqs. "" then label  = "0"				!default
$ create_index = 0						!init
$ root = "SMG$''d_name'_LINE"				!temp varaible  
$ SMG$'d_name'_SIZE :== 'nrows''ncols'			!window size
$SMG_CREATE_LOOP:
$
$ create_index = create_index + 1
$ if create_index .gt. nrows then goto SMG_NO_MORE_ROWS	!end of window
$ display = root + "''create_index'"			!build global var
$ 'display' == ""					!create it
$ goto SMG_CREATE_LOOP
$SMG_NO_MORE_ROWS:
$
$ if border .eqs. "0" then goto SMG_NO_BORDER
$ border_index = 1
$ display = root + "''border_index'"
$ 'display' == -
 gr_on + "l" + f$extract(0,ncols-2,gr_line) + "k" + gr_off	!update
$SMG_BORDER_LOOP:
$
$ border_index = border_index + 1
$ if border_index .eq. nrows then goto SMG_LAST_LINE	!last one is diff.
$ display = root + "''border_index'"
$ 'display' == -
 gr_on + "x" + gr_off + f$extract(0,ncols-2,blanks) + gr_on + "x" + gr_off
$ goto SMG_BORDER_LOOP
$SMG_LAST_LINE:
$
$ display = root + "''border_index'"
$ 'display' == -
 gr_on + "m" + f$extract(0,ncols-2,gr_line) + "j" + gr_off
$ exit
$!+
$! read display from memory and paste it onto the screen
$!-
$PASTE_VIRTUAL_DISPLAY:
$
$ lin = 'p2						!line number
$ if lin .lt. 10 then lin = "0" + "''lin'"
$ col = 'p3						!column number
$ if col .lt. 10 then col = "0" + "''col'"
$ d_name = P4						!display name
$ display_stack_pointer == display_stack_pointer + 1	!a new window
$ window'display_stack_pointer'_name == d_name		!window name in stack
$ SMG$'d_name'_POSITION :== 'lin''col'			!absolute position
$ size = SMG$'d_name'_SIZE				!get size of it
$ nrows = 'f$extract(0,2,size)
$ ncols = 'f$extract(2,2,size)
$ paste_index = 0
$ root = "SMG$''d_name'_LINE"
$PASTE_LOOP:						!display loop
$
$ paste_index = 'paste_index + 1
$ if paste_index .gt. nrows then exit			!no more rows
$ display = root + "''paste_index'"
$ write sys$output esc,"[''lin';''col'f",'display'	!paint line
$ lin = lin + 1						!next line
$ goto PASTE_LOOP
$!+
$! routine to paste a particular line of a given window
$!-
$PASTE_PARTIAL_VIRTUAL_DISPLAY:
$
$ lin = 'P2						!starting position 
$ col = 'P3						!starting position
$ d_name = P4						!display name
$ paste_index = P5					!line to paste
$ size = SMG$'d_name'_SIZE				!display size
$ nrows = 'f$extract(0,2,size)				!rows number
$ ncols = 'f$extract(2,2,size)				!columns nr
$ root = "SMG$''d_name'_LINE"				!transfer variable
$ display = root + "''paste_index'"			!global var name
$ write sys$output esc,"[''lin';''col'f",'display'	!paint it
$ exit							!done
$!+
$! unpaste function. Actually removes the window by painting blanks.
$!-
$UNPASTE_VIRTUAL_DISPLAY:
$
$ lin = 'p2						!display position 
$ p2_lin = lin						!save initial value
$ col = 'p3						!display position 
$ d_name = P4						!display name
$ size = SMG$'d_name'_SIZE				!display size
$ nrows = f$extract(0,2,size) 				!number of rows
$ ncols = f$extract(2,2,size) 				!number of columns
$!+
$! first check if window may overstrike another one, to repaint it.
$!-
$ if display_stack_pointer .le. 1 then goto NO_OVERSTRIKE !no
$ display_stack_pointer == display_stack_pointer - 1	!decrement stack
$ ovw_name = window'display_stack_pointer'_name 	!pop window name
$ if ovw_name .eqs. d_name then goto NO_OVERSTRIKE 	!same display
$ unpasted_window_end = lin + nrows - 1			!absolute end of displ.
$!+
$! now check which lines are to be repaint
$!-
$ ovw_start_line = f$extract(0,2,SMG$'ovw_name'_POSITION) !absolute line #
$ offset = ovw_start_line - 1				!shift abs/rel pos.
$ ovw_end_line = 'ovw_start_line' + f$extract(0,2,SMG$'ovw_name'_SIZE) !end
$ ovw_end_line = ovw_end_line - 1			!absolute end line #
$ if 'lin .gt. 'ovw_end_line then goto NO_OVERSTRIKE	!window is under
$OVERSTRIKE_LOOP:
$
$ if 'ovw_start_line .gt. 'ovw_end_line then goto NO_OVERSTRIKE !no more
$ if 'ovw_start_line .gt. 'unpasted_window_end then goto NO_OVERSTRIKE !no more
$ if 'ovw_start_line .eq. 'lin then goto MARK_FOR_REPAINT
$ if 'ovw_start_line .lt. 'lin then ovw_start_line = ovw_start_line + 1 !next
$ if 'ovw_start_line .gt. 'lin then lin = lin + 1 	!next
$ goto OVERSTRIKE_LOOP					!check next one
$MARK_FOR_REPAINT:
$
$ line_nr = lin - offset				!relative line #
$ repaint_line'lin'=smg$'ovw_name'_line'line_nr'	!record line
$ lin = lin + 1						!next line 
$ ovw_start_line = ovw_start_line + 1			!next overstr line
$ goto OVERSTRIKE_LOOP					!next check
$!+
$! no previous display. we just remove this one
$!-
$NO_OVERSTRIKE:
$
$ lin = p2_lin						!restore value
$ unpaste_index = 0					!init loop
$ display = f$extract(0,ncols,blanks)			!blanks
$UNPASTE_LOOP:
$ unpaste_index = unpaste_index + 1
$ if unpaste_index .gt. nrows then exit			!no more
$ write sys$output esc,"[''lin';''col'f",display	!paint blanks
$ if f$type(repaint_line'lin') .eqs. "" then goto next_line !no line to repaint
$ rlin = lin						!position
$ rcol = f$extract(2,2,SMG$'ovw_name'_POSITION)		!position
$ write sys$output esc,"[''rlin';''rcol'f",repaint_line'lin'
$NEXT_LINE:
$ lin = lin + 1						!next line
$ goto UNPASTE_LOOP
$!+
$! write line into window
$!-
$PUT_LINE:
$
$ text = "''p2'"					!text to be written
$ lin = 'p3						!position
$ col = 'p4						!position
$ d_name = P5						!display name
$ size = SMG$'d_name'_SIZE				!display size
$ nrows = 'f$extract(0,2,size) 
$ ncols = 'f$extract(2,2,size) 
$ if lin .eq. 1 then goto SMG_INV_LINE_FOR_PUT		!border line
$ if lin .eq. nrows then goto SMG_INV_LINE_FOR_PUT	!border line
$ if lin .gt. nrows then goto SMG_OUT_OF_WINDOW		!no such position
$ if col .eq. 1 then goto SMG_INV_COL_FOR_PUT		!border line
$ if col .eq. ncols then goto SMG_INV_COL_FOR_PUT	!border line
$ if col .gt. ncols then goto SMG_OUT_OF_WINDOW		!no such position
$ line = SMG$'d_name'_LINE'lin'				!get current value
$ text_length = f$length(text)
$ if text_length .gt. (ncols-2) then text = f$extract(0,ncols-2,stars) !overflow
$ if text_length .gt. (ncols-2) then text_length = (ncols-2)
$ line = "''f$extract(0,6+col-1,line)'" + "''f$extract(0,text_length,text)'" + -
  "''f$extract(6+col-1+text_length,99,line)'"
$ SMG$'d_name'_LINE'lin' == line			!update line value
$ exit
$!+
$! ERROR border line for PUT
$!-
$SMG_INV_LINE_FOR_PUT:
$ write sys$output -
"%DCL$SMG-E-BORDERLINE, requested line for PUT is a border line"
$ exit
$!+
$! ERROR border column for PUT
$!-
$SMG_INV_COL_FOR_PUT:
$ write sys$output -
"%DCL$SMG-E-BORDERCOL, requested column for PUT is a border column"
$ exit
$!+
$! ERROR position for PUT is outside of window
$!-
$SMG_OUT_OF_WINDOW:
$ write sys$output -
"%DCL$SMG-E-OUTSIDE, requested position for PUT is outside of window"
$ exit
$!+
$! ERROR missing parameters for window creation
$!-
$
$SMG_CREATE_VIRTUAL_DISPLAY_ERROR:
$ write sys$output -
"%DCL$SMG-E-CREATERR, one or more parameters are missing during call"
$ exit
$!+
$! ERROR service unknown or syntax error in service name
$!-
$UNKNOWN_SERVICE:
$
$ write sys$output -
"%DCL$MAIN-E-UNKNOWN, the requested service does not exist. Check spelling"
$ exit
$!+
$! error in call. no P1 parameter 
$!-
$CALL_ERROR:
$
$ write sys$output -
"%DCL$MAIN-E-INVCALL, this procedure is a set of subroutines to be called"
$ exit
$!+
$! error in call. The syntax for parameter P1 is incorrect
$!-
$SYNTAX_ERROR:
$
$ write sys$output -
"%DCL$MAIN-E-SYNTAX, incorrect call syntax. Should start with dcl$"
$ exit
