$! SDCL  : Preprocesseur structure DCL 1.0 -- INSTALL_UTIL.CDCL
$!
$!  ++									      
$!  Nom                                                                        
$! 		INSTALL_UTIL.CDCL                                             
$!                                                                             
$!  Description                                                                
$! 	Procdure de controle de l'existance de l'arborescence ULT$...        
$! 	Si celle-ci n'existe pas, elle propose sa cration. Si l'utilisateur  
$! 	refuse cette cration, il a encore la ressource de redfinir les noms 
$! 	logiques UTL$... utiliss.                                            
$! 	Cette redfinition peut etre faite au niveau de l'utilisateur ou du   
$! 	systme.                                                              
$!                                                                             
$!  Utilisation                                                                
$!  	@INSTALL_UTIL                                                         
$! 	Cette procedure est lancee par les procedures d'installation des      
$! 	logiciels LAL							      
$!                                                                             
$!  Privilges ventuels                                                       
$! 	Cration de directories.                                              
$! 	Dfinition de noms logiques.                                          
$! 	Copie des fichiers dans les directories de receptions.                
$!                                                                             
$!  Parametres                                                                 
$! 	La procedure n'attent pas de parametre en entree.                     
$! 	En sortie, elle definie un status de sortie                           
$! 		Ce status est 1, si le nom logique UTL$SYSTEM a pu etre       
$! 		definie                                                       
$! 		Le status est 0, si l'utilisateur ne veut pas creer	      
$! 		l'arborescence						      
$! 		En cas d'erreur, le code d'erreur est retourne		      
$!                                                                             
$!  Cration                                                                   
$! 	22 Avril 1986 : JN Albert - LAL                                       
$!                                                                             
$!  Modification                                                               
$!  --                                                                         
$!  Existance des noms logiques UTL$SYSROOT, UTL$SYSTEM                        
$    utl_sysroot = F$Edit(F$Logical("UTL$SYSROOT"), "TRIM")
$    utl_system  = F$Edit(F$Logical("UTL$SYSTEM"),  "TRIM")
$!  Le nom logique existe - Pas de probleme   
$    if (.not.(utl_sysroot .nes. "" .and. utl_system .nes. "")) then goto 23000
$    Exit 1
$ 23000: 
$!  Noms logiques non dfinis						
$    Type SYS$INPUT

 	Les noms logiques UTL$SYSROOT ou UTL$SYSTEM ne sont pas definis.

 La structure des directories UTL$... est :

		Disque --->  [Racine]		: UTL$SYSROOT
			---------+---------
			|        |        |
		     [sysmgr] [sysexe] [syshlp] : UTL$MANAGER
						  UTL$SYSTEM
						  UTL$HELP

 Il est possible de :

	Definir le nom logique UTL$SYSROOT au niveau SYSTEM

	Definir le nom logique UTL$SYSROOT au niveau PROCESS

            Attention, dans ces deux derniers cas, le directory destine a
         contenir la racine UTL$SYSROOT doit deja exister

$    inquire create_dir "Voulez-vous creer l'arborescence UTL$... (Y/N) "
$    if (.not.(create_dir)) then goto 23002
$! 	Creation de l'arborescence   
$    Type Sys$Input

   Par defaut, l'arborescence est definie par :

            disque         ---      SYS$SYSDEVICE
            racine         ---      [UTIL]
$ 23004: 
$    
$    Inquire Disque "Nom du disque (SYS$SYSDEVICE) "
$    if (.not.(Disque .eqs. "")) then goto 23007
$    Disque = "SYS$SYSDEVICE"
$    goto 23006
$    goto 23008
$ 23007: 
$    if (.not.(F$Getdvi(Disque,"EXISTS"))) then goto 23009
$    Flg_Avl = F$Getdvi(Disque,"AVL")
$    Flg_Dir = F$Getdvi(Disque,"DIR")
$    if (.not.(Flg_Avl .and. Flg_Dir)) then goto 23011
$    goto 23006
$ 23011: 
$ 23009: 
$    write sys$output "Disque non utilisable !"
$ 23008: 
$ 23005: 
$    
$    goto 23004
$ 23006: 
$    Inquire Racine "Nom directory de la racine UTL$SYSROOT (UTIL) "
$    if (.not.(Racine .eqs. "")) then goto 23013
$    Racine = "UTIL"
$ 23013: 
$    Option = "SYSTEM"
$    goto 23003
$ 23002: 
$    inquire Def_Sys "Voulez-vous definir UTL$SYSROOT au niveau SYSTEM (Y/N) "
$    if (.not.(Def_Sys)) then goto 23015
$    Option = "SYSTEM"
$    goto 23016
$ 23015: 
$    inquire Def_Prc  "Voulez-vous definir UTL$SYSROOT au niveau PROCESS (Y/N) "
$    if (.not.(Def_Prc)) then goto 23017
$    Option = "PROCESS"
$    goto 23018
$ 23017: 
$! **********************************************
$! 	Impossible de definir UTL$SYSROOT	
$! 						
$! 		Sortie avec STATUS d'erreur	
$! **********************************************
$    Write Sys$Output "Impossible d'installer UTL$..."
$    Exit 0
$ 23018: 
$ 23016: 
$ 23019: 
$    
$    if (.not.(Def_Sys)) then goto 23022
$    Inquire Disque "Nom du disque (SYS$SYSDEVICE) "
$    if (.not.(Disque .eqs. "")) then goto 23024
$    Disque = "SYS$SYSDEVICE"
$ 23024: 
$    goto 23023
$ 23022: 
$    Inquire Disque "Nom du disque (SYS$DISK) "
$    if (.not.(Disque .eqs. "")) then goto 23026
$    Disque = "SYS$DISK"
$ 23026: 
$ 23023: 
$    if (.not.(F$Getdvi(Disque,"EXISTS"))) then goto 23028
$    Flg_Avl = F$Getdvi(Disque,"AVL")
$    Flg_Dir = F$Getdvi(Disque,"DIR")
$    if (.not.(Flg_Avl .and. Flg_Dir)) then goto 23030
$    goto 23021
$ 23030: 
$ 23028: 
$    write sys$output "Disque non utilisable !"
$ 23020: 
$    
$    goto 23019
$ 23021: 
$ 23032: 
$    
$ 23035: 
$    Inquire Racine  "Nom du directory UTL$SYSROOT [Pas de defaut] "
$ 23036: 
$    if( Racine .eqs. "" ) then goto 23035
$ 23037: 
$    Racine = Racine - "[" - "]"
$    Disque = Disque - ":"
$    Open/Write/Error=Direct_err Tst 'disque':['racine']TEST.TMP
$    Close Tst
$    Delete 'disque':['racine']TEST.TMP;
$    goto 23034
$    DIRECT_ERR:
$    Write Sys$Output ""
$    Write Sys$Output "Nom de directory incorrect"
$    Write Sys$Output ""
$ 23033: 
$    
$    goto 23032
$ 23034: 
$ 23003: 
$    Type SYS$INPUT

   Deux procedures de commandes peuvent etre placees dans UTL$SYSTEM pour
   faciliter la manipulation des utilitaires.

   UTIL.COM   - Definit un symbole permettant d'utiliser l'utilitaire comme
                une commande.
            Ex:
               UTIL @Edit_fontes
                     Definie le symbole 'EDIT_FONTES'

               On peut ensuite taper 
                           EDIT_FONTES 
               au lieu de 
                           @UTL$SYSTEM:EDIT_FONTES

   EXECUTE.COM - Lance directement l'execution d'un utilitaire
            Ex:
               EXECUTE Edit_Fontes

$    inquire procedure_utl  "Voulez-vous la copie de ces procedures dans UTL$SYSTEM (Y/N) "
$!    Creation de l'arborescence et definition des noms logiques   
$    on error then Exit $Status
$    write sys$output "Fin des choix"
$    disque = disque - ":"
$    racine = racine - "[" - "]"    
$    Write sys$output "Creation des directories et des noms logiques"
$    if (.not.(create_dir)) then goto 23038
$    create/directory 'disque':['racine']
$ 23038: 
$    Assign/'Option'/Translate=(Concealed,Terminal)  'disque':['racine'.]   UTL$SYSROOT:
$    Create/directory  UTL$SYSROOT:[SYSMGR]
$    Assign/'Option'   UTL$SYSROOT:[SYSMGR]   UTL$MANAGER
$    Create/directory  UTL$SYSROOT:[SYSEXE]
$    Assign/'Option'   UTL$SYSROOT:[SYSEXE]   UTL$SYSTEM
$    Create/directory  UTL$SYSROOT:[SYSHLP]
$    Assign/'Option'   UTL$SYSROOT:[SYSHLP]   UTL$HELP
$!  Creation du fichier de definition   
$    write sys$output "Creation du fichier de Startup"
$    Open/Write utl Utlstartup.com
$    Write utl "$!"
$    Write utl "$! Nom"
$    Write utl "$!         UTLSTARTUP.COM"
$    Write utl "$! Description"
$    Write utl "$!   Definition des noms logiques UTL$..."
$    Write utl "$!"
$    Write utl "$! Creation "
$    Write utl "$!    ", F$Cvtime("TODAY","ABSOLUTE","DATE"), " : ", F$Getjpi("","USERNAME")
$    Write utl "$!"
$    Write utl "$ Assign/",Option,"/Translate=(Concealed,Terminal) ", disque, ":[", racine, ".]   UTL$SYSROOT:"
$    Write utl "$ Assign/",Option,"    UTL$SYSROOT:[SYSMGR]   UTL$MANAGER"
$    Write utl "$ Assign/",Option,"    UTL$SYSROOT:[SYSEXE]   UTL$SYSTEM"
$    Write utl "$ Assign/",Option,"    UTL$SYSROOT:[SYSHLP]   UTL$HELP"
$    Write utl "$ Exit"
$    Close Utl
$!  Copie des procedures de definition  
$    write sys$output "Copie des procedures de definition"
$    Copy/log utlstartup.com UTL$MANAGER:
$    manager = racine + ".SYSMGR"
$    if (.not.(option .eqs. "SYSTEM")) then goto 23040
$    Type SYS$INPUT

   Le fichier UTL$MANAGER:UTLSTARTUP.COM contient les definitions des noms 
   logiques UTL$... Il peut etre appelle depuis la procedure
   SYS$MANAGER:SYSTARTUP.COM pour etre pris en compte a chaque demarrage
   du VAX par la ligne :

$    goto 23041
$ 23040: 
$    Type SYS$INPUT

   Le fichier UTL$MANAGER:UTLSTARTUP.COM contient les definitions des noms 
   logiques UTL$... Il peut etre appelle dans votre LOGIN.COM pour
   etre pris en compte a chaque login par la ligne :

$ 23041: 
$    write sys$output "		$  @",disque,":[",manager,"]UTLSTARTUP.COM"
$    if (.not.(procedure_utl)) then goto 23042
$    Copy util.com,execute.com UTL$SYSTEM
$    Type Sys$Input

   Les procedures UTIL.COM et EXECUTE.COM sont copiees dans UTL$SYSTEM.
   Elles peuvent etre definie a chaque login par les lignes ajoutees au
$    if (.not.(option .eqs. "SYSTEM")) then goto 23044
$    write sys$output "   fichier SYS$MANAGER:SYLOGIN.COM"
$    goto 23045
$ 23044: 
$    write sys$output "   fichier SYS$LOGIN:LOGIN.COM"
$ 23045: 
$    write sys$output ""
$    write sys$output "	$ UTIL == ""@ UTL$SYSTEM:UTIL"" "
$    write sys$output "	$ EXE*CUTE == ""@ UTL$SYSTEM:EXECUTE"" "
$ 23042: 
$    write sys$output ""
$    write sys$output "Fin de l'installation des UTL$..."
$    Exit 1
