
#include <stdio.h>
#include <ctype.h>
#include <descrip.h>
   
/*
 *	EDIT_CARACTERE
 *		Transforme le caractere 'pixelise' en un fichier texte
 *	et appel l'editeur pour le modifie]
 */

		/*	Fichiers de travail	*/

	char *mod_name	= "EDIT_FONTES.MOD";
	char *org_name	= "EDIT_FONTES.ORG";

	FILE *org_file;			/* Fichier PXL - En entree	*/
 	FILE *mod_file;			/* Fichier ASCII - En sortie 	*/

	$DESCRIPTOR(dsc_tpu,
	    "TPU/SECTION=EDIT_FONTES/OUTPUT=EDIT_FONTES.MOD EDIT_FONTES.ORG");

		/* 	Matrice de travail	*/

	char matrice[64][132];


edit_caractere(buffer, column, row, next_pxl, pxm_ras)
char buffer[], next_pxl[];
int *column, *row, *pxm_ras;
{
	register return_status;                               
	register rd;
	/*
	 *	Transformation du caractere en une matrice de caracteres
	 *	sauvee dans un fichier
	 */
	if ((org_file = fopen(org_name, "w", "rat=cr")) == NULL)
	   {
		printf("Erreur d'ouverture du fichier %s\n",org_name);
		return;
	   }
    	pxltoasc(buffer, *column, *row);	/* Extrait le caractere	*/
	fclose(org_file);

	/*
	 *	Utilisation de TPU pour editer le caractere
	 *		Utilise une extension particuliere de EVE
	 */
	return_status=tpu$tpu(&dsc_tpu);	/* Edition du caractere*/
	if ( ! return_status )
	   {
		printf("Fatal erreur - TPU\n");
		exit(return_status);
	   }

	/*
	 *	Relecture de la matrice corrigee et rasterisation
	 */
   	if ((mod_file = fopen(mod_name, "r", "rat=cr")) == NULL)
	   {
		printf("Caractere non modifie\n");
		return;
	   }                                                 

	read_asc(column, row);
	rd = *pxm_ras;
	asctopxl(next_pxl, *column, *row, pxm_ras);
	fclose(mod_file);

	/*
	 *	Suppression des fichiers de tarvail
	 */

	delete(org_name);                               
	delete(mod_name);
}

/*
 *	PXL to ASCII
 *            
 *		Transcrit les rasters
 *	en matrices de points et sauve ces matrices sous forme ASCII dans
 *	un fichier.
 *
 */

pxltoasc(buffer,column,row)
char *buffer;
int column, row;
{                     
	register int l,b,k;            
	int nb_long_word,nb_byte;
	char *pt_ligne;

	/*                     
	 *	Nombre de mots du caractere
	 */

	nb_long_word = column / 32;
	if (nb_long_word*32 < column)
		++nb_long_word;
	nb_byte = 4*nb_long_word;

	for (l=0; l<row; l++)
	    {
		pt_ligne = matrice;

		for (k=0; k<nb_byte; k++,buffer++)
		    {         
			extract_raster(buffer, pt_ligne);
			for (b=0; b<8; b++,pt_ligne++)
				*pt_ligne = (*pt_ligne == 0 ?
						      	'.' : 'X');
 		     }
		matrice[0][column] = '\0';
 		fprintf(org_file,"%s\n", matrice);
	    }
}

/*                                         
 *	READ_ASC
 *		Lit le fichier modifie et le charge dans une matrice
 */
read_asc(k, l)
int *k, *l;
{
	register cl, lg;

	/*
	 *	Charge la matrice de points
	 */

  	*k = *l = lg = cl = 0;
	while (fgets(&matrice[cl][0], 132, mod_file))
	    {
		lg = strlen(&matrice[cl][0]);
		if (matrice[cl][lg-1] == '\n')
		   {
			matrice[cl][--lg] = '\0';
		   }
		if (lg > *k)
		   {
		       	*k = lg;
		   }
	     	cl++;
	    }
	*l = cl;

	for (--cl; cl>=0; cl--)
	    {
		for (lg=strlen(&matrice[cl][0]); lg<*k; lg++)
			matrice[cl][lg] = '.';
 	     	matrice[cl][*k] = '\0';
	    }
}

/*
 *	ASCII to PXL
 *            
 *		Transcrit la matrice de points en raster.
 *                  
 */

asctopxl(buffer,column,row,pxm_ras)
char *buffer;
int column, row, *pxm_ras;
{                     
	register int l,b,k;
	int nb_long_word,nb_byte, nb_bit;

	/*
	 *	Calcule le nombre de mots associes
	 */

	nb_long_word = column / 32;		/* Nombre de Long Word	*/
	if (nb_long_word*32 < column)
		++nb_long_word;
	nb_byte = 4*nb_long_word;		/* Exprime en octet	*/
	nb_bit = 32*nb_long_word;		/* Exprime en bit	*/

	/*                                                
 	 *	Normalise cette matrice
	 */
 	for (l=0; l<row; l++)
	    {
		for (k=0; k<column; k++)
			matrice[l][k] = (matrice[l][k] == '.' ||
					 matrice[l][k] == ' ') ? 0 : 1;
		for (k=column; k<nb_bit; k++)
		    {
			matrice[l][k] = 0;		/* Normalise */
		    }
	    }

	/*
	 *	Transcription du fichier
	 */

	for (l=0; l<row; l++)
	    {
		for (k=0; k<nb_byte; k++, buffer++, (*pxm_ras)++)
		    {
			comput_raster(buffer, &matrice[l][k*8]);
		     }
	    }
}
