/*
 *	PXL to ASCII
 *
 *		Ce programme lit un fichier PXL. Transcrit les rasters
 *	en matrices de points et sauve ces matrices sous forme ASCII dans
 *	un fichier.
 *
 *	D'apres le programme FFC.WEB de DEC et MODPX.C.
 *
 *	Version 1.0 - JNA - 24 Janvier 1985
 */

#include <stdio.h>
#include <ctype.h>


#define MAX_INPUT 128		/* Taille du buffer de commande	*/

	/* Buffer des caracteres	*/

#define	pxl_blocks	512
#define nb_blocks	512

#define pxl_buf_size	(pxl_blocks*nb_blocks)

typedef char PXL_BUF_TYPE[pxl_buf_size];

	     	/* Buffer de travail des donnees */

	PXL_BUF_TYPE pxl_buf;
	int pxl_len;
	int dsize, mag;

		/* Parametres des caracteres */

	int def_start, ras_start;
	int x_offset, y_offset, tfm_width;
	int row, column;


	char visible[9];

		/*	Fichiers de travail	*/

	FILE *pxl_file;			/* Fichier PXL - En entree	*/
 	FILE *asc_file;			/* Fichier ASCII - En sortie 	*/

#define	pxl_def_start(c)	(pxl_len - 4*517 + 16*c)

main(argc,argv)
int argc;
char *argv[];
{                     
	register int i,n,l,b,k;
	int nb_long_word,nb_byte;
	char *pxl_raster;

	if (argc < 3)
	   {
		printf("PXLTOASC file_name.pxl file_name.asc\n");
		exit();
	   }

	/*
	 *		Lecture du fichier PXL
	 */

	if ((pxl_file = fopen(argv[1],"r","rfm=fix","mrs=512")) == NULL)
	   {
		printf("Couldn't open file %s\n",argv[1]);
	    	exit();
	   }

	/*
	 *		Fichier de sortie
	 */

	if ((asc_file = fopen(argv[2],"w")) == NULL)
	   {
		printf("Couldn't open file %s\n",argv[2]);
	    	exit();
	   }

	/*
	 *		Lecture du fichier PXL et controle
	 */

	pxl_len=0;
	while ((pxl_len < pxl_buf_size) &&
		fread(&pxl_buf[pxl_len], pxl_blocks, 1, pxl_file) > 0)
			pxl_len += pxl_blocks; 
	fclose(pxl_file);

                                   
	if (pxl_len % 4 != 0) 
	   {                             
		printf("PXL file length not multiple of 4\n");
	   	printf("    PXL_LEN %d\n",pxl_len);
	   }
	if (pxl_to_long(0) != 1001)
	   { 
		printf("Initial PXL format id wrong\n");
	    	printf("Theorique %d - Lu %d\n",1001,pxl_to_long(0));
	   }
	l = pxl_len-4;
	while (l >= pxl_len-512)
	   {
		if (pxl_to_long(l) == 1001)
		   {
		    	pxl_len = l+4;
		    	l = -1;
		    }
		else
			l = l-4;
	   }    

	if (pxl_len < 16)
	   {
	    	printf("PXL file too short\n");
	   	printf("    PXL_LEN %d\n",pxl_len);
	   }

	if (pxl_to_long(pxl_len-4) != 1001)
	   {
		printf("Final PXL format id wrong\n");
	    	printf("Theorique %d - Lu %d\n",1001,pxl_to_long(pxl_len-4));
	   }

	/*
	 *	Transcription du fichier
	 */

	for (i=0; i<127; i++)
	    {

		def_start = pxl_len - 4*517 + 16*i;
		ras_start = 4*pxl_to_long(def_start+8);
		if (ras_start <= 0)
			continue;		/* Caractere suivant	*/

		if (ras_start > pxl_len)
		   {
			printf("For character %d Rasters out of file %d (%d)\n",
						i,ras_start,pxl_len);
			continue;
		   }

		column = pxl_to_word(def_start);    
		row = pxl_to_word(def_start+2);

		nb_long_word = column / 32;
		if (nb_long_word*32 < column)
			++nb_long_word;
 		nb_byte = 4*nb_long_word;

		pxl_raster = &pxl_buf[ras_start];
		fprintf(asc_file,"# %d\n",i);
		for (l=0; l<row; l++)
		    {
			for (n=0; n<nb_byte; n++,pxl_raster++)
			    {
				extract_raster(pxl_raster, visible);
				for (b=0; b<8; b++)
					visible[b] = (visible[b] == 0 ?
							'.' : 'X');
				visible[8] = '\0';
				fprintf(asc_file,"%s",visible);
			     }
			fprintf(asc_file,"\n");
		    }
	    }
	fclose(asc_file);
	fclose(pxl_file);
}
