
/*
 *	Traduction des formats de PXL en Integer et inversement
 */

#include <stdio.h>

	extern char pxl_buf[];
				/* Buffer de travail - Raster modifies */
	extern char pxm_raster[];
				/* Dictionnaire temporaire */
	extern char pxm_dict[];

	/* Definition de structures - Utiliser pour les traductions */
	/*	Dans l'hyphothese de la translation des octets sous VMS*/


union TYPE_LONG {
	     char c[4];
	long  int l;
	};

union TYPE_WORD {
	     char c[2];
	short int w;
	};
/*
	Routines de conversion entre les buffers en octets et des entiers
*/

pxl_to_long(c)
int c; 
{
	union TYPE_LONG mot;
	register i;

	for (i=0; i<4; i++)
		mot.c[i] = pxl_buf[c-i+3];

	return (mot.l);
}

pxl_to_word(c)
int c;
{
	union TYPE_WORD mot;
	register i;                      

	for (i=0; i<2; i++)             
		mot.c[i] = pxl_buf[c-i+1];

	return (mot.w);
}

pxm_to_long(c)
int c;
{
	union TYPE_LONG mot;
	register i;

	for (i=0; i<4; i++)
		mot.c[i] = pxm_raster[c-i+3];

	return (mot.l);
}

pxm_to_word(c)
int c;
{
	union TYPE_WORD mot;
	register i;

	for (i=0; i<2; i++)
		mot.c[i] = pxm_raster[c-i+1];

	return (mot.w);
}

dict_to_long(c)
int c;
{
	union TYPE_LONG mot;
	register i;

	for (i=0; i<4; i++)
		mot.c[i] = pxm_dict[c-i+3];

	return (mot.l);
}

dict_to_word(c)
int c; 
{
	union TYPE_WORD mot;
	register i;

	for (i=0; i<2; i++)
		mot.c[i] = pxm_dict[c-i+1];

	return (mot.w);
}

word_to_dict (offset, value)
int offset, value;
{                                           
        pxm_dict[offset] = value / 256;
        pxm_dict[offset+1] = value % 256;
	if (dict_to_word(offset) != value) 
 		printf(">>> La fonction WORD_TO_DICT est incorrecte\n");
}

long_to_dict (offset, value)
int offset, value;
{
        word_to_dict(offset, value / (256*256));    /* Attention a l'ordre*/
        word_to_dict(offset+2, value % (256*256));
	if (dict_to_long(offset) != value) 
		printf(">>> La fonction LONG_TO_DICT est incorrecte");
}

long_to_pxm (offset, value)
int offset, value;
{
	int i;
	int low_value, high_value;

	low_value = value / (256*256);
	high_value= value % (256*256);
	pxm_raster[offset+0] = low_value  / 256;
	pxm_raster[offset+1] = low_value  % 256;
	pxm_raster[offset+2] = high_value / 256;
	pxm_raster[offset+3] = high_value % 256;
	if (pxm_to_long(offset) != value)
	   {
		printf(">>> LONG_TO_PXM erreur pour l'offset %d\n",
						offset);
		printf("    Value       :%d\n",value);
		printf("    PXM_TO_LONG :%d\n",pxm_to_long(offset));
		for (i=offset; i<offset+3; i++) 
			printf("    RASTER [%d]  :%d\n",i, pxm_raster[i]);
	   }
}
