/*
 *	EXTRACT_RASTER
 * 		Transforme un octet raster en une chaine de points
 *		Format d'appel de FORTRAN
 */
extract_raster(r,visible)
char *r;
char visible[];
{
	register i;
	char rst;

	rst = *r;
	for (i=0; i<8; i++)
	    {
		visible[7-i] = rst & 1;
		rst >>= 1;
	    }
}


/*
 *	COMPUT_RASTER
 * 		Transforme une chaine de points en un octet raster.
 *		Format d'appel de FORTRAN
 */
comput_raster(r,visible)
char *r;
char visible[];
{
      	register i;

	*r = 0;
	for (i=0; i<8; i++)
	    {
		*r = (*r<<1) | (visible[i] & 1);
	    }
}
