$INCLUDE (:F4:V6NET.ENT)
	NAME	NET0
$INCLUDE (:F4:V6NET.LIT)
;
;
;
;	*******************************************************************
;	*                                                                 *
;	*                ROUTINES CONSOLE OPERATEUR                       *
;	*                ROUTINES TRANSMISSION SYSTEME HOTE               *
;;	*                ANALYSE ZONE OPTION DES COMMANDES                *
;;	*                CONVERSION BINAIRE-ASCII                         *
;	*                                                                 *
;	*******************************************************************
;
;
;	POINTS D'ENTREE
;	***************
;
;	WAITOU : ATTENTE I.O.C PRETE POUR ECRITURE
;	WAITIN : ATTENTE I.O.C PRETE POUR LECTURE
;	AFFI : AFFICHAGE D'UN MESSAGE SUR LA CONSOLE OPERATEUR
;	OUTCAR : AFFICHAGE D'UN CARACTERE SUR LA CONSOLE OPERATEUR
;	READC : LECTURE D'UNE COMMANDE SUR LA CONSOLE OPERATEUR
;	TABORT : TEST DEMANDE D'ARRET PAR L'OPERATEUR
;	EMCAR : EMISSION CARACTERE VERS SYSTEME HOTE
;	RECCAR : ATTENTE RECEPTION CARACTERE EMIS PAR SYSTEME HOTE
;	EMNAM  : EMISSION D'UN MESSAGE CONTENANT UN NOM DE FICHIER
;;	TOPT   : TEST PRESENCE OPTION ET EVALUATION VALEUR ASSOCIEE
;;	ASCI4  : CONVERSION BINAIRE ASCI SUR 4 CARACTERES
;
	PUBLIC	AFFI,READC,OUTCA,TABORT,WAITOU,WAITIN
	PUBLIC	EMCAR,RECCAR,EMNAM
;;	PUBLIC  TOPT,ASCI4
;
;
;	VARIABLES PUBLIQUES
;	*******************
;
;
;	ABORT : CODE D'ABORT DETECTE PAR LA PROCEDURE DE TEST DEMANDE D'ARRET
;	        PAR L'OPERATEUR : CETTE VARIABLE EST TESTEE DANS LE MODULE PRINCIPAL
;	        POUR VERIFIER SI L'OPERATEUR N'A PAS DEMANDE L'ARRET D'UNE COMMANDE
;	        MULTIFICHIER (EN FRAPPANT UN CARACTERE CTRL B)
;	        ELLE EST REMISE A ZERO A CHAQUE DEBUT DE COMMANDE
;
	PUBLIC	ABORT
;
	DSEG
;
ABORT:	DS	1
;
;
;
;	PROCEDURES EXTERNES
;	*******************
;
;	ISIS : POINT D'ENTREE DANS LE SYSTEME ISIS
;
	EXTRN	ISIS
;
;
;	VARIABLES EXTERNES
;	******************
;
;	ZREP : ZONE CONTENANT LA DERNIERE COMMANDE FRAPPE PAR L'OPERATEUR
;	ANAME: ZONE OU LE MODULE PRINCIPAL RANGE L'ADRESSE DEBUT DU NOM DE FICHIER
;	       QUE DOIT EMETTRE LA PROCEDURE EMNAM
;
	EXTRN	ZREP,ANAME
;
;
;	CARACTERES DE PROCEDURE DE TRANSMISSION
;	***************************************
;
ACK	EQU	06H
NACK	EQU	15H
;
;
;	VARIABLES LOCALES
;	*****************
;
;	CTO : COMPTEUR DE TEMPS (PROCEDURE RECCAR)
;	RCBL : BLOC PARAMETRE PASSE A ISIS POUR LECTURE CONSOLE
;	ACTL : LONGUEUR LUE A LA CONSOLE RETOURNEE PAR ISIS
;	STAT : STATUS RETOURNE PAR ISIS APRES UN READ CONSOLE
;	CAROPT : STOCKAGE TEMPORAIRE (PROCEDURE TOPT)
;
	DSEG
;
CTO:	DS	1
CAROPT:	DS	1
RCBL	EQU	$;		BLOC PARAMETRE POUR READ CONSOLE ISIS
	DW	1;			NUMERO D'UNITE ( 1=CONSOLE )
	DS	2;			ADRESSE DU BUFFER DE LECTURE
	DW	SBLECT;			TAILLE DU BUFFER DE LECTURE
	DW	ACTL;			ADR RETOUR LONGUEUR DE LA LIGNE LUE
	DW	STAT;			ADR RETOUR STATUS LECTURE
ACTL:	DS	2
STAT:	DS	2
;
;
WCO:	DW	0		; CB POUR WRITE CONSOLE
WACO:	DW	0		; BUFFER ADDRESS
WLCO:	DW	0		; LENGTH
	DW	STAT
;
;
;
;	PARAMETRES
;	**********
;
; CONSTANTE POUR TIME-OUT RECEPTION CARACTERE DEPUIS LE SYSTEME HOTE
VTO	EQU	20H
;
; TAILLE DU MESSAGE NOM DE FICHIER (VNET niveau 6)
SBC	EQU	60
;
; TAILLE BUFFER DE LECTURE COMMANDE
SBLECT	EQU	80
;
; CODE D'APPEL ISIS POUR GESTION CONSOLE OPERATEUR
READ	EQU	3
WRIT	EQU	4
;
;
;	CODES CARACTERES
;	****************
;
ABOR1	EQU	01H;	CTRL A
ABOR2	EQU	02H;	CTRL B
SLASH	EQU	'/'
VIRG	EQU	','
;
;
$EJECT
;
;	**************************************************************
;	*                                                            *
;	*              ROUTINES CONSOLE OPERATEUR                    *
;	*                                                            *
;	**************************************************************
;
	CSEG
;
;	ROUTINE ATTENTE IOC READY EN LECTURE
;	************************************
;
;	REGISTES DETRUITS: A,FLAGS
;
;
WAITIN	EQU	$
	IN	STCL
	ANI	BUSY
	CPI	OBF
	JNZ	WAITIN
	RET
;
;
;	ROUTINE ATTENTE IOC READY EN ECRITURE
;	*************************************
;
;	REGISTRE DETRUIT: A,FLAGS
;
WAITOU	EQU	$
	IN	STAF
	ANI	BUSY
	JNZ	WAITOU
	RET
;
;	SUBROUTINE D'AFFICHAGE MESSAGE SUR ECRAN
;	****************************************
;
;	EN ENTREE : H-L= ADRESSE DU MESSAGE A AFFICHER
;	                 LE MESSAGE DOIT SE TERMINER PAR 00H
;	REGISTRES MODIFIES : H-L,A,C,FLAGS
;
AFFI	EQU	$		;ARRET SUR CARACTERE NUL 
	PUSH	B
	SHLD	WACO		; MAJ ADRESSE BUFFER
	MVI	B,0		; INIT NBR OCTETS MESSAGE
AFF1:	MOV	A,M
	INX	H
	ANA	A
	JZ	AFF2		; SI FIN MESSAGE
	INR	B
	JMP	AFF1
AFF2:	MOV	A,B		; MAJ NBR OCTETS
	LXI	H,WLCO
	MOV	M,A
	MVI	C,WRIT		; WRITE SUR :CO:
	LXI	D,WCO
	CALL	ISIS
	POP	B
	RET
;
;
;	SUBROUTINE D'AFFICHAGE CARACTERE SUR ECRAN
;	******************************************
;
;	EN ENTREE : A=CARACTERE A AFFICHER
;	REGISTRES MODIFIES : A,C,FLAGS
;
OUTCA	EQU	$
	MOV	C,A	; SAVE CHARACTER
	CALL	WAITOU
	MVI	A,CRTC	; SEND WRITE CRT COMMAND
	OUT	STAF
	CALL	WAITOU
	MOV	A,C	; SEND CHARACTER
	OUT	DAAF
	RET
;
;	SUBROUTINE LECTURE MESSAGE SUR LA CONSOLE
;	*****************************************
;
;	EN ENTREE : H-L= ADRESSE DE RANGEMENT DU MESSAGE LU
;	REGISTRES MODIFIES : H-L,B-C,A,FLAGS
;
;	LA LECTURE SUR LA CONSOLE EST ASSUREE PAR LE SYSTEME ISIS
;
;
READC	EQU	$
	SHLD	RCBL+2;		RANGER ADR BUFFER DANS BLOC PARAMETRE POUR ISIS
;
;	RAZ DU BUFFER DE RANGEMENT
;
	XRA	A
	MVI	B,SBLECT
READ1:	MOV	M,A
	INX	H
	DCR	B
	JNZ	READ1
;
;	APPEL ISIS POUR LECTURE CONSOLE
;
	MVI	C,READ
	LXI	D,RCBL
	CALL	ISIS
	RET
;
$EJECT
;
;
;	ROUTINE DE TEST DEMANDE D'ARRET PAR L'OPERATEUR
;	***********************************************
;
;	CETTE ROUTINE SCRUTE L'ETAT DU CLAVIER OPERATEUR : SI UN CARACTERE Y A ETE
;	FRAPPE CE CARACTERE EST LU
;	SI CE CARACTERE EST CTRL A OU CTRL B IL EST INTERPRETE COMME UNE DEMANDE
;	D'ABORT DE LA TACHE EN COURS
;	L'INDICATEUR ABORT EST ALORS POSITIONNE A 1 (CTRL A :ABORT FICHIER)
;	OU 2 (CTRL B :ABORT LISTE DE FICHIER)
;	EN SORTIE : Z=1 SI PAS DE DEMANDE D'ARRET
;	            Z=0 SI DEMANDE D'ARRET
;	REGISTRES MODIFIES : A,FLAGS
;
;
TABORT	EQU	$
	CALL	WAITOU
	MVI	A,KEYS	; SEND READ KEYBOARD STATUS COMMAND
	OUT	STCL
	CALL	WAITIN
	IN	DACL
	ANI	PRESEN
	RZ		; EXIT SI RIEN RECU DU CLAVIER
	CALL	WAITOU
	MVI	A,KEYC	; SEND READ KEYBOARD COMMAND
	OUT	STCL
	CALL	WAITIN
	IN	DACL	;READ CHARACTER
	ANI	7FH
	MVI	C,1
	CPI	ABOR1
	JZ	TAB1
	MVI	C,2
	CPI	ABOR2
	JZ	TAB1
	MVI	A,0;		SI CARACTERE RECU <>ABOR1 ET <>ABOR2
	ANA	A;		ALORS EXIT AVEC Z=1
	RET
TAB1:	MVI	A,1
	ANA	A;		EXIT AVEC Z=0
	MOV	A,C
	STA	ABORT;		POSITIONNER INDICATEUR D'ABORT
	RET
;
;
$EJECT
;
;
;	***************************************************************
;	*                                                             *
;	*       ROUTINES TRANSMISSION PROCESSEUR HOTE                 *
;	*                                                             *
;	***************************************************************
;
;
;	ROUTINE D'EMISSION CARACTERE
;	*****************************
;
;	EN ENTREE : A=CARACTERE A EMETTRE
;	REGISTRES MODIFIES : A,C,FLAGS
;
;
EMCAR	EQU	$
	MOV	C,A
EMCAR0:	IN	STLE
	ANI	PRET
	JZ	EMCAR0
	MOV	A,C
	OUT	DALE
	RET
;
;
;	ROUTINE DE RECEPTION CARACTERE
;	******************************
;
;	EN SORTIE : A = CARACTERE RECU 
;	            SI AUCUN CARACTERE N'A ETE RECU AU BOUT DU DELAI DETERMINE
;	            PAR LA CONSTANTE VTO : INDICATION D'INCIDENT :
;	            CARRY=1
;	REGISTRES MODIFIES : H-L,A,FLAGS
;
;
RECCAR	EQU	$
	MVI	A,VTO;		INIT COMPTE POUR TIME-OUT
	STA	CTO
	LXI	H,0
REC1:	IN	STLR
	ANI	RECU
	JNZ	REC2;		OK CARACTERE RECU
	INX	H
	MOV	A,H
	ORA	L
	JNZ	REC1
	LDA	CTO
	DCR	A
	STA	CTO
	JNZ	REC1
	STC	;		SORTIE SUR TIME-OUT
	RET
REC2:	IN	DALR
	ANI	0FFH;		POUR RESET CARRY FLAG
	RET
;
;
;	ROUTINE D'ENVOI MESSAGE NOM DE FICHIER
;	**************************************
;
;	L'ADRESSE DU NOM DE FICHIER A COMMUNIQUER AU HOST A ETE RANGEE AVANT
;	L'APPEL DANS LA VARIABLE ANAME
;
;	LA LONGUEUR DU MESSAGE EMIS EST DETERMINEE PAR LA CONSTANTE SBC
;	ATTENTION : CETTE LONGUEUR FAIT PARTIE DES CONVENTIONS DE TRANSMISSION
;	ENTRE LE PROCESSEUR NET ET LE SYSTEME HOTE :
;	NE PAS MODIFIER CETTE CONSTANTE SANS LA MODIFIER AUSSI DANS LE LOGICIEL
;	SUR LE SYSTEME HOTE
;
;	EN SORTIE : Z = 1 : SI NOM DE FICHIER BIEN EMIS ET ACCUSE POSITIF
;	                    RECU DU SYSTEME HOTE
;	            Z = 0 : SI PAS D'ACCUSE RECU DU SYSTEME HOTE OU ACCUSE INCORRECT
;
;
EMNAM	EQU	$
	MVI	B,SBC
	LHLD	ANAME;		EMETTRE LE BUFFER CONTENANT LE NOM DU FICHIER
FEMD1:	MOV	A,M
	CALL	EMCAR
	INX	H
	DCR	B
	JNZ	FEMD1
	CALL	RECCAR;	ATTENDRE ACCUSE DE RECEPTION
	JC	EMN1;	PAS D'ACCUSE RECU (TIME-OUT RECEPTION)
	CPI	ACK;	SI ACCUSE POSITIF ALORS
	RZ	;		RETOUR AVEC Z=1
EMN1:	MVI	A,1;	SI PAS D'ACCUSE RECU
	ANA	A;		RETOUR AVEC Z=0
	RET
;
;
$EJECT
;;
;;	*****************************************************************
;;	*                                                               *
;;	*            ANALYSE ZONE OPTION DES COMMANDES OPERATEUR        *
;;	*                                                               *
;;	*****************************************************************
;;
;;
;;	TEST PRESENCE OPTION ET EVALUATION VALEUR ASSOCIEE
;;	**************************************************
;;
;;	LA SYNTAXE DES OPTIONS EST :
;;	<ZONE OPTION> = <VIDE>
;;	<ZONE OPTION> = <OPTION> <ZONE OPTION>
;;	<OPTION>      = <SLASH> <NOM> <ESPACE> <NBRE HEXA>
;;	<SLASH>       = /
;;	<NOM>         = <CARACTERE ALPHA>
;;	<NBRE HEXA>   = <CHIFFRE HEXA> <CHIFFRE HEXA> <CHIFFRE HEXA> <CHIFFRE HEXA>
;;
;;	CETTE PROCEDURE DETERMINE SI L'OPTION DONT LE NOM EST PASSE EN PARAMETRE
;;	EST PRESENTE DANS LA ZONE COMMANDE (ZONE ZREP)
;;	SI OUI : LA VALEUR HEXA ASSOCIEE EST ANALYSEE ET SA VALEUR EST RETOURNEE
;;	A LA PROCEDURE APPELLANTE
;;
;;	EN ENTREE : A=CARACTERE OPTION RECHERCHE
;;	EN SORTIE :	C=1 SI ERREUR SYNTAXIQUE
;;			Z=1 SI OPTION PRESENTE
;;			H,L= VALEUR HEXA ASSOCIEE
;;	REGISTRES MODIFIES : B-C,D-E,H-L,A,FLAGS
;;
;;
;;
;;TOPT	EQU	$
;;	STA	CAROPT
;;	LXI	H,ZREP
;;TO1:	MOV	A,M
;;	INX	H
;;	ANA	A
;;	JZ	TO2;		OPTION ABSENTE
;;	CPI	SLASH
;;	JNZ	TO1
;;	MOV	B,M
;;	INX	H
;;	LDA	CAROPT
;;	CMP	B
;;	JNZ	TO1
;;	INX	H
;;	CALL	HEXA
;;	RC	;		RETOUR EN ERREUR
;;	XRA	A;		SET Z FLAG
;;	RET
;;TO2:	MVI	A,1
;;	ANA	A;		RESET Z FLAG SI OPTION ABSENTE
;;	RET
;;
;;	CONVERSION ASCII-BINAIRE
;;	************************
;;
;;	EN ENTREE : H-L=ADRESSE DE LA ZONE A CONVERTIR
;;	                CETTE ZONE DOIT CONTENIR 4 CARACTERES HEXA
;;	EN SORTIE : SI PAS D'ERREUR : CARRY=0 H-L=VALEUR HEXA CONVERTIE
;;	            SI ERREUR       : CARRY=1
;;	REGISTRES MODIFIES : C,D-E,H-L,A,FLAGS
;;
;;
;;HEXA	EQU	$
;;	LXI	D,0
;;COL2:	MOV	A,M
;;	INX	H
;;	CPI	CR
;;	JZ	COL3
;;	CPI	SLASH
;;	JZ	COL3
;;	CPI	VIRG
;;	JZ	COL3
;;	ADI	0D0H
;;	CPI	0AH
;;	JC	COL25
;;	ADI	0EFH
;;	CPI	06H
;;	JC	COL24
;;	STC	;		ERREUR : SET CARRY
;;	RET
;;COL24:	ADI	0AH
;;COL25:	MOV	C,A
;;	MOV	A,D
;;	RLC
;;	RLC
;;	RLC
;;	RLC
;;	ANI	0F0H
;;	MOV	D,A
;;	MOV	A,E
;;	RRC
;;	RRC
;;	RRC
;;	RRC
;;	ANI	0FH
;;	ORA	D
;;	MOV	D,A
;;	MOV	A,E
;;	RLC
;;	RLC
;;	RLC
;;	RLC
;;	ANI	0F0H
;;	ORA	C
;;	MOV	E,A
;;	JMP	COL2
;;COL3:	XCHG
;;	RET
;;
;;
;;
;;$EJECT
;;
;;
;;
;;	CONVERSION DE 2 OCTETS EN ASCII
;;	*******************************
;;
;;	NBRE A CONVERTIR DANS (D,E)
;;	ADRESSE DE RANGEMENT DU RESULTAT DANS (H,L)
;;	REGISTRES MODIFIES : B-C,D-E,H-L,A,FLAGS
;;
;;ASCI4	EQU	$
;;	MOV	A,D
;;	CALL	ASC;	CONVERTIR ET RANGER OCTET DE POIDS FORT
;;	MOV	A,E
;;	CALL	ASC;	CONVERTIR ET RANGER OCTET DE POIDS FAIBLE
;;	RET
;;ASC	EQU	$
;;	CALL	ASCII;	CONVERSION
;;	MOV	M,B;	RANGER CHIFFRE HEXA POIDS FORT
;;	INX	H
;;	MOV	M,C;	RANGER CHIFFRE HEXA POIDS FAIBLE
;;	INX	H
;;	RET
;;
;;	ROUTINE DE CONVERSION OCTET EN ASCII
;;	************************************
;;
;;	EN ENTREE : OCTET A CONVERTIR DANS A
;;	EN SORTIE : RESULTAT DANS B,C
;;	REGISTRES MODIFIES : B-C,A,FLAGS
;;
;;ASCII	EQU	$
;;	PUSH	PSW
;;	CALL	HEXASC
;;	MOV	C,A
;;	POP	PSW
;;	RLC
;;	RLC
;;	RLC
;;	RLC
;;	CALL	HEXASC
;;	MOV	B,A
;;	RET
;;
;;	ROUTINE DE CONVERSION CHIFFRE HEXA EN ASCII
;;	*******************************************
;;
;;	EN ENTREE : CHIFFRE A CONVERTIR DANS A
;;	EN SORTIE : RESULTAT DANS A
;;	REGISTRES MODIFIE : A,FLAGS
;;
;;HEXASC	EQU	$
;;	ANI	0FH
;;	CPI	0AH
;;	JNC	HEX1
;;	ADI	'0'
;;	RET
;;HEX1:	ADI	'A'-0AH
;;	RET
;;
;;
	END
