$INCLUDE (:F4:V6NET.ENT)
	NAME	NET1
;
;
;			MODE TRANSPARENT
;			================
;
;	GERE UN BUFFER CIRCULAIRE DE 1024 OCTETS AVEC CONTROL S ET CONTROL Q
;		CONTROL S DECLENCHE A 850
;		CONTROL Q DECLENCHE A 50 (APRES UN CONTROL S)
;
;
$INCLUDE (:F4:V6NET.LIT)
;
	PUBLIC	TRANS
;
	EXTRN	CONTRO,EMCAR
;
	PUBLIC	BUFR,FINBUF
;
SIZE	EQU	1024
;
	DSEG
;
BUFR:	DS	SIZE		;BUFFER CIRCULAIRE
FINBUF	EQU	$
;
NCARMX	EQU	850
NCARMN	EQU	50
;
PTEBUF:	DS	2		;POINTEUR EN ECRITURE DANS LE BUFFER
PTLBUF:	DS	2		;POINTEUR EN LECTURE DANS LE BUFFER
BLOCAG:	DS	1		;=0 PAS DE BLOCAGE EN COURS
				;=1 BLOCAGE PAR CONTROL S EN COURS
CPTCAR:	DS	2		;COMPTEUR CARACTERE EN ATTENTE D'AFFICHAGE
;
AREC:	DS	2
ARET:	DS	2
STCLA:	DS	1
CARCLA:	DS	1
ITE:	DS	1
ITC:	DS	1
;
;
CTRLX	EQU	18H
CTRLS	EQU	13H
CTRLQ	EQU	11H
$EJECT
;
	CSEG
;
TRANS	EQU	$
	MVI	A,CR		; POUR OBTENIR PROMPT HOTE
	CALL	EMCAR
	XRA	A		; RAZ INDICATEURS TRAIT. EN COURS
	STA	ITE
	STA	ITC
	STA	BLOCAG
	LXI	H,ECRAN
	SHLD	AREC
	LXI	H,LSTAT		; ADR APPEL LECTURE STATUS CLAVIER
	SHLD	ARET
	LXI	H,BUFR		; RAZ POINTEURS ECRITURE ET LECTURE
	SHLD	PTEBUF
	SHLD	PTLBUF
	LXI	H,0
	SHLD	CPTCAR
;
;	ECOUTE LIGNE HOTE
;	*****************
;
TR0:	IN	STLR		; CARACTERE RECU SUR LIGNE HOTE ?
	ANI	RECU
	JZ	TR1		; NON : 
	IN	DALR		; LECTURE CARACTERE EMIS PAR HOTE
	ANI	7FH
	LHLD	PTEBUF		; SAUVEGARDE CARACTERE DANS BUFFER
	MOV	M,A
	INX	H		; PTEBUF = PTEBUF + 1
	SHLD	PTEBUF
	LHLD	CPTCAR
	INX	H		; CPTCAR = CPTCAR + 1
	SHLD	CPTCAR
;  verification borne NCARMX (nombre de caracteres max)
	MOV	A,H
	CPI	NCARMX / 256	;poids forts
	JNZ	TR05
	MOV	A,L
	CPI	NCARMX AND 0FFH
	JNZ	TR05
;  egalite => emission control S
TR06:	IN	STLR
	ANI	PRET
	JZ	TR06
	MVI	A,CTRLS
	OUT	DALR
	MVI	A,1
	STA	BLOCAG
	JMP	TR07
;
;  gestion buffer circulaire
TR05:
	LHLD	PTEBUF
	LXI	D,FINBUF
	MOV	A,H
	CMP	D
	JNZ	TR07
	MOV	A,L
	CMP	E
	JNZ	TR07
	LXI	H,BUFR
	SHLD	PTEBUF
;
TR07:
TR1:	LDA	ITE		; TRAIT. ECRAN EN COURS ?
	ANA	A
	JNZ	TR2		; OUI
	LDA	ITC		; TRAIT. CLAVIER EN COURS ?
	ANA	A
	JNZ	TR3		; OUI
; test buffer vide CPTCAR = 0
	LHLD	CPTCAR
	MOV	A,L
	ORA	H
	JNZ	TR2
TR3:	LHLD	ARET
	PCHL
TR2:	LHLD	AREC
	PCHL
$EJECT
;
;	AFFICHAGE ECRAN
;	***************
;
ECRAN:
	IN	STAF		; ATTENTE IOC PRET EN ECRITURE
	ANI	BUSY
	JNZ	TR0
	LXI	H,ITE		; INDIQUER TRAIT. ECRAN EN COURS
	INR	M
	MVI	A,CRTC		; DEMANDE ECRITURE CARACTERE SUR ECRAN
	OUT	STAF
TR22:	IN	STAF		; ATTENTE IOC PRET EN ECRITURE
	ANI	BUSY
	JZ	TR20		; OUI
	LXI	H,TR22
	SHLD	AREC
	JMP	TR0		; RETOUR ECOUTE HOTE
;
TR20:	LHLD	PTLBUF		; CARACTERE A AFFICHER
	MOV	A,M
	OUT	DAAF
	INX	H		; PTLBUF = PTLBUF + 1
	SHLD	PTLBUF
	XRA	A		; TRAIT. TERMINE !
	STA	ITE
	LHLD	CPTCAR
	DCX	H
	SHLD	CPTCAR
;  verification borne NCARMN
	LDA	BLOCAG
	ANA	A
	JZ	TR25		;pas de blocage en cours
	MOV	A,H
	CPI	NCARMN / 256	;poids forts
	JNZ	TR25
	MOV	A,L
	CPI	NCARMN AND 0FFH
	JNZ	TR25
;  egalite => emission control Q
TR26:	IN	STLR
	ANI	PRET
	JZ	TR26
	MVI	A,CTRLQ
	OUT	DALR
	XRA	A
	STA	BLOCAG
	JMP	TR07
;
;  gestion buffer circulaire
TR25:
	LHLD	PTLBUF
	LXI	D,FINBUF
	MOV	A,H
	CMP	D
	JNZ	TR27
	MOV	A,L
	CMP	E
	JNZ	TR27
	LXI	H,BUFR
	SHLD	PTLBUF
TR27:
	LXI	H,ECRAN
	SHLD	AREC
	JMP	TR0
;
$EJECT
;
;	LECTURE STATUS CLAVIER
;	**********************
;
LSTAT	EQU	$
	IN	STAF		; IOC PRET EN ECRITURE ?
	ANI	BUSY
	JNZ	TR0		; NON: RETOUR ECOUTE LIGNE HOTE
	LXI	H,ITC		; INDIQUER TRAIT. CLAVIER EN COURS
	INR	M
	MVI	A,KEYS		; DEMANDE LECTURE STATUS CLAVIER
	OUT	STCL
LS0:	IN	STCL		; IOC PRET EN LECTURE ?
	ANI	BUSY
	CPI	OBF		; ET CARACTERE DISPONIBLE ?
	JZ	LS1		; OUI
	LXI	H,LS0
	JMP	LS2
LS1:	IN	DACL
	STA	STCLA
	XRA	A		; TRAIT. TERMINE !
	STA	ITC
	LXI	H,LCLA		; INIT RETOUR SUR 'LECTURE CLAVIER'
LS2:	SHLD	ARET
	JMP	TR0		; RETOUR ECOUTE LIGNE HOTE
$EJECT
;
;	LECTURE CLAVIER
;	***************
;
LCLA	EQU	$
	LDA	STCLA
	ANI	PRESEN
	JNZ	LC0		; OUI
	LXI	H,LSTAT
	SHLD	ARET
	JMP	TR0
LC0:	IN	STAF		; IOC PRET EN ECRITURE ?
	ANI	BUSY
	JNZ	TR0		; NON
	LXI	H,ITC		; INDIQUER TRAIT. EN COURS
	INR	M
	MVI	A,KEYC		; DEMANDE LECTURE CARACTERE CLAVIER
	OUT	STCL
LC1:	IN	STCL		; ATTENTE IOC PRET EN LECTURE 
	ANI	BUSY
	CPI	OBF
	JZ	LC2		; OUI
	LXI	H,LC1
	SHLD	ARET
	JMP	TR0
LC2:	IN	DACL		; LECTURE CARACTERE CLAVIER
	ANI	7FH
	STA	CARCLA		; SAUVEGARDE
	XRA	A		; TRAIT. TERMINE !
	STA	ITC
	LXI	H,CNTCAR	; INIT RETOUR SUR 'CONTROLE CARACTERE'
	SHLD	ARET
	JMP	TR0
$EJECT
;
;	CONTROLE CARACTERE
;	******************
;
CNTCAR	EQU	$
	LDA	CARCLA		; CAR CLAVIER =CTRL/X ?
	CPI	CTRLX
	JZ	CONTRO		; OUI: RETOUR LECTURE DES COMMANDES
	IN	STLR		; PRET A EMETTRE SUR LIGNE HOTE ?
	ANI	PRET
	JZ	TR0		; NON RETOUR ECOUTE LIGNE HOTE
	LDA	CARCLA		; EMISSION CARACTERE SUR LA LIGNE
	OUT	DALR
	LXI	H,LSTAT		; INIT RETOUR SUR 'LECT. STATUS CLAVIER'
	SHLD	ARET
	JMP	TR0		; RETOUR ECOUTE LIGNE HOTE
;
	END
