$INCLUDE (:F4:V6NET.ENT)
;
	NAME	NET2
$INCLUDE (:F4:V6NET.LIT)
;
;	*********************************************************************
;	*                                                                   *
;	*                MODULE EMISSION DES FICHIERS                       *
;	*                                                                   *
;	*********************************************************************
;
;
;
;	POINT D'ENTREE DU MODULE
;	************************
;
;	CE MODULE EST APPELLE DEPUIS LE MODULE PRINCIPAL PAR CALL FEMD
;	AU MOMEMT DE L'APPEL LA VARIABLE ANAME DOIT CONTENIR L'ADRESSE OU SE
;	TROUVE LE NOM DU FICHIER A TRAITER
;
;	A LA SORTIE DU MODULE :
;		- SI PAS D'INCIDENT : Z FLAG = 1
;		- SI INCIDENT DETECTE : Z FLAG = 0 ET CODE D'ERREUR DANS A
;
;
	PUBLIC	FEMD
;
;
;	PROCEDURES EXTERNES
;	*******************
;
;	TRANSMISSION AVEC LE SYSTEME HOTE :
;		- EMNAM : EMISSION DU NOM DE FICHIER A RECEVOIR
;		- EMCAR : EMISSION D'UN CARACTERE VERS LE SYSTEME HOTE
;		- RECCAR: ATTENTE RECEPTION D'UN CARACTERE EMIS PAR LE HOST
;
;	LECTURE DU FICHIER A EMETTRE
;		- CARBUF : LECTURE CARACTERE PAR CARACTERE DU FICHIER A EMETTRE
;		           ( LE FICHIER A EMETTRE EST OUVERT ET FERME DANS LE
;		             MODULE PRINCIPAL )
;		  CETTE ROUTINE RETOURNE :
;			- CARRY = 1 ET Z = 1 SI FIN DE FICHIER
;			- CARRY = 1 ET Z = 0 SI INCIDENT DE LECTURE
;			- CARRY = 0 ET OCTET COURANT DU FICHIER DANS A
;
;	TEST DEMANDE D'ABORT PAR L'OPERATEUR
;		- TABORT : CETTE ROUTINE SURVEILLE SI UN CARACTERE
;		          CTRL A OU CTRL B A ETE FRAPPE A LA CONSOLE INDIQUANT
;		          QUE L'OPERATEUR DESIRE ABORTER LE TRANSFERT EN COURS
;		  ELLE RETOURNE : Z = 0 SI PAS DE DEMANDE D'ABORT
;		                  Z = 1 SI DEMANDE D'ABORT
;
;
	EXTRN	EMNAM,EMCAR,RECCAR,CARBUF,TABORT,AFFI
;
;
;
;
;	CARACTERES DE PROCEDURE DE TRANSMISSION
;	***************************************
;
STX	EQU	02H
ACK	EQU	06H
NACK	EQU	15H
EOT	EQU	04H
DLE	EQU	10H
;
;	PARAMETRES
;	**********
;
; TAILLE BUFFER D'EMISSION
;
SBE	EQU	127
;
$EJECT
;
;		TRAITEMENT EMISSION FICHIER
;		****************************
;
;
;	ON REMET A ZERO LES INDICATEURS :
;		- INCID : INDICATEUR D'INCIDENT
;		- FINF  : INDICATEUR DE FIN DE FICHIER
;
;	PUIS ON APPELLE LA ROUTINE EMNAM QUI ASSURRE L'EMISSION DU NOM DU
;	FICHIER A RECEVOIR.
;	CETTE ROUTINE EMET LE NOM DU FICHIER PUIS SE MET EN ATTENTE D'UN ACCUSE
;	DE RECEPTION EMIS LE HOST QUI SIGNALE QU'IL A CORRECTEMENT OUVERT LE
;	FICHIER DEMANDE.
;	EN CAS DE RECEPTION D'UN ACCUSE NEGATIF OU NON CONFORME : LA ROUTINE
;	RETOURNE 0 DANS Z FLAG POUR SIGNALER L'INCIDENT.
;
;	SI LA ROUTINE EMNAM RETOURNE UN RESULTAT POSITIF ON VA EMETTRE
;	LE PREMIER BLOC.
;
;	APRES CHAQUE EMISSION D'UN BLOC ON SE MET EN ATTENTE DE LA RECEPTION
;	DE L'ACCUSE QUE DOIT EMETTRE LE SYSTEME HOTE :
;		- SI UN ACCUSE POSITIF EST RECU ON PASSE AU BLOC SUIVANT
;		- SI L'ACCUSE RECU EST NEGATIF : LE SYSTEME HOTE A MAL RECU
;		  LE DERNIER BLOC EMIS : ON VA LE REEMETTRE
;		- SI L'ACCUSE EST ERRONNE : RETOUR EN ERREUR
;
;	QUAND LE DERNIER BLOC DU FICHIER A ETE EMIS ET BIEN RECU ON EMET UN
;	MESSAGE EOT POUR SIGNALER LA FIN DE LA TRANSMISSION.
;
;
	CSEG
;
;
FEMD	EQU	$
	XRA	A
	STA	FINF
	STA	INCID
	CALL	EMNAM
	JZ	FEM0
	LXI	H,ER200
	CALL	AFFI
	MVI	A,'B'
	ANA	A
	RET
;
; PREPARATION BUFFER D'EMISSION
;
FEM0:	LXI	D,BUFE+1
	MVI	A,STX
	STA	BUFEX
	MVI	B,SBE
	MVI	C,0;	 INITIALISER CALCUL DU BCC DANS C
FEM1:	CALL	CARBUF;	 CARACTERE COURANT A EMETTRE
	JNC	FEM2
	JNZ	FEM10;	 SI FIN DE FICHIER
	LXI	H,FINF
	INR	M;	 POSITIONNER INDICATEUR FINF
	MVI	A,EOT
	STA	BUFEX;	 RANGER EOT DANS BUFEX
	JMP	FEM3
FEM10:	LXI	H,INCID; SI INCIDENT DE LECTURE
	MVI	M,'2'	;ERREUR 2 INCIDENT D'ECRITURE DISQUE
	LXI	H,ER201
	CALL	AFFI
	MVI	A,DLE
	STA	BUFEX
	JMP	FEM3
;
FEM2:	STAX	D
	XRA	C
	MOV	C,A;	 MISE A JOUR DU BCC
	INX	D
	DCR	B
	JNZ	FEM1
FEM3:	MVI	A,SBE
	SUB	B
	STA	BUFE;	 RANGER LONGUEUR DU MESSAGE
	MOV	A,C
	STAX	D;	 RANGER BCC
;
; TEST DEMANDE D'ARRET PAR OPERATEUR
;
FEM30:	CALL	TABORT
	JZ	FEM31;	 SI CARACTERE ABORT EMIS AU CLAVIER
	MVI	A,DLE
	STA	BUFEX	 ;ALORS EMETTRE DLE
	LXI	H,INCID
	MVI	M,'7';	 ET POSITIONNER INDICATEUR INCID
	LXI	H,ER202
	CALL	AFFI
;
; EMISSION BUFFER
;
FEM31:	MVI	B,0
TEMP1:	MVI	A,30		;PETITE TEMPO
TEMP2:	DCR	A
	JNZ	TEMP2
	DCR	B
	JNZ	TEMP1
	LDA	BUFEX
	CALL	EMCAR
	MVI	B,SBE+2
	LXI	D,BUFE
FEM4	EQU	$
;
;	TEMPORISATION ENTRE L'EMISSION DE CHAQUE CARACTERE AU SYSTEME HOTE
;
;	CETTE PARTIE DU TRAITEMENT EST ASSEMBLEE CONDITIONNELLEMENT
;	EN FONCTION DU TYPE DE COUPLEUR PDP OU VAX
;	SI COUPLEUR PDP=DZ11 OU VAX=DZ11 OU DMF32 ON NE TEMPORISE PAS
;	SI COUPLEUR PDP=DL11 ON TEMPORISE
;	LE TYPE COUPLEUR PDP/VAX EST DEFINI DANS V6NET.LIT (TCPDP)
	IF	TCPDP EQ DL11
	MOV	C,B
	MVI	B,2
TOTOP4:	MVI	A,255
TOTOP3:	DCR	A
	JNZ	TOTOP3
	DCR	B
	JNZ	TOTOP4
	MOV	B,C
	ENDIF
;
;
	LDAX	D
	CALL	EMCAR
	INX	D
	DCR	B
	JNZ	FEM4
;
; ATTENDRE ACCUSE DE RECEPTION
;
FEM44:	CALL	RECCAR
	JNC	FEM40
	LXI	H,ER203
	CALL	AFFI
	MVI	A,'6';		SI TIME-OUT ALORS
	ANA	A;		ERREUR 6
	RET
FEM40:	CPI	ACK
	JZ	FEM5;		SI ACCUSE POSITIF ALLER TESTER FIN DE FICHIER
	CPI	NACK
	JZ	FEM30;		SI ACCUSE NEGATIF ALLER REEMETTRE LE BLOC
	LXI	H,ER204
	CALL	AFFI
	MVI	A,'4';		 SI ACCUSE INCOHERENT
	ANA	A;		ALORS ERREUR 4
	RET
FEM5:	LDA	INCID
	ANA	A
	JNZ	FEM6
	LDA	FINF
	ANA	A
	JZ	FEM0;		 SI PAS FIN DE FICHIER ET PAS D'INCIDENT PASSER AU BLOC SUIVANT
	XRA	A
	ANA	A
	RET	;		EXIT SANS ERREUR
FEM6:	STC
	RET
;
;
;
;
;
ER200:	DB	'NET> erreur emission message nom de fichier '
	DB	'(V6NET2,FEMD)'
	DB	CR,LF,0
ER201:	DB	'NET> abandon transmission [emission DLE]'
	DB	' (V6NET2,FEMD)'
	DB	CR,LF,0
ER202:	DB	'NET> abandon transmission par operateur'
	DB	' (V6NET2,FEMD)'
	DB	CR,LF,0
ER203:	DB	'NET> time-out accuse reception message'
	DB	' (V6NET2,FEMD)'
	DB	CR,LF,0
ER204:	DB	'NET> accuse reception incorrect'
	DB	' (V6NET2,FEMD)'
	DB	CR,LF,0
;
;
	DSEG
;
INCID:	DS	1;	INDICATEUR D'INCIDENT
FINF:	DS	1;	INDICATEUR DE FIN DE FICHIER
BUFEX:	DS	1
BUFE:	DS	132
;
	END
