C
C
C***********************************************************************C
C									C
C									C
C		reseau interne TELEMECANIQUE VNET niveau 6		C
C		******************************************		C
C									C
C									C
C	module : GESTION DES ENTREES / SORTIES SUR LA			C
C		 LIGNE DE TRANSMISSION					C
C									C
C		necessite au moins VMS 4.0				C
C									C
C	V2.0 4 decembre 1984		T.DUQUESNAY (DRD MEYLAN)	C
C	V2.1 13 juin 1985		T.DUQUESNAY (DRD MEYLAN)	C
C									C
C									C
C***********************************************************************C
C
C V2.1 13/6/85 adaptation pour VMS V4.0
C
C
C
	SUBROUTINE INITIO
C
C++
	COMMON /IO/CHAN,IFUNC1,IFUNC2,BUFIN,BUFOUT,STATUS,BUFCHAR
	INTEGER*2 CHAN,STATUS(4)
	INTEGER*4 IFUNC1,IFUNC2,BUFCHAR(3)
	BYTE BUFIN(134),BUFOUT(256)
C--
C++
	INTEGER*4 SYS$ASSIGN,SYS$QIOW
C
	EXTERNAL IO$_WRITEPBLK,IO$_READLBLK
	EXTERNAL IO$M_NOECHO,IO$M_TIMED,IO$M_NOFORMAT
	EXTERNAL SS$_NORMAL
	EXTERNAL IO$_SENSEMODE,IO$_SETMODE
	EXTERNAL TT$M_EIGHTBIT,TT2$M_PASTHRU,TT$M_TTSYNC,TT2$M_DECCRT
	EXTERNAL TT2$M_ALTYPEAHD,TT$M_NOBRDCST
C
	INTEGER*2 IOSB(4),TIMEOUT
	INTEGER*4 ERREUR
C
	INTEGER*2 BUFORM(6)
	INTEGER*4 BUFORMX(3)
	EQUIVALENCE (BUFORM(1),BUFORMX(1))
C--
C
C
	IFUNC2 = IOR (%LOC(IO$_WRITEPBLK),%LOC(IO$M_NOFORMAT))
	IFUNC1 = IOR (%LOC(IO$M_TIMED),%LOC(IO$M_NOECHO))
	IFUNC1 = IOR (%LOC(IO$_READLBLK),IFUNC1)
C
C  ouverture de la ligne de transmission
C
	ERREUR = SYS$ASSIGN ('TT',CHAN,,)
	IF (.NOT.ERREUR) CALL ERRFAT(1,ERREUR) 
C
C  modification des caracteristiques de la ligne
C  ---------------------------------------------
C
C    acquisition de caracteristiques
C
	ERREUR = SYS$QIOW (,%VAL(CHAN),IO$_SENSEMODE,IOSB,,,
     1			   %REF(BUFORM),%VAL(12),,,,,)
	IF (ERREUR .NE. %LOC(SS$_NORMAL)) THEN
	    CALL ERRFAT (6,ERREUR)
	ELSE
	    IF (IOSB(1) .NE. %LOC(SS$_NORMAL)) THEN
		ERREUR = IOSB(1)
		CALL ERRFAT (6,ERREUR)
	    END IF
	END IF
C
C    sauvegarde des caracteristiques
C
	DO I = 1,3
	    BUFCHAR(I) = BUFORMX(I)
	END DO
C
C    modification des caracteristiques de la ligne
C
C	  width = 160   : taille du buffer terminal
	BUFORM(2) = 160
C	  eightbit      : caracteres sur 8 bits (pour le binaire)
	BUFORMX(2) = IOR (%LOC(TT$M_EIGHTBIT),BUFORMX(2))
C	  pasthru et NOttsync : pour remplacer TTYREADPALL en V4.0
	BUFORMX(3) = IOR (%LOC(TT2$M_PASTHRU),BUFORMX(3))
	BUFORMX(3) = IAND ((NOT(%LOC(TT2$M_DECCRT))),BUFORMX(3))
	BUFORMX(2) = IAND ((NOT(%LOC(TT$M_TTSYNC))),BUFORMX(2))
C	  altypeahd
	BUFORMX(3) = IOR (%LOC(TT2$M_ALTYPEAHD),BUFORMX(3))
C	  nobrdcst pour ne pas etre perturbe par des messages systemes
	BUFORMX(2) = IOR (%LOC(TT$M_NOBRDCST),BUFORMX(2))
C
	ERREUR = SYS$QIOW (,%VAL(CHAN),IO$_SETMODE,IOSB,,,
     1			   %REF(BUFORM),%VAL(12),,,,,)
	IF (ERREUR .NE. %LOC(SS$_NORMAL)) THEN
	    CALL ERRFAT (7,ERREUR)
	ELSE
	    IF (IOSB(1) .NE. %LOC(SS$_NORMAL)) THEN
		ERREUR = IOSB(1)
		CALL ERRFAT (7,ERREUR)
	    END IF
	END IF
C
	END
C
	SUBROUTINE FINIO
C
C++
	COMMON /IO/CHAN,IFUNC1,IFUNC2,BUFIN,BUFOUT,STATUS,BUFCHAR
	INTEGER*2 CHAN,STATUS(4)
	INTEGER*4 IFUNC1,IFUNC2,BUFCHAR(4)
	BYTE BUFIN(134),BUFOUT(256)
C--
C++
	INTEGER*4 SYS$QIOW
C
	EXTERNAL SS$_NORMAL
	EXTERNAL IO$_SETMODE
C
	INTEGER*2 IOSB(4)
	INTEGER*4 ERREUR
C--
C
C
C  retablissement des caracteristiques de la ligne
C  -----------------------------------------------
C
	ERREUR = SYS$QIOW (,%VAL(CHAN),IO$_SETMODE,IOSB,,,
     1			   %REF(BUFCHAR),%VAL(12),,,,,)
	IF (ERREUR .NE. %LOC(SS$_NORMAL)) THEN
	    CALL ERRFAT (7,ERREUR)
	ELSE
	    IF (IOSB(1) .NE. %LOC(SS$_NORMAL)) THEN
		ERREUR = IOSB(1)
		CALL ERRFAT (7,ERREUR)
	    END IF
	END IF
C
	END
C
C
	SUBROUTINE DIALOGUE (LGIMAX,LGOUT)
C
	INTEGER*2 LGIMAX,LGOUT
C
C++
	COMMON /IO/CHAN,IFUNC1,IFUNC2,BUFIN,BUFOUT,STATUS,BUFCHAR
	INTEGER*2 CHAN,STATUS(4)
	INTEGER*4 IFUNC1,IFUNC2,BUFCHAR(3)
	BYTE BUFIN(134),BUFOUT(256)
C--
C
	INTEGER*4 SYS$QIOW
C
	EXTERNAL SS$_NORMAL
C
	INTEGER*2 IOSB(4),TIMEOUT
	INTEGER*4 ERREUR
	INTEGER*4 TERMINATOR(2) 
C
C   terminator : aucun caracteres 'terminateur d'echange'
C		  arret sur compte d'octets
	DATA TERMINATOR/0,0/
C   timeout    : 30 secondes
	DATA TIMEOUT/30/
C
C
	ERREUR = SYS$QIOW (,%VAL(CHAN),%VAL(IFUNC2),IOSB,,,
     1		%REF(BUFOUT),%VAL(LGOUT),,,,)
	IF (ERREUR .NE. %LOC(SS$_NORMAL)) THEN
	    CALL ERRFAT (2,ERREUR)
	ELSE
	    IF (IOSB(1) .NE. %LOC(SS$_NORMAL)) THEN
		ERREUR = IOSB(1)
		CALL ERRFAT (3,ERREUR)
	    END IF
	END IF
C	
	ERREUR = SYS$QIOW (,%VAL(CHAN),%VAL(IFUNC1),IOSB,,,
     1		%REF(BUFIN),%VAL(LGIMAX),%VAL(TIMEOUT),
     2		%REF(TERMINATOR),,)
	STATUS(1) = IOSB(1)
	STATUS(2) = IOSB(2)
	STATUS(3) = IOSB(3)
	STATUS(4) = IOSB(4)
	IF (ERREUR .NE. %LOC(SS$_NORMAL)) THEN
	    CALL ERRFAT (2,ERREUR)
	ELSE
	    IF (IOSB(1) .NE. %LOC(SS$_NORMAL)) THEN
		ERREUR = IOSB(1)
		CALL ERRFAT (3,ERREUR)
	    END IF
	END IF
C
	END
C
C
	SUBROUTINE EMIS (LGOUT)
C
	INTEGER*2 LGOUT
C
C++
	COMMON /IO/CHAN,IFUNC1,IFUNC2,BUFIN,BUFOUT,STATUS,BUFCHAR
	INTEGER*2 CHAN,STATUS(4)
	INTEGER*4 IFUNC1,IFUNC2,BUFCHAR(3)
	BYTE BUFIN(134),BUFOUT(256)
C--
C++
	INTEGER*4 SYS$QIOW
C
	EXTERNAL SS$_NORMAL
C
	INTEGER*2 IOSB(4)
	INTEGER*4 ERREUR
C--
C
	ERREUR = SYS$QIOW (,%VAL(CHAN),%VAL(IFUNC2),IOSB,,,
     1			%REF(BUFOUT),%VAL(LGOUT),,,,,)
	STATUS(1) = IOSB(1)
	STATUS(2) = IOSB(2)
	STATUS(3) = IOSB(3)
	STATUS(4) = IOSB(4)
	IF (ERREUR .NE. %LOC(SS$_NORMAL)) THEN
	    CALL ERRFAT2 (2,ERREUR)
	ELSE
	    IF (IOSB(1) .NE. %LOC(SS$_NORMAL)) THEN
		ERREUR = IOSB(1)
		CALL ERRFAT2 (3,ERREUR)
	    END IF
	END IF
C
	END
