*INCLUDE V6NETENT.S
*INCLUDE V6NETEQU.S
*INCLUDE V6NETGBL.S
*INCLUDE V6NET0EXT.S
*INCLUDE V6NET1EXT.S
*INCLUDE V6NET2EXT.S
*INCLUDE V6NET3EXT.S
*INCLUDE V6NET4EXT.S
*INCLUDE V6NET6EXT.S
*INCLUDE V6NET7EXT.S
*EJECT
;
;
;
;       POINTS D'ENTREE DU MODULE
;       *************************
;
;       MAIN : ADRESSE DE LANCEMENT
;       CONTRO : LECTURE COMMANDE LOCALE
;       RETMON : RETOUR AU MONITEUR
;
;
;       VARIABLES PUBLIQUES
;       *******************
;
;       ANAME : POINTEUR SUR LA ZONE OU SE TROUVE LE NOM DE FICHIER
;               CITE DANS LA COMMANDE EN COURS
;       ZREP  : BUFFER DE RANGEMENT DE LA DERNIERE COMMANDE
;
;
;
;       MODULES EXTERNES
;       ****************
;
;       IDENT   : ROUTINE D'AFFICHAGE MESSAGE D'IDENTIFICATION
;	SOS	: ROUTINE D'AFFICHAGE DES COMMANDES DISPONIBLES
;       AFFI    : AFFICHAGE D'UNE CHAINE DE CARACTERES SUR LA CONSOLE
;       OUTCA   : AFFICHAGE D'UN CARACTERE SUR LA CONSOLE
;       READC   : LECTURE D'UNE COMMANDE SUR LA CONSOLE
;       TABORT  : TEST DEMANDE D'ABORT OPERATEUR
;       ISIS    : APPEL SYSTEME MCZ ZDOS
;       OPENF   : OUVERTURE FICHIER MCZ
;       CLOSEF  : FERMETURE DE FICHIER MCZ
;       TFMF    : TRAITEMENT COMMANDES MULTI-FICHIERS
;       EMCAR   : EMISSION CARACTERE VERS SYSTEME HOTE
;       RECCAR  : RECEPTION CARACTERE EMIS PAR SYSTEME HOTE
;       FEMD    : SEQUENCE D'EMISSION DE FICHIER
;       FREC    : SEQUENCE DE RECEPTION DE FICHIER
;       TOPT    : TRAITEMENT ZONE OPTION DES COMMANDES
;       TRANS   : FONCTIONNEMENT TRANSPARENT
;
;
;
;
;       VARIABLES EXTERNES
;       ******************
;
;
;       LA VARIABLE ABORT CONTIENT LE RESULTAT DU DERNIER TEST
;       DE DEMANDE D'ABORT
;
;               - SI PAS DE DEMANDE D'ABORT : ELLE CONTIENT 0
;               - SI DEMANDE D'ABORT SUR UN SEUL FICHIER (CTRL A) : 1
;               - SI DEMANDE D'ABORT SUR TOUTE UNE LISTE (CTRL B) : 2
;
;
;       FICHOP EST UN INDICATEUR DU MODULE D'ACCES AUX FICHIERS :
;       IL DOIT ETRE INITIALISE A ZERO DANS LA SEQUENCE
;       PRINCIPALE D'INIT
;
;
;
*EJECT
;
;       ****************************************************
;       *                                                  *
;       *           INITIALISATION LOGICIEL NET            *
;       *                                                  *
;       ****************************************************
;
;
;       IMPRESSION DU MESSAGE D'IDENTIFICATION
;       INITIALISATION DES INDICATEURS DE MODE BATCH ET MULTI-FICHIER
;       READ CONSOLE POUR SAUTER LA LIGNE DE COMMANDE
;       (AU LANCEMENT DE NET PAR RIO LE PREMIER READ CONSOLE EFFECTUE
;                ACCEDE A LA LIGNE DE COMMANDE)
;       DETERMINATION DU MODE DE FONCTIONNEMENT DE NET :
;       ON UTILISE L'APPEL SYSTEME WHOCON QUI PERMET DE DETERMINER
;       QUEL EST LE PERIPHERIQUE QUI SERT DE CONSOLE LOGIQUE :
;       SI CE PERIPHERIQUE EST UN DRIVE C'EST QU'ON EST EN MODE BATCH :
;       NET LANCE PAR UNE COMMANDE SUBMIT
;
;       A LA FIN DE CETTE SEQUENCE :
;       - SI ON EST EN MODE CONVERSATIONNEL : 
;				BRANCHEMENT AU MODE TRANSPARENT
;       - SI ON EST EN MODE BATCH : 
;				BRANCHEMENT A LA SEQUENCE DE LECTURE
;			        DE LA PREMIERE COMMANDE
;
;
;
;
MAIN    EQU     $
        CALL    INTRAN          ; INIT TRANSMISSION "HOST" A 9600 BAUDS
        XOR     A
        LD      (LISTE),A       ; MODE LISTE = FAUX
        LD      (FICHOP),A      ; RESET INDICATEUR FICHIER OUVERT
        LD      A,1             ; MODE BATCH = FAUX
        LD      (BATCH),A       ; PUIS ALLER LIRE LA PREMIERE COMMANDE
	POP	HL		; RECUP DANS HL @ CDE ACTIVATION
	EX	(SP),HL
	LD	A,0DH		; TEST SI UNE COMMANDE SPECIFIEE
	CP	(HL)
	JP	Z,BCL2		; SI NON
	INC	HL		; SAUTE ESPACE
	LD	DE,ZREP		; TRANSFERT DANS BUFFER CDE NET
BCL1:	LD	A,(HL)
	INC	HL
	LD	(DE),A
	INC	DE
	CP	0DH
	JP	NZ,BCL1
	XOR	A
	LD	(BATCH),A	; MODE BATCH = VRAI
	JP	CON05
BCL2:	CALL    IDENT           ; IMPRESSION MESSAGE D'IDENTIFICATION

;
;
*EJECT
;
;       **************************************************
;       *                                                *
;       *        LECTURE DES COMMANDES LOCALES           *
;       *                                                *
;       **************************************************
;
;
;       LES COMMANDES LOCALES SONT LUES SUR L'UNITE :CI:
;        (CONSOLE LOGIQUE D'ENTREE)
;       CES COMMANDES PEUVENT DE TYPE MONOFICHIER OU
;       MULTIFICHIERS (UTILISATION DE NOMS DE FICHIERS COMPORTANT
;       UN OU PLUSIEURS CARACTERES * OU ?)
;
;       ON VA D'ABORD DETERMINER SI ON EST OU NON EN TRAIN DE
;       TRAITER UNE COMMANDE MULTIFICHIERS :
;       - SI OUI ON EXECUTERA UNE SEQUENCE DE CALCUL DU NOM DE FICHIER
;         A TRAITER
;       - SI NON ON DEMANDERA LE NOM DU FICHIER A TRAITER SUR LA CONSOLE
;
;       APRES ANALYSE DE LA COMMANDE RECUE ON SE BRANCHERA AU
;        MODULE DE TRAITEMENT CORRESPONDANT
;
;       ON COMMENCE LA SEQUENCE PAR UNE LECTURE DU DATA PORT LIGNE
;       DE TRANSMISSION :
;       CECI PERMET DE LE VIDER ET EVITE DE PRENDRE UN CARACTERE
;       QUI Y SERAIT RESTE POUR UNE REPONSE DU HOST A LA COMMANDE
;       D'ACTIVATION DE TACHE
;
;
;
;
CONTRO  EQU     $
        IN      A,(DALPDP)
	LD	A,(BATCH)		; TEST SI MODE BATCH
	AND	A
	JP	Z,RETMON		; SI OUI ON EXIT
        LD      A,(LISTE)
        AND     A
        JP      Z,CON0
;
;
;       MODE MULTIFICHIERS
;       ******************
;
;
;
; ON TESTE SI PENDANT L'EXECUTION DE LA COMMANDE PRECEDENTE
; ON N'A PAS RECU DE DEMANDE D'ABORT PORTANT SUR LA TOTALITE 
; DE LA COMMANDE (FRAPPE DE CTRL B PAR L'OPERATEUR)
;       - SI OUI : ON SORT DU MODE MULTI FICHIER ET ON PASSE 
;         LIRE LA COMMANDE SUIVANTE
;       - SI NON : ON VA DETERMINER LE PROCHAINE FICHIER A TRAITER
;
        LD      A,(ABORT)
        CP      2
        JP      NZ,ML0          ; SI ABORT LISTE
        XOR     A
        LD      (LISTE),A       ; ALORS SORTIR DU MODE LISTE
        JP      FCOM
;
;
; LORS DE L'ANALYSE DE LA COMMANDE QUI A PROVOQUE LE PASSAGE 
; EN MODE MULTIFICHIERS
; LA ROUTINE TMUL A CONSTRUIT UNE LISTE DES FICHIERS A TRAITER :
; ON VA CHERCHER LE NOM DU PROCHAIN FICHIER A TRAITER 
; DANS CETTE LISTE ET ON VA LE RECOPIER DANS LA ZONE ZREP 
; (COMMANDE A EXECUTER)
; LA ZONE ZREP CONTIENT TOUJOURS LE NOM DE LA COMMANDE 
; QUI A ETE EMISE
; ON Y RECOPIE LE CONTENU DE LA ZONE OPTION QUI A ETE 
; MEMORISE A PART APRES CETTE SEQUENCE ELLE AURA DONC LE MEME 
; FORMAT QUE SI LA COMMANDE CONCERNANT LE FICHIER QUE L'ON VA 
; TRAITER AVAIT ETE ENTREE DIRECTEMENT PAR L'OPERATEUR
;
; PUIS ON TESTERA SI LE FICHIER OBTENU EST OU NON LE DERNIER 
; DE LA LISTE SI C'EST LE CAS ON REMET A ZERO L'INDICATEUR 
; DE MODE MULTIFICHIERS
;
ML0:    LD      HL,(ALISTE)
        LD      DE,ZREP+2       ; ZONE FICHIER DU BUFFER DE COMMANDE
ML2:    LD      A,(HL)
        INC     HL
        LD      (DE),A
        INC     DE
        AND     A
        JP      NZ,ML2
        LD      (ALISTE),HL
        DEC     DE
        LD      HL,ZOPT         ; RECOPIER LA ZONE OPTION
ML25:   LD      A,(HL)
        INC     HL
        LD      (DE),A
        INC     DE
        CP      CR              ; ARRET SUR CARACTERE CR
        JP      NZ,ML25
        LD      HL,NFICH
        DEC     (HL)            ; NFICH-1
        JP      NZ,ML3
        XOR     A               ; SI NFICH PASSE A ZERO
        LD      (LISTE),A       ; ON SORT DU MODE LISTE
;
;
; ON A MAINTENANT DANS ZREP L'IMAGE DE LA COMMANDE A EXECUTER :
;       - CARACTERE DONNANT LE NOM DE LA COMMANDE
;       - NOM DU FICHIER
;       - ZONE OPTION
; ON VA AFFICHER CETTE COMMANDE
;
; PUIS ON PASSERA A LA SEQUENCE D'ANALYSE DE LA COMMANDE
ML3:    LD      HL,ZREP
ML31:	LD	A,(HL)		; AFFICHE CDE
	CALL	OUTCA
	INC	HL
	CP	CR
	JP	NZ,ML31
        JP      CON05           ; PUIS ALLER TRAITER LA COMMANDE
;
;       FONCTIONNEMENT EN MODE MONOFICHIER
;       **********************************
;
;
;       ON VA LIRE LA COMMANDE A EXECUTER SUR L'UNITE :CI:
;       PUIS ON PASSERA A LA SEQUENCE D'ANALYSE DE LA COMMANDE
;
;
CON0:   LD      HL,MES1         ; AFFICHAGE net>
        CALL    AFFI
        LD      HL,ZREP
        CALL    READC           ; LIRE COMMANDE OPERATEUR
;
*EJECT
;
;       *******************************************************
;       *                                                     *
;       *          ANALYSE ET TRAITEMENT DES COMMANDES        *
;       *                                                     *
;       *******************************************************
;
;
;       LA COMMANDE DE RETOUR A RIO EST TRAITEE DE FACON PARTICULIERE :
;       EN EFFET CETTE COMMANDE NE COMPORTE PAS DE NOM DE FICHIER
;       ELLE NE PEUT DONC PAS ETRE ANALYSEE COMME LES AUTRE
;       POUR CELA ON VA IMMEDIATEMENT DETECTER SI LE CODE DE LA 
;       COMMANDE EST UN CODE DE RETOUR A MCZ : CARACTERES E 
;       OU CTRL E
;
;       SINON ON REMET A ZERO L'INDICATEUR D'ABORT
;       ON DETERMINE L'ADRESSE DE NOM DE FICHIER A EMETTRE 
;       VERS LE SYSTEME HOTE :
;       LE NOM DE FICHIER DE LA COMMANDE PEUT COMMENCER PAR UNE INDICATION
;       DE NUMERO DE DRIVE :X/ DANS CE CAS CETTE PARTIE DU NOM DU
;       FICHIER N'EST PAS TRANSMISE AU SYSTEME HOTE
;       L'ADRESSE A LAQUELLE DEBUTE LE NOM A TRANSMETTRE EST RANGEE DANS
;       LA VARIABLE PUBLIQUE ANAME
;
;       PUIS ON VA ANALYSER LE PREMIER CARACTERE DE LA COMMANDE QUI 
;       CONTIENT LE NOM DE LA COMMANDE
;       ON RECHERCHE CE NOM DANS LA TABLE DES COMMANDES
;       SI LE NOM EST TROUVE ON RECUPERE L'ADRESSE DE LA SEQUENCE 
;       DE TRAITEMENT DE LA COMMANDE
;
;       AVANT DE SE BRANCHER A CETTE SEQUENCE ON APPELLE LA ROUTINE 
;       TMUL QUI VA VERIFIER SI LE NOM DE FICHIER CONTENU DANS LA 
;       COMMANDE CONTIENT LES CARACTERES * OU ? QUI SIGNALENT UN 
;       NOM MULTIPLE
;       - SI C'EST LE CAS : LA ROUTINE TMUL RETOURNE 0 DANS Z FLAG
;         ON VA ALORS RETOURNER AU DEBUT DE LA SEQUENCE POUR VENIR RANGER
;         LE NOM DU PREMIER FICHIER A TRAITER DANS LA ZONE DE COMMANDE
;         PUIS TRAITER CE PREMIER FICHIER
;       - SI TMUL DETECTE UNE ERREUR DANS LE NOM DU FICHIER :
;         ELLE AFFICHE UN MESSAGE D'ERREUR PUIS RETOURNE CARRY = 1
;       - SI CE N'EST PAS LE CAS : BRANCHEMENT A LA SEQUENCE DE TRAITEMENT
;         DE LA COMMANDE
;
;
CON05   EQU     $
        LD      HL,ZREP
        LD      A,'E'
        CP      (HL)
        JP      Z,RETMON
        LD      A,05H
        CP      (HL)
        JP      Z,RETMON
	LD	A,'?'
	CP	(HL)
	JP	Z,COV
        LD      A,'T'           ; TEST SI MODE TRANSPARENT
        CP      (HL)
        JP      Z,TRANS
	LD	A,CR
	CP	(HL)
	JP	Z,CONTRO
;
;       RECHERCHE PLACE NOM DE FICHIER DANS COMMANDE
;
        LD      HL,ZREP+2       ; TEST SI DEVICE INDIQUE
        LD      A,(HL)          ; DANS COMMANDE OPERATEUR
        CP      ':'             ; FORME   :2/FILENAME
        JP      NZ,CON06        ; NON -> FORME FILENAME
;
        LD      HL,ZREP         ; ADR BUFFER COMMANDE
        LD      BC,(LZREP)      ; NBR CAR BUFFER ZREP
        LD      A,'/'           ; DELIMITEUR DEBUT NOM DE FICHIER
        CPIR
        JP      Z,CON06         ; SI / TROUVE
        LD      HL,ZREP+2
CON06:  LD      (ANAME),HL      ; ADR NOM DE FICHIER
        LD      A,(ZREP)
        LD      B,A
        LD      HL,TABADR
CON1:   LD      A,(HL)          ; CODE COURANT DANS TABLE
        INC     HL
        CP      00H             ; FIN DE TABLE
        JP      Z,CON3
        CP      B               ; CODE DE LA COMMANDE OPERATEUR
        JP      Z,CON2
        INC     HL
        INC     HL
        JP      CON1
CON2:   LD      E,(HL)          ; RECUPERE ADRESSE DE BRANCHEMENT
        INC     HL
        LD      D,(HL)
        PUSH    DE
        CALL    TMUL
        POP     HL
        JP      C,FCOM          ; NOM DE FICHIER ERRONE
        JP      NZ,CONTRO       ; TRAITER LE 1ER FICHIER DE LA LISTE
        JP      (HL)
CON3:   LD      HL,MESINC
        CALL    AFFI
        JP      CONTRO          ; ALLER A LA SEQUENCE FIN DE COMMANDE
;
MES1:   DEFB	CR
	DEFM    'net>'
        DEFB    0
;
;
;
;
; TABLE DES COMMANDES
;
TABADR  EQU     $
        DEFB    'S';    S : EMISSION DE FICHIER
        DEFW    COS
        DEFB    'R';    R : RECEPTION DE FICHIER
        DEFW    COR
;       DEFB    'L';    L : CHARGEMENT DE FICHIER LDA
;       DEFW    COL
        DEFB    0
;
MESINC: DEFM    'net> commande inconnue'
        DEFB    CR
        DEFB    0
;
;
*EJECT
;
;       COMMANDE E : RETOUR A RIO
;       **************************
;
;
RETMON  EQU     $
        RET
;
;
*EJECT
;
;
;       COMMANDE S : EMISSION FICHIER
;       *****************************
;
;
;       ON APPELLE LA ROUTINE OPENF QUI ASSURE L'OUVERTURE DU FICHIER
;       SI L'OUVERTURE SE PASSE BIEN (FICHIER EXISTANT) LA ROUTINE 
;       OPENF RETOURNE  1 DANS Z FLAG
;       ON APPELLE ALORS LA ROUTINE FONCT QUI ASSURE L'EMISSION 
;       D'UN MESSAGE DEMANDANT L'ACTIVATION DE LA TACHE 'SEND' 
;       SUR le host
;       SI LA TACHE SEND S'ACTIVE CORRECTEMENT LA ROUTINE FONCT RETOURNE
;       1 DANS Z FLAG
;       ON APPELLE ALORS LA ROUTINE FEMD QUI ASSURE L'EMISSION DU 
;       FICHIER
;
;       CETTE ROUTINE RETOURNE DANS Z FLAG ET CARRY FLAG UNE 
;       INDICATION DE LA FACON DONT S'EST PASSE LE TRANSFERT
;       CES VALEURS SONT DIRECTEMENT PASSEES A LA ROUTINE 'AFFST' 
;       QUI AFFICHE SUR LA CONSOLE UN MESSAGE INDIQUANT LA FACON 
;       DONT LA TRANSFERT S'EST PASSE :
;               - abandon SI TRANSFERT INTERROMPU
;
;       A LA FIN DE CETTE SEQUENCE ON SE BRANCHE A LA SEQUENCE DE 
;       FIN DE COMMANDE
;
;
COS     EQU     $
;
; OUVERTURE DU FICHIER A EMETTRE
;
        LD      A,ACCR
        CALL    OPENF;   OUVERTURE FICHIER EN LECTURE
;
; SI FICHIER BIEN OUVERT : ACTIVER TACHE SEND SUR VAX
;
        LD      A,START         ; ACCUSE VAX ATTENDU
        LD      HL,EMSD         ; ADR BUFFER EMISSION COMMANDE
        CALL    Z,FONCT
;
; SI TACHE SEND BIEN ACTIVEE ALORS : APPEL DE LA SEQUENCE 
; D'EMISSION FICHIER
;
        CALL    Z,FEMD
;
; AU RETOUR : FERMETURE DU FICHIER EMIS PUIS AFFICHAGE COMPTE RENDU
;
CO1:    CALL    AFFST
        CALL    CLOSEF          ;FERMETURE FICHIER
        LD      A,(ABORT)
        CP      2
        JP      NZ,FCOM
        XOR     A
        LD      (LISTE),A
        JP      FCOM
;
EMSD:   DEFM    'SND6'
        DEFB    CR
;
;
*EJECT
;
;
;       COMMANDE R : RECEPTION DE FICHIER
;       *********************************
;
;
;       LE TRAITEMENT DE CETTE COMMANDE EST IDENTIQUE A 
;       CELUI DE LA COMMANDE D'EMISSION DE FICHIER A CES 
;       DIFFERENCES PRES :
;               - LE FICHIER A TRAITER EST OUVERT EN ECRITURE
;               - LA TACHE ACTIVEE SUR VAX EST LA TACHE RECEIVE
;               - SI L'OUVERTURE DU FICHIER SE PASSE BIEN ET SI 
;               - LA TACHE RECEIVE  S'ACTIVE CORRECTEMENT : 
;                 C'EST LA ROUTINE FREC QUI EST APPELLEE
;                 POUR ASSURER LA TRANSMISSION EN RECEPTION
;
COR     EQU     $
;
; OUVRIR LE FICHIER A RECEVOIR
;
        LD      A,ACCW
        CALL    OPENF;   OUVERTURE FICHIER EN ECRITURE
;
; SI L'OUVERTURE S'EST BIEN PASSEE : ACTIVER LA TACHE RECEIVE SUR VAX
;
        LD      A,START         ; ACCUSE VAX ATTENDU
        LD      HL,EMRC;         ADRESSE BUFFER D'EMISSION COMMANDE
        CALL    Z,FONCT
;
; SI LA TACHE RECEIVE S'EST BIEN ACTIVEE : APPEL MODULE 
; DE RECEPTION FICHIER
;
        CALL    Z,FREC
;
; AU RETOUR : FERMER LE FICHIER RECU ET AFFICHAGE COMPTE RENDU
;
        CALL    AFFST
        CALL    CLOSEF
        JP      FCOM
;
EMRC:   DEFM    'RCV6'
        DEFB    CR
;
;
*EJECT
;
;
;       COMMANDE L : CHARGEMENT DE FICHIER
;       **********************************
;
;	!-----------------------------------------------!
;	! N O N   I M P L E M E N T E E   S U R   V A X !
;	!-----------------------------------------------!
;
;
; TRAITEMENT DES OPTIONS DE LA COMMANDE :
;
;       - OPTION O : DEFINITION DE LA VALEUR DE L'OFFSET DE 
;                    CHARGEMENT SI CETTE OPTION EST ABSENTE L'OFFSET 
;                    SERA EGAL A ZERO
;       - OPTION S : ADRESSE DEBUT DE LA ZONE DE CHARGEMENT DE LA 
;                    TABLE DES SYMBOLES DU PROGRAMME
;                    SI CETTE OPTION EST ABSENTE LA TABLE DES 
;                    SYMBOLES NE SERA PAS CHARGEE EN MEMOIRE
;       - OPTION F : ADRESSE FIN DE LA TABLE DES SYMBOLES
;                    SI CETTE OPTION EST ABSENTE LA TABLE DES 
;                    SYMBOLES POURRA S'ETENDRE DANS TOUTE LA 
;                    MEMOIRE DISPONIBLE
;
;COL:    EQU     $
;        LD      A,'O'
;        CALL    TOPT            ; TEST PRESENCE OPTION O POUR OFFSET
;        JP      C,COL10
;        JP      Z,COL2
;        LD      HL,0            ; SI ABSENTE VALEUR PAR DEFAUT = 0
;COL2:   LD      (OFFSET),HL
;        LD      A,'S'           ; TEST OPTION S
;        CALL    TOPT
;        JP      C,COL10
;        JP      Z,COL25
;        LD      HL,0
;        LD      (DSYM),HL
;        JP      COL3
;COL25:  LD      (DSYM),HL
;        LD      A,'F'           ; TEST OPTION F POUR TAILLE TABLE
;        CALL    TOPT
;        JP      C,COL10
;        JP      Z,COL28
;        LD      HL,0
;COL28:  LD      (FSYM),HL
;
;       EMISSION MESSAGE ACTIVATION DE LA TACHE LOAD SUR VAX
;
;COL3:   LD      HL,EMLOA
;        LD      A,START
;        CALL    FONCT
;
;       SI TACHE LOAD BIEN ACTIVEE APPEL DE LA SEQUENCE DE CHARGEMENT
;
;        CALL    Z,LOAD
;
;       AFFICHAGE COMPTE RENDU EXECUTION
;
;COL4:   CALL    AFFST
;        JP      FCOM            ; ALLER A LA SEQUENCE DE FIN
;COL10:  LD      A,'3'
;        AND     A
;        JP      COL4
;
;
;EMLOA:  DEFM    'RUN $LOAD'
;        DEFB    CR
;
;
*EJECT
;
;
;       COMMANDE V: LISTE DES COMMANDES
;       *******************************
;
;
COV     EQU     $
	CALL	SOS
	JP	CONTRO
;
;
*EJECT
;
;       FIN DE TRAITEMENT DES COMMANDES
;       *******************************
;
;
;       ON EXECUTE UNE SEQUENCE DE TEMPORISATION QUI LAISSE LE 
;       TEMPS A LA TACHE SUR SYSTEME HOTE DE SE
;       TERMINER PUIS ON REVIENT LIRE UNE NOUVELLE COMMANDE 
;       OU TRAITER LE FICHIER SUIVANT DE LA LISTE 
;       (SI ON EST EN MODE MULTIFICHIER)
;
;
;
FCOM    EQU     $
	CALL	RECCAR		; POUR PURGE LIGNE VAX
	LD	A,CR		; ON EMET UN CR POUR TESTER
	CALL	EMCAR		; SI VMS EST PRESENT
	CALL	RECCAR		; PETITE TEMPO REALISE PAR DES 
	JP	NC,FCOM3	; APPEL A RECCAR
	CALL	RECCAR
	JP	NC,FCOM3
FCOM1:  CALL    RECCAR
        JP      C,FCOM2
FCOM3:  CP      '$'
        JP      NZ,FCOM1
        JP      CONTRO
FCOM2:  LD	HL,ER04
	CALL	AFFI
        LD      A,0FFH
        JP      CONTRO
;
;
;
*EJECT
;
;
;       ROUTINE FONCT : ENVOI MESSAGE D'ACTIVATION DE TACHE SUR VAX
;       ***********************************************************
;
;
;       EN ENTREE : H,L = ADRESSE DU MESSAGE D'ACTIVATION
;                  CE MESSAGE SE TERMINE PAR UN CARACTERE CR
;                  A= CARACTERE ACCUSE VAX ATTENDU
;
;       EN RETOUR Z = 0 OK : TACHE CORRECTEMENT ACTIVEE
;                 Z = 1 ERREUR
;
; LA LIAISON ENTRE LE MCZ ET LE VAX EST REALISEE AVEC UNE LIGNE
; DE TRANSMISSION SERIE . CETTE LIGNE EST VUE PAR LE SYSTEME VMS 
; COMME UNE CONSOLE NORMALE
; POUR ACTIVER UNE TACHE ON UTILISE DONC LE MECANISME STANDARD 
; D'ACTIVATION D'UNE TACHE DEJA INSTALLEE : 
;   pour VMS : commande XXXX<rc> (ou XXXX est le nom de la tache)
; CE MESSAGE EST RECU PAR LE HOST QUI DECLENCHERA L'ACTIVATION DE LA TACHE
; UNE FOIS LA TACHE ACTIVEE LES CARACTERES EMIS PAR LE 
; PROCESSEUR NET SERONT ALORS RECUS PAR LA TACHE ACTIVEE 
;
; PENDANT TOUTE CETTE SEQUENCE ON APPELLE REGULIEREMENT LA 
; ROUTINE TABORT POUR DETECTER UNE EVENTUELLE DEMANDE D'ARRET 
; PAR L'OPERATEUR
;
;
FONCT   EQU     $
        LD      DE,CARPDP       ; SAUVEGARDE ACCUSE VAX ATTENDU
        LD      (DE),A
;
;       ON EMET LE MESSAGE D'ACTIVATION : XXXX<rc> 
;       ( OU XXXX EST LE NOM DE LA TACHE A ACTIVER )
;       A CHAQUE CARACTERE EMIS ON VERIFIE QUE LE VAX REPOND
;       EN EMETTANT L'ECHO DU CARACTERE
;
        IN      A,(DALPDP)      ; VIDER BUFFER PCI LIGNE RECEPTION
FON0:   LD      A,(HL)
        CALL    EMCAR
FON2:   CALL    TABORT
        JP      NZ,FON6         ; SI ABORT OPERATEUR
        CALL    RECCAR          ; LECTURE ECHO
        JP      NC,FON20
        LD      HL,ER01
        CALL    AFFI
        LD      A,'Z'
        AND     A
        RET
FON20:  SUB     (HL)
        JP      Z,FON4          ; ECHO CORECT
        LD      HL,ER02
        CALL    AFFI
        LD      A,'Y'           ; ECHO INCORRECT
        AND     A
        RET
FON4:   LD      A,(HL)
        INC     HL
        CP      CR
        JP      NZ,FON0         ; PASSER AU CARACTERE SUIVANT
FON5:   CALL    TABORT
        JP      NZ,FON6         ; SI ABORT OPERATEUR
;
;
; LE MESSAGE D'ACTIVATION DE LA TACHE A ETE CORRECTEMENT EMIS
; ON ATTEND MAINTENANT QUE LA TACHE ACTIVEE SE SIGNALE
; EN EMETTANT UN CARACTERE START
;
        IN      A,(STLPDP)
        AND     RECU
        JP      Z,FON5
        IN      A,(DALPDP)
        AND     A
        JP      Z,FON5          ; LAISSER PASSER CARACTERE NUL
	CP	LF		;ignorer egalement les LINE_FEED
	JP	Z,FON5
        LD      HL,CARPDP
        CP      (HL)            ; CARACTERE ATTENDU DU VAX
        JP      NZ,FON6         ; SI INCORRECT
;
; ON VIENT DE RECEVOIR LE CARACTERE START : C'EST BON
; RETOUR A LA SEQUENCE APPELLANTE AVEC Z FLAG = 1
; MAIS D'ABORD ON AFFICHE LE MESSAGE ... transfert en cours ...
;
	CP	START
	JP	NZ,FON55
        LD      HL,MESST        ; AFFICHE START
        CALL    AFFI
FON55:	LD      A,0
        AND     A
        RET
;
; ON A RECU UNE DEMANDE D'ABORT DE L'OPERATEUR OU UN 
; CARACTERE START INCORRECT
; ON ENVOIE AU VAX UNE SERIE DE CARACTERES D'ANNULATION
; PUIS RETOUR A LA SEQUENCE APPELLANTE AVEC CARRY=1 ET Z FLAG = 0
;
FON6    EQU     $               ;ABORT OPERATEUR :
        LD      B,130
FON65:  LD      A,7FH
        CALL    EMCAR           ;ENVOYER UNE SERIE DE CARACTERES RUB-OUT
        DJNZ    FON65
        LD      HL,ER03
        CALL    AFFI
        LD      A,1
        AND     A
        SCF                     ; RETOUR EN ABORT AVEC C=1 ET Z=0
        RET
;
;
MESST:  DEFM    '... transfert en cours ...'
        DEFB    CR
        DEFB    0
CARPDP: DEFS    1               ; CARACTERE ACCUSE VAX ATTENDU
;
;
*EJECT
;
;
;       TEST COMMANDE MULTIFICHIER
;       **************************
;
;
;       ON COMMENCE PAR APPELLER LA ROUTINE TFMF QUI 
;       DETERMINE SI LE NOM CONTENU DANS LA COMMANDE EST OU 
;       NON UN NOM MULTIPLE
;       - SI LE NOM DE LA COMMANDE N'EST PAS UN NOM MULTIPLE :
;         CETTE ROUTINE RETOURNE Z FLAG = 1
;         ON RETOURNE DIRECTEMENT CETTE VALEUR A LA SEQUENCE PRINCIPALE
;       - SI LE NOM DU FICHIER EST INCORRECT LA ROUTINE TFMF 
;         RETOURNE CARRY = 1
;         ON AFFICHE ALORS UN MESSAGE D'ERREUR PUIS ON 
;         RETOURNE CARRY = 1
;       - SI LE NOM DE LA COMMANDE EST UN NOM MULTIPLE CORRECT :
;         LA ROUTINE TFMF RETOURNE Z FLAG = 0
;                   A = NBRE DE FICHIERS A TRAITER
;                   H-L = ADRESSE LISTE DES NOMS DES FICHIERS
;
;
;
TMUL    EQU     $
;
; DANS LE CAS OU L'ON PASSE EN MODE MULTIFICHIER ON 
; SAUVEGARDE L'IMAGE DE LA ZONE OPTION DE LA COMMANDE 
; INITIALE : CECI PERMETTRA DE LA RECOPIER DANS TOUTES LES COMMANDES
; QUI SERONT EMISES POUR TRAITER LES FICHIERS DE LA LISTE
;
        LD      HL,(ANAME)       ; TESTER LA PRESENCE D'UNE OPTION
        LD      DE,ZOPT
TM3:    LD      A,(HL)
        INC     HL
        CP      CR
        JP      Z,TM5           ; PAS D'OPTION
        CP      SLASH
        JP      NZ,TM3
TM4:    LD      (DE),A          ; RECOPIE ZONE OPTION
        INC     DE
        LD      A,(HL)
        INC     HL
        CP      CR
        JP      NZ,TM4
TM5:    LD      (DE),A          ; CR EN FIN DE ZONE
;
;
        LD      HL,ZREP+2
        CALL    TFMF            ; APPEL MODULE DE TEST
        JP      NC,TM1          ; SI INCIDENT
	LD	HL,ER07
	CALL	AFFI
        SCF                     ; RETOUR AVEC CARRY =1
        RET
;
TM1:
	RET     Z               ; SI FICHIER SIMPLE Z FLAG=1
;
        LD      (NFICH),A
        LD      (ALISTE),HL     ; MEMORISER ADR LISTE DE NOMS
;
        LD      A,(ZREP)        ; COMMANDE R EN MODE MULTIFICHIER
        CP      'R'
	JP	NZ,TM25
	LD	HL,ER05
	CALL	AFFI
	SCF
	RET
;
TM25:
	LD	HL,ZREP
TM56:
	LD	A,(HL)
	INC	HL
	CP	'/'
	JP	Z,TM57
	CP	CR
	JP	Z,TM58
	JP	TM56
TM57:
	LD	A,(HL)
	CP	'N'
	JP	NZ,TM56
	LD	HL,ER06
	CALL	AFFI
        SCF                     ; RETOUR AVEC CARRY =1
        RET
TM58:	
        LD      A,1
        LD      (LISTE),A       ; PASSER EN MODE LISTE
        XOR     A
        LD      (ABORT),A       ; RAZ INDICATEUR ABORT LISTE
;
        LD      A,1
        AND     A               ; POUR RETOUR AVEC Z FLAG=0
        RET
;
;
*EJECT
;
;       AFFICHAGE COMPTE RENDU D'EXECUTION
;       **********************************
;
;       EN ENTREE :     C=1 : TACHE ABORTEE
;			C=0 : execution correcte , pas d'erreur
;
AFFST   EQU     $
	RET	NC
        LD      HL,MESSA
        CALL    AFFI
	RET
;
MESSA:  DEFM    'net> abandon'
MESSCR: DEFB    CR
        DEFB    0
;
;
;
;
ZREP:   DEFS    80              ; ZONE DE LECTURE DES COMMANDES
;
CODERR: DEFS    1               ;CODE D'ERREUR POUR AFFST
ANAME:  DEFS    2
BATCH:  DEFS    1
LISTE:  DEFS    1               ;= 1 MODE LISTE MULTIFICHIER
ALISTE: DEFS    2
NFICH:  DEFS    1               ;NOMBRE DE FICHIERS EN MODE LISTE
ZOPT:   DEFS    80
        DEFS    30
;
;
;       MESSAGES ERREURS
;       ----------------
ER01:   DEFM    'net> erreur time-out echo VAX (V6NET,FONCT)'
        DEFB    CR
        DEFB    0
ER02:   DEFM    'net> echo VAX incorrect (V6NET,FONCT)'
        DEFB    CR
        DEFB    0
ER03:   DEFM    'net> abandon operateur ou'
        DEFB    CR
        DEFM    ' accuse reception start incorrect (V6NET,FONCT)'
        DEFB    CR
        DEFB    0
ER04:	DEFM	'net> erreur non reception du prompt VAX'
	DEFM	' (V6NET,FCOM)'
	DEFB	CR
	DEFB	0
ER05:	DEFM	'net> syntaxe * interdite dans la commande R'
	DEFB	CR
	DEFB	0
ER06:	DEFM	'net> syntaxe * interdite car presence de l''option /N'
	DEFB	CR
	DEFB	0
ER07:	DEFM	'net> erreur de syntaxe'
	DEFB	CR
	DEFB	0
;
;
;
        END     MAIN
