*INCLUDE V6NETENT.S
*INCLUDE V6NETEQU.S
*INCLUDE V6NETEXT.S
*INCLUDE V6NET0GBL.S
;
;
;	POINTS D'ENTREE
;	***************
;
;	AFFI : AFFICHAGE D'UN MESSAGE SUR LA CONSOLE OPERATEUR
;	OUTCAR : AFFICHAGE D'UN CARACTERE SUR LA CONSOLE OPERATEUR
;	READC : LECTURE D'UNE COMMANDE SUR LA CONSOLE OPERATEUR
;	TABORT : TEST DEMANDE D'ARRET PAR L'OPERATEUR
;	EMCAR : EMISSION CARACTERE VERS SYSTEME HOTE
;	RECCAR : ATTENTE RECEPTION CARACTERE EMIS PAR SYSTEME HOTE
;	EMNAM  : EMISSION D'UN MESSAGE CONTENANT UN NOM DE FICHIER
;;	TOPT   : TEST PRESENCE OPTION ET EVALUATION VALEUR ASSOCIEE
;;	ASCI4  : CONVERSION BINAIRE ASCI SUR 4 CARACTERES
;
;
;
;	VARIABLES PUBLIQUES
;	*******************
;
;
;	ABORT : CODE D'ABORT DETECTE PAR LA PROCEDURE DE TEST 
;		DEMANDE D'ARRET PAR L'OPERATEUR : CETTE VARIABLE 
;		EST TESTEE DANS LE MODULE PRINCIPAL POUR VERIFIER 
;		SI L'OPERATEUR N'A PAS DEMANDE L'ARRET D'UNE COMMANDE
;	        MULTIFICHIER (EN FRAPPANT UN CARACTERE CTRL B)
;	        ELLE EST REMISE A ZERO A CHAQUE DEBUT DE COMMANDE
;
;
ABORT:	DEFS	1
;
;
;	VARIABLES EXTERNES
;	******************
;
;	ZREP : ZONE CONTENANT LA DERNIERE COMMANDE FRAPPE PAR L'OPERATEUR
;	ANAME: ZONE OU LE MODULE PRINCIPAL RANGE L'ADRESSE DEBUT DU 
;	       NOM DE FICHIER QUE DOIT EMETTRE LA PROCEDURE EMNAM
;
;
;	VARIABLES LOCALES
;	*****************
;
;	CTO : COMPTEUR DE TEMPS (PROCEDURE RECCAR)
;	CAROPT : STOCKAGE TEMPORAIRE (PROCEDURE TOPT)
;
;
CTO:	DEFS	2
CAROPT:	DEFS	1
*EJECT
;
;
;	SUBROUTINE D'AFFICHAGE MESSAGE SUR ECRAN
;	*****************************************
;
;	EN ENTREE : H-L= ADRESSE DU MESSAGE A AFFICHER
;	            LE MESSAGE DOIT SE TERMINER PAR  00H
;	REGISTRES MODIFIES : H-L,A,C,FLAGS
;
AFFI	EQU	$		;ARRET SUR CARACTERE NUL OU SUR CR
	LD	A,(HL)
	AND	A
	RET	Z
	CALL	OUTCA
	INC	HL
	JP	AFFI
;
;
;	SUBROUTINE D'AFFICHAGE CARACTERE SUR ECRAN
;	******************************************
;
;	EN ENTREE : A=CARACTERE A AFFICHER
;	REGISTRES MODIFIES : A,C,FLAGS
;
OUTCA	EQU	$
	LD	(CONOBF),A
	PUSH	AF
	PUSH	HL
	LD	IY,IO1
	CALL	SYSTEM
	POP	HL
	POP	AF
	RET
;
;	SUBROUTINE LECTURE MESSAGE SUR LA CONSOLE
;	*****************************************
;
;	EN ENTREE : H-L= ADRESSE DE RANGEMENT DU MESSAGE LU
;	REGISTRES MODIFIES : H-L,B-C,A,FLAGS
;
;	LA LECTURE SUR LA CONSOLE EST ASSURREE PAR LE SYSTEME RIO
;
;
READC	EQU	$
	LD	(IO2AD),HL
;
;	RAZ DU BUFFER DE RANGEMENT
;
	XOR	A
	LD	B,SBLECT
READ1:	LD	(HL),A
	INC	HL
	DJNZ	READ1
;
;	APPEL RIO POUR LECTURE CONSOLE
;
	LD	HL,SBLECT		; MAJ NBR OCTETS A LIRE
	LD	(IO2LE),HL
;
;	TEST SI FICHIER DE COMMANDE OU CONSOLE OPERATEUR
;
	LD	A,(140EH)
	AND	04H			; BIT DONT DE SYSFLG
	JP	Z,READ2			; DONT=0 -> NON DO
	LD	A,DO			; LUN DU FICHIER DO
	JP	READ3
READ2:	LD	A,CONIN			; LUN CONSOLE OPERATEUR
READ3:	LD	(IO2LUN),A
	LD	IY,IO2
	CALL	SYSTEM
	LD	HL,(IO2LE)
	LD	(LZREP),HL		; NBR CAR LUS
	RET
;
*EJECT
;
;
;	ROUTINE DE TEST DEMANDE D'ARRET PAR L'OPERATEUR
;	***********************************************
;
;	CETTE ROUTINE SCRUTE L'ETAT DU CLAVIER OPERATEUR : 
;	SI UN CARACTERE Y A ETE	FRAPPE CE CARACTERE EST LU
;	SI CE CARACTERE EST CTRL A OU CTRL B IL EST INTERPRETE 
;	COMME UNE DEMANDE D'ABORT DE LA TACHE EN COURS
;	L'INDICATEUR ABORT EST ALORS POSITIONNE A 1 
;	(CTRL A :ABORT FICHIER)	OU 2 (CTRL B :ABORT LISTE DE FICHIER)
;	EN SORTIE : Z=1 SI PAS DE DEMANDE D'ARRET
;	            Z=0 SI DEMANDE D'ARRET
;	REGISTRES MODIFIES : A,FLAGS
;
;
TABORT	EQU	$		; NON IMPLEMENTE
	LD	A,0		; SET Z FLAG
	AND	A
	RET
;
;
*EJECT
;
;
;	ROUTINE D'EMISSION CARACTERE
;	*****************************
;
;	EN ENTREE : A=CARACTERE A EMETTRE
;	REGISTRES MODIFIES : A,C,FLAGS
;
;
EMCAR	EQU	$
	LD	C,A
EMCAR0:	IN	A,(STLPDP)
	AND	PRET
	JP	Z,EMCAR0
	LD	A,C
	OUT	(DALPDP),A
	RET
;
;	ROUTINE DE RECEPTION CARACTERE
;	******************************
;
;	EN SORTIE : A=CARACTERE RECU DU VAX
;	            SI AUCUN CARACTERE N'A ETE RECU DU VAX AU 
;		    BOUT DU DELAI DETERMINE PAR LA CONSTANTE VTO 
;		    : INDICATION D'INCIDENT : CARRY=1
;	REGISTRES MODIFIES : A,FLAGS
;
;
RECCAR	EQU	$
	PUSH	HL
	PUSH	BC
	LD	HL,VTO
	LD	(CTO),HL
REC0:	LD	B,255
REC1:	IN	A,(STLPDP)
	AND	RECU
	JP	NZ,REC2
	DJNZ	REC1
	LD	HL,(CTO)
	DEC	HL
	LD	(CTO),HL
	LD	A,H
	OR	L
	JP	NZ,REC0
	SCF
	JP	REC3
REC2:	IN	A,(DALPDP)
REC3:	POP	BC
	POP	HL
	RET
;
;
;
;	ROUTINE D'ENVOI MESSAGE NOM DE FICHIER
;	**************************************
;
;	L'ADRESSE DU NOM DE FICHIER A COMMUNIQUER AU HOST 
;	A ETE RANGEE AVANT L'APPEL DANS LA VARIABLE ANAME
;
;	LA LONGUEUR DU MESSAGE EMIS EST DETERMINEE PAR LA CONSTANTE SBC
;	ATTENTION : CETTE LONGUEUR FAIT PARTIE DES CONVENTIONS 
;	DE TRANSMISSION	ENTRE LE PROCESSEUR NET ET LE SYSTEME HOTE :
;	NE PAS MODIFIER CETTE CONSTANTE SANS LA MODIFIER AUSSI 
;	DANS LE LOGICIEL SUR LE SYSTEME HOTE
;
;	EN SORTIE : Z = 1 : SI NOM DE FICHIER BIEN EMIS ET 
;			    ACCUSE POSITIF RECU DU SYSTEME HOTE
;	            Z = 0 : SI PAS D'ACCUSE RECU DU SYSTEME HOTE 
;			    OU ACCUSE INCORRECT
;
;
EMNAM	EQU	$
	LD	B,SBC
	LD	HL,(ANAME)
FEMD1:	LD	A,(HL)
	CALL	EMCAR
	INC	HL
	DJNZ	FEMD1
	CALL	RECCAR		; ATTENTE ACCUSE DE RECEPTION
	JP	C,EMN1
	CP	ACK
	RET	Z
EMN1:	LD	A,01H
	AND	A
	RET
*EJECT
;
;	*****************************************************
;	*                                                   *
;	*    ANALYSE ZONE OPTION DES COMMANDES OPERATEUR    *
;	*                                                   *
;	*****************************************************
;
;
;	TEST PRESENCE OPTION ET EVALUATION VALEUR ASSOCIEE
;	**************************************************
;
;	LA SYNTAXE DES OPTIONS EST :
;	<ZONE OPTION> = <VIDE>
;	<ZONE OPTION> = <OPTION> <ZONE OPTION>
;	<OPTION>      = <SLASH> <NOM> <ESPACE> <NBRE HEXA>
;	<SLASH>       = /
;	<NOM>         = <CARACTERE ALPHA>
;	<NBRE HEXA>   = <CHIFFRE HEXA> <CHIFFRE HEXA> <CHIFFRE HEXA> 
;			<CHIFFRE HEXA>
;
;	CETTE PROCEDURE DETERMINE SI L'OPTION DONT LE NOM EST 
;	PASSE EN PARAMETRE EST PRESENTE DANS LA ZONE COMMANDE 
;	(ZONE ZREP)
;	SI OUI : LA VALEUR HEXA ASSOCIEE EST ANALYSEE ET SA VALEUR 
;	EST RETOURNEE A LA PROCEDURE APPELLANTE
;
;	EN ENTREE : A=CARACTERE OPTION RECHERCHE
;	EN SORTIE :	C=1 SI ERREUR SYNTAXIQUE
;			Z=1 SI OPTION PRESENTE
;			H,L= VALEUR HEXA ASSOCIEE
;	REGISTRES MODIFIES : B-C,D-E,H-L,A,FLAGS
;
;
;
;TOPT	EQU	$
;	LD	(CAROPT),A
;	LD	HL,ZREP
;TO1:	LD	A,(HL)
;	INC	HL
;	AND	A
;	JP	Z,TO2
;	CP	SLASH
;	JP	NZ,TO1
;	LD	B,(HL)
;	INC	HL
;	LD	A,(CAROPT)
;	CP	B
;	JP	NZ,TO1
;	INC	HL
;	CALL	HEXA
;	RET	C
;	XOR	A
;	RET
;TO2:	LD	A,1
;	AND	A
;	RET
;
;	CONVERSION ASCII-BINAIRE
;	************************
;
;	EN ENTREE : H-L=ADRESSE DE LA ZONE A CONVERTIR
;	            CETTE ZONE DOIT CONTENIR 4 CARACTERES HEXA
;	EN SORTIE : SI PAS D'ERREUR : CARRY=0 H-L=VALEUR HEXA 
;		    CONVERTIE
;	            SI ERREUR       : CARRY=1
;	REGISTRES MODIFIES : C,D-E,H-L,A,FLAGS
;
;
;HEXA	EQU	$
;	LD	D,0
;COL2:	LD	A,(HL)
;	INC	HL
;	CP	CR
;	JP	Z,COL3
;	CP	SLASH
;	JP	Z,COL3
;	CP	VIRG
;	JP	Z,COL3
;	ADD	A,0D0H
;	CP	0AH
;	JP	C,COL25
;	ADD	A,0EFH
;	CP	06H
;	JP	C,COL24
;	SCF
;	RET
;COL24:	ADD	A,0AH
;COL25:	LD	C,A
;	LD	A,D
;	RLCA
;	RLCA
;	RLCA
;	RLCA
;	AND	0F0H
;	LD	D,A
;	LD	A,E
;	RRCA
;	RRCA
;	RRCA
;	RRCA
;	AND	0FH
;	OR	D
;	LD	D,A
;	LD	A,E
;	RLCA
;	RLCA
;	RLCA
;	RLCA
;	AND	0F0H
;	OR	C
;	LD	E,A
;	JP	COL2
;COL3:	EX	DE,HL
;	RET
;
;
;
;*EJECT
;
;
;
;	CONVERSION DE 2 OCTETS EN ASCII
;	*******************************
;
;	NBRE A CONVERTIR DANS (D,E)
;	ADRESSE DE RANGEMENT DU RESULTAT DANS (H,L)
;	REGISTRES MODIFIES : B-C,D-E,H-L,A,FLAGS
;
;ASCI4	EQU	$
;	LD	A,D
;	CALL	ASC
;	LD	A,E
;	CALL	ASC
;	RET
;ASC	EQU	$
;	CALL	ASCI
;	LD	(HL),B
;	INC	HL
;	LD	(HL),C
;	INC	HL
;
;	ROUTINE DE CONVERSION OCTET EN ASCII
;	************************************
;
;	EN ENTREE : OCTET A CONVERTIR DANS A
;	EN SORTIE : RESULTAT DANS B,C
;	REGISTRES MODIFIES : B-C,A,FLAGS
;ASCI	EQU	$
;	PUSH	AF
;	CALL	HEXASC
;	LD	C,A
;	POP	AF
;	RLCA
;	RLCA
;	RLCA
;	RLCA
;	CALL	HEXASC
;	LD	B,A
;	RET
;
;
;	ROUTINE DE CONVERSION CHIFFRE HEXA EN ASCII
;	*******************************************
;
;	EN ENTREE : CHIFFRE A CONVERTIR DANS A
;	EN SORTIE : RESULTAT DANS A
;	REGISTRES MODIFIE : A,FLAGS
;
;HEXASC	EQU	$
;	AND	0FH
;	CP	0AH
;	JP	NC,HEX1
;	ADD	A,'0'
;	RET
;HEX1:	ADD	A,'A'-0AH
;	RET
;
*EJECT
;
;
;	SUBROUTINE PURGE LIGNE VAX
;	**************************
;
;	ON ENVOI AU VAX UN CR POUR PURGER LES EVENTUELS 
;	CARACTERES SE TROUVANT DANS LE BUFFER MCR
;	PUIS ON ATTEND LA RECEPTION DU PROMPT VAX  CR,CR,LF, ,$
;
PURG	EQU	$
	LD	A,CR
	CALL	EMCAR
PURG1:	CALL	RECCAR
	JP	C,PURG1
	CP	'$'
	JP	NZ,PURG1
	RET
;
;
;
;	SUBROUTINE INITIALISATION LIGNE MCZ-VAX
;	***************************************
;
;	USART 1 DE LA CARTE SIB UTILISE EN MODE POOLING (PAS D'IT)
;	CTC 0 EST UTILISE EN COUNTER MODE
;	ENTREE DU CTC 0 = HORLOGE EXTERNE PHI/2 DE LA CARTE SIB
;	SORTIE DU CTC 0 = CK/T1
;	FACTEUR DE DIVISION DU CTC 0 = RATE1
;	FACTEUR DIVISION USART 1  X=16
;
INTRAN	EQU	$
;
;	CLEAR ALL CTC INTERRUPT DISABLE
	LD	B,4		; DO BAUD RATE GENERATOR
	LD	C,CTC0		; ON CTC0
	LD	A,OFFMOD
IN0:	OUT	(C),A
	INC	C
	DJNZ	IN0
;
	LD	B,4		; DO RECEIVER CHANNELS
	LD	C,CTC1		; ON CTC 1
	LD	A,OFFMOD
IN1:	OUT	(C),A
	INC	C
	DJNZ	IN1
;
	LD	B,4		; DO TRANSMITTER CHANNELS
	LD	C,CTC2		; ON CTC 2
	LD	A,OFFMOD
IN2:	OUT	(C),A
	INC	C
	DJNZ	IN2
;
;	RESET AND INITIALIZE ALL 4 USART
	LD	C,USART0+1	; CONTROL ADR PORT
	LD	B,4
IN3:	LD	A,0
	OUT	(C),A		; THREE INTERNAL RESET
	OUT	(C),A
	OUT	(C),A
	LD	A,RESCOM
	OUT	(C),A		; RETURN MODE INSTRUCTION
	LD	A,SIBMOD
	OUT	(C),A		; SET UP TESTING MODE
	LD	A,SIBCOM	; ENABLE TR AND RCV
	OUT	(C),A
	DEC	C
	IN	A,(C)		; CLEAR OUT RECEIVER BUFFER
	INC	C
	INC	C
	INC	C
	DJNZ	IN3
;
;	SET UP CTC 0 TO GENERATE BAUD RATE
	LD	A,CNTMOD	; CHANNEL 1 IN COUNTER MODE
	OUT	(CTC0+1),A
	LD	A,RATE1		; M FACTOR FOR CTC 0
	OUT	(CTC0+1),A
;
	RET
;
;
;
IO1	EQU	$		; WRITE 1 BYTE BINARY ON CONOUT
	DEFB	CONOUT
	DEFB	WBIN
	DEFW	CONOBF
	DEFW	1
	DEFW	0
	DEFW	0
IO1ST:	DEFB	0
	DEFW	0
CONOBF:	DEFS	1
;
;
;
IO2	EQU	$		; LECTURE CONSOLE 
IO2LUN:	DEFS	1		; LUN DE LECTURE
	DEFB	RLIN
IO2AD:	DEFW	0
IO2LE:	DEFW	SBLECT
	DEFW	0
	DEFW	0
IO2ST:	DEFB	0
	DEFW	0
;
;
LZREP:	DEFS	2
;
	END
