*INCLUDE V6NETENT.S
*INCLUDE V6NETEQU.S
*INCLUDE V6NETEXT.S
*INCLUDE V6NET0EXT.S
*INCLUDE V6NET2GBL.S
*INCLUDE V6NET4EXT.S
;
;
;			MODULE D'EMISSION DE FICHIER
;			----------------------------
;
;
;	POINT D'ENTREE DU MODULE
;	************************
;
;	CE MODULE EST APPELLE DEPUIS LE MODULE PRINCIPAL PAR CALL FEMD
;	IL RETOURNE LE CONTROLE PAR UN RET
;	AU MOMEMT DE L'APPEL LA VARIABLE ANAME DOIT CONTENIR 
;	L'ADRESSE OU SE	TROUVE LE NOM DU FICHIER A TRAITER
;
;	A LA SORTIE DU MODULE :
;	- SI PAS D'INCIDENT : Z FLAG = 1
;	- SI INCIDENT DETECTE : Z FLAG = 0 ET CODE D'ERREUR DANS A
;
;
;
;
;	PROCEDURES EXTERNES
;	*******************
;
;	TRANSMISSION AVEC LE SYSTEME HOTE :
;	- EMNAM : EMISSION DU NOM DE FICHIER A RECEVOIR
;	- EMCAR : EMISSION D'UN CARACTERE VERS LE SYSTEME HOTE
;	- RECCAR: ATTENTE RECEPTION D'UN CARACTERE EMIS PAR LE HOST
;
;	LECTURE DU FICHIER A EMETTRE
;	- CARBUF : LECTURE CARACTERE PAR CARACTERE DU FICHIER A EMETTRE
;	           ( LE FICHIER A EMETTRE EST OUVERT ET FERME DANS LE
;	             MODULE PRINCIPAL )
;	  CETTE ROUTINE RETOURNE :
;		- CARRY = 1 ET Z = 1 SI FIN DE FICHIER
;		- CARRY = 1 ET Z = 0 SI INCIDENT DE LECTURE
;		- CARRY = 0 ET OCTET COURANT DU FICHIER DANS A
;
;	TEST DEMANDE D'ABORT PAR L'OPERATEUR
;	- ROUTINE TABORT : CETTE ROUTINE SURVEILLE SI UN CARACTERE
;             DTRL A OU CTRL B A ETE FRAPPE A LA CONSOLE INDIQUANT
;             QUE L'OPERATEUR DESIRE ABORTER LA TRANSMISSION
;             EN COURS
;             ELLE RETOURNE : Z = 0 SI PAS DE DEMANDE D'ABORT
;		                  Z = 1 SI DEMANDE D'ABORT
;
*EJECT
;
;		TRAITEMENT EMISSION FICHIER
;		****************************
;
;
;	ON REMET A ZERO LES INDICATEURS :
;		- INCID : INDICATEUR D'INCIDENT
;		- FINF  : INDICATEUR DE FIN DE FICHIER
;
;	PUIS ON APPELLE LA ROUTINE EMNAM QUI ASSURE L'EMISSION 
;	DU NOM DU FICHIER A RECEVOIR
;	CETTE ROUTINE EMET LE NOM DU FICHIER PUIS SE MET EN 
;	ATTENTE D'UN ACCUSE DE RECEPTION EMIS PAR LE HOST QUI SIGNALE 
;	QU'IL A CORRECTEMENT OUVERT LE FICHIER	DEMANDE
;	EN CAS DE RECEPTION D'UN ACCUSE NEGATIF OU NON CONFORME : 
;	LA ROUTINE RETOURNE 0 DANS Z FLAG POUR SIGNALER L'INCIDENT
;
;	SI LA ROUTINE EMNAM RETOURNE UN RESULTAT POSITIF ON VA EMETTRE
;	LE PREMIER BLOC
;
;	APRES CHAQUE EMISSION D'UN BLOC ON SE MET EN ATTENTE 
;	DE LA RECEPTION DE L'ACCUSE QUE DOIT EMETTRE LE SYSTEME HOTE :
;         - SI UN ACCUSE POSITIF EST RECU ON PASSE AU BLOC SUIVANT
;	  - SI L'ACCUSE RECU EST NEGATIF : LE SYSTEME HOTE A MAL RECU
;	    LE DERNIER BLOC EMIS : ON VA LE REEMETTRE
;	  - SI L'ACCUSE EST ERRONNE : RETOUR EN ERREUR
;
;	QUAND LE DERNIER BLOC DU FICHIER A ETE EMIS ET BIEN RECU 
;	ON EMET UN MESSAGE EOT POUR SIGNALER LA FIN DE LA TRANSMISSION
;
;
;
;
FEMD	EQU	$
	XOR	A
	LD	(FINF),A		;FINF = 0
	LD	(INCID),A		;INCID = 0
;
	CALL	EMNAM
	JP	Z,FEM0
	LD	HL,ER200
	CALL	AFFI
	LD	A,'B'
	AND	A
	RET
;
; PREPARATION BUFFER D'EMISSION
;
FEM0:	LD	DE,BUFE+1
	LD	A,STX
	LD	(BUFEX),A
	LD	B,SBE
	LD	C,0		; INIT CALCUL BCC DANS C
FEM1:	CALL	CARBUF		; CAR COURANT A EMETTRE
	JP	NC,FEM2
	JP	NZ,FEM10	; SI EOF
	LD	HL,FINF
	INC	(HL)		; SET INDICATEUR FINF
	LD	A,EOT
	LD	(BUFEX),A	; RANGER EOT DANS MESSAGE
	JP	FEM3
FEM10:	LD	HL,INCID	; SI INCIDENT DE LECTURE
	LD	(HL),'2'
	LD	HL,ER201
	CALL	AFFI
	LD	A,DLE
	LD	(BUFEX),A
	JP	FEM3
;
FEM2:	LD	(DE),A
	XOR	C
	LD	C,A		; MAJ BCC
	INC	DE
	DJNZ	FEM1
FEM3:	LD	A,SBE
	SUB	B
	LD	(BUFE),A	; RANGER LONGUEUR MESSAGE
	LD	A,C
	LD	(DE),A		; RANGER BCC	
;
; TEST DEMANDE D'ARRET PAR OPERATEUR
;
FEM30:	CALL	TABORT
	JP	Z,FEM31		; SI ABORT DEMANDE
	LD	A,DLE
	LD	(BUFEX),A	; ALORS EMETTRE DLE
	LD	HL,INCID
	LD	(HL),'7'	; ET POSITIONNER INDICATEUR INCID
	LD	HL,ER202
	CALL	AFFI
;
; EMISSION BUFFER
;
FEM31:	LD	B,0
TEMP1:	LD	A,30		; PETIT TEMPO
TEMP2:	DEC	A
	JP	NZ,TEMP2
	DJNZ	TEMP1
	LD	A,(BUFEX)
	CALL	EMCAR
	LD	B,SBE+2
	LD	DE,BUFE
FEM4:	LD	A,(DE)
	CALL	EMCAR
	INC	DE
	DJNZ	FEM4
;
; ATTENDRE ACCUSE DE RECEPTION
;
FEM44:	CALL	RECCAR
	JP	NC,FEM40
	LD	HL,ER203
	CALL	AFFI
	LD	A,'6'
	AND	A
	RET
FEM40:	CP	ACK
	JP	Z,FEM5		; SI ACCUSE POSITIF TESTER FIN FICHIER
	CP	NACK
	JP	Z,FEM30		; SI NACK REEMETTRE LE BLOC
	LD	HL,ER204
	CALL	AFFI
	LD	A,'4'
	AND	A
	RET
FEM5:	LD	A,(INCID)
	AND	A
	JP	NZ,FEM6
	LD	A,(FINF)
	AND	A
	JP	Z,FEM0		; SI PAS INCIDENT ET PAS EOF NEXT BLOC
	XOR	A
	AND	A
	RET			; RETOUR SANS ERREUR
FEM6:	SCF
	RET
;
;
;
;
;
;
INCID:	DEFS	1		; INDICATEUR D'INCIDENT
FINF:	DEFS	1		; INDICATEUR DE FIN DE FICHIER
BUFEX:	DEFS	1
BUFE:	DEFS	132
;
;
;	MESSAGES ERREUR
;	---------------
ER200:	DEFM	'net> erreur emission message nom de fichier (V6NET2,FEMD)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER201:	DEFM	'net> abandon transmission [emission DLE] (V6NET2,FEMD)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER202:	DEFM	'net> abandon transmision par l''operateur (V6NET2,FEMD)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER203:	DEFM	'net> time_out accuse reception message (V6NET2,FEMD)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER204:	DEFM	'net> accuse reception incorrect (V6NET2,FEMD)'
	DEFB	LF
	DEFB	CR
	DEFB	0
;
;
	END
