*INCLUDE V6NETENT.S
*INCLUDE V6NETEQU.S
*INCLUDE V6NETEXT.S
*INCLUDE V6NET0EXT.S
*INCLUDE V6NET3GBL.S
*INCLUDE V6NET4EXT.S
*EJECT
;
;	MODULE DE RECEPTION DES FICHIERS
;	********************************
;
;
;
;	POINT D'ENTREE DU MODULE
;	************************
;
;	CE MODULE EST APPELLE DEPUIS LE MODULE PRINCIPAL PAR CALL FREC
;	IL RETOURNE LE CONTROLE PAR UN RET
;	AU MOMEMT DE L'APPEL LA VARIABLE ANAME DOIT CONTENIR 
;	L'ADRESSE OU SE	TROUVE LE NOM DU FICHIER A TRAITER
;
;	A LA SORTIE DU MODULE :
;		- SI PAS D'INCIDENT : Z FLAG = 1
;		- SI INCIDENT DETECTE : Z FLAG = 0 ET CODE 
;		  D'ERREUR DANS A
;
;
;
;
;	PROCEDURES EXTERNES
;	*******************
;
;	TRANSMISSION AVEC LE SYSTEME HOTE :
;	- EMNAM : EMISSION DU NOM DE FICHIER A RECEVOIR
;	- EMCAR : EMISSION D'UN CARACTERE VERS LE SYSTEME HOTE
;	- RECCAR: ATTENTE RECEPTION D'UN CARACTERE EMIS PAR LE HOST
;
;	ECRITURE SUR FICHIER DE RECEPTION :
;	- WRICAR : ECRITURE CARACTERE PAR CARACTERE DANS LE FICHIER DE
;	           RECEPTION
;	           ( LE FICHIER DE RECEPTION EST OUVERT ET FERME DANS LE
;	             MODULE PRINCIPAL )
*EJECT
;
;		TRAITEMENT RECEPTION FICHIER
;		****************************
;
;
;	ON APPELLE LA ROUTINE EMNAM QUI ASSURE L'EMISSION DU 
;	NOM DU FICHIER A RECEVOIR
;	CETTE ROUTINE EMET LE NOM DU FICHIER PUIS SE MET EN 
;	ATTENTE D'UN ACCUSE DE RECEPTION EMIS LE HOST QUI SIGNALE 
;	QU'IL A CORRECTEMENT OUVERT LE FICHIER	DEMANDE
;	EN CAS DE RECEPTION D'UN ACCUSE NEGATIF OU NON CONFORME : 
;	LA ROUTINE RETOURNE 0 DANS Z FLAG POUR SIGNALER L'INCIDENT
;
;	SI LA ROUTINE EMNAM RETOURNE UN RESULTAT POSITIF ON VA SE METTRE
;	EN ATTENTE DU PREMIER BLOC
;	PUIS ON VERIFIERA LE MESSAGE RECU
;	SI LA VERIFICATION EST OK :
;		LES CARACTERES DU BLOC SERONT RANGES DANS LE 
;		FICHIER DE RECEPTION
;		PUIS UN ACCUSE POSTIF SERA EMIS VERS LE HOST
;	SINON :
;		UN ACCUSE NEGATIF EST EMIS VERS LE HOTE POUR LUI DEMANDER
;		DE REEMETTRE LE BLOC
;
;	LA TRANSMISSION SE TERMINE :
;		- SOIT SUR RECEPTION D'UN BLOC EOT : FIN DE TRANSMISSION
;		- SOIT SUR RECEPTION D'UN BLOC DLE : ABORT  TRANSMISSION
;		  PAR LE SYSTEME HOTE
;
;
;
;
FREC	EQU	$
	CALL	EMNAM		; EMETTRE LE NOM DU FICHIER
	JP	Z,FRE05		; SI ERREUR ALORS
	LD	HL,ER300
	CALL	AFFI
	LD	A,'B'
	AND	A
	RET			; RETOUR EN ERREUR
;
; RECEPTION BLOC
;
FRE05:	LD	B,SBR
	LD	DE,BUFR
FRE1:	CALL	RECCAR
	JP	C,FRE30		; SI TIME -OUT
	LD	(DE),A
	INC	DE
	DJNZ	FRE1
;
; VERIFICATION ENTETE
;
	LD	HL,BUFR
	LD	A,(HL)
	CP	EOT
	JP	Z,FRE9
	CP	DLE
	JP	Z,FRE8
	CP	STX
	JP	NZ,FRE7
;
; VERIFICATION DU BCC
;
	INC	HL
	LD	B,(HL)		; LONGUEUR DANS B
	LD	A,0		; INIT CALCUL BCC DANS A
FRE2:	INC	HL
	XOR	(HL)
	DJNZ	FRE2
	INC	HL
	XOR	(HL)
	JP	NZ,FRE4		; SI BCC INCORRECT
;
; ECRITURE BLOC
;
	LD	DE,BUFR+1
	LD	A,(DE)
	LD	B,A		; LONGUEUR DANS B
	INC	DE
FRE3:	LD	A,(DE)
	INC	DE
;				; SUPPRESSION LF APRES CR
	PUSH	AF
	LD	A,(TFIC)	; TEST TYPE DE FICHIER
	CP	ASCII
	JP	NZ,FRE14	; PAS DE SUPRESSION LF APRES CR
	POP	AF		; RESTORE A
	PUSH	AF
	CP	CR
	JP	NZ,FRE10
	LD	A,1
	LD	(ICR),A
	POP	AF
	JP	FRE20
FRE10:	CP	LF
	JP	NZ,FRE13
	LD	A,(ICR)
	CP	1
	JP	NZ,FRE13
FRE11:	LD	A,0
	LD	(ICR),A
	POP	AF
	JP	FRE31		; ON SAUTE LE LF
FRE13:	LD	A,0
	LD	(ICR),A
FRE14:	POP	AF
FRE20	EQU	$
	CALL	WRICAR
	JP	C,FRE5		; SI INCIDENT ECRITURE
FRE31:	DJNZ	FRE3
;
; EMISSION ACK
;
	LD	A,ACK
	CALL	EMCAR
	JP	FRE05
;
; BCC ERRONE : ENVOYER ACCUSE NEGATIF ET ATTENDRE REEMISSION
;
FRE4:	LD	A,NACK
	CALL	EMCAR
	JP	FRE05
;
; SI INCIDENT ENVOYER DLE
;
FRE5:	LD	A,DLE
	CALL	EMCAR
	LD	HL,ER301
	CALL	AFFI
	LD	A,'8'
	AND	A
	RET
;
; CARACTERE D'ENTETE NON RECONNU
;
FRE7:	LD	HL,ER302
	CALL	AFFI
	LD	A,'9'
	AND	A
	RET
;
; RECEPTION DE DLE : ARRETER LE PROCESSUS
;
FRE8:	SCF
	RET
;
; SUR EOT : FIN NORMALE DE TRANSMISSION
;
FRE9:	LD	A,0
	AND	A
	RET
FRE30:	LD	HL,ER303
	CALL	AFFI
	LD	A,'9'
	AND	A
	RET
;
;
;
;
ICR:	DEFB	0
BUFR:	DEFS	132
;
;
;	MESSAGE ERREUR
;	--------------
ER300:	DEFM	'net> erreur emission message nom du fichier (V6NET3,FREC)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER301:	DEFM	'net> abandon transmission [emissoin DLE] (V6NET3,FREC)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER302:	DEFM	'net> caractere entete recu ni EOT,ni DLE,ni STX'
	DEFM	' (V6NET3,FREC)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER303:	DEFM	'net> time-out reception message host ecoule'
	DEFM	' (V6NET3,FREC)'
	DEFB	LF
	DEFB	CR
	DEFB	0
;
;
;
	END
