*INCLUDE V6NETENT.S
*INCLUDE V6NETEQU.S
*INCLUDE V6NETEXT.S
*INCLUDE V6NET4GBL.S
*INCLUDE V6NET0EXT.S
;
; corrections V6.1 TD 8/10/85  dans OPENF traitement /O
;
;
;	POINTS D'ENTREE DU MODULE
;	*************************
;
;	OPENF : OUVERTURE DE FICHIER
;	CLOSEF: FERMETURE DE FICHIER
;	CARBUF: LECTURE CARACTERE COURANT DANS LE FICHIER D'ENTREE
;	WRICAR: ECRITURE CARACTERE COURANT DANS LE FICHIER DE SORTIE
;
;
;
;	VARIABLES PUBLIQUES
;	*******************
;
;	FICHOP INDIQUE SI UN FICHIER EST DEJA OUVERT
;	CET INDICATEUR SERT A FORCER LA FERMETURE AVANT D'OUVRIR 
;	UN NOUVEAU FICHIER
;	IL DOIT ETRE INTIALISE A FAUX DANS LA SEQUENCE D'INTIALISATION 
;	DE NET
;
;
;
;
;	VARIABLES EXTERNES
;	******************
;
;
;	LA ROUTINE D'OUVERTURE DE FICHIER RECUPERE LE NOM DU 
;	FICHIER A OUVRIR DANS LA ZONE ZREP (QUI CONTIENT LA 
;	COMMANDE EN COURS D'EXECUTION)
;
;
;
*EJECT
;
;
;
;	SUBROUTINE OUVERTURE DE FICHIER
;	*******************************
;
;
;	CETTE ROUTINE OUVRE LE FICHIER DONT LE NOM EST CONTENU 
;	DANS LE BUFFER DE COMMANDE ZREP (A PARTIR DU TROISIEME 
;	OCTET : LES 2 PREMIERS CONTENANT LE NOM DE LA COMMANDE PUIS UN ESPACE)
;	LE TYPE D'OUVERTURE EST DETERMINE PAR LE PARAMETRE RECU DANS A
;		1 : OUVERTURE EN LECTURE
;		2 : ACCES EN ECRITURE
;
;	EN SORTIE :
;		- SI OUVERTURE OK : Z FLAG = 1
;		- SI INCIDENT     : Z FLAG = 0
;		                   CODE D'ERREUR DANS A
;
;	APRES LA DEMANDE D'OUVERTURE DE FICHIER FAITE AU SYSTEME 
;	ZDOS  ON EXECUTE LES ACTIONS SUIVANTES :
;	    - POSITIONNEMENT A 1 DE L'INDICATEUR DE FICHIER OUVERT
;	    - SI LE FICHIER A ETE OUVERT EN LECTURE :
;		- LECTURE DU PREMIER BLOC
;		- POSITIONNEMENT D'UN POINTEUR ET D'UN COMPTE D'OCTETS
;		  DANS LE BUFFER DE LECTURE DE FACON A INITIALISER
;		  LES VARIABLES NECESSAIRES AU FONCTIONNEMENT 
;		  DE LA PROCEDURE  CARBUF
;	    - SI LE FICHIER A ETE OUVERT EN ECRITURE :
;		- POSITIONNEMENT D'UN POINTEUR ET D'UN COMPTE 
;		  D'OCTET SUR  UNE ZONE QUI SERVIRA DE BUFFER 
;		  D'ECRITURE POUR LA PROCEDURE WRICAR
;
;
;
OPENF	EQU	$
	LD	(EOPEN),A		; MAJ TYPE OPEN
	LD	A,(FICHOP)		; SI FICHIER RESTE OUVERT 
	AND	A			; IL FAUT LE FERMER
	CALL	NZ,CLOS1
;
; avec ZDOS il faut specifier le type du fichier a ouvrir 
;		soit : ASCII , OBJET ou COMMANDE
; seuls les 2 premiers types sont ici utilises
; par defaut c'est de l'ascii et si l'option /O est presente
; on est alors en presence de binaire.
;
	LD	A,ASCII
	LD	(TFIC),A		; type suppose ascii
	LD	HL,(ANAME)		; POINTE DEBUT CDE OPERATEUR
TYP0:	LD	A,(HL)
	INC	HL
	CP	CR
	JP	Z,TYP1			; FIN RECHERCHE TYPE
	CP	SLASH
	JP	NZ,TYP0			; RECHERCHE OPTION /
	LD	A,(HL)
	CP	'O'			; option /O ?
	JP	NZ,TYP0			; non -> on continue a chercher
	LD	A,OBJ
	LD	(TFIC),A		;type = binaire
;
TYP1	EQU	$
	LD	A,FICH			; ASSIGN FILE ON LUN 4
	LD	(ASGN0),A
	LD	A,ASGN
	LD	(ASGN1),A
	LD	A,2
	LD	(ASGNE0),A
	LD	HL,0
	LD	(ASGN2),HL
	LD	(ASGN3),HL
	LD	(ASGN4),HL
	LD	(ASGN5),HL
	LD	HL,ZREP+2		; MAJ ADR FILENAME
	LD	DE,ASGNE3		; MAJ FILENAME FIELD
;
	LD	A,(HL)			; TEST SI DEVICE INDIQUE
	CP	':'			; SEQUENCE :0/
	JP	NZ,OPE02		; NON
	LD	B,3			; TRANSFERT SEQUENCE :0/
OPE06:	LD	A,(HL)
	LD	(DE),A
	INC	DE
	INC	HL
	DJNZ	OPE06
;
OPE02:	LD	A,(HL)			; recopie le nom du fichier dans
	CP	CR			; FIELD FILENAME sans les options
	JP	Z,OPE05
	CP	SLASH
	JP	NZ,OPE03
	LD	A,CR
	JP	OPE05
OPE03:	INC	HL
	CP	SPA			; SAUTE LES ESPACES
	JP	Z,OPE02
	LD	(DE),A
	INC	DE
	JP	OPE02
OPE05:	LD	(DE),A
	LD	IY,IASGN
	CALL	SYSTEM
	LD	A,(SASGN)
	BIT	6,A
	JP	NZ,OPE3
;
;
	LD	HL,0
	LD	(OPEN0),HL
	LD	(OPEN1),HL
	LD	(OPEN2),HL
	XOR	A
	LD	(OPEN3),A
	LD	A,0FFH
	LD	(OPEN5),A
	LD	A,'*'
	LD	(OPEN4),A
	LD	IY,IOPEN		; OPEN FILE
	CALL	SYSTEM
	LD	A,(SOPEN)
	BIT	6,A
	JP	NZ,OPE1			; ERREUR OPEN
;
	LD	A,(EOPEN)		; TEST TYPE OPEN
	CP	ACCW			; EN ECRITURE ?
	JP	Z,OPE01
;
	LD	HL,FLECT		; SI ACCES EN LECTURE
	LD	(LLECT),HL		; MAJ NBR CAR A LIRE
	LD	IY,ILECT
	CALL	SYSTEM			; LECTURE DISQUE
	LD	A,(SLECT)
	CP	EOF
	JP	Z,OPE00			; SI EOF
	BIT	6,A
	JP	NZ,OPE2			; SI ERREUR LECTURE
;
OPE00:	CALL	INIPTR			; INIT DES POINTEURS
	LD	A,1
	LD	(FICHOP),A		; SET INDICATEUR FICHIER OUVERT
	JP	OPER
;
OPE01:	LD	HL,FLECT		; ACCES EN ECRITURE
	LD	(RWRIT),HL
	LD	(LLECT),HL
	CALL	INIPTR
;
OPER:	LD	A,0
	AND	A
	RET
;
OPE1:	LD	HL,ER400
	CALL	AFFI
	LD	A,'1'
	AND	A
	RET
;
OPE2:	LD	HL,ER401
	CALL	AFFI
	LD	A,'2'
	AND	A
	RET
;
OPE3:	LD	HL,ER404
	CALL	AFFI
	LD	A,'1'
	AND	A
	RET
;
;
;
; INITIALISATION DES POINTEURS SUR LE BUFFER LECTURE/ECRITURE
;
; ATTENTION : CETTE ROUTINE EST AUSSI UTILISEE PAR LES PROCEDURES :
;             CARBUF (LECTURE CARACTERE SUR FICHIER DISQUE)
;             WRICAR (ECRITURE CARACTERE SUR FICHIER DISQUE)
;
;
INIPTR	EQU	$
	PUSH	DE
	PUSH	AF
	LD	HL,(LLECT)
	LD	(COMPTE),HL
	LD	HL,BUF
	LD	(PTRBUF),HL
	LD	A,(EOPEN)
	CP	ACCW			; ACCES EN ECRITURE
	JP	NZ,INI1			; NON
	LD	DE,FLECT		; FILL BUFFER DISQUE
INI0:	LD	A,0AAH			; AVEC AAH (NECESSAIRE POUR
	LD	(HL),A			; LA FIN DU FICHIER)
	INC	HL
	DEC	DE
	LD	A,D
	OR	E
	JP	NZ,INI0
	LD	HL,BUF
INI1:	POP	AF
	POP	DE
	RET
;
*EJECT
;
;
;	ROUTINE DE LECTURE CARACTERE DANS LE BUFFER DE LECTURE
;	******************************************************
;
;
;	CETTE ROUTINE PERMET DE LIRE LE FICHIER D'ENTREE OCTET PAR OCTET
;	L'INITIALISATION DES VARIABLES DE TRAVAIL NECESSAIRES 
;	A LA PROCEDURE EST ASSURE A L'OUVERTURE DU FICHIER PAR 
;	LA PROCEDURE OPENF
;
;	L'ACCES AU FICHIER EST REALISE DANS CETTE ROUTINE BLOC PAR BLOC 
;	A CHAQUE APPEL DE LA ROUTINE ON DELIVRE L'OCTET COURANT DU BLOC LU
;	QUAND LE BLOC EST EPUISE ON RELIT UN NOUVEAU BLOC OU ON RETOURNE 
;	UNE INDICATION DE FIN DE FICHIER
;
;
;	EN SORTIE :
;		- SI PAS D'INCIDENT : CARRY = 0
;		                      A = CARACTERE COURANT DU FICHIER
;	        - SI FIN DE FICHIER : CARRY = 1 ET Z FLAG = 1
;		- SI INCIDENT DE LECTURE : CARRY = 1 ET Z FLAG = 0
;
;
;
CARBUF	EQU	$
	PUSH	DE
	PUSH	BC
	PUSH	HL
CARB0:	LD	HL,(COMPTE)
	LD	A,L
	OR	H
	JP	Z,CARB1			; SI FIN DE BLOC
	DEC	HL
	LD	(COMPTE),HL		; COMPTE -1
	LD	HL,(PTRBUF)
	LD	A,(HL)			; CAR COURANT DANS A
	LD	B,A			; SAVE REG A
	LD	A,(TFIC)		; TEST SI FICHIER ASCII
	CP	ASCII
	LD	A,B			; RESTORE REG A
	JP	NZ,CARB5		; FICHIER NON ASCII
	CP	0FFH			; DERNIER CAR DU FICHIER ASCII
	JP	Z,CARB3			; OUI-> C=1  ET Z=1
	CCF				; POUR CLEAR CARRY
CARB5:	INC	HL
	LD	(PTRBUF),HL		; MAJ POINTEUR BUFFER
	JP	CARB4
;
CARB1:	LD	A,(SLECT)
	CP	EOF
	JP	Z,CARB3			; SI FIN DE FICHIER
	LD	IY,ILECT
	CALL	SYSTEM
	LD	A,(SLECT)
	CP	EOF
	JP	Z,CARB2
	BIT	6,A
	JP	Z,CARB2
	LD	HL,ER402
	CALL	AFFI
	JP	CARB3			; SI ERREUR READ
CARB2:	CALL	INIPTR
	JP	CARB0			; ALLER RETOURNER 1ER CAR
CARB3:	SCF
CARB4:	POP	HL
	POP	BC
	POP	DE
	RET
;
*EJECT
;
;	ROUTINE DE FERMETURE FICHIER
;	****************************
;
;
;	CETTE ROUTINE TERMINE LE TRAITEMENT D'UN FICHIER :
;	ELLE APPELLE LE SYSTEME ZDOS  POUR EFFECTUER LE CLOSE 
;	DU FICHIER
;	PUIS ELLE REMET A ZERO L'INDICATEUR DE FICHIER OUVERT
;
;	SI LE FICHIER AVAIT ETE OUVERT EN ECRITURE : 
;	AVANT DE DEMANDER LE CLOSE A ZDOS ON ECRIT LE BLOC QUI 
;	ETAIT EN COURS DE CONSTITUTION PAR LA ROUTINE WRICAR
;
;
;
CLOSEF	EQU	$
	LD	A,(EOPEN)		; TEST TYPE OPEN
	CP	ACCW			; OPEN EN ECRITURE
	JP	NZ,CLOS1		; NON
	LD	A,(TFIC)		; TEST TYPE DE FICHIER
	CP	ASCII
	JP	NZ,CLOS0		; NON ASCII PAS BESOIN DE FF
	LD	A,0FFH			; ECRITURE MARQUE FIN FICHIER
	CALL	WRICAR
CLOS0:	CALL	WRITB			; ECRIRE DERNIER BLOC
;
;
;	ON VA MODIFIER LE NBR OCTETS UTILES DU DERNIER RECORD 
;	DE 128 OCTETS ECRIT SUR LE DISQUE
;	CETTE INFORMATION EST CONTENUE DANS LE HEADER DU FICHIER
;	RESERVED FOR SYSTEM USE DU FILE ATTRIBUT SECTION ...
;	OCTETS 11 ET 12
;
	LD	IY,IQAT		; LECTURE FILE ATTRIBUTS
	CALL	SYSTEM
	LD	A,(SQAT)
	BIT	6,A
	JP	NZ,ERCL0
;
	LD	HL,(NCDR)	; NBR OCTETS ECRIT DANS DERNIER
;				; WRITE DISK	(MAX 4KOCTETS)
;
	COND	SZDOS
;
;	si systeme gestion fichier = ZDOS
;	default record size = 128 
;	nbr. car. dernier record = octets 11 et 12 du file header de 116
; 
	LD	A,L		; L=NBR OCTETS UTILES DANS DERNIER
	AND	07FH		; SUPPRIME 128
;				; RECORD DE 128 OCTETS ECRIT PAR RIO
	CP	0		; MULTIPLE DE 128?
	JP	NZ,CLOS2	; NON
	LD	A,128		; OUI -> NBR OCTETS DERNIER RECORD=128
CLOS2:	LD	HL,BUF+10	; ADR OCTETS 11 ET 12 HEADER
	LD	(HL),A		; MAJ NBR OCTETS DERNIER RECORD
;
;
	ENDC
;
;
	COND	SFFS
;
;
;	systeme gestion fichier = FFS
;	default record size = 512 octets
;	nbr. car. dernier record = octets 22 et 23 du file header de 512
;
	LD	A,H		; POIDS FORT
	AND	01H		; SUPRIME 512 ET MULTIPLES
	OR	L
	CP	0
	JP	NZ,CLOS2
	LD	DE,0200H	; 512 OCTETS
	JP	CLOS3
CLOS2:	LD	A,H
	AND	01H		; SUPRIME 512 ET MULTIPLES
	LD	D,A		; POIDS FORT
	LD	E,L		; POIDS FAIBLE
CLOS3:	LD	(BUF+10),DE
	ENDC
;
;
	LD	IY,ISAT		; MODIF DU HEADER FILE
	CALL	SYSTEM
	LD	A,(SSAT)
	BIT	6,A
	JP	NZ,ERCL1
;
;	FERMETURE DU FICHIER
;
CLOS1:	XOR	A
	LD	(FICHOP),A
	LD	IY,ICLOS
	CALL	SYSTEM
	LD	A,(SCLOS)
	BIT	6,A
	JP	NZ,ERCLOS
	RET
ERCLOS:	LD	HL,ER405
ERCL:	CALL	AFFI
	LD	A,'1'
	AND	A
	RET
ERCL0:	LD	HL,ER406
	JP	ERCL
ERCL1:	LD	HL,ER407
	JP	ERCL
;
*EJECT
;
;
;	ROUTINE D'ECRITURE CARACTERE DANS LE BUFFER DE SORTIE
;	*****************************************************
;
;	CETTE ROUTINE PERMET L'ECRITURE DANS LE FICHER DE 
;	SORTIE OCTET PAR OCTET
;	A CHAQUE APPEL L'OCTET PASSE DANS LE REGISTRE A EST 
;	RANGE DANS LE BUFFER D'ECRITURE DISQUE
;	QUAND CE BUFFER EST PLEIN IL EST ECRIT SUR DISQUE PAR 
;	APPEL A LA ROUTINE WRITB
;
;	LES INITIALISATIONS NECESSAIRES AU FONCTIONNEMENT DE 
;	CETTE ROUTINE SONT REALISEES PAR LA ROUTINE OPENF 
;	(OUVERTURE DE FICHIER)
;
;	L'ECRITURE SUR DISQUE DU DERNIER BLOC EN COURS EST 
;	REALISEE PAR LA ROUTINE	CLOSEF (FERMETURE DE FICHIER)
;
;
WRICAR	EQU	$
	LD	HL,(PTRBUF)		; RANGEMENT DU CARACTERE
	LD	(HL),A
	INC	HL
	LD	(PTRBUF),HL
	LD	HL,(COMPTE)		; MAJ COMPTE OCTETS DISPO
	DEC	HL
	LD	(COMPTE),HL
	LD	A,H
	OR	L
	CALL	Z,WRITB			; SI BLOC PLEIN ECRITURE DISQUE
	RET
;
;
; ECRITURE BLOC DISQUE
;
WRITB	EQU	$
	PUSH	DE
	PUSH	BC
	LD	DE,(COMPTE)		; CALCUL NBR OCTETS A ECRIRE
	LD	HL,FLECT
	SCF				; CLEAR CARRY
	CCF
	SBC	HL,DE			; LONG=FLECT-COMPTE
	LD	(NCDR),HL		; NBR OCTETS DERNIER WRITE
	LD	A,H
	OR	L
	JP	Z,WRIT1			; SI LONG=0 EXIT
	LD	(RWRIT),HL
	LD	IY,IWRIT		; ECRITURE DISQUE
	CALL	SYSTEM
WRIT1:	POP	BC
	POP	DE
	LD	A,(SWRIT)
	BIT	6,A
	JP	Z,WRIT3
	LD	HL,ER403
	CALL	AFFI
	JP	WRIT2
WRIT3:	CALL	INIPTR
	RET
WRIT2:	SCF
	RET
;
;
;
;
FICHOP:	DEFS	1		; INDICATEUR FICHIER OUVERT
COMPTE:	DEFS	2
PTRBUF:	DEFS	2
NCDR:	DEFS	2
BUF:	DEFS	FLECT		; BUFFER DISQUE
;
;
;
;
;
IASGN	EQU	$		; ASSIGN FILE ON LUN 4
ASGN0:	DEFS	1
ASGN1:	DEFS	1
ASGN2:	DEFW	0
ASGN3:	DEFW	0
ASGN4:	DEFW	0
ASGN5:	DEFW	0
SASGN:	DEFB	0
	DEFW	EASGN
EASGN	EQU	$
ASGNE0:	DEFS	1
	DEFS	1
	DEFS	1
ASGNE3:	DEFS	32
;
;
IOPEN	EQU	$		; OPEN FILE ON PREVIOUS ASSIGN
	DEFB	FICH
	DEFB	OPEN
OPEN0:	DEFW	0		; DEFAULT ATTRIBUT
OPEN1:	DEFW	0		; DEFAULT
OPEN2:	DEFW	0
OPEN3:	DEFW	0
SOPEN:	DEFB	0
	DEFW	EOPEN
EOPEN:	DEFB	0		; TYPE OPEN
OPEN4:	DEFS	1		; OPEN FILE DRIVE
OPEN5:	DEFS	1		; NO ASSIGN
FOPEN:	DEFS	32		; FILENAME
;
;
;
ICLOS	EQU	$		; CLOSE FILE
	DEFB	FICH
	DEFB	CLOSE
	DEFW	0
	DEFW	0
	DEFW	0
	DEFW	0
SCLOS:	DEFB	0
	DEFW	0
;
;
;
IWRIT	EQU	$		; DISK BINARY WRITE
	DEFB	FICH
	DEFB	WBIN
AWRIT:	DEFW	BUF		; ADR BUFFER
RWRIT:	DEFW	0		; LENGTH TRANSFERT
	DEFW	0
	DEFW	0
SWRIT:	DEFB	0
	DEFW	0
;
;
;
ILECT	EQU	$		; DISK BINARY READ
	DEFB	FICH
	DEFB	RBIN
	DEFW	BUF
LLECT:	DEFW	0		; LENGTH TRANSFERT
	DEFW	0
	DEFW	0
SLECT:	DEFB	0
	DEFW	0
TFIC:	DEFS	1		; INDICATEUR TYPE DE FICHIER
;
;
;
IQAT	EQU	$		; LECTURE HEADER FICHIER
	DEFB	FICH
	DEFB	QAT
	DEFW	BUF
	COND	SZDOS
	DEFW	116
	ENDC
	COND	SFFS
	DEFW	512
	ENDC
	DEFW	0
	DEFW	0
SQAT:	DEFB	0
	DEFW	0
ISAT	EQU	$		; ECRITURE HEADER FICHIER
	DEFB	FICH
	DEFB	SAT
	DEFW	BUF
	COND	SZDOS
	DEFW	116
	ENDC
	COND	SFFS
	DEFW	512
	ENDC
	DEFW	0
	DEFW	0
SSAT:	DEFB	0
	DEFW	0
;
;
;	MESSAGES D'ERREUR
;	-----------------
ER400:	DEFM	'net> erreur ouverture fichier (V6NET4,OPENF)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER401:	DEFM	'net> erreur lecture fichier (V6NET4,OPENF)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER402:	DEFM	'net> erreur lecture fichier (V6NET4,CARBUF)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER403:	DEFM	'net> erreur ecriture fichier (V6NET4,WRICAR)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER404:	DEFM	'net> erreur ASSIGN fichier (V6NET4,OPENF)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER405:	DEFM	'net> erreur fermeture fichier (V6NET4,CLOSEF)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER406:	DEFM	'net> erreur lecture header fichier (V6NET4,CLOSEF)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER407:	DEFM	'net> erreur ecriture header fichier (V6NET4,CLOSEF)'
	DEFB	LF
	DEFB	CR
	DEFB	0
;
;
;
	END
