*INCLUDE V6NETENT.S
*INCLUDE V6NETEQU.S
*INCLUDE V6NET7GBL.S
*INCLUDE V6NETEXT.S
*INCLUDE V6NET4EXT.S
*INCLUDE V6NET0EXT.S
*EJECT
;
;
;
;
;	POINT D'ENTREE DU MODULE
;	************************
;
;	LA ROUTINE TFMF EST APPELLE DEPUIS LA SEQUENCE PRINCIPALE 
;	POUR TESTER SI LE NOM DE FICHIER DE LA COMMANDE COURANTE 
;	EST OU NON UN NOM MULTIPLE
;
;	EN ENTREE : H-L = ADRESSE DE DEBUT DU NOM DE FICHIER
;	EN SORTIE :
;		- SI INCIDENT : CARRY = 1
;		- SI FICHIER SIMPLE : Z = 1
;		- SI FICHIER MULTIPLE :
;			- Z = 0
;			- A = NBRE DE FICHIERS A TRAITER
;			- H-L = ADRESSE DE LA LISTE DES FICHIERS
;
;
;	DESCRIPTION
;	***********
;
;	LA SYNTAXE STANDARD RIO AUTORISE A REPRESENTER 
;	UN ENSEMBLE DE FICHIERS PAR UN NOM MULTIPLE PAR EXEMPLE :
;	:2/AB*.C* REPRESENTERA TOUS LES FICHIERS DU DRIVE 2 
;	DONT LE NOM COMMENCE PAR 'AB' ET L'EXTENSION PAR 'C'
;
;	LE LOGICIEL NET AUTORISE AUSSI CETTE SYNTAXE
;
;	SI LE NOM DE FICHIER POINTE PAR LE PARAMETRE H-L 
;	CONTIENT UN CARACTERE * : LE MODULE VA CONSULTER LA 
;	DIRECTORY DU DRIVE
;	POUR CHAQUE ENTREE DE LA DIRECTORY ON VA EXAMINER SI 
;	LE NOM DU FICHIER CORRESPOND A UN NOM POSSIBLE POUR LE 
;	NOM MULTIPLE CITE
;	SI C'EST LE CAS CE NOM DE FICHIER SERA RANGE DANS UNE 
;	LISTE DONT LE NBRE D'ELEMENTS ET L'ADRESSE SERA RETOURNEE 
;	A LA SEQUENCE APPELLANTE
;
;
;
;
;
TFMF	EQU	$
	LD	A,0		; RAZ NBR DE FICHIER
	LD	(NFICH),A
;
;	TEST PRESENCE ETOILE DANS NOM DE FICHIER
;
	PUSH	HL
TF0:	LD	A,(HL)
	INC	HL
	CP	CR		; FIN COMMANDE
	JP	Z,TF1
	CP	'*'
	JP	Z,TF2
	JP	TF0
;
;	CAS D'UN NOM SANS ETOILE
;
TF1:	POP	HL
	LD	A,0
	AND	A		; RETOUR AVEC Z FLAG A 1
	RET
;
;	CAS D'UN NOM AVEC ETOILE
;	ON DEMANDE A RIO L'EXECUTION D'UNE COMMANDE
;	CAT NOM DU FICHIER ET DE SORTIR LE LISTING RESULTAT
;	SUR LE FICHIER NET.DIR QUE L'ON CONSULTERA PAR
;	LA SUITE POUR RECUPERER LE OU LES NOMS DE FICHIER
;	CORRESPONDANT A LA COMMANDE OPERATEUR
;
TF2	EQU	$
;
;	TEST SI CDE R EN MODE MULTIFICHIER
;
	LD	A,(ZREP)
	CP	'R'		; SI OUI L'INTERDIRE
	JP	Z,ERTF2
;
;	CONSTITUTION DE LA COMMANDE CAT
;	EX:	CAT *.S D=2 L=NET.DIR
;
	LD	DE,DIRBF	; RECOPIE NOM DU FICHIER
	LD	HL,(ANAME)
TF3:	LD	A,(HL)
	CP	CR
	JP	Z,TF4
	CP	' '
	JP	Z,TF4
	CP	SLASH
	JP	Z,TF4
	LD	(DE),A
	INC	HL
	INC	DE
	JP	TF3
TF4	EQU	$		; TEST SI DEVICE SPECIFIE
	POP	HL
	LD	A,(HL)
	CP	':'
	JP	NZ,TF5
	LD	A,' '
	LD	(DE),A
	INC	DE
	INC	HL		; INDIQUE DEVICE NUMBER
	LD	A,(HL)
	LD	(NDRIV),A
	LD	HL,DRIVE
	LD	BC,4
	LDIR
TF5	EQU	$
	LD	BC,11		; MAJ LISTING DISPOSITION
	LD	HL,LIS
	LDIR
;
;	DEMANDE DIRECTORY A RIO
;	EXECUTION COMMANDE CAT
;
	LD	HL,DIR
	LD	(CDEAD),HL
	LD	IY,RIOCAL
	CALL	SYSTEM
	LD	A,(SRIO)
	BIT	6,A
	JP	NZ,ERTF0
;
;	OPEN DU FICHIER NET.DIR POUR CONSULTATION RESULTAT
;
	LD	DE,ZREP+2
	LD	HL,LIS+3	; MAJ ZREP POUR OPEN DU FICHIER
	LD	BC,8		; PAR ROUTINE OPENF
	LDIR
	LD	HL,ZREP+2
	LD	(ANAME),HL
	LD	A,ACCR		; OPEN EN LECTURE
	CALL	OPENF
	JP	NZ,ERTF1
;
;	CONSTITUTION TABLE DES NOMS DE FICHIER (ZONE BUFD)
;
TF8:	CALL	CARBUF		; SAUTE 1ERE LIGNE ENTETE
	JP	C,TF14		; SI INCIDENT OU EOF
	CP	CR
	JP	NZ,TF8
	LD	DE,BUFD		; INIT POINTEUR SUR TABLE
TF9	EQU	$
	LD	HL,DEV		; TRANSFERT ZONE DEVICE :X/
	LD	BC,3		; NON A JOUR DU NO DRIVE
	LDIR
	PUSH	DE		; SAVE ADR NO DRIVE
	POP	HL
	DEC	HL
	DEC	HL
	CALL	CARBUF		; SAUTE 1ER CAR ESPACE
	JP	C,TF14
TF10	EQU	$
	CALL	CARBUF		; LECT CAR COURANT
	JP	C,TF14
	CP	' '		; FIN DU NOM DE FICHIER
	JP	Z,TF11		; OUI
	LD	(DE),A
	INC	DE
	JP	TF10
TF11:	LD	A,0
	LD	(DE),A		; MAJ FIN DU NOM PAR CAR NUL
	INC	DE
;
;	MAJ NBR FICHIER DANS TABLE DES NOMS
;
	LD	A,(NFICH)	; +1 DANS NBR FICHIER
	ADD	A,1
	LD	(NFICH),A
;
;	ON CHERCHE NO DU DRIVE (COL 21 DE LA DIRECTORY)
;
TF12:	CALL	CARBUF
	JP	C,TF14
	CP	' '
	JP	Z,TF12
	LD	(HL),A		; MAJ NO DU DRIVE
;
;	ON CHERCHE FIN LIGNE
;
TF13:	CALL	CARBUF
	JP	C,TF14
	CP	CR
	JP	NZ,TF13
	JP	TF9
;
;	TEST SI FIN FICHIER OU INCIDENT
;
TF14	EQU	$
	PUSH	AF
	CALL	CLOSEF		; AUPARAVENT ON FERME NET.DIR
	POP	AF
	JP	NZ,TF15		; RET AVEC C=1 INCIDENT
	CCF			; CLEAR CARRY
	LD	HL,BUFD		; ADR TABLE DES NOMS
	LD	A,(NFICH)
	AND	A		; TEST SI LISTE VIDE
	JP	NZ,TF15		; RET AVEC C=0 ET Z=0 SI NON VIDE
	SCF			; RET AVEC C=1 ET Z=1 SI VIDE
TF15:	RET
;
;
;	TRAITEMENT DES ERREURS
;
ERTF0:	LD	HL,ER700
	CALL	AFFI
	SCF
	RET
ERTF1:	LD	HL,ER701
	CALL	AFFI
	SCF
	RET
ERTF2:	POP	HL
	LD	HL,ER702
	CALL	AFFI
	SCF
	RET
;
;
;	DEFINTION DES DONNEES
;
NFICH	DEFS	1
BUFD	DEFS	FLECT
DEV:	DEFM	': /'
DIR:	DEFM	'CAT '
DIRBF:	DEFS	80
DRIVE	DEFM	' D='
NDRIV:	DEFS	1
LIS:	DEFM	' L=NET.DIR'
	DEFB	CR
;
RIOCAL	EQU	$
	DEFB	0		; SYSTEM CALL
	DEFB	0
CDEAD:	DEFS	2		; COMMAND ADDRESS
	DEFW	0
	DEFW	0
	DEFW	0
SRIO:	DEFB	0
	DEFW	0
;
;
;	NESSAGES ERREUR
;
ER700:	DEFM	'net> ERREUR EXECUTION COMMANDE CAT '
	DEFM	'(V6NET7,TFMF)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER701:	DEFM	'net> ERREUR OPEN NET.DIR (V6NET7,TFMF)'
	DEFB	LF
	DEFB	CR
	DEFB	0
ER702:	DEFM	'net> syntaxique * interdite pour la commande R'
	DEFB	LF
	DEFB	CR
	DEFB	0
;
;
;
;
	END
