;
;	PARAMETRES DE GENERATION DE NET MCZ
;	-----------------------------------
;
;	type du systeme de gestion de fichier MCZ
SZDOS	EQU	0	; SZDOS=1 systeme gestion fichier = ZDOS
;			; SZDOS=0 systeme gestion fichier # ZDOS
SFFS	EQU	1	; SFFS=1  ----------------------- = FFS
;			; SFFS=0  ----------------------- # FFS
;
;	EQUIVALENCES SYSTEME RIO
;	------------------------
;
SYSTEM	EQU	1403H
ERCODE	EQU	13BDH
DO	EQU	0
CONIN	EQU	1
CONOUT	EQU	2
FICH	EQU	4
WSTA	EQU	42H
LSTA	EQU	40H
WBIN	EQU	0EH
RLIN	EQU	0CH
RBIN	EQU	0AH
ASGN	EQU	02H
OPEN	EQU	04H
CLOSE	EQU	06H
QAT	EQU	30H
SAT	EQU	2EH
LCAR	EQU	0BH
WCAR	EQU	0FH
ACCR	EQU	0		; OPEN EN LECTURE
ACCW	EQU	1		; OPEN EN ECRITURE
EOF	EQU	0C9H
ASCII	EQU	0		; type de fichier = ASCII
OBJ	EQU	1		; type de fichier = BINAIRE
PRO	EQU	2		; type de fichier = fich. de commande
;
;
;	EQUIVALENCES CARACTERES SPECIFIQUES
;	-----------------------------------
;
CR	EQU	0DH
LF	EQU	0AH
SPA	EQU	' '
SLASH	EQU	'/'
VIRG	EQU	','
CTRLQ	EQU	13H
CTRLS	EQU	11H
CTRLA	EQU	01H
CTRLB	EQU	02H
CTRLX	EQU	18H
CTRLE	EQU	05H
;
;
;	constantes diverses
;	-------------------
;
VTO	EQU	01FFH	; VALEUR TIME-OUT
SBC	EQU	60	; TAILLE MESSAGE NOM DE FICHIER 	     ;***V6.0
SBLECT	EQU	80	; TAILLE BUFFER LECTURE COMMANDE 	     ;***V6.0
FLECT	EQU	4096	; BUFFER LECTURE DISQUE
SBR	EQU	130	; TAILLE BUFFER RECEPTION MESSAGE
SBE	EQU	127	; TAILLE BUFFER EMISSION
;
;
;	EQUIVALENCES USART(S) 8251 DE LA CARTE SIB
;	------------------------------------------
;
USART0	EQU	8CH		; USART 0 ADDRESS
USART1	EQU	8EH		; USART 1 ADDRESS
STLPDP	EQU	USART1+1	; STATUS PORT LIGNE PDP
DALPDP	EQU	USART1		; DATA PORT LIGNE PDP
PRET	EQU	01H		; TRANSMITTER READY
RECU	EQU	02H		; RECEIVER READY
RESCOM	EQU	40H		; RESET USART TO ACCEPT MODE INSTRUCTION
SIBMOD	EQU	4EH		; ASYNC,8 BIT,NO PARITY,1 STOP BIT,X16
SIBCOM	EQU	37H		; TRANSMIT AND RECEIVE AND ERROR RESET
;
;
;	EQUIVALENCES COUNTER TIMER CIRCUIT (CTC) DE LA CARTE SIB
;	--------------------------------------------------------
;
CTC0	EQU	80H		; CTC 0 ADDRESS (BAUD RATE GENERATOR)
CTC1	EQU	84H		; CTC 1 ADDRESS ( 4 RECEIVER CHANEL)
CTC2	EQU	88H		; CTC 2 ADDRESS ( 4 TRANSMITTER CHANEL)
OFFMOD	EQU	43H		; CTC STOP AND INTERRUPT DISABLE
CNTMOD	EQU	47H		; CHANNEL 1 IN COUNTER MODE
RATE1	EQU	4		; DIVISION FACTOR M FOR CTC0 -> 9600 BD
;
;
;	CODES DE CONTROLE DE LA TRANSMISSION
;	------------------------------------
;
SOH	EQU	01H
START	EQU	SOH
STX	EQU	02H
ACK	EQU	06H		;****V5.0
NACK	EQU	15H
EOT	EQU	04H 		;****V5.0
DLE	EQU	10H
;
;
