$INCLUDE (:F1:V6NET.ENT)
	NAME	NET
;
;
;
;	********************************************************************
;	*                                                                  *
;	*                     MODULE PRINCIPAL                             *
;	*                                                                  *
;	********************************************************************
;
;
;
;	POINTS D'ENTREE DU MODULE
;	*************************
;
;	MAIN : ADRESSE DE LANCEMENT
;	CONTRO : LECTURE COMMANDE LOCALE
;	RETMON : RETOUR AU MONITEUR
;
	PUBLIC	MAIN,CONTRO,RETMON
;
;	VARIABLES PUBLIQUES
;	*******************
;
;	ANAME : POINTEUR SUR LA ZONE OU SE TROUVE LE NOM DE FICHIER CITE DANS
;	        LA COMMANDE EN COURS
;	ZREP  : BUFFER DE RANGEMENT DE LA DERNIERE COMMANDE
;
;
	PUBLIC	ANAME,ZREP
;
;
;	MODULES EXTERNES
;	****************
;
;	IDENT   : ROUTINE D'AFFICHAGE MESSAGE D'IDENTIFICATION
;	SOS     : ROUTINE D'AFFICHAGE DE LA SYNTAXE DES COMMANDES
;	AFFI    : AFFICHAGE D'UNE CHAINE DE CARACTERES SUR LA CONSOLE
;	OUTCA   : AFFICHAGE D'UN CARACTERE SUR LA CONSOLE
;	READC   : LECTURE D'UNE COMMANDE SUR LA CONSOLE
;	TABORT  : TEST DEMANDE D'ABORT OPERATEUR
;	ISIS    : APPEL SYSTEME ISIS
;	OPENF   : OUVERTURE FICHIER ISIS-II
;	CLOSEF  : FERMETURE DE FICHIER ISIS-II
;	TFMF    : TRAITEMENT COMMANDES MULTI-FICHIERS
;	EMCAR   : EMISSION CARACTERE VERS SYSTEME HOTE
;	RECCAR  : RECEPTION CARACTERE EMIS PAR SYSTEME HOTE
;	FEMD    : SEQUENCE D'EMISSION DE FICHIER
;	FREC    : SEQUENCE DE RECEPTION DE FICHIER
;	TRANS   : FONCTIONNEMENT TRANSPARENT
;
;
	EXTRN	IDENT,AFFI,OUTCA,READC,TABORT
	EXTRN	ISIS,OPENF,CLOSEF,TFMF
	EXTRN	EMCAR,RECCAR
	EXTRN	FEMD,FREC
	EXTRN	TRANS,SOS
;
;
;	VARIABLES EXTERNES
;	******************
;
;
;	LA VARIABLE ABORT CONTIENT LE RESULTAT DU DERNIER TEST DE DEMANDE D'ABORT
;
;		- SI PAS DE DEMANDE D'ABORT : ELLE CONTIENT 0
;		- SI DEMANDE D'ABORT SUR UN SEUL FICHIER (CTRL A) : 1
;		- SI DEMANDE D'ABORT SUR TOUTE UNE LISTE (CTRL B) : 2
;
	EXTRN	ABORT
;
;	FICHOP EST UN INDICATEUR DU MODULE D'ACCES AUX FICHIERS : IL DOIT ETRE
;	INITIALISE A ZERO DANS LA SEQUENCE PRINCIPALE D'INIT
;
	EXTRN	FICHOP
;
$INCLUDE (:F1:V6NET.LIT)
;
;	PARAMETRES
;	**********
;
; CONSTANTE DU TIME-OUT RECEPTION CARACTERE
;
VTO	EQU	20H
;
; CODES PROCEDURE DE TRANSMISSION
;
START	EQU	01H		;SOH
;
; CODES D'APPEL SYSTEME ISIS
;
EXIT	EQU	9
WHOCON	EQU	13
ACCR	EQU	1;		CODE ACCESS = READ (POUR OPEN FICHIER)
ACCW	EQU	2;		CODE ACCESS = WRITE (POUR OPEN FICHIER)
;
$EJECT
;
;	*******************************************************************
;	*                                                                 *
;	*              INITIALISATION LOGICIEL VNET                       *
;	*                                                                 *
;	*******************************************************************
;
;
;	IMPRESSION DU MESSAGE D'IDENTIFICATION
;	INITIALISATION DES INDICATEURS DE MODE BATCH ET MULTI-FICHIER
;	READ CONSOLE POUR SAUTER LA LIGNE DE COMMANDE
;		(AU LANCEMENT DE VNET PAR ISIS-II LE PREMIER READ CONSOLE EFFECTUE
;		 ACCEDE A LA LIGNE DE COMMANDE)
;	DETERMINATION DU MODE DE FONCTIONNEMENT DE NET :
;		ON UTILISE L'APPEL SYSTEME WHOCON QUI PERMET DE DETERMINER
;		QUEL EST LE PERIPHERIQUE QUI SERT DE CONSOLE LOGIQUE.
;		SI CE PERIPHERIQUE EST UN DRIVE C'EST QU'ON EST EN MODE BATCH :
;		 NET LANCE PAR UNE COMMANDE SUBMIT
;
;	A LA FIN DE CETTE SEQUENCE :
;		- SI ON EST EN MODE CONVERSATIONNEL : BRANCHEMENT AU MODE TRANSPARENT
;		- SI ON EST EN MODE BATCH : BRANCHEMENT A LA SEQUENCE DE LECTURE
;		  DE LA PREMIERE COMMANDE
;
;
;
	CSEG
;
MAIN	EQU	$
	LXI	SP,ZPILE
	LXI	H,ZREP
	CALL	READC	;	 READ CONSOLE FICTIF POUR CLEAR DU BUFFER ISIS
	CALL	IDENT	;	 IMPRESSION MESSAGE D'IDENTIFICATION
	XRA	A
	STA	LISTE;		MODE LISTE = FAUX
	STA	BATCH;		MODE BATCH=FAUX
	STA	FICHOP;		RESET INDICATEUR FICHIER OUVERT
;				PUIS ALLER LIRE LA COMMANDE
;
;
$EJECT
;
;	*******************************************************************
;	*                                                                 *
;	*            LECTURE DES COMMANDES LOCALES                        *
;	*                                                                 *
;	*******************************************************************
;
;
;	LES COMMANDES LOCALES SONT LUES SUR L'UNITE :CI: (CONSOLE LOGIQUE D'ENTREE)
;	CES COMMANDES SONT DE TYPE MONOFICHIER OU MULTIFICHIERS (UTILISATION DE
;	NOMS DE FICHIERS COMPORTANT UN OU PLUSIEURS CARACTERES * OU ?)
;
;	ON VA D'ABORD DETERMINER SI ON EST OU NON EN TRAIN DE TRAITER UNE COMMANDE
;	MULTIFICHIERS :
;		- SI OUI ON EXECUTERA UNE SEQUENCE DE CALCUL DU NOM DE FICHIER
;		  A TRAITER
;		- SI NON ON DEMANDERA LE NOM DU FICHIER A TRAITER SUR LA CONSOLE
;
;	APRES ANALYSE DE LA COMMANDE RECUE ON SE BRANCHERA AU MODULE DE TRAITEMENT
;	CORRESPONDANT
;
;	ON COMMENCE LA SEQUENCE PAR UNE LECTURE DU DATA PORT LIGNE DE TRANSMISSION :
;	CECI PERMET DE LE VIDER ET EVITE DE PRENDRE UN CARACTERE QUI Y SERAIT
;	RESTE POUR UNE REPONSE DU HOST A LA COMMANDE D'ACTIVATION DE TACHE.
;
;
;
;
CONTRO	EQU	$
	IN	DALR
	LDA	LISTE
	ANA	A
	JZ	CON0
;
;	MODE MULTIFICHIERS
;	******************
;
;
; ON TESTE SI PENDANT L'EXECUTION DE LA COMMANDE PRECEDENTE ON N'A PAS RECU DE
; DEMANDE D'ABORT PORTANT SUR LA TOTALITE DE LA COMMANDE (FRAPPE DE CTRL B PAR
; L'OPERATEUR)
;	- SI OUI : ON SORT DU MODE MULTI FICHIER ET ON PASSE LIRE LA COMMANDE
;	  SUIVANTE
;	- SI NON : ON VA DETERMINER LE PROCHAINE FICHIER A TRAITER
;
	LDA	ABORT
	CPI	2
	JNZ	ML0;		SI ABORT LISTE
	XRA	A
	STA	LISTE;		ALORS SORTIR DU MODE LISTE
	JMP	FCOM
;
; LORS DE L'ANALYSE DE LA COMMANDE QUI A PROVOQUE LE PASSAGE EN MODE MULTIFICHIERS
; LA ROUTINE TMUL A CONSTRUIT UNE LISTE DES FICHIERS A TRAITER :
; ON VA CHERCHER LE NOM DU PROCHAIN FICHIER A TRAITER DANS CETTE LISTE
; ET ON VA LE RECOPIER DANS LA ZONE ZREP (COMMANDE A EXECUTER)
; LA ZONE ZREP CONTIENT TOUJOURS LE NOM DE LA COMMANDE QUI A ETE EMISE
; ON Y RECOPIE LE CONTENU DE LA ZONE OPTION QUI A ETE MEMORISE A PART
; APRES CETTE SEQUENCE ELLE AURA DONC LE MEME FORMAT QUE SI LA COMMANDE CONCERNANT
; LE FICHIER QUE L'ON VA TRAITER AVAIT ETE ENTREE DIRECTEMENT PAR L'OPERATEUR
;
; PUIS ON TESTERA SI LE FICHIER OBTENU EST OU NON LE DERNIER DE LA LISTE
; SI C'EST LE CAS ON REMET A ZERO L'INDICATEUR DE MODE MULTIFICHIERS.
;
ML0:	LHLD	ALISTE
	LXI	D,ZREP+2;	ZONE FICHIER DU BUFFER DE COMMANDE
ML2:	MOV	A,M
	INX	H
	STAX	D
	INX	D
	ANA	A
	JNZ	ML2		;ARRET SUR CARACTERE 00
	SHLD	ALISTE
	DCX	D
	LXI	H,ZOPT;		RECOPIER LA ZONE OPTION
ML25:	MOV	A,M
	INX	H
	STAX	D
	INX	D
	CPI	CR		;ARRET SUR CARACTERE CR
	JNZ	ML25
	MVI	A,0		; POUR AFFI
	STAX	D
	LXI	H,NFICH
	DCR	M;		NFICH=-1;
	JNZ	ML3
	XRA	A		;SI NFICH PASSE A 0
	STA	LISTE;		ON SORT DU MODE LISTE
;
; ON A MAINTENANT DANS ZREP L'IMAGE DE LA COMMANDE A EXECUTER :
;	- CARACTERE DONNANT LE NOM DE LA COMMANDE
;	- NOM DU FICHIER
;	- ZONE OPTION
; ON VA AFFICHER CETTE COMMANDE
;
; PUIS ON PASSERA A LA SEQUENCE D'ANALYSE DE LA COMMANDE
ML3:	LXI	H,ZREP
	CALL	AFFI;		AFFICHER LE BUFFER DE COMMANDE
	MVI	A,LF
	CALL	OUTCA
	JMP	CON05;		PUIS ALLER TRAITER LA COMMANDE
;
;	FONCTIONNEMENT EN MODE MONOFICHIER
;	**********************************
;
;
;	ON VA LIRE LA COMMANDE A EXECUTER SUR L'UNITE :CI:
;	PUIS ON PASSERA A LA SEQUENCE D'ANALYSE DE LA COMMANDE
;
;
CON0:	LXI	H,MES1
	CALL	AFFI		;AFFICHAGE PROMPT NET>
	LXI	H,ZREP
	CALL	READC		;LIRE COMMANDE OPERATEUR
;
$EJECT
;
;	********************************************************************
;	*                                                                  *
;	*                  ANALYSE ET TRAITEMENT DES COMMANDES             *
;	*                                                                  *
;	********************************************************************
;
;
;	LA COMMANDE DE RETOUR A ISIS EST TRAITEE DE FACON PARTICULIERE :
;	EN EFFET CETTE COMMANDE NE COMPORTE PAS DE NOM DE FICHIER
;	ELLE NE PEUT DONC PAS ETRE ANALYSEE COMME LES AUTRES.
;	POUR CELA ON VA IMMEDIATEMENT DETECTER SI LE CODE DE LA COMMANDE EST UN
;	CODE DE RETOUR A ISIS : CARACTERE E
;
;	SINON ON REMET A ZERO L'INDICATEUR D'ABORT
;	ON DETERMINE L'ADRESSE DE NOM DE FICHIER A EMETTRE VERS LE SYSTEME HOTE :
;		LE NOM DE FICHIER DE LA COMMANDE PEUT COMMENCER PAR UNE INDICATION
;		DE NUMERO DE DRIVE :FX: : DANS CE CAS CETTE PARTIE DU NOM DU
;		FICHIER N'EST PAS TRANSMISE AU SYSTEME HOTE
;		L'ADRESSE A LAQUELLE DEBUTE LE NOM A TRANSMETTRE EST RANGEE DANS
;		LA VARIABLE PUBLIQUE ANAME
;
;	PUIS ON VA ANALYSER LE PREMIER CARACTERE DE LA COMMANDE QUI CONTIENT
;	LE NOM DE LA COMMANDE
;	ON RECHERCHE CE NOM DANS LA TABLE DES COMMANDES
;	SI LE NOM EST TROUVE ON RECUPERE L'ADRESSE DE LA SEQUENCE DE TRAITEMENT
;	DE LA COMMANDE
;
;	AVANT DE CE BRANCHER A CETTE SEQUENCE ON APPELLE LA ROUTINE TMUL QUI VA
;	VERIFIER SI LE NOM DE FICHIER CONTENU DANS LA COMMANDE CONTIENT LES CARACTERES * OU ?
;	QUI SIGNALENT UN NOM MULTIPLE
;	- SI C'EST LE CAS : LA ROUTINE TMUL RETOURNE 0 DANS Z FLAG
;	  ON VA ALORS RETOURNER AU DEBUT DE LA SEQUENCE POUR VENIR RANGER
;	  LE NOM DU PREMIER FICHIER A TRAITER DANS LA ZONE DE COMMANDE
;	  PUIS TRAITER CE PREMIER FICHIER
;	- SI TMUL DETECTE UNE ERREUR DANS LE NOM DU FICHIER :
;	  ELLE AFFICHE UN MESSAGE D'ERREUR PUIS RETOURNE CARRY = 1
;	- SI CE N'EST PAS LE CAS : BRANCHEMENT A LA SEQUENCE DE TRAITEMENT
;	  DE LA COMMANDE.
;
;
CON05	EQU	$
	LDA	ZREP;		CODE COMMANDE
	MOV	B,A
	MVI	A,'E'
	CMP	B
	JZ	RETMON;		COMMANDE = RETOUR A ISIS
	MVI	A,'?'
	CMP	B
	JZ	COV;		COMMANDE AIDE OPERATEUR
	MVI	A,'T'
	CMP	B
	JZ	TRANS		;COMMANDE MODE TRANSPARENT SUR HOST
	XRA	A
	STA	ABORT
	LXI	H,ZREP+2
	MOV	A,M
	CPI	':'
	JNZ	CON06
	LXI	H,ZREP+6
CON06:	SHLD	ANAME;	 ADDRESSE NOM DU FICHIER
	LDA	ZREP
	MOV	B,A;	 CARACTERE DE COMMANDE DANS B
	LXI	H,TABADR;RECHERCHER ADRESSE DE BRANCHEMENT CORRESPONDANT
CON1:	MOV	A,M
	INX	H
	ANA	A
	JZ	CON3;	 COMMANDE INCONNUE
	CMP	B
	JZ	CON2;	 ON A TROUVE LE CARACTERE DANS LA TABLE
	INX	H;	 SINON CONTINUER LA RECHERCHE
	INX	H
	JMP	CON1
;
CON2:	MOV	E,M;	 RECUPERER L'ADRESSE DE BRANCHEMENT
	INX	H
	MOV	D,M
	PUSH	D;
	CALL	TMUL
	POP	H
	JC	FCOM;		NOM DE FICHIER ERRONE
	JNZ	CONTRO;		ALLER TRAITER LE PREMIER FICHIER DE LA LISTE
	PCHL	;		TRAITER LE FICHIER
;
CON3:	LXI	H,MESINC	;ERREUR COMMANDE INCONNUE
	CALL	AFFI
	JMP	CONTRO;		BRANCHEMENT A LA SEQUENCE DE FIN DE COMMANDE
;
MES1:	DB	CR,LF
	DB	'NET>'
	DB	0
;
;
;
;
; TABLE DES COMMANDES
;
TABADR	EQU	$
	DB	'S';	S : EMISSION DE FICHIER
	DW	COS
	DB	'R';	R : RECEPTION DE FICHIER
	DW	COR
	DB	0
;
MESINC:	DB	'NET> commande inconnue',LF,CR,0
;
;
$EJECT
;
;	COMMANDE E : RETOUR A ISIS
;	**************************
;
;
RETMON	EQU	$
	MVI	C,EXIT
	LXI	D,EXBL
	CALL	ISIS
;
;
$EJECT
;
;
;	COMMANDE S : EMISSION FICHIER
;	*****************************
;
;
;	ON APPELLE LA ROUTINE OPENF QUI ASSURE L'OUVERTURE DU FICHIER
;	SI L'OUVERTURE SE PASSE BIEN (FICHIER EXISTANT) LA ROUTINE OPENF
;	RETOURNE 1 DANS Z FLAG
;	ON APPELLE ALORS LA ROUTINE FONCT QUI ASSURE L'EMISSION D'UN MESSAGE
;	DEMANDANT L'ACTIVATION DE LA TACHE 'SND6' SUR VAX
;	SI LA TACHE SEND S'ACTIVE CORRECTEMENT LA ROUTINE FONCT RETOURNE
;	1 DANS Z FLAG
;	ON APPELLE ALORS LA ROUTINE FEMD QUI ASSURE L'EMISSION DU FICHIER
;
;	CETTE ROUTINE RETOURNE DANS Z FLAG ET CARRY FLAG UNE INDICATION DE LA
;	FACON DONT S'EST PASSE LE TRANSFERT.
;	CES VALEURS SONT DIRECTEMENT PASSEES A LA ROUTINE 'AFFST' QUI AFFICHE
;	SUR LA CONSOLE UN MESSAGE INDIQUANT LA FACON DONT LA TRANSFERT S'EST
;	PASSE :
;		- abandon SI TRANSFERT INTERROMPU
;
;	A LA FIN DE CETTE SEQUENCE ON SE BRANCHE A LA SEQUENCE DE FIN DE COMMANDE
;
;
COS	EQU	$
;
; OUVERTURE DU FICHIER A EMETTRE
;
	MVI	A,ACCR
	CALL	OPENF;	 OUVERTURE FICHIER EN LECTURE
;
; SI FICHIER BIEN OUVERT : ACTIVER TACHE SUR HOST
;
	MVI	A,START		; ACCUSE HOST ATTENDU
	LXI	H,EMSD;	 ADRESSE BUFFER D'EMISSION COMMANDE DANS (H,L)
	CZ	FONCT
;
; SI TACHE SEND BIEN ACTIVER ALORS : APPEL DE LA SEQUENCE D'EMISSION FICHIER
;
	CZ	FEMD
;
; AU RETOUR : FERMETURE DU FICHIER EMIS PUIS AFFICHAGE COMPTE RENDU
;
CO1:	CALL	AFFST
	CALL	CLOSEF		;FERMETURE FICHIER
	LDA	ABORT
	CPI	2
	JNZ	FCOM
	XRA	A
	STA	LISTE
	JMP	FCOM
;
EMSD:	DB	'SND6'
	DB	CR
;
;
$EJECT
;
;
;	COMMANDE R : RECEPTION DE FICHIER
;	*********************************
;
;
;	LE TRAITEMENT DE CETTE COMMANDE EST IDENTIQUE A CELUI DE LA COMMANDE
;	D'EMISSION DE FICHIER A CES DIFFERENCES PRES :
;		- LE FICHIER A TRAITER EST OUVERT EN ECRITURE
;		- LA TACHE ACTIVEE EST SUR VAX LA TACHE RCV6
;		- SI L'OUVERTURE DU FICHIER SE PASSE BIEN ET SI LA TACHE
;		  S'ACTIVE CORRECTEMENT : C'EST LA ROUTINE FREC QUI EST APPELLEE
;		  POUR ASSURER LE TRANSMISSION EN RECEPTION
;
COR	EQU	$
;
; OUVRIR LE FICHIER A RECEVOIR
;
	MVI	A,ACCW
	CALL	OPENF;	 OUVERTURE FICHIER EN ECRITURE
;
; SI L'OUVERTURE S'EST BIEN PASSEE : ACTIVER LA TACHE SUR HOST
;
	MVI	A,START		; ACCUSE HOST ATTENDU
	LXI	H,EMRC;	 ADRESSE BUFFER D'EMISSION COMMANDE
	CZ	FONCT
;
; SI LA TACHE RECEIVE S'EST BIEN ACTIVEE : APPEL MODULE DE RECEPTION FICHIER
;
	CZ	FREC
;
; AU RETOUR : FERMER LE FICHIER RECU ET AFFICHAGE COMPTE RENDU
;
	CALL	AFFST
	CALL	CLOSEF
	JMP	FCOM
;
EMRC:	DB	'RCV6'
	DB	CR
;
;
$EJECT
;
;
;	COMMANDE V: LISTE DES COMMANDES
;	*******************************
;
;
COV	EQU	$
	CALL	SOS
	JMP	CONTRO
;
;
$EJECT
;
;	FIN DE TRAITEMENT DES COMMANDES
;	*******************************
;
;
;	ON EXECUTE UNE SEQUENCE DE TEMPORISATION 
;	QUI LAISSE LE TEMPS A LA TACHE SUR SYSTEME HOTE DE SE TERMINER 
;	PUIS ON REVIENT LIRE UNE NOUVELLE COMMANDE OU TRAITER LE FICHIER
;	SUIVANT DE LA LISTE (SI ON EST EN MODE MULTIFICHIER).
;
;
;
FCOM	EQU	$
	IN	DALR		; POUR PURGE LIGNE HOST
	MVI	A,CR
	CALL	EMCAR		; TEST SI VMS PRESENT
	CALL	RECCAR
	JNC	FCOM3
	CALL	RECCAR
	JNC	FCOM3
FCOM1:	CALL	RECCAR
	JC	FCOM2
FCOM3:	CPI	'$'		;PROMPT CARACTERE DE VMS
	JNZ	FCOM1
	JMP	CONTRO
FCOM2:	LXI	H,ER04
	CALL	AFFI
	MVI	A,0FFH
	JMP	CONTRO
;
;
$EJECT
;
;
;		ROUTINE FONCT : ENVOI MESSAGE D'ACTIVATION DE TACHE SUR HOST
;		************************************************************
;
;
;	EN ENTREE : H,L = ADRESSE DU MESSAGE D'ACTIVATION
;	                  CE MESSAGE SE TERMINE PAR UN CARACTERE CR
;                   C = CARACTERE ACCUSE VAX ATTENDU
;
;	EN RETOUR Z = 0 OK : TACHE CORRECTEMENT ACTIVEE
;		  Z = 1 ERREUR
;
; LA LIAISON ENTRE LE PROCESSEUR NET EST REALISEE PAR UNE LIGNE DE TRANSMISSION
; SERIE . CETTE LIGNE EST VUE PAR LE SYSTEME HOST COMME UNE CONSOLE NORMALE.
; POUR ACTIVER UNE TACHE ON UTILISE DONC LE MECANISME STANDARD D'ACTIVATION 
; D'UNE TACHE DEJA INSTALLEE 
;	pour VMS : commande XXXX<rc> (ou XXXX est le nom de la tache a activer)
; CE MESSAGE EST RECU PAR LE HOST QUI DECLENCHERA L'ACTIVATION DE LA TACHE.
; UNE FOIS LA TACHE ACTIVEE LES CARACTERES EMIS PAR LE PROCESSEUR NET SERONT
; ALORS RECUS PAR LA TACHE ACTIVEE
;
; PENDANT TOUTE CETTE SEQUENCE ON APPELLE REGULIEREMENT LA ROUTINE TABORT POUR
; DETECTER UNE EVENTUELLE DEMANDE D'ARRET PAR L'OPERATEUR
;
;
FONCT	EQU	$
	LXI	D,CARPDP	; SAUVEGARDE ACCUSE VAX ATTENDU
	STAX	D
;
;	ON EMET LE MESSAGE D'ACTIVATION : XXXX<RC> (OU XXXX EST LE NOM DE LA
;	TACHE A ACTIVER )
;	A CHAQUE CARACTERE EMIS ON VERIFIE QUE LE HOST REPOND EN EMETTANT
;	L'ECHO DU CARACTERE
;
	IN	DALR;		VIDER BUFFER PCI LIGNE RECEPTION HOST
FON0:	MOV	A,M
	CALL	EMCAR;		EMETTRE CARACTERE
	MVI	B,VTO;		INITIALISER COMPTEUR POUR TEMPO
FON1:	LXI	D,0
FON2:	CALL	TABORT
	JNZ	FON6;		SI ABORT OPERATEUR GOTO FON6
	IN	STLR
	ANI	RECU
	JNZ	FON3;		SI ECHO RECU GOTO FON3
	DCX	D
	MOV	A,E
	ORA	D
	JNZ	FON2;		ATTENDRE ENCORE
	DCR	B
	JNZ	FON1;		ATTENDRE ENCORE
	LXI	H,ER01
	CALL	AFFI
	MVI	A,'Z'
	ANA	A;		SI PAS D'ECHO RECU : ERREUR Z
	RET
FON3:	IN	DALR
	SUB	M;		COMPARER L'ECHO AU CARACTERE EMIS
	JZ	FON4;		C'EST BON
	LXI	H,ER02
	CALL	AFFI
	MVI	A,'Y'
	ANA	A;		SINON : ERREUR Y : ECHO INCORRECT
	RET
FON4:	MOV	A,M
	INX	H
	CPI	CR
	JNZ	FON0;		PASSER AU CARACTERE SUIVANT
FON5:	CALL	TABORT
	JNZ	FON6;		SI ABORT OPERATEUR GOTO FON6
;
; LE MESSAGE D'ACTIVATION DE LA TACHE A ETE CORRECTEMENT EMIS
; ON ATTEND MAINTENANT QUE LA TACHE ACTIVEE SE SIGNALE EN EMETTANT UN
; CARACTERE START
;
	IN	STLR
	ANI	RECU
	JZ	FON5;		ATTENDRE START
	IN	DALR
	ANA	A
	JZ	FON5;		LAISSER PASSER CARACTERE NUL
	CPI	LF
	JZ	FON5		;IGNORER EGALEMENT LES LINE FEED
	LXI	H,CARPDP
	CMP	M		; CARACTERE ATTENDU DU HOST ?
	JNZ	FON6;		SI CARACTERE START INCORRECT GOTO FON6
;
; ON VIENT DE RECEVOIR LE CARACTERE START : C'EST BON
; RETOUR A LA SEQUENCE APPELLANTE AVEC Z FLAG = 1
; MAIS D'ABORD ON AFFICHE LE MESSAGE NET>start
;
	CPI	START
	JNZ	FON55
	LXI	H,MESST;	TOUT EST OK : AFFICHER START
	CALL	AFFI
FON55:	MVI	A,0
	ANA	A
	RET
;
; ON A RECU UNE DEMANDE D'ABORT DE L'OPERATEUR OU UN CARACTERE START INCORRECT
; ON ENVOIE AU HOST UNE SERIE DE CARACTERES D'ANNULATION
; PUIS RETOUR A LA SEQUENCE APPELLANTE AVEC CARRY=1 ET Z FLAG = 0
;
FON6	EQU	$;		ABORT OPERATEUR :
	MVI	B,130
FON65:	MVI	A,7FH
	CALL	EMCAR;		ENVOYER UNE SERIE DE CARACTERES RUB-OUT
	DCR	B
	JNZ	FON65
	LXI	H,ER03
	CALL	AFFI
	MVI	A,1
	ANA	A
	STC	;		RETOUR EN ABORT AVEC C=1 ET Z=0
	RET
;
;
MESST:	DB	'...transfert en cours...',LF,CR,0
CARPDP:	DS	1		; CARACTERE ACCUSE HOST ATTENDU
;
;
$EJECT
;
;
;	TEST COMMANDE MULTIFICHIER
;	**************************
;
;
;	ON COMMENCE PAR APPELLER LA ROUTINE TFMF QUI DETERMINE SI LE NOM CONTENU
;	DANS LA COMMANDE EST OU NON UN NOM MULTIPLE
;	- SI LE NOM DE LA COMMANDE N'EST PAS UN NOM MULTIPLE :
;	  CETTE ROUTINE RETOURNE Z FLAG = 1
;	  ON RETOURNE DIRECTEMENT CETTE VALEUR A LA SEQUENCE PRINCIPALE
;	- SI LE NOM DU FICHIER EST INCORRECT LA ROUTINE TFMF RETOURNE CARRY = 1
;	  ON AFFICHE ALORS UN MESSAGE D'ERREUR PUIS ON RETOURNE CARRY = 1
;	- SI LE NOM DE LA COMMANDE EST UN NOM MULTIPLE CORRECT :
;	  LA ROUTINE TFMF RETOURNE Z FLAG = 0
;	                           A = NBRE DE FICHIERS A TRAITER
;	                           H-L = ADRESSE LISTE DES NOMS DES FICHIERS
;
;
;
TMUL	EQU	$
	LXI	H,ZREP+2
	CALL	TFMF;		APPEL MODULE DE TEST
	JNC	TM1;		SI INCIDENT
	LXI	H,ER07
	CALL	AFFI
	STC	;		RETOUR AVEC CARRY = 1
	RET
;
TM1:	RZ	;		SI FICHIER SIMPLE Z FLAG = 1
	STA	NFICH
	SHLD	ALISTE;		MEMORISER ADRESSE DE LA LISTE DE NOMS
; VERIFICATION AUTORISATION SYNTAXE MULTIFICHIER
	LDA	ZREP		; COMMANDE R EN MODE MULTIFICHIER ?
	CPI	'R'
	JNZ	TM25		; OUI INTERDIRE CETTE COMMANDE
	LXI	H,ER05
	CALL	AFFI
	STC	;		RETOUR AVEC CARRY = 1
	RET
;
TM25:
	LXI	H,ZREP
TM56:
	MOV	A,M		;RECHERCHE SI SWITCH /N
	INX	H
	CPI	'/'
	JZ	TM57
	CPI	CR
	JZ	TM58
	JMP	TM56
TM57:
	MOV	A,M
	CPI	'N'
	JNZ	TM56
	LXI	H,ER06         ;SWITCH TROUVE -> INTERDIRE LA COMMANDE
	CALL	AFFI
	STC	;		RETOUR AVEC CARRY = 1
	RET
TM58:
	MVI	A,1
	STA	LISTE;		PASSER EN MODE LISTE
	XRA	A
	STA	ABORT;		RAZ INDICATEUR D'ABORT LISTE
;
; DANS LE CAS OU L'ON PASSE EN MODE MULTIFICHIER ON SAUVEGARDE L'IMAGE DE LA ZONE
; OPTION DE LA COMMANDE INITIALE : CECI PERMETTRA DE LA RECOPIER DANS TOUTES LES COMMANDES
; QUI SERONT EMISES POUR TRAITER LES FICHIERS DE LA LISTE
;
	LXI	H,ZREP+2;	TESTER LA PRESENCE D'UNE OPTION
	LXI	D,ZOPT
TM3:	MOV	A,M
	INX	H
	CPI	CR
	JZ	TM5;		PAS D'OPTION
	CPI	'/'
	JNZ	TM3
TM4:	STAX	D;		RECOPIE ZONE OPTION
	INX	D
	MOV	A,M
	INX	H
	CPI	CR
	JNZ	TM4
TM5:	STAX	D;		CR EN FIN DE ZONE
	MVI	A,1
	ANA	A;		POUR RETOUR AVEC Z FLAG = 0
	RET
;
;
$EJECT
;
;	AFFICHAGE COMPTE RENDU D'EXECUTION
;	**********************************
;
;	EN ENTREE :	C=1 : TACHE ABORTEE
;			C=0 : execution correcte , pas d'erreur
;
AFFST	EQU	$
;tache en erreur mais message deja affiche ou
;fin d'execution normale : pas de message
	RNC
;  tache abortee
	LXI	H,MESSA
	CALL	AFFI
	RET
;
MESSA:	DB	'NET> abandon'
	DB	LF,CR,0
;
;
;
ER01:	DB	'NET> erreur time-out echo VAX (V6NET,FONCT)'
	DB	CR,LF,0
ER02:	DB	'NET> echo VAX incorrect (V6NET,FONCT)'
	DB	CR,LF,0
ER03:	DB	'NET> abandon operateur ou'
	DB	' accuse reception start incorrect (V6NET,FONCT)'
	DB	CR,LF,0
ER04:	DB	'NET> erreur non reception du prompt VAX'
	DB	' (V6NET,FCOM)'
	DB	CR,LF,0
ER05:	DB	'NET> syntaxe * interdite pour la commande R'
	DB	CR,LF,0
ER06:	DB	'NET> syntaxe * interdite car presence de l''option /N'
	DB	CR,LF,0
ER07:	DB	'NET> erreur de syntaxe'
	DB	CR,LF,0
;
;
	DSEG
;
ZREP:	DS	80		;ZONE DE LECTURE DES COMMANDES
;
EXBL	EQU	$		;BLOC PARAMETRE POUR EXIT
	DW	STAT
WHBL	EQU	$		;BLOC PARAMETRE POUR WHOCON
	DW	1
	DW	ZREP
	DW	STAT
STAT:	DS	2
CODERR:	DS	1		;CODE D'ERREUR POUR AFFST
ANAME:	DS	2
BATCH:	DS	1
LISTE:	DS	1		;= 1 MODE LISTE MULTIFICHIER
ALISTE:	DS	2
NFICH:	DS	1		;NOMBRE DE FICHIERS EN MODE LISTE
ZOPT:	DS	80
;
	DS	60
ZPILE	EQU	$
;
;
	END	MAIN
