; 27 MARS 1985 TD
;
	NAME	NET0
$INCLUDE (:F1:V6NET.ENT)
$INCLUDE (:F1:V6NET.LIT)
;
;
;
;	*******************************************************************
;	*                                                                 *
;	*                ROUTINES CONSOLE OPERATEUR                       *
;	*                ROUTINES TRANSMISSION SYSTEME HOTE               *
;	*                                                                 *
;	*******************************************************************
;
;
;	POINTS D'ENTREE
;	***************
;
;	AFFI : AFFICHAGE D'UN MESSAGE SUR LA CONSOLE OPERATEUR
;	OUTCA : AFFICHAGE D'UN CARACTERE SUR LA CONSOLE OPERATEUR
;	READC : LECTURE D'UNE COMMANDE SUR LA CONSOLE OPERATEUR
;	TABORT : TEST DEMANDE D'ARRET PAR L'OPERATEUR
;	EMCAR : EMISSION CARACTERE VERS SYSTEME HOTE
;	RECCAR : ATTENTE RECEPTION CARACTERE EMIS PAR SYSTEME HOTE
;	EMNAM  : EMISSION D'UN MESSAGE CONTENANT UN NOM DE FICHIER
;
	PUBLIC	AFFI,READC,OUTCA,TABORT
	PUBLIC	EMCAR,RECCAR,EMNAM
;
;
;	VARIABLES PUBLIQUES
;	*******************
;
;	ABORT : CODE D'ABORT DETECTE PAR LA PROCEDURE DE TEST DEMANDE D'ARRET
;	        PAR L'OPERATEUR : CETTE VARIABLE EST TESTEE DANS LE MODULE PRINCIPAL
;	        POUR VERIFIER SI L'OPERATEUR N'A PAS DEMANDE L'ARRET D'UNE COMMANDE
;	        MULTIFICHIER (EN FRAPPANT UN CARACTERE CTRL B)
;	        ELLE EST REMISE A ZERO A CHAQUE DEBUT DE COMMANDE
;
	PUBLIC	ABORT
;
	DSEG
;
ABORT:	DS	1
;
;
;
;	PROCEDURES EXTERNES
;	*******************
;
;	ISIS : POINT D'ENTREE DANS LE SYSTEME ISIS
;
	EXTRN	ISIS
;
;
;
;	VARIABLES EXTERNES
;	******************
;
;	ZREP : ZONE CONTENANT LA DERNIERE COMMANDE FRAPPE PAR L'OPERATEUR
;	ANAME: ZONE OU LE MODULE PRINCIPAL RANGE L'ADRESSE DEBUT DU NOM DE FICHIER
;	       QUE DOIT EMETTRE LA PROCEDURE EMNAM
;
	EXTRN	ZREP,ANAME
;
;
;
;	CARACTERES DE PROCEDURE DE TRANSMISSION
;	***************************************
;
ACK	EQU	06H
NACK	EQU	15H
;
;
;
;	VARIABLES LOCALES
;	*****************
;
;	CTO : COMPTEUR DE TEMPS (PROCEDURE RECCAR)
;	RCBL : BLOC PARAMETRE PASSE A ISIS POUR LECTURE CONSOLE
;	ACTL : LONGUEUR LUE A LA CONSOLE RETOURNEE PAR ISIS
;	STAT : STATUS RETOURNE PAR ISIS APRES UN READ CONSOLE
;	CAROPT : STOCKAGE TEMPORAIRE (PROCEDURE TOPT)
;
	DSEG
;
CTO:	DS	1
CAROPT:	DS	1
RCBL	EQU	$;		BLOC PARAMETRE POUR READ CONSOLE ISIS
	DW	1;			NUMERO D'UNITE ( 1=CONSOLE )
	DS	2;			ADRESSE DU BUFFER DE LECTURE
	DW	SBLECT;			TAILLE DU BUFFER DE LECTURE
	DW	ACTL;			ADR RETOUR LONGUEUR DE LA LIGNE LUE
	DW	STAT;			ADR RETOUR STATUS LECTURE
ACTL:	DS	2
STAT:	DS	2
;
;
WBLK:
	DW	0		; CB POUR WRITE CONSOLE
WACO:	DS	2		; BUFFER ADDRESS
WLCO:	DS	2		; LENGTH
	DW	STAT
;
WBLK1:
	DW	0		; CB POUR WRITE CONSOLE 1 CARACTERE
	DW	WBUF		; BUFFER ADDRESS
	DW	1		; LENGTH
	DW	STAT
;
WBUF:	DS	2
;
;
;	PARAMETRES
;	**********
;
; CONSTANTE POUR TIME-OUT RECEPTION CARACTERE DEPUIS LE SYSTEME HOTE
VTO	EQU	20H
;
; TAILLE DU MESSAGE NOM DE FICHIER
SBC	EQU	60
;
; TAILLE BUFFER DE LECTURE COMMANDE
SBLECT	EQU	80
;
; CODE D'APPEL ISIS POUR GESTION CONSOLE OPERATEUR
READ	EQU	3
WRIT	EQU	4
;
;
;	CODES CARACTERES
;	****************
;
ABOR1	EQU	01H;	CTRL A
ABOR2	EQU	02H;	CTRL B
SLASH	EQU	'/'
VIRG	EQU	','
;
;
$EJECT
;
;	**************************************************************
;	*                                                            *
;	*              ROUTINES CONSOLE OPERATEUR                    *
;	*                                                            *
;	**************************************************************
;
	CSEG
;
;
;	SUBROUTINE D'AFFICHAGE MESSAGE SUR ECRAN
;	*****************************************
;
;	EN ENTREE : H-L= ADRESSE DU MESSAGE A AFFICHER
;	                 LE MESSAGE DOIT SE TERMINER PAR 00H
;	REGISTRES MODIFIES : H-L,A,C,FLAGS
;
AFFI	EQU	$		;ARRET SUR CARACTERE NUL 
	PUSH	B
	PUSH	D
	SHLD	WACO	;ADRESSE DU BUFFER
	LXI	D,0
AFFI1:			;COMPTE LE NOMBRE D'OCTETS A AFFICHER
	MOV	A,M
	ANA	A
	INX	D
	INX	H
	JNZ	AFFI1
;
	XCHG
	SHLD	WLCO	;NOMBRE D'OCTETS
	MVI	C,WRIT
	LXI	D,WBLK
	CALL	ISIS
	POP	D
	POP	B
	RET
;
;
;	SUBROUTINE D'AFFICHAGE CARACTERE SUR ECRAN
;	******************************************
;
;	EN ENTREE : A=CARACTERE A AFFICHER
;	REGISTRES MODIFIES : A,FLAGS
;
OUTCA	EQU	$
	PUSH	H
	PUSH	D
	PUSH	B
	STA	WBUF
	MVI	C,WRIT
	LXI	D,WBLK1
	CALL	ISIS
	POP	B
	POP	D
	POP	H
	RET
;
;

;	SUBROUTINE LECTURE MESSAGE SUR LA CONSOLE
;	*****************************************
;
;	EN ENTREE : H-L= ADRESSE DE RANGEMENT DU MESSAGE LU
;	REGISTRES MODIFIES : H-L,B-C,A,FLAGS
;
;	LA LECTURE SUR LA CONSOLE EST ASSUREE PAR LE SYSTEME ISIS
;
;
READC	EQU	$
	SHLD	RCBL+2;		RANGER ADR BUFFER DANS BLOC PARAMETRE POUR ISIS
;
;	RAZ DU BUFFER DE RANGEMENT
;
	XRA	A
	MVI	B,SBLECT
READ1:	MOV	M,A
	INX	H
	DCR	B
	JNZ	READ1
;
;	APPEL ISIS POUR LECTURE CONSOLE
;
	MVI	C,READ
	LXI	D,RCBL
	CALL	ISIS
	RET
;
$EJECT
;
;
;	ROUTINE DE TEST DEMANDE D'ARRET PAR L'OPERATEUR
;	***********************************************
;
;	CETTE ROUTINE SCRUTE L'ETAT DU CLAVIER OPERATEUR : SI UN CARACTERE Y A ETE
;	FRAPPE CE CARACTERE EST LU
;	SI CE CARACTERE EST CTRL A OU CTRL B IL EST INTERPRETE COMME UNE DEMANDE
;	D'ABORT DE LA TACHE EN COURS
;	L'INDICATEUR ABORT EST ALORS POSITIONNE A 1 (CTRL A :ABORT FICHIER)
;	OU 2 (CTRL B :ABORT LISTE DE FICHIER)
;	EN SORTIE : Z=1 SI PAS DE DEMANDE D'ARRET
;	            Z=0 SI DEMANDE D'ARRET
;	REGISTRES MODIFIES : A,FLAGS
;
;
TABORT	EQU	$
	IN	STCL
	ANI	RECU
	RZ
	PUSH	B
	IN	DACL
	ANI	7FH
	MVI	C,1
	CPI	ABOR1
	JZ	TAB1
	MVI	C,2
	CPI	ABOR2
	JZ	TAB1
	MVI	A,0;		SI CARACTERE RECU <>ABOR1 ET <>ABOR2
	ANA	A;		ALORS EXIT AVEC Z=1
	POP	B
	RET
TAB1:	MVI	A,1
	ANA	A;		EXIT AVEC Z=0
	MOV	A,C
	STA	ABORT;		POSITIONNER INDICATEUR D'ABORT
	POP	B
	RET
;
;
$EJECT
;
;
;	***************************************************************
;	*                                                             *
;	*       ROUTINES TRANSMISSION PROCESSEUR HOTE                 *
;	*                                                             *
;	***************************************************************
;
;
;	ROUTINE D'EMISSION CARACTERE
;	*****************************
;
;	EN ENTREE : A=CARACTERE A EMETTRE
;	REGISTRES MODIFIES : A,C,FLAGS
;
;
EMCAR	EQU	$
	MOV	C,A
EMCAR0:	IN	STLE
	ANI	PRET
	JZ	EMCAR0
	MOV	A,C
	OUT	DALE
	RET
;
;	ROUTINE DE RECEPTION CARACTERE
;	******************************
;
;	EN SORTIE : A = CARACTERE RECU
;	            SI AUCUN CARACTERE N'A ETE RECU AU BOUT DU DELAI DETERMINE
;	            PAR LA CONSTANTE VTO : INDICATION D'INCIDENT :
;	            CARRY=1
;	REGISTRES MODIFIES : H-L,A,FLAGS
;
;
RECCAR	EQU	$
	MVI	A,VTO;		INIT COMPTE POUR TIME-OUT
	STA	CTO
	LXI	H,0
REC1:	IN	STLR
	ANI	RECU
	JNZ	REC2;		OK CARACTERE RECU
	INX	H
	MOV	A,H
	ORA	L
	JNZ	REC1
	LDA	CTO
	DCR	A
	STA	CTO
	JNZ	REC1
	STC	;		SORTIE SUR TIME-OUT
	RET
REC2:	IN	DALR
	ANI	0FFH;		POUR RESET CARRY FLAG
	RET
;
;
;
;	ROUTINE D'ENVOI MESSAGE NOM DE FICHIER
;	**************************************
;
;	L'ADRESSE DU NOM DE FICHIER A COMMUNIQUER AU HOST A ETE RANGEE AVANT
;	L'APPEL DANS LA VARIABLE ANAME
;
;	LA LONGUEUR DU MESSAGE EMIS EST DETERMINEE PAR LA CONSTANTE SBC
;	ATTENTION : CETTE LONGUEUR FAIT PARTIE DES CONVENTIONS DE TRANSMISSION
;	ENTRE LE PROCESSEUR NET ET LE SYSTEME HOTE :
;	NE PAS MODIFIER CETTE CONSTANTE SANS LA MODIFIER AUSSI DANS LE LOGICIEL
;	SUR LE SYSTEME HOTE
;
;	EN SORTIE : Z = 1 : SI NOM DE FICHIER BIEN EMIS ET ACCUSE POSITIF
;	                    RECU DU SYSTEME HOTE
;	            Z = 0 : SI PAS D'ACCUSE RECU DU SYSTEME HOTE OU ACCUSE INCORRECT
;
;
EMNAM	EQU	$
	MVI	B,SBC
	LHLD	ANAME;		EMETTRE LE BUFFER CONTENANT LE NOM DU FICHIER
FEMD1:	MOV	A,M
	CALL	EMCAR
	INX	H
	DCR	B
	JNZ	FEMD1
	CALL	RECCAR;	ATTENDRE ACCUSE DE RECEPTION
	JC	EMN1;	PAS D'ACCUSE RECU (TIME-OUT RECEPTION)
	CPI	ACK;	SI ACCUSE POSITIF ALORS
	RZ	;		RETOUR AVEC Z=1
EMN1:	MVI	A,1;	SI PAS D'ACCUSE RECU
	ANA	A;		RETOUR AVEC Z=0
	RET
;
;
	END
