$INCLUDE (:F1:V6NET.ENT)
	NAME	NET1
;
; DATE : 4 decembre 1984  TD
;
;			MODE TRANSPARENT  POUR MDS 800
;			================
;
;	GERE UN BUFFER CIRCULAIRE DE 1024 OCTETS AVEC CONTROL S ET CONTROL Q
;		CONTROL S DECLENCHE A 850
;		CONTROL Q DECLENCHE A 50 (APRES UN CONTROL S)
;
;
$INCLUDE (:F1:V6NET.LIT)
;
	PUBLIC	TRANS
;
	EXTRN	CONTRO,EMCAR
;
	PUBLIC	BUFR,FINBUF
;
;
SIZE	EQU	1024
NCARMX	EQU	850
NCARMN	EQU	50
;
;
	DSEG
;
BUFR:	DS	SIZE		;BUFFER CIRCULAIRE
FINBUF	EQU	$
;
PTEBUF:	DS	2		;POINTEUR EN ECRITURE DANS LE BUFFER
PTLBUF:	DS	2		;POINTEUR EN LECTURE DANS LE BUFFER
BLOCAG:	DS	1		;=0 PAS DE BLOCAGE EN COURS
				;=1 BLOCAGE PAR CONTROL S EN COURS
CPTCAR:	DS	2		;COMPTEUR CARACTERE EN ATTENTE D'AFFICHAGE
;
AREC:	DS	2
ARET:	DS	2
CARCLA:	DS	1		;CARACTERE LU AU CLAVIER
ITE:	DS	1		;=1 INDIQUE ACCES A L'ECRAN EN COURS
;
;
CTRLX	EQU	18H
CTRLS	EQU	13H
CTRLQ	EQU	11H
;
$EJECT
;
	CSEG
;
TRANS	EQU	$
	MVI	A,CR		; POUR OBTENIR PROMPT HOTE
	CALL	EMCAR
	XRA	A		; RAZ INDICATEURS TRAIT. EN COURS
	STA	ITE
	STA	BLOCAG
	LXI	H,ECRAN
	SHLD	AREC
	LXI	H,LSTAT		; ADR APPEL LECTURE STATUS CLAVIER
	SHLD	ARET
	LXI	H,BUFR		; RAZ POINTEURS ECRITURE ET LECTURE
	SHLD	PTEBUF
	SHLD	PTLBUF
	LXI	H,0
	SHLD	CPTCAR
;
;	ECOUTE LIGNE HOTE
;	*****************
;
TR0:
	IN	STLR		; CARACTERE RECU SUR LIGNE HOTE ?
	ANI	RECU
	JZ	TR1		; NON -> GOTO TR1 
	IN	DALR		; LECTURE CARACTERE EMIS PAR HOTE
	ANI	7FH
	LHLD	PTEBUF		; SAUVEGARDE CARACTERE DANS BUFFER
	MOV	M,A
	INX	H		; PTEBUF = PTEBUF + 1
	SHLD	PTEBUF
	LHLD	CPTCAR
	INX	H		; CPTCAR = CPTCAR + 1
	SHLD	CPTCAR
;  verification borne NCARMX (nombre de caracteres max)
	MOV	A,H
	CPI	NCARMX / 256	;poids forts
	JNZ	TR05
	MOV	A,L
	CPI	NCARMX AND 0FFH
	JNZ	TR05
;  egalite => emission control S
TR06:	IN	STLR
	ANI	PRET
	JZ	TR06
	MVI	A,CTRLS		;EMISSION CONTROL S
	OUT	DALE
	MVI	A,1
	STA	BLOCAG		;BLOCAG = 1
	JMP	TR07
;
;  gestion buffer circulaire
TR05:
	LHLD	PTEBUF
	LXI	D,FINBUF
	MOV	A,H
	CMP	D
	JNZ	TR07
	MOV	A,L
	CMP	E
	JNZ	TR07
	LXI	H,BUFR
	SHLD	PTEBUF
;
TR07:
TR1:	LDA	ITE		; TRAIT. ECRAN EN COURS ?
	ANA	A
	JNZ	TR2		; OUI
; test buffer vide CPTCAR = 0
	LHLD	CPTCAR
	MOV	A,L
	ORA	H
	JNZ	TR2
	LHLD	ARET
	PCHL
TR2:	LHLD	AREC
	PCHL
$EJECT
;
;	AFFICHAGE ECRAN
;	***************
;
ECRAN:
	LXI	H,ITE		; INDIQUER TRAIT. ECRAN EN COURS
	INR	M
TR22:	IN	STAF		; ATTENTE ACCES ECRAN LIBRE
	ANI	PRET
	JNZ	TR20		; OUI
	LXI	H,TR22
	SHLD	AREC
	LHLD	ARET
	PCHL
;			AFFICHAGE CARACTERE
TR20:	LHLD	PTLBUF		; CARACTERE A AFFICHER
	MOV	A,M
	OUT	DAAF
	INX	H		; PTLBUF = PTLBUF + 1
	SHLD	PTLBUF
	XRA	A		; TRAIT. ECRAN TERMINE 
	STA	ITE
	LHLD	CPTCAR
	DCX	H		; CPTCAR = CPTCAR - 1
	SHLD	CPTCAR
;  verification borne NCARMN
	LDA	BLOCAG
	ANA	A
	JZ	TR25		;pas de blocage en cours
	MOV	A,H
	CPI	NCARMN / 256	;poids forts
	JNZ	TR25
	MOV	A,L
	CPI	NCARMN AND 0FFH
	JNZ	TR25
;  egalite => emission control Q
TR26:
	IN	STLR
	ANI	PRET
	JZ	TR26
	MVI	A,CTRLQ
	OUT	DALR
	XRA	A
	STA	BLOCAG
	JMP	TR07
;
;  gestion buffer circulaire
TR25:
	LHLD	PTLBUF
	LXI	D,FINBUF
	MOV	A,H
	CMP	D
	JNZ	TR27
	MOV	A,L
	CMP	E
	JNZ	TR27
	LXI	H,BUFR
	SHLD	PTLBUF
TR27:
	LXI	H,ECRAN
	SHLD	AREC
	JMP	TR0
;
$EJECT
;
;	LECTURE CLAVIER
;	***************
;
LSTAT	EQU	$
	IN	STCL		; CARACTERE FRAPPE ?
	ANI	RECU
	JZ	TR0		; NON PAS DE TOUCHE
;
	IN	DACL		; LECTURE TOUCHE
	ANI	7FH
	STA	CARCLA		; SAUVEGARDE
	LXI	H,CNTCAR	; INIT RETOUR SUR 'CONTROLE CARACTERE'
	SHLD	ARET
	JMP	TR0
$EJECT
;
;
;	CONTROLE CARACTERE
;	******************
;
CNTCAR	EQU	$
	LDA	CARCLA		; CAR CLAVIER =CTRL/X ?
	CPI	CTRLX
	JZ	CONTRO		; OUI: RETOUR LECTURE DES COMMANDES
;
	IN	STLR		; PRET A EMETTRE SUR LIGNE HOTE ?
	ANI	PRET
	JZ	TR0		; NON RETOUR ECOUTE LIGNE HOTE
;
	LDA	CARCLA		; EMISSION CARACTERE SUR LA LIGNE
	OUT	DALR
	LXI	H,LSTAT		; INIT RETOUR SUR 'LECT. STATUS CLAVIER'
	SHLD	ARET
	JMP	TR0		; RETOUR ECOUTE LIGNE HOTE
;
	END
