$INCLUDE (:F1:V6NET.ENT)
	NAME	NET3
$INCLUDE (:F1:V6NET.LIT)
;
;	*********************************************************************
;	*                                                                   *
;	*                MODULE DE RECEPTION DES FICHIERS                   *
;	*                                                                   *
;	*********************************************************************
;
;
;
;	POINT D'ENTREE DU MODULE
;	************************
;
;	CE MODULE EST APPELLE DEPUIS LE MODULE PRINCIPAL PAR CALL FREC
;	IL RETOURNE LE CONTROLE PAR UN RET
;	AU MOMEMT DE L'APPEL LA VARIABLE ANAME DOIT CONTENIR L'ADRESSE OU SE
;	TROUVE LE NOM DU FICHIER A TRAITER
;
;	A LA SORTIE DU MODULE :
;		- SI PAS D'INCIDENT : Z FLAG = 1
;		- SI INCIDENT DETECTE : Z FLAG = 0 ET CODE D'ERREUR DANS A
;
;
	PUBLIC	FREC
;
;
;	PROCEDURES EXTERNES
;	*******************
;
;	TRANSMISSION AVEC LE SYSTEME HOTE :
;		- EMNAM : EMISSION DU NOM DE FICHIER A RECEVOIR
;		- EMCAR : EMISSION D'UN CARACTERE VERS LE SYSTEME HOTE
;		- RECCAR: ATTENTE RECEPTION D'UN CARACTERE EMIS PAR LE HOST
;
;	ECRITURE SUR FICHIER DE RECEPTION :
;		- WRICAR : ECRITURE CARACTERE PAR CARACTERE DANS LE FICHIER DE
;		           RECEPTION
;		           ( LE FICHIER DE RECEPTION EST OUVERT ET FERME DANS LE
;		             MODULE PRINCIPAL )
;
;
	EXTRN	EMNAM,EMCAR,RECCAR,WRICAR,AFFI
;
;
;
;
;	CARACTERES DE PROCEDURE DE TRANSMISSION
;	***************************************
;
STX	EQU	02H
ACK	EQU	06H
NACK	EQU	15H
EOT	EQU	04H
DLE	EQU	10H
;
;	PARAMETRES
;	**********
;
; TAILLE DU BUFFER DE RECEPTION
;
SBR	EQU	130
;
$EJECT
;
;		TRAITEMENT RECEPTION FICHIER
;		****************************
;
;
;	ON APPELLE LA ROUTINE EMNAM QUI ASSURRE L'EMISSION DU NOM DU FICHIER
;	A RECEVOIR
;	CETTE ROUTINE EMETS LE NOM DU FICHIER PUIS SE MET EN ATTENTE D'UN ACCUSE
;	DE RECEPTION EMIS LE HOST QUI SIGNALE QU'IL A CORRECTEMENT OUVERT LE FICHIER
;	DEMANDE
;	EN CAS DE RECEPTION D'UN ACCUSE NEGATIF OU NON CONFORME : LA ROUTINE
;	RETOURNE 0 DANS Z FLAG POUR SIGNALER L'INCIDENT
;
;	SI LA ROUTINE EMNAM RETOURNE UN RESULTAT POSITIF ON VA SE METTRE
;	EN ATTENTE DU PREMIER BLOC
;	PUIS ON VERIFIERA LE MESSAGE RECU
;	SI LA VERIFICATION EST OK :
;		LES CARACTERES DU BLOC SERONT RANGES DANS LE FICHIER DE RECEPTION
;		PUIS UN ACCUSE POSTIF SERA EMIS VERS LE HOST
;	SINON :
;		UN ACCUSE NEGATIF EST EMIS VERS LE HOST POUR LUI DEMANDER
;		DE REEMETTRE LE BLOC
;
;	LA TRANSMISSION SE TERMINE :
;		- SOIT SUR RECEPTION D'UN BLOC EOT : FIN DE TRANSMISSION
;		- SOIT SUR RECEPTION D'UN BLOC DLE : ABORT DE LA TRANSMISSION
;		  PAR LE SYSTEME HOTE
;
;
	CSEG
;
;
FREC	EQU	$
	CALL	EMNAM		;EMETTRE LE NOM DU FICHIER
	JZ	FRE05		;OK
; RECEPTION DES 129 CARACTERES SUIVANTS : MESSAGE D'ERREUR EN CLAIR
	MVI	B,SBR-1
	LXI	D,BUFR+1
FRE24:	CALL	RECCAR
	JC	FRE25		; SI TIME-OUT 
	STAX	D
	INX	D
	DCR	B
	JNZ	FRE24
FRE25:
	XRA	A
	STAX	D
	LXI	H,ER300
	CALL	AFFI
	LXI	H,BUFR+1
	CALL	AFFI
	MVI	A,'B'
	ANA	A
	RET	;		RETOUR EN ERREUR
;
; RECEPTION BLOC
;
FRE05:	MVI	B,SBR
	LXI	D,BUFR
FRE1:	CALL	RECCAR
	JC	FRE30		; SI TIME-OUT 
	STAX	D
	INX	D
	DCR	B
	JNZ	FRE1
;
; VERIFICATION ENTETE
;
	LXI	H,BUFR
	MOV	A,M
	CPI	EOT
	JZ	FRE9;		SI EOT ALORS GOTO FRE9
	CPI	DLE
	JZ	FRE8;		SI DLE ALORS GOTO FRE8
	CPI	STX
	JNZ	FRE7;		SI ERREUR PROCEDURE ALORS GOTO FRE7
;
; VERIFICATION DU BCC
;
	INX	H
	MOV	B,M;		LONGUEUR DANS B
	MVI	A,0;		INIT DU BCC CALCULE DANS A
FRE2:	INX	H
	XRA	M
	DCR	B
	JNZ	FRE2
	INX	H
	XRA	M
	JNZ	FRE4;		SI ERREUR PARITE GOTO FRE4
;
; ECRITURE BLOC
;
	LXI	D,BUFR+1
	LDAX	D
	MOV	B,A;		LONGUEUR DANS B
	INX	D
FRE3:	LDAX	D
	INX	D
	CALL	WRICAR
	JC	FRE5		;INCIDENT DANS ECRITURE
	DCR	B
	JNZ	FRE3
;
; EMMISSION ACK
;
	MVI	A,ACK
	CALL	EMCAR
	JMP	FRE05
;
; BCC ERRONE : ENVOYER ACCUSE NEGATIF ET ATTENDRE REEMISSION
;
FRE4:	MVI	A,NACK
	CALL	EMCAR
	JMP	FRE05
;
; SI INCIDENT ENVOYER DLE
;
FRE5:	MVI	A,DLE
	CALL	EMCAR
	LXI	H,ER301
	CALL	AFFI
	MVI	A,'8'
	ANA	A
	RET
;
; CARACTERE D'ENTETE NON RECONNU
;
FRE7:	LXI	H,ER302
	CALL	AFFI
	MVI	A,'9'
	ANA	A
	RET
;
; RECEPTION DE DLE : ARRETER LE PROCESSUS
;
FRE8:
;    AFFICHAGE DU MESSAGE D'ERREUR RECU EN CLAIR
	XRA	A
	STA	BUFR+130
	LXI	H,BUFR+1
	CALL	AFFI
	STC
	RET
;
; SUR EOT : FIN NORMALE DE TRANSMISSION
;
FRE9:	MVI	A,0
	ANA	A
	RET
;
FRE30:	LXI	H,ER303
	CALL	AFFI
	MVI	A,'9'
	ANA	A
	RET
;
;
ER300:	DB	'NET> erreur emission message nom de fichier'
	DB	' (V6NET3,FREC)'
	DB	CR,LF,0
ER301:	DB	'NET> abandon transmission [emission DLE]'
	DB	' (V6NET3,FREC)'
	DB	CR,LF,0
ER302:	DB	'NET> caractere entete recu ni EOT,ni DLE,ni STX'
	DB	' (V6NET3,FREC)'
	DB	CR,LF,0
ER303:	DB	'NET> time-out reception message host ecoule'
	DB	' (V6NET3,FREC)'
	DB	CR,LF,0
;
;
	DSEG
;
BUFR:	DS	132
;
	END
