$INCLUDE (:F1:V6NET.ENT)
	NAME	NET4
$INCLUDE (:F1:V6NET.LIT)
;
;
;
;	*********************************************************************
;	*                                                                   *
;	*                     ACCES AUX FICHIERS ISIS-II                    *
;	*                                                                   *
;	*********************************************************************
;
;
;
;	POINTS D'ENTREE DU MODULE
;	*************************
;
;	OPENF : OUVERTURE DE FICHIER
;	CLOSEF: FERMETURE DE FICHIER
;	CARBUF: LECTURE CARACTERE COURANT DANS LE FICHIER D'ENTREE
;	WRICAR: ECRITURE CARACTERE COURANT DANS LE FICHIER DE SORTIE
;
	PUBLIC	OPENF,CLOSEF,CARBUF,WRICAR
;
;
;	VARIABLES PUBLIQUES
;	*******************
;
;	FICHOP INDIQUE SI UN FICHIER EST DEJA OUVERT
;	CET INDICATEUR SERT A FORCER LA FERMETURE AVANT D'OUVRIR UN NOUVEAU
;	FICHIER
;	IL DOIT ETRE INTIALISE A FAUX DANS LA SEQUENCE D'INTIALISATION DE NET
;
	PUBLIC	FICHOP
;
;
;	PROCEDURES EXTERNES
;	*******************
;
;	ISIS : POINT D'ENTREE DANS LE SYSTEME ISIS
;
	EXTRN	ISIS
;
;
;	VARIABLES EXTERNES
;	******************
;
;
;	LA ROUTINE D'OUVERTURE DE FICHIER RECUPERE LE NOM DU FICHIER A OUVRIR DANS
;	LA ZONE ZREP (QUI CONTIENT LA COMMANDE EN COURS D'EXECUTION)
;
	EXTRN	ZREP,AFFI
;
;
;	PARAMETRES
;	**********
;
;
; TAILLE BUFFER DE LECTURE DISQUE
;
FLECT	EQU	4096
;
; CODES D'APPEL ISIS
;
READ	EQU	3
OPEN	EQU	0
WRITE	EQU	4
CLOSE	EQU	1
ACCR	EQU	1;	ACCES LECTURE
ACCW	EQU	2;	ACCES ECRITURE
;
;
	CSEG
;
;
;
;	SUBROUTINE OUVERTURE DE FICHIER
;	*******************************
;
;
;	CETTE ROUTINE OUVRE LE FICHIER DONT LE NOM EST CONTENU DANS LE BUFFER
;	DE COMMANDE ZREP (A PARTIR DU TROISIEME OCTET : LES 2 PREMIERS CONTENANT
;	LE NOM DE LA COMMANDE PUIS UN ESPACE)
;	LE TYPE D'OUVERTURE EST DETERMINE PAR LE PARAMETRE RECU DANS A :
;		1 : OUVERTURE EN LECTURE
;		2 : ACCES EN ECRITURE
;
;	EN SORTIE :
;		- SI OUVERTURE OK : Z FLAG = 1
;		- SI INCIDENT    : Z FLAG = 0
;		                   CODE D'ERREUR DANS A
;
;	APRES LA DEMANDE D'OUVERTURE DE FICHIER FAITE AU SYSTEME ISIS ON EXECUTE
;	LES ACTIONS SUIVANTES :
;		- POSITIONNEMENT A 1 DE L'INDICATEUR DE FICHIER OUVERT
;		- SI LE FICHIER A ETE OUVERT EN LECTURE :
;			- LECTURE DU PREMIER BLOC
;			- POSITIONNEMENT D'UN POINTEUR ET D'UN COMPTE D'OCTETS
;			  DANS LE BUFFER DE LECTURE DE FACON A INITIALISER
;			  LES VARIABLES NECESSAIRES AU FONCTIONNEMENT DE LA PROCEDURE
;			  CARBUF
;		- SI LE FICHIER A ETE OUVERT EN ECRITURE :
;			- POSITIONNEMENT D'UN POINTEUR ET D'UN COMPTE D'OCTET SUR
;			  UNE ZONE QUI SERVIRA DE BUFFER D'ECRITURE POUR LA PROCEDURE
;			  WRICAR
;
;
;
OPENF	EQU	$
	MOV	L,A
	MVI	H,0
	SHLD	OPBL+4;		RANGER TYPE D'ACCES DEMANDE
	LDA	FICHOP;		SI FICHIER RESTE OUVERT
	ANA	A;		IL FAUT LE FERMER
	CNZ	CLOS1
	LXI	H,ZREP+2
	SHLD	OPBL+2;		RANGER POINTEUR SUR NOM DU FICHIER
	MVI	C,OPEN
	LXI	D,OPBL
	CALL	ISIS;		OPEN FICHIER
	LDA	STAT
	ANA	A
	JNZ	OPE1;		 ERREUR D'OUVERTURE
	LHLD	AFTN
	LDA	OPBL+4
	CPI	ACCR;
	JNZ	OPE2;		SI ACCES EN LECTURE
	SHLD	RDBL;		 RANGER AFTN DANS BLOC READ
	MVI	C,READ
	LXI	D,RDBL
	CALL	ISIS;		 ET LIRE PREMIER BLOC
	LDA	STAT
	ANA	A;
	JZ	OPE10
	LXI	H,ER401
	CALL	AFFI
	MVI	A,'2'		;ERREUR LECTURE 1 ER BLOC
	ANA	A
	RET
OPE10:	CALL	INIPTR;		 INIT POINTEURS SUR LE BUFFER
	MVI	A,1
	STA	FICHOP;		SET INDICATEUR FICHIER OUVERT
	MVI	A,0
	ANA	A
	RET
OPE1:	LXI	H,ER400
	CALL	AFFI
	MVI	A,'1'		;ERREUR OUVERTURE FICHIER
	ANA	A
	RET
OPE2	EQU	$;		SI ACCES EN ECRITURE
	SHLD	WRBL;		 RANGER AFTN DANS BLOC WRITE
	LXI	H,FLECT
	SHLD	ACTL
	CALL	INIPTR;		 INIT DES POINTEURS
	MVI	A,0
	ANA	A
	RET
;
; INITIALISATION DES POINTEURS SUR LE BUFFER LECTURE/ECRITURE
;
; ATTENTION : CETTE ROUTINE EST AUSSI UTILISEE PAR LES PROCEDURES :
;             CARBUF (LECTURE CARACTERE SUR FICHIER DISQUE)
;             WRICAR (ECRITURE CARACTERE SUR FICHIER DISQUE)
;
;
INIPTR	EQU	$
	LHLD	ACTL
	SHLD	COMPTE
	LXI	H,BUF
	SHLD	PTRBUF
	RET
;
$EJECT
;
;
;	ROUTINE DE LECTURE CARACTERE DANS LE BUFFER DE LECTURE
;	******************************************************
;
;
;	CETTE ROUTINE PERMET DE LIRE LE FICHIER D'ENTREE OCTET PAR OCTET
;	L'INITIALISATION DES VARIABLES DE TRAVAIL NECESSAIRES A LA PROCEDURE
;	EST ASSURRE A L'OUVERTURE DU FICHIER PAR LA PROCEDURE OPENF
;
;	L'ACCES AU FICHIER EST REALISE DANS CETTE ROUTINE BLOC PAR BLOC
;	A CHAQUE APPEL DE LA ROUTINE ON DELIVRE L'OCTET COURANT DU BLOC LU
;	QUAND LE BLOC EST EPUISE ON RELIT UN NOUVEAU BLOC OU ON RETOURNE UNE
;	INDICATION DE FIN DE FICHIER
;
;
;	EN SORTIE :
;		- SI PAS D'INCIDENT : CARRY = 0
;		                      A = CARACTERE COURANT DU FICHIER
;	        - SI FIN DE FICHIER : CARRY = 1 ET Z FLAG = 1
;		- SI INCIDENT DE LECTURE : CARRY = 1 ET Z FLAG = 0
;
;
;
CARBUF	EQU	$
	LHLD	COMPTE
	MOV	A,L
	ORA	H
	JZ	CARB1;	 SI PAS FIN DE BLOC
	DCX	H;		ALORS
	SHLD	COMPTE;		COMPTE-:=1
	LHLD	PTRBUF
	MOV	A,M;		CARACTERE COURANT DANS A
	INX	H
	SHLD	PTRBUF;		METTRE A JOUR POINTEUR SUR BUFFER
	RET
CARB1:	PUSH	B;		SINON
	PUSH	D
	MVI	C,READ;		
	LXI	D,RDBL
	CALL	ISIS;		LIRE UN NOUVEAU BLOC
	POP	D
	POP	B
	LDA	STAT
	ANA	A;
	JZ	CARB3;		SI INCIDENT EXIT AVEC C=1 ET Z=0
	LXI	H,ER402
	CALL	AFFI
	MVI	A,1
	ANA	A		; POUR RESET Z FLAG
	JMP	CARB2
CARB3:	LHLD	ACTL;		TEST FIN DE FICHIER SUR ACTL=0
	MOV	A,H
	ORA	L
	JZ	CARB2;		SI FIN DE FICHIER EXIT AVEC C=1 ET Z=1
	CALL	INIPTR;		SI LECTURE OK REINIT DES POINTEURS
	JMP	CARBUF;		ET ALLER RETOURNER LE PREMIER CARACTERE
CARB2:	STC	;
	RET
;
$EJECT
;
;	ROUTINE DE FERMETURE FICHIER
;	****************************
;
;
;	CETTE ROUTINE TERMINE LE TRAITEMENT D'UN FICHIER :
;	ELLE APPELLE LE SYSTEME ISIS POUR EFFECTUER LE CLOSE DU FICHIER
;	PUIS ELLE REMET A ZERO L'INDICATEUR DE FICHIER OUVERT
;
;	SI LE FICHIER AVAIT ETE OUVERT EN ECRITURE : AVANT DE DEMANDER LE CLOSE A ISIS
;	ON ECRIT LE BLOC QUI ETAIT EN COURS DE CONSTITUTION PAR LA ROUTINE WRICAR
;
;
;
CLOSEF	EQU	$
	LDA	OPBL+4
	CPI	ACCW
	CZ	WRITB;		SI FICHIER OUVERT EN ECRITURE ECRIRE LE DERNIER BLOC
CLOS1:	LHLD	AFTN
	SHLD	CLBL
	MVI	C,CLOSE
	LXI	D,CLBL
	CALL	ISIS
	RET
;
$EJECT
;
;
;	ROUTINE D'ECRITURE CARACTERE DANS LE BUFFER DE SORTIE
;	*****************************************************
;
;	CETTE ROUTINE PERMET L'ECRITURE DANS LE FICHER DE SORTIE OCTET PAR OCTET
;	A CHAQUE APPEL L'OCTET PASSE DANS LE REGISTRE A EST RANGE DANS LE BUFFER
;	D'ECRITURE DISQUE
;	QUAND CE BUFFER EST PLEIN IL EST ECRIT SUR DISQUE PAR APPEL A LA
;	ROUTINE WRITB
;
;	LES INITIALISATIONS NECESSAIRES AU FONCTIONNEMENT DE CETTE ROUTINE
;	SONT REALISEES PAR LA ROUTINE OPENF (OUVERTURE DE FICHIER)
;
;	L'ECRITURE SUR DISQUE DU DERNIER BLOC EN COURS EST REALISEE PAR LA ROUTINE
;	CLOSEF (FERMETURE DE FICHIER)
;
;
WRICAR	EQU	$
	LHLD	PTRBUF
	MOV	M,A;		RANGEMENT DU CARACTERE
	INX	H
	SHLD	PTRBUF
	LHLD	COMPTE
	DCX	H
	SHLD	COMPTE;		METTRE A JOUR COMPTE D'OCTETS DISPONIBLES
	MOV	A,H
	ORA	L
	CZ	WRITB;		SI BLOC PLEIN ECRITURE SUR DISQUE
	RET;
;
; ECRITURE BLOC DISQUE
;
WRITB	EQU	$
	PUSH	B
	PUSH	D
	LHLD	COMPTE
	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	LXI	D,FLECT
	DAD	D;		LONG=4096-COMPTE
	MOV	A,H
	ORA	L
	JZ	WRIT1;		SI LONG=0 EXIT
	SHLD	WRBL+4;		RANGER LONG DS BLOC PARAMETRE
	MVI	C,WRITE
	LXI	D,WRBL
	CALL	ISIS;		ECRITURE SUR DISQUE
WRIT1:	POP	D
	POP	B
	LDA	STAT
	ANA	A
	JNZ	WRIT2;		SI INCIDENT EXIT AVEC C=1
	CALL	INIPTR;		SINON REINIT DES POINTEURS
	RET
WRIT2:	LXI	H,ER403
	CALL	AFFI
	MVI	A,1
	ANA	A		; POUR RESET Z FLAG
	STC
	RET
;
;
ER400:	DB	'NET> erreur ouverture fichier (V6NET4,CARBUF)'
	DB	CR,LF,0
ER401:	DB	'NET> erreur lecture fichier (V6NET4,OPENF)'
	DB	CR,LF,0
ER402:	DB	'NET> erreur lecture fichier (V6NET4,CARBUF)'
	DB	CR,LF,0
ER403:	DB	'NET> erreur ecriture fichier (V6NET4,WRICAR)'
	DB	CR,LF,0
;
;
	DSEG
;
OPBL	EQU	$;	BLOC PARAMETRE POUR OPEN
	DW	AFTN;	POINTEUR SUR AFTN
	DS	2;	POINTEUR SUR NOM DE FICHIER
	DS	2;	CODE ACCES
	DW	0;	PAS D'ECHO
	DW	STAT;	POINTEUR SUR STATUS RENDU
RDBL	EQU	$;	BLOC PARAMETRE POUR READ DISQUE
	DS	2;	AFTN
	DW	BUF;	POINTEUR SUR BUFFER
	DW	FLECT;	LONGUEUR
	DW	ACTL;	LONGUEUR RETOURNEE
	DW	STAT;	POINTEUR SUR STATUS RENDU
CLBL	EQU	$;	BLOC PARAMETRE POUR CLOSE
	DS	2;	POINTEUR SUR AFTN
	DW	STAT;	POINTEUR SUR STATUS RENDU
WRBL	EQU	$;	BLOC PARAMETRE POUR WRITE
	DS	2;	AFTN
	DW	BUF;	POINTEUR SUR BUFFER
	DS	2;	LONGUEUR
	DW	STAT;	POINTEUR SUR STATUS RENDU
FICHOP:	DS	1;	INDICATEUR FICHIER OUVERT
AFTN:	DS	2;
ACTL:	DS	2
STAT:	DS	2
COMPTE:	DS	2
PTRBUF:	DS	2
BUF:	DS	FLECT;	BUFFER DISQUE
;
	END
