$INCLUDE (:F1:V6NET.ENT)
	NAME	NET7
;
;	*********************************************************************
;	*                                                                   *
;	*              TRAITEMENT DES NOMS DE FICHIERS MULTIPLES            *
;	*                                                                   *
;	*********************************************************************
;
;
;
;
;	POINT D'ENTREE DU MODULE
;	************************
;
;	LA ROUTINE TFMF EST APPELLE DEPUIS LA SEQUENCE PRINCIPALE POUR TESTER
;	SI LE NOM DE FICHIER DE LA COMMANDE COURANTE EST OU NON UN NOM MULTIPLE
;
;	EN ENTREE : H-L = ADRESSE DE DEBUT DU NOM DE FICHIER
;	EN SORTIE :
;		- SI INCIDENT : CARRY = 1
;		- SI FICHIER SIMPLE : Z = 1
;		- SI FICHIER MULTIPLE :
;			- Z = 0
;			- A = NBRE DE FICHIERS A TRAITER
;			- H-L = ADRESSE DE LA LISTE DES FICHIERS
;
;
;	DESCRITION
;	**********
;
;	LA SYNTAXE STANDARD ISIS-II AUTORISE A REPRESENTER UN ENSEMBLE DE FICHIERS
;	PAR UN NOM MULTIPLE PAR EXEMPLE :
;	:F1:AB*.C* REPRESENTERA TOUT LES FICHIERS DU DRIVE 1 DONT LE NOM
;	COMMENCE PAR 'AB' ET L'EXTENSION PAR 'C'
;
;	LE LOGICIEL NET AUTORISE AUSSI CETTE SYNTAXE
;	( VOIR DESCRIPTION COMPLETE DANS ISIS-II USER MANUEL)
;
;	SI LE NOM DE FICHIER POINTE PAR LE PARAMETRE H-L CONTIENT UN CARACTERE
;	* : LE MODULE VA CONSULTER LA DIRECTORY DU DRIVE
;	POUR CHAQUE ENTREE DE LA DIRECTORY ON VA EXAMINER SI LE NOM DU FICHIER
;	CORRESPOND A UN NOM POSSIBLE POUR LE NOM MULTIPLE CITE
;	SI C'EST LE CAS CE NOM DE FICHIER SERA RANGE DANS UNE LISTE DONT LE
;	NBRE D'ELEMENTS ET L'ADRESSE SERA RETOURNEE A LA SEQUENCE APPELLANTE
;
;
;
;
	PUBLIC	TFMF
;
	EXTRN	ISIS
;
;
; CODES FONCTION ISIS
;
OPEN	EQU	0
CLOSE	EQU	1
READ	EQU	3
WRITE	EQU	4
;
; CODES CARACTERES
;
CR	EQU	0DH
LF	EQU	0AH
SLASH	EQU	'/'
;
; TAILLE DU BUFFER DE LECTURE FICHIER DIRECTORY
;
FLECT	EQU	4096
;
;
;
	CSEG
;
TFMF	EQU	$
	SHLD	ADRN;		RANGER ADDRESSE CHAINE D'ENTREE
;
; ON VA RANGER LE NOM A TRAITER SOUS FORME 'INTERNE' : DANS CETTE FORME LE NOM
; DU FICHIER EST SUR 9 OCTETS :
;	- 6 OCTETS POUR LE NOM EVENTUELLEMENT COMPLETES PAR DES 00
;	- 3 OCTETS D'EXTENSION EVENTUELLEMENT COMPLETES PAR DES 00
; CETTE FORME EST CELLE QUI EST UTILISEE DANS LA DIRECTORY
; LA ZONE UTILISEE POUR CELA EST LA ZONE ZNOM
;
; D'ABORD RAZ DE LA ZONE ZNOM
;
	MVI	B,9
	LXI	H,ZNOM
	XRA	A
TF0:	MOV	M,A
	INX	H
	DCR	B
	JNZ	TF0
;
; SAUTER LA ZONE :DD: SI ELLE EXISTE
;
	LHLD	ADRN
	MOV	A,M
	CPI	':'
	JNZ	TF1
	LXI	B,4
	DAD	B
;
; PUIS Y RANGER LE NOM DE FICHIER SOUS FORME INTERNE
;
TF1:	MVI	B,6+1
	LXI	D,ZNOM
	CALL	TFST
	RC
	CPI	'.'
	JNZ	TF10
	MVI	B,3+1
	LXI	D,ZEXT
	CALL	TFST
	RC
;
; TESTER LA PRESENCE DU CARACTERE '*'
;
TF10:	MVI	B,9
	LXI	H,ZNOM
TF2:	MOV	A,M
	CPI	'*'
	JZ	TF3
	INX	H
	DCR	B
	JNZ	TF2
	ANI	0
	RET	;		SI PAS TROUVE RETOUR IMMEDIAT AVEC Z=1 ET C=0
;
; OUVERTURE DU FICHIER DIRECTORY
;
TF3:	LHLD	ADRN
	MOV	A,M
	CPI	':'
	MVI	A,'0';		A PRIORI OUVERTURE SUR F0
	JNZ	TF4
	INX	H
	INX	H
	MOV	A,M
TF4:	STA	NUMD
	MVI	C,OPEN
	LXI	D,OPBLD
	CALL	ISIS
	CALL	TFTER
	RC	;		RETOUR EN ERREUR SI INCIDENT D'OUVERTURE
;
; ON VA MAINTENANT BALAYER LA DIRECTORY POUR Y RECHERCHER LES NOM DES FICHIERS
; CORRESPONDANT AU NOM CHERCHE
; LES NOMS TROUVES SERONT RANGES DANS LA ZONE BUFN
; ON INITIALISE UN POINTEUR SUR CETTE ZONE
; ON TIENT A JOUR DANS NFICH LE NOMBRE DE FICHIERS TROUVES
;
	MVI	A,0
	STA	NFICH
	LXI	H,BUFN
	SHLD	PZR
;
; LECTURE DIRECTORY
;
TF40:	MVI	C,READ
	LXI	D,RDBLD
	CALL	ISIS
	CALL	TFTER
	RC	;		RETOUR EN ERREUR SUR INCIDENT
;
; RECHERCHER LES FICHIERS CORRESPONDANT DANS LA DIRECTORY
;
	LXI	H,BUFD
	SHLD	V1
TF5:	LHLD	V1
	MOV	A,M
	CPI	7FH
	JZ	TFA;		FIN DE LA DIRECTORY
	ANA	A
	JNZ	TF9;		ENTREE SUPPRIMEE
	INX	H
	MVI	B,6
	LXI	D,ZNOM
	CALL	TFCOM;		TEST SUR LA ZONE NOM
	JNC	TF9
	LHLD	V1
	LXI	B,7
	DAD	B
	MVI	B,3
	LXI	D,ZEXT
	CALL	TFCOM;		TEST SUR LA ZONE EXTENSION
	JNC	TF9
;
; FICHIER CORRESPONDANT : RANGER SON NOM DANS LE FICHIER DE COMMANDE
;
	LXI	H,NDIR
	MVI	B,4
TF55:	MOV	A,M;		RECOPIE ZONE DEVICE
	CALL	TFSCA
	INX	H
	DCR	B
	JNZ	TF55
	LXI	H,NFICH
	INR	M;		NFICH=NFICH+1
	LHLD	V1;		ADR ZONE NOM DANS H
	INX	H
	MVI	B,6;		LONG DANS B
TF6:	MOV	A,M;		RECOPIE ZONE NOM DANS LA ZONE DE RANGEMENT
	INX	H
	ANA	A
	JZ	TF7
	CALL	TFSCA
	DCR	B
	JNZ	TF6
TF7:	LHLD	V1
	LXI	B,7
	DAD	B;		DANS H ADR ZONE EXTENSION
	MVI	B,3;		LONG ZONE EXTENSION
	MOV	A,M
	ANA	A
	JZ	TF8;		SI ZONE EXTENSION NON NULLE
	MVI	A,'.'
	CALL	TFSCA;		RANGER SEPARATEUR
TF75:	MOV	A,M;		RECOPIE ZONE EXTENSION
	INX	H
	ANA	A
	JZ	TF8
	CALL	TFSCA
	DCR	B
	JNZ	TF75
TF8:	MVI	A,0;		RANGER SEPARATEUR
	CALL	TFSCA
;
; PASSAGE A L'ENTREE SUIVANTE DE LA DIRECTORY
;
TF9:	LHLD	V1
	LXI	B,16
	DAD	B
	SHLD	V1
;
;  TEST SI FIN LECTURE BUFFER 4K IMAGE ISIS.DIR
	PUSH	H
	MOV	A,H
	LXI	H,FBUFD+1
	CMP	M
	POP	H
	JNZ	TF5
	MOV	A,L
	LXI	H,FBUFD
	CMP	M
	JNZ	TF5
	JMP	TF40		; LECTURE NOUVEAU BLOC ISIS.DIR
;
; FIN DE CONSULTATION DE LA DIRECTORY
;
TFA:	LHLD	AFTND
	SHLD	CLBLD
	MVI	C,CLOSE
	LXI	D,CLBLD
	CALL	ISIS;		FERMER FICHIER DIRECTORY
	CALL	TFTER
	RC	;		RETOUR SI INCIDENT
	LXI	H,BUFN;		(H,L)=ADDRESSE ZONE LISTE
	MVI	A,1		; POUR RESET Z FLAG
	ANA	A
	LDA	NFICH
	RET
;
$EJECT
;
;	ROUTINES INTERNES
;	*****************
;
;
;
; RANGEMENT NOM DE FICHIER SOUS FORME INTERNE
; *******************************************
;
TFST	EQU	$
	MOV	A,M
	CPI	CR
	RZ
	CPI	SLASH
	RZ
	CPI	' '
	RZ
	CPI	';'
	RZ
	CPI	'.'
	INX	H
	RZ
	STAX	D
	INX	D
	DCR	B
	JNZ	TFST
	STC	;		SI NBRE DE CARACTERES TROP GRAND SET CARRY
	RET
;
; TEST CONDITION D'ERREUR : SET CARRY SI STAT<>0
; **********************************************
;
TFTER	EQU	$
	LDA	STAT
	ANA	A
	STC
	RNZ
	CMC
	RET
;
; RANGEMENT CARACTERE DANS LA ZONE DE RANGEMENT
; *********************************************
;
TFSCA	EQU	$
	PUSH	H
	LHLD	PZR
	MOV	M,A
	INX	H
	SHLD	PZR
	POP	H
	RET
;
; COMPARAISON NOM DE FICHIER
; **************************
;
TFCOM	EQU	$
	LDAX	D
	INX	D
	CPI	'*'
	STC
	RZ	;		SI OK RETOUR AVEC C=1
	MOV	C,M
	INX	H
	CMP	C
	JNZ	TFCO1
	DCR	B
	JNZ	TFCOM
TFCO1:	STC
	RZ
	CMC
	RET
;
;
	DSEG
;
;
OPBLD	EQU	$;	BLOC PARAMETRE POUR OPEN DIRECTORY
	DW	AFTND;		ADRESSE AFTN
	DW	NDIR;		ADRESSE NOM FICHIER
	DW	1;		ACCESS=READ
	DW	0;		NO ECHO
	DW	STAT;		ADRESSE STATUS RENDU
CLBLD	EQU	$;	BLOC PARAMETRE POUR CLOSE
	DS	2;		AFTN
	DW	STAT;		ADRESSE STATUS RENDU
RDBLD	EQU	$;	BLOC PARAMETRE POUR READ DIRECTORY
	DS	2;		AFTN
	DW	BUFD;		ADRESSE BUFFER DE LECTURE
	DW	FLECT;		LONGUEUR BUFFER
	DW	ACTL;		ADRESSE LONGUEUR RENDUE
	DW	STAT;		ADRESSE STATUS
AFTND	EQU	RDBLD
;
ACTL:	DS	2
STAT:	DS	2
;
NDIR:	DB	':F0:ISIS.DIR'
	DB	0
NUMD	EQU	NDIR+2
;
ADRN:	DS	2
V1:	DS	2
PZR:	DS	2;	POINTEUR SUR ZONE DE RANGEMENT
NFICH:	DS	1;	NBRE DE FICHIERS TROUVES
ZNOM:	DS	10;	ZONE NOM DE FICHIER
ZEXT	EQU	ZNOM+6
BUFD:	DS	FLECT
FBUFD:	DW	BUFD+FLECT
BUFN:	DS	FLECT	; BUFFER LISTE DES NOMS
;
;
;
	END
