	program loginwarn
	implicit none
	parameter maxdisks = 20		! max disks to wrry about at once

	parameter warning  = 2.0	! %age to send first warning is
	parameter critical = 1.0	! %age to really start worrying

	parameter fmt = '!UL block!%S'	! output formatting string

	parameter strsize  = 64		! disk logical name buff size
	character diskname(maxdisks)*64	! logical name buffer - change here too

	integer   diskspace		! get disk info routine
	integer   n			! number of disks retrieved in a lookup
	integer   dvl(maxdisks)		! logical name length buffer
	integer   maxblks(maxdisks)	! maximum blocks
	real	  percentfree		! calculated %age free
	integer   freeblks(maxdisks)	! free blocks

	integer   outlen		! FAO formatting aid
	character outstr*20		! output buffer for FAO

	integer   i			! Loop variable
	integer   istat			! system service status
	integer   getquota		! quota lookup routine
	integer   qstat			! disk quota lookup status

	integer   getjpi		! external routine for GETJPI lookup
	character terminal*15		! terminal name
	integer   tlen			! terminal name length
	integer   group, member		! UIC buffers
	integer   pid			! Process ID buffer
	logical	  operpriv		! does he have oper priv
	logical   notify		! Do we tell him to delete files?

	include	  '($ssdef)/nolist'	! system service def'ns
	data notify /.false./
*
*	Get disk data
*
	istat=diskspace (maxdisks, 
     &			   n,
     &			   strsize,
     &			   dvl,
     &			   %ref(diskname),
     &			   maxblks,
     &			    freeblks)
	if ( (istat .and. 1) .ne. 1) call lib$signal(%val(istat))
	istat = getjpi(, terminal, tlen,
     &			   group, member, operpriv, pid)
	if ( (istat .and. 1) .ne. 1) call lib$signal(%val(istat))
	if ((terminal .ne. ' ') .and. (tlen .ne. 0)) then
*
*	Is this user an operator? do we notify him?
*
	  do i=1, n
	    percentfree = 100.0 * freeblks(i) / maxblks(i)

	    if (operpriv .and. (percentfree .lt. warning)) then
*
*	Yes! notify him of the situation
*
	      call sys$fao(fmt, outlen, outstr, %val(freeblks(i)))
	      print 100, outstr(:outlen), percentfree, diskname(i)(:dvl(i))
	    else if ((.not. operpriv) .and.
     &			(percentfree .lt. critical)) then

*
*	Is this user a non-operator, with a quota on this disk?
*
	      qstat = getquota(diskname(i) (:dvl(i)), group, member)

	      if ((qstat .and. 1) .eq. 1) then
		notify = .true.
		call sys$fao(fmt, outlen, outstr, %val(freeblks(i)))
		print 100, outstr(:outlen), percentfree, diskname(i)(:dvl(i))
	      end if
	    end if
	  end do
	end if
	if (notify) print 200
	call exit
100	format(5x,'Warning - only ', a, ' (',f4.2,'%) free on ', a)
200	format(5x,'Please delete any files you no longer need')
	end
