	PROGRAM WRAPLINES

c	This program reads ascii text files containing lines up to
c	2000 characters long, and breaks up lines longer than the value
c	of WRAP into shorter pieces.  It creates an outputfile identical
c	to the input file except that lines longer than the WRAP
c	parameter are "wrapped" around to the next line.

c	This program makes it possible to edit files containing lines
c	longer than 255 characters.

C	LINK THIS PROGRAM WITH /NOTRACEBACK
c	David Deley  GRC/SB 20-AUG-1986  Created

	parameter linelen=2000	! if longer lines needed, change this
				! and the 'line' declaration below
        character*2000  line
	character*80    inputfile
	character*80    outputfile
	integer         beg, end, wrap, status

20	FORMAT (
	1' '/
	2' This program reads ascii text files containing lines up to'/
	3' 2000 characters long, and breaks up lines longer than the value'/
	4' of WRAP into shorter pieces.  It creates an outputfile identical'/
	5' to the input file except that lines longer than the WRAP'/
	6' parameter are "wrapped" around to the next line.'/
	7' '/
	8' This program makes it possible to edit files containing lines'/
	9' longer than 255 characters.'/
	1' ')

21	format (' INPUT FILE: ',$)
22	format (' WRAP: ',$)
23	format (' OUTPUT FILE: ',$)

24	format (' Wrap value must be a positive integer')

31	format (a)
32	format (I)

	write (6,20)
	write (6,21)
	read  (5,31) inputfile
50	write (6,22)
	read  (5,32) wrap
	if (wrap .lt. 1) then
	  write (6,24)
	  goto 50
	endif
	write (6,23)
	read  (5,31) outputfile

c       set maximum output record length (fortran default is 133)
        open(unit=1,file=inputfile,status='OLD',recl=linelen,
	1	readonly)

	open(unit=2,file=outputfile,status='NEW',carriagecontrol='LIST')

	do while (.true.)
		read(1,100,end=1000)len,line
100		format(q,a)
102		format(a)
d		print *,' line=',line
		beg = 1
		do while (beg .le. len)
			end = beg + wrap - 1
			if (end .gt. len) end = len
			write(2,102) line(beg:end)
			beg = end + 1
		enddo
	enddo

1000	close(2)
	close(1)
	stop
	end
