/*-----------------------------------------------------------------------*
 *           TOOLS.H: Various #defines and typedefs for VMSGREP          *
 *-----------------------------------------------------------------------*/

/* 
 *    #define for non-printing ASCII characters
 */

#define NUL      0x00   /* ^@   */
#define CR       0x0d   /* ^M   */
#define SUB      0x1a   /* ^Z   */

#define islower(c)      ( 'a' <= (c) && (c) <= 'z' )
#define toupper(c)      ( islower(c) ? (c) - ('a' - 'A') : (c) )
#define max(a,b)        ( (a) > (b) ? (a) : (b) )

#define CHAR     unsigned char

/*      Definitions of meta-characters used in pattern matching routines.
 *      LITCHAR & NCCL are only used as token identifiers; all the others
 *      are also both token identifiers and the actual symbol used in     
 *      the regular expression
 */

#define BOL        '^'
#define EOL        '$'
#define ANY        '.'
#define LITCHAR    'L'
#define ESCAPE	   '\\'
#define CCL        '['            /* Character class:    [...]       */
#define CCLEND     ']'
#define NEGATE     '^'
#define NCCL       '!'            /* Negative character class [^...] */
#define CLOSURE    '*'
#define OR_SYM     '|'

/*
 *      Tokens are used to hold pattern templates. (see makepat() in
 *      tools.h
 */

typedef struct token
{
        CHAR           tok;
        CHAR           lchar;
        CHAR           *bitmap;
        struct token   *next;
}TOKEN;

#define TOKSIZE sizeof(TOKEN)

/*
 *      An absolute maximum for strings.
 */

#define MAXSTR         255             /* Maximum number of characters in
                                        *      a line.
                                        */

extern  CHAR       *matchs      ();
extern  CHAR       *amatch      ();
extern  CHAR       *index       ();
extern  TOKEN	   *getpat      ();
extern  int        esc          ();
extern  CHAR       *dodash      ();
extern  TOKEN      *makepat     ();
extern  int        unmakepat    ();   
extern  int        insert       ();
extern  int        delete       ();
extern  int        isalphanum   ();
extern  CHAR       *stoupper    ();
extern  int        pr_tok       ();
extern  int        pr_line      ();
