       IDENTIFICATION DIVISION.
       PROGRAM-ID.        HOME_BLOCK.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
               SYMBOLIC CHARACTERS TWO-FIFTY-FIVE IS 256.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT INDEXF ASSIGN TO INDEXF
               FILE STATUS IS MSD-STATUS.
       DATA DIVISION.
       FILE SECTION.
000100 FD  INDEXF
               LABEL RECORDS ARE STANDARD
               RECORD CONTAINS 512 CHARACTERS.
000500 01  HOME-BLOCK-RECORD.
           02  HB-HOME-BLOCK-LBN        PIC S9(09) COMP.
           02  HB-ALT-HOM-BLOCK-LBN     PIC S9(09) COMP.
           02  HB-ALT-INDEXF-HEADER-LBN PIC S9(09) COMP.
           02  HB-STRUCT-1              PIC X(01).
           02  HB-STRUCT-2              PIC X(01).
           02  HB-CLUSTER               PIC S9(04) COMP.
           02  HB-HOME-BLOCK-VBN        PIC S9(04) COMP.
           02  HB-ALT-HOME-BLOCK-VBN    PIC S9(04) COMP.
           02  HB-ALT-INDEXF-HEADER-VBN PIC S9(04) COMP.
           02  HB-BITMAP-VBN            PIC S9(04) COMP.
           02  HB-BITMAP-LBN            PIC S9(09) COMP.
           02  HB-MAX-FILES             PIC S9(09) COMP.
           02  HB-INDEXF-BITMAP-SIZE    PIC S9(04) COMP.
           02  HB-NO-RESERVED-FILES     PIC S9(04) COMP.
           02  HB-DEVICE-TYPE           PIC S9(04) COMP.
           02  HB-RVN                   PIC S9(04) COMP.
           02  HB-NO-VOLS-IN-SET        PIC S9(04) COMP.
           02  HB-VOLUME-CHARS          PIC S9(04) COMP.
           02  HB-UIC-MEMBER            PIC S9(04) COMP.
           02  HB-UIC-GROUP             PIC S9(04) COMP.
           02  FILLER                   PIC X(412).
           02  HB-VOL-SET-NAME          PIC X(12).
           02  HB-VOLUME-NAME           PIC X(12).
           02  HB-OWNER-NAME            PIC X(12).
           02  HB-FORMAT                PIC X(12).
           02  FILLER                   PIC X(04).
000500 01  INDEXF-RECORD.
000600     02  IDXF-FIRST-WORD		PIC S9(04)    COMP.
000600     02  FILLER   		PIC X(78).
000700     02  IDXF-FILE-NAME-PART1     PIC X(20).
000600     02  FILLER   		PIC X(34).
000700     02  IDXF-FILE-NAME-PART2     PIC X(66).
           02  FILLER                   PIC X(310).
           02  IDXF-LAST-WORD           PIC S9(04)    COMP.
       WORKING-STORAGE SECTION.
       01  FILLER.
           02  MSD-STATUS              PIC X(02).
           02  RECORD-COUNT            PIC 9(06).
           02  DHOME-BLOCK-LBN         PIC Z(09).
           02  DALT-HOM-BLOCK-LBN      PIC Z(09).
           02  DALT-INDEXF-HEADER-LBN  PIC Z(09).
           02  DCLUSTER                PIC Z(04).
           02  DHOME-BLOCK-VBN         PIC Z(04).
           02  DALT-HOME-BLOCK-VBN     PIC Z(04).
           02  DALT-INDEXF-HEADER-VBN  PIC Z(04).
           02  DBITMAP-VBN             PIC Z(04).
           02  DBITMAP-LBN             PIC Z(09).
           02  DMAX-FILES              PIC Z(09).
           02  DINDEXF-BITMAP-SIZE     PIC Z(04).
           02  DNO-RESERVED-FILES      PIC Z(04).
           02  DDEVICE-TYPE            PIC Z(04).
           02  DRVN                    PIC Z(04).
           02  DNO-VOLS-IN-SET         PIC Z(04).
           02  DVOLUME-CHARS           PIC Z(04).
           02  DUIC-MEMBER             PIC Z(03)9.
           02  DUIC-GROUP              PIC Z(03)9.
           02  CLR-ATT.
               03  FILLER              PIC S9(04) COMP VALUE 27.
               03  FILLER              PIC S9(04) COMP VALUE 91.
               03  FILLER              PIC S9(04) COMP VALUE 48.
               03  FILLER              PIC S9(04) COMP VALUE 109.
           02  WBOLD.
               03  FILLER              PIC S9(04) COMP VALUE 27.
               03  FILLER              PIC S9(04) COMP VALUE 91.
               03  FILLER              PIC S9(04) COMP VALUE 49.
               03  FILLER              PIC S9(04) COMP VALUE 109.
           02  WBLINK.
               03  FILLER              PIC S9(04) COMP VALUE 27.
               03  FILLER              PIC S9(04) COMP VALUE 91.
               03  FILLER              PIC S9(04) COMP VALUE 53.
               03  FILLER              PIC S9(04) COMP VALUE 109.
       PROCEDURE DIVISION.
       DECLARATIVES.
       FIXA SECTION 00.
           USE AFTER STANDARD ERROR PROCEDURE ON I-O.
       FIX1.
           IF MSD-STATUS = 02 OR MSD-STATUS = 90 OR MSD-STATUS = 92
               NEXT SENTENCE
           ELSE
               DISPLAY " "
               DISPLAY "*****************************"
               DISPLAY "*                           *"
               DISPLAY "*     FILE I/O ERROR " MSD-STATUS "     *"
               DISPLAY "*                           *"
               DISPLAY "*****************************"
               DISPLAY " "
               STOP RUN.
       FIX-EXIT.
           EXIT.
       END DECLARATIVES.
       MAIN SECTION 00.
       MAIN-PARA.
           OPEN INPUT INDEXF ALLOWING ALL.
           MOVE 0 TO RECORD-COUNT.
       READ-HOME-BLOCK.
           READ INDEXF AT END
               GO TO E-O-J.
           ADD 1 TO RECORD-COUNT.
           IF RECORD-COUNT NOT = 2
               GO TO READ-HOME-BLOCK.
           MOVE HB-HOME-BLOCK-LBN TO DHOME-BLOCK-LBN.
           MOVE HB-ALT-HOM-BLOCK-LBN TO DALT-HOM-BLOCK-LBN.
           MOVE HB-ALT-INDEXF-HEADER-LBN TO DALT-INDEXF-HEADER-LBN.
           MOVE HB-CLUSTER TO DCLUSTER.
           MOVE HB-HOME-BLOCK-VBN TO DHOME-BLOCK-VBN.
           MOVE HB-ALT-HOME-BLOCK-VBN TO DALT-HOME-BLOCK-VBN.
           MOVE HB-ALT-INDEXF-HEADER-VBN TO DALT-INDEXF-HEADER-VBN.
           MOVE HB-BITMAP-VBN TO DBITMAP-VBN.
           MOVE HB-BITMAP-LBN TO DBITMAP-LBN.
           MOVE HB-MAX-FILES TO DMAX-FILES.
           MOVE HB-INDEXF-BITMAP-SIZE TO DINDEXF-BITMAP-SIZE.
           MOVE HB-NO-RESERVED-FILES TO DNO-RESERVED-FILES.
           MOVE HB-DEVICE-TYPE TO DDEVICE-TYPE.
           MOVE HB-RVN TO DRVN.
           MOVE HB-NO-VOLS-IN-SET TO DNO-VOLS-IN-SET.
           MOVE HB-VOLUME-CHARS TO DVOLUME-CHARS.
           MOVE HB-UIC-MEMBER TO DUIC-MEMBER.
           MOVE HB-UIC-GROUP TO DUIC-GROUP.
           DISPLAY " ".
           DISPLAY WBOLD " HOME BLOCK LBN        = " CLR-ATT
                                                        DHOME-BLOCK-LBN.
           DISPLAY WBOLD " ALT HOME BLOCK LBN    = " CLR-ATT
                                                     DALT-HOM-BLOCK-LBN.
           DISPLAY WBOLD " ALT INDEXF HEADER LBN = " CLR-ATT
                                                 DALT-INDEXF-HEADER-LBN.
           DISPLAY WBOLD " CLUSTER               =      " CLR-ATT
                                                               DCLUSTER.
           DISPLAY WBOLD " HOME BLOCK VBN        =      " CLR-ATT
                                                        DHOME-BLOCK-VBN.
           DISPLAY WBOLD " ALT HOME BLOCK VBN    =      " CLR-ATT
                                                    DALT-HOME-BLOCK-VBN.
           DISPLAY WBOLD " ALT INDEXF HEADER VBN =      " CLR-ATT
                                                 DALT-INDEXF-HEADER-VBN.
           DISPLAY WBOLD " BITMAP VBN            =      " CLR-ATT
                                                            DBITMAP-VBN.
           DISPLAY WBOLD " BITMAP LBN            = " CLR-ATT
                                                            DBITMAP-LBN.
           DISPLAY WBOLD " MAXIMUM FILES ALLOWED = " CLR-ATT DMAX-FILES.
           DISPLAY WBOLD " INDEXF BITMAP SIZE    =      " CLR-ATT
                                                    DINDEXF-BITMAP-SIZE.
           DISPLAY WBOLD " NO RESERVED FILES     =      " CLR-ATT
                                                     DNO-RESERVED-FILES.
           DISPLAY WBOLD " DEVICE TYPE           =      " CLR-ATT
                                                           DDEVICE-TYPE.
           DISPLAY WBOLD " RVN                   =      " CLR-ATT DRVN.
           DISPLAY WBOLD " NUMBER OF VOLS IN SET =      " CLR-ATT
                                                        DNO-VOLS-IN-SET.
           DISPLAY WBOLD " VOLUME CHARS          =      " CLR-ATT
                                                          DVOLUME-CHARS.
           DISPLAY WBOLD " UIC                   = " 
                                     CLR-ATT DUIC-GROUP "," DUIC-MEMBER.
           DISPLAY WBOLD " VOLUME SET NAME       = " CLR-ATT
                                                        HB-VOL-SET-NAME.
           DISPLAY WBOLD " VOLUME NAME           = " CLR-ATT
                                                         HB-VOLUME-NAME.
           DISPLAY WBOLD " OWNER NAME            = " CLR-ATT
                                                          HB-OWNER-NAME.
           DISPLAY WBOLD " FORMAT                = " CLR-ATT HB-FORMAT.
           DISPLAY " ".
       E-O-J.
           CLOSE INDEXF.
           STOP RUN.
