C
C	The purpose of this subroutine is to check the given class for
C 	then professor's account and check that the uic group from that
C	account is the same as the uic group of the class.  If the 
C	account or the uic come up with an error then the program will
C	stop until the Prof account has been set up correctly
C

	Logical*1 Function CheckProf(class,ProfUic,InGroup)

	Parameter	Rec_len=184
	Parameter	screen=1
	Parameter	Uaf=5
	Parameter	UAF$L_UIC='24'X+1

	Character*1	Record(Rec_len)
	Character*12	class
	Character*12	Prof
	Integer*2	ProfUic(2)
	Integer*2	Uic(2)
	Integer*2	InGroup
	Integer*2	IO_err
	Integer*2	length

	Equivalence (Record(UAF$L_UIC),Uic)


C	Get to the actual characters
	length=LEN(class)
	Do while (class(length:length) .eq. ' ')
		length=length-1
	end do

C	Set up the Username for the prof account
	Prof='            '
	Prof(1:length)=class(1:length)
	Prof(length+1:length+6)='_prof'
	call str$upcase (Prof,Prof)


	Open(	unit=Uaf, File='sys$system:sysuaf.dat', readonly,
     +		status='old', shared, organization='indexed',
     +		access='keyed', recordtype='variable',
     +		form='unformatted',err=99)

	Read(Uaf, key=prof, IOstat=IO_err) Record
	close (Uaf)

C	Check to see if the prof account exists
	if (IO_err .eq. 36) goto 1000	! Nope it doesn't
	if (IO_err .gt. 0) then		! There was an error in accessing 
99		write (screen,100)	! the Uaf
100		format (1x,'%%%%% Problem with the UAF access !!!')
		CheckProf=.FALSE.	! Return the error code
		Return
	end if

C	Check the group number and write error if needed
	if (Uic(2) .ne. InGroup) then
		write (screen,101) InGroup
101		format (1x,'%%%%% Error Prof Account NOT Group ',1O8)
		CheckProf=.FALSE.	! Everything is Bad
		else
		CheckProf=.TRUE.
		ProfUic(1)=Uic(1)
		ProfUic(2)=Uic(2)
	end if

	Return

C	No prof account in the UAF
1000	write (screen,1001) prof
1001	format (1x,'%%%%% Error Prof Account ',1A12,' not found in UAF')
	CheckProf=.FALSE.	! No Account Error stop program

	Return 

	end
