C
C	The purpose of this routine is to get a unique 
C	UIC for each user.  This is done by opening the 
C	SYSUAF.DAT open for a key on the UIC and checking 
C	the IO_status.
C

	Subroutine GetUic(ptrInStack,UicStack,Group,Last_UIC)

	Parameter	Rec_len=184
	Parameter	screen=1
	Parameter	Uaf=5
	Parameter	UAF$L_UIC='24'X+1

	Character*1	Record(Rec_len)
	Integer*4	uic
	Integer*4	UicStack(1000)
	Integer*2	ptrInStack
	Integer*2	Group,intermed(2)
	Integer*2	Last_UIC
	Integer*2	IO_err
	Integer*2	j
	Integer*2	length

	Equivalence (uic,intermed)

	intermed(2)=Group
	intermed(1)=Last_UIC

	Open(	unit=Uaf, File='sys$system:sysuaf.dat', readonly,
     +		status='old', shared, organization='indexed',
     +		access='keyed', recordtype='variable',
     +		form='unformatted')

50	Read(Uaf, key=uic, keyid=1, IOstat=IO_err) Record

C	Check to see if the UIC exists
	if (IO_err .eq. 36) goto 500	! Unique UIC Gooood
	if (IO_err .gt. 0) then		! There was an error in accessing 
		write (screen,100)	! the Uaf
100		format (1x,'%%%%% Problem with the UAF access !!!')
		call exit(IO_err)
	end if

C	Change the uic to a unique one
200	intermed(1)=intermed(1)+1
	goto 50

C	Check the Uic Stack for duplicates
500	if (ptrInStack .eq. 0) goto 1000
	Do j=1,ptrInStack
		if (uic .eq. UicStack(j)) goto 200
	end do

1000	close (Uaf)
C	Add uic to the stack and save the uic member number
	UicStack(ptrInStack+1)=uic
	Last_UIC=intermed(1)

	end
