C
C	This is the main routine for the make account section of
C	code.  This will read in the data file and parse it and 
C	create the com files.
C

	Subroutine MakeList

	Parameter	(screen=1,semIn=2,semOut=3,extension=7,roster=15)

	Integer*2	ptrInStack
	Character*12	Type
	Character*12	Class
	Character*30	Name
	Character*30	pwd
	Integer*2	group
	Integer*2	ProfUic(2)
	Logical*1	CheckProf
	Character*12	disk
	Integer*2	loginQ
	Integer*2	logoutQ
	Integer*2	rate
	Integer*2	NumOfAcc
	Real		money
	Integer*4	Uic(1000)
	Integer*4	UicHolder
	Integer*2	intermed(2)
	Integer*2	Last_UIC
	Character*12	Username(1000)
	Character*35	Dir(1000)
	Character*68	Idents(50)
	Integer		NumOfIds
	Logical*1	In_Progress
	Character*7	ext
	Character*30	fileName
	Integer*2	length
	Integer*2	length2
	Integer*2	Find_error

	equivalence (UicHolder,intermed)

C	Check to see if a MAKALL is in Progress
	inquire (file='MAKACT_WORK:MAKE_IN_PROGRESS.TEMP',
     +	exist=In_Progress)
	if (In_Progress) then
		write (screen,1)
1		format (1x,'%%%%% MAKALL Currently in the',
     +		' Batch Queue.',/,1x,'%%%%% MAKE NOT permitted')
		goto 10300
	end if

C	Intialize the program
	ptrInStack=0
	Open(unit=extension,
     +	file='MAKACT_FILES:directory.sav',status='old',
     +	carriagecontrol='list',err=10100)
	read (extension,fmt='(1A7)') ext
	close (extension)

C	Open the roster file
150	write (screen,152)
152	format (1x,'File    > ',$)
200	read (screen,100,err=10300) length,fileName
100	format (Q,A)
	if (length .eq. 0) goto 150
	Open (unit=roster,file=fileName,err=999,status='old',
     +	carriagecontrol='list')


C	Open up the different COM files for the creation of accounts
	call OpenFiles

5	read (roster,15,err=10200) length,Type
15	format (Q,A)
	if (length .eq. 0) goto 5

	read (roster,15,err=10200) length2,Class
	if (length2 .eq. 0) goto 10200

	read (roster,*,err=99) money
	if (money .le. 0) goto 10200

	call str$upcase(type,type)

	NumOfAcc=0

	Find_error=0
	call OpenSemBud(Type,Class,group,disk,loginQ,logoutQ,
     +			rate,Find_error)
	if (Find_error .eq. -1) then
		write (screen,143)
143		format (1x,'%%%%% Batch Job NOT submitted')
		call Exit
	end if

C	For all CLASS accounts check for the prof UIC
	if (Type .eq. 'CLASS ') then
		if ( .NOT. CheckProf(Class,ProfUic,group)) goto 50
	end if

C	Get the customizing information
	call Customize(Type,Idents,NumOfIds)

C	Create the upper directories
	call WriteDir(disk,Type,length,Class,length2)

C	Reset the Last UIC member number to 1
	Last_UIC=1

C	Start the loop to get all the names for the one class
30	read (roster,15,err=10250) length,Name
	if (Name .eq. '*') goto 50
	pwd='                              '
	if (length .eq. 0) then
		read (roster,15) length,pwd
		if (length .eq. 0) then
			write (screen,40) Type,Class
40			format (1x,'%%%%% ERROR in name or password ',
     +			'with : ',1A12,2x,1A12)
			call CloseSembud(line,BudgetIn,BudgetPos,
     +			NumOfAcc,money)
			close (semIn)
			close (semOut)
			close (roster)
			Stop			! To hard to recover from
		end if
	end if

	call str$upcase(Name,Name)

	call getuser(ptrInStack,Username,Class,Name)
	call getuic (ptrInStack,Uic,group,Last_UIC)
	call getdir (ptrInStack,Dir,disk,type,class,ext)

	NumOfAcc=NumOfAcc+1
	ptrInStack=ptrInStack+1
	UicHolder=Uic(ptrInStack)

	call WriteFiles(Dir(ptrInStack),disk,intermed,
     +		      Username(ptrInStack),class,name,pwd,
     +		      loginQ,logoutQ,type,ProfUic,ext)
	call WriteIds(Username(ptrInStack),Idents,NumOfIds)

	goto 30

C	Done with a class close up the Sembud
50	call CloseSemBud(Type,Class,NumOfAcc,money)
	goto 5

C	Error Message for the bad conversion of the money
99	write (screen,199)
199	format (1x,'%%%%% Error in converting the Money/Account')
	close (roster)
	Stop

C	Error message for the missing file
999	write (screen, 1000) fileName
1000	format (1x,'%%%%% Error in Opening Roster File ',1A30)
	goto 150

9999	write (screen,10000)
10000	format (1x,'%%%%% ERROR in opening the SemBud.dat file')
	stop

10100	ext='A001'
	goto 5

C	Close the Sembud.dat
10250	call CloseSemBud(Type,Class,NumOfAcc,money)

10200	Open(unit=extension,
     +	file='MAKACT_FILES:directory.sav',status='new',
     +	carriagecontrol='list')
	write (extension,10201) ext
10201	format (1A7)
	close (extension)
C	Close all the COM files that were Opened
	call CloseFiles

	close (roster)

C	Print out the Roster file
	call Lib$Spawn('Print /delete/notify MAKACT_WORK:Roster.List')
	call Lib$Do_Command('@MAKACT_WORK:MAKALL.COM')

10300	end
