	Subroutine Mod_Sembud

	Parameter (screen=1,sembud=2,Rec_S=52)

	Logical*1	Exists
	Character*52	rec_line
	Character*24	Id_Key
	Character*12	Type
	Character*12	Sub_type
	Character*12	disk
	Integer*2	group
	Integer*2	login_Q
	Integer*2	logout_Q
	Real*8		budget
	Integer*2	rate
	Character*12	NewDisk
	Integer*2	NewGroup
	Integer*2	NewLogin
	Integer*2	NewLogout
	Real*8		NewBudget
	Integer*2	NewRate
	Character*8	TempGroup
	Character*8	TempLogin
	Character*8	TempLogout
	Character*20	TempBudget
	Character*8	TempRate
	Integer*2	length
	Integer*2	IO_err

	Equivalence (rec_line(37:38),group)
	Equivalence (rec_line(39:40),login_Q)
	Equivalence (rec_line(41:42),logout_Q)
	Equivalence (rec_line(43:44),rate)
	Equivalence (rec_line(45:52),Budget)

	Inquire (File='MAKACT_FILES:sembud.idx',exist=Exists)
	If (Exists) then 
		Open (unit=sembud,file='MAKACT_FILES:sembud.idx',
     +		status='old',Organization='indexed',access='keyed',
     +		RecordType='fixed',form='unformatted',shared,
     +		key=(1:24,37:38),recordsize=Rec_S)
	else
		write (screen,*) '%%%%% No SemBud to Modify'
		goto 9999
	end if

1	format (Q,A)

5	type='            '
	write (screen,10)
10	format (1x,'Type of Account     > ',$)
	read (screen,1,err=9999) length,type
	if (length .eq. 0) goto 5

15	Sub_type='            '
	write (screen,20)
20	format (1x,'Sub-Type of Account > ',$)
	read (screen,1,err=5) length,Sub_type
	if (length .eq. 0) goto 15

	call str$upcase(type,type)
	call str$upcase(Sub_type,Sub_type)

	if ((type .eq. 'THSS ').OR.(type .eq. 'PROF ')) then
		if (index(Sub_type,'_') .eq. 0) then
			Sub_type(length+1:length+1 )='_'
			length=length+1
		end if
	end if

	Id_Key=type//Sub_type

	read (sembud,key=Id_Key,keyid=0,IOstat=IO_err) rec_line
	if (IO_err .eq. 36) then
		write (screen,25) Id_Key
25		format (1x,'%%%%% Classification ',1A24,' NOT found')
		goto 5
	end if
	if ((IO_err .ne. 0).AND.(IO_err .ne. 36)) then
		write (screen,30)
30		format (1x,'%%%%% ERROR in the SemBud File')
		call Exit(IO_err)
	end if

	disk=rec_line(25:36)

32	write (screen,35) disk
35	format (/,1x,'Disk to be Used    [',1A12,'] > ',$)
	read (screen,1,err=15) length,NewDisk
	if (length .ne. 0) then
		call str$Upcase(NewDisk,NewDisk)
		disk=NewDisk
	end if

40	write (screen,45) group
45	format (1x,'UIC Group Number       [',1O8,'] > ',$)
	read (screen,1,err=32) length,TempGroup
	if (length .ne. 0) then
		read (unit=TempGroup(1:length),
     +		      fmt='(1O8)',err=40)NewGroup
		group=NewGroup
	end if

50	write (screen,55) login_Q
55	format (1x,'Permquota              [',1I8,'] > ',$)
	read (screen,1,err=40) length,TempLogin
	if (length .ne. 0) then
		read (unit=TempLogin(1:length),
     +		      fmt='(1I8)',err=50)NewLogin
		login_Q=NewLogin
	end if

60	write (screen,65) logout_Q
65	format (1x,'Overdraft              [',1I8,'] > ',$)
	read (screen,1,err=50) length,TempLogout
	if (length .ne. 0) then
		read (unit=TempLogout(1:length),
     +		      fmt='(1I8)',err=60)NewLogout
		logout_Q=NewLogout
	end if

70	write (screen,75) rate
75	format (1x,'PACS Rate Number       [',1I8,'] > ',$)
	read (screen,1,err=60) length,TempRate
	if (length .ne. 0) then
		read (unit=TempRate(1:length),
     +		      fmt='(1I8)',err=70)NewRate
		rate=NewRate
	end if

80	write (screen,85) budget
85	format (1x,'Budget             [',1F12.2,'] > ',$)
	read (screen,1,err=70) length,TempBudget
	if (length .ne. 0) then
		if (index(TempBudget,'.') .eq. 0) then
			length=length+1
			TempBudget(length:length)='.'
		end if
		read (unit=TempBudget(1:length),
     +		      fmt='(1F12.2)',err=80)NewBudget
		budget=NewBudget
	end if

	rec_line(1:36)=Id_Key//disk
	rewrite(sembud) rec_line

	write (screen,*) ' '
	goto 15

9999	close(sembud)
	end
