C
C	This is a routine to get all the information from the
C	SEMBUD.DAT file and write out the updated version of the
C	file to the system.
C
C	What needs to be passed in is the type, sub-type, the number
C	of accounts being created, and the money per account allocation
C
C	What is passed back is UIC group, disk, login quota, logout quota,
C	and the pacs rate. ( the rate for class accounts will be set to the
C	default value initialized in the beginning of the routine )
C

	Subroutine OpenSemBud(type,Sub_type,UIC,disk,loginQ,logoutQ,
     +			      rate,Find_error)

	Character*52	rec_line
	Character*12	type
	Character*12	Sub_type
	Character*24	Id_Key
	Integer*2	UIC
	Character*12	disk
	Integer*2	loginQ
	Integer*2	logoutQ
	Integer*2	rate
	Real*8		budget
	Integer*2	temp_UIC
	Character*12	temp_disk
	Integer*2	temp_login
	Integer*2	temp_logout
	Integer*2	temp_rate
	Integer*2	IO_err
	Logical*1	Exists
	Integer*2	Find_error

	Parameter (screen=1,sembud=2,Rec_S=52)

	Equivalence (rec_line(25:36),temp_disk)
	Equivalence (rec_line(37:38),temp_Uic)
	Equivalence (rec_line(39:40),temp_login)
	Equivalence (rec_line(41:42),temp_logout)
	Equivalence (rec_line(43:44),temp_rate)
	Equivalence (rec_line(45:52),budget)

	Id_Key=type//Sub_type
	call str$upcase(Id_Key,Id_Key)

	Inquire (File='MAKACT_FILES:sembud.idx',exist=Exists)
	If (Exists) then 
		Open (unit=sembud,file='MAKACT_FILES:sembud.idx',
     +		status='old',Organization='indexed',access='keyed',
     +		RecordType='fixed',form='unformatted',shared,
     +		key=(1:24,37:38),recordsize=Rec_S)
	else
		write (screen,*) '%%%%% No SemBud to use ',
     +				 '(see ADD command)'
		goto 9999
	end if

	read (sembud,key=Id_Key,IOstat=IO_err) rec_line
	if (IO_err .eq. 36) then
		Find_error=-1
		write (screen,*) '%%%%% Warning ',
     +				 Id_Key,' NOT present'
		goto 9999
	end if
	if (IO_err .ne. 0) call Exit(IO_err)

	disk=temp_disk
	UIC=temp_Uic
	loginQ=temp_login
	logoutQ=temp_logout
	rate=temp_rate

	if (budget .le. 0)write (screen,*) '%%%%% Warning Zero Budget'

9999	close (sembud)
	end
