! ------------------------------------------------------------------------------
! PP&L VAX Computer Systems <> System Application Utility
! -------------------------------------------------------
!
! Perform image exit
!
!
! M. Latshaw <> 07/16/86
! ------------------------------------------------------------------------------


!			-------------------------------------
	SUBROUTINE	I B M _ N L _ T O _ D I S K _ E X I T
!			-------------------------------------

	1 ( MTCHAN )	! I*2	Input	Tape drive channel number



	IMPLICIT NONE


	INTEGER*4 SYS$DASSGN
	INTEGER*4 SYS$QIOW


	INTEGER*2 IOSB(4)		! I/O status block
	INTEGER*2 MTCHAN		! Tape drive channel

	INTEGER*4 IOF			! I/O function code
	INTEGER*4 IRC			! Internal return status


	EXTERNAL IO$_AVAILABLE
	EXTERNAL IO$_REWIND
	EXTERNAL IO$M_NOWAIT
	EXTERNAL SS$_NORMAL


! ---------------
! Rewind the tape
! ---------------

	IOF = %LOC (IO$_REWIND) .OR. %LOC (IO$M_NOWAIT)

	IRC = SYS$QIOW (, %VAL (MTCHAN), %VAL (IOF),IOSB,,,,,,,,, )

	IF (IOSB(1) .NE. %LOC (SS$_NORMAL)) THEN

	    TYPE *,'Unable to rewind the tape'
	    END IF


! -----------------
! Release the drive
! -----------------

	IOF = %LOC (IO$_AVAILABLE)

	IRC = SYS$QIOW (, %VAL (MTCHAN), %VAL (IOF),IOSB,,,,,,,,, )

	IF (IOSB(1) .NE. %LOC (SS$_NORMAL)) THEN

	    TYPE *,'Unable to release the tape drive'
	    END IF


! ------------------------
! Release the tape channel
! ------------------------

	IRC = SYS$DASSGN (%VAL (MTCHAN))



! -------------
! We're gone...
! -------------

	CALL EXIT
	END
