
type
   cli_tableType = 
      [byte(5)] record cli_tableType: boolean end;
      {Example declaration: 
         table: [external] cli_tableType;
       The strange type declaration is mostly intended to ensure
       that no other variable has the same type.
       This should refer to a .CLD file something like
       MODULE TABLE
          DEFINE VERB CLI_
          ROUTINE CLI_ABORT ! abort if cli$dispatch is called
          ...
       }

[external] procedure cli_parse_foreign(
   var table: cli_tableType;
       verb: [class_s,truncate] packed array[a..b: integer] of char);
   extern;

[external] procedure cli_abort; extern;
   {aborts if cli$dispatch is called}

type
    pas_FileSpec = varying [NAM$C_MAXRSS] of char;

[hidden] type
    AnUnsafeFile = [unsafe] file of char;

[external] function pas_getFileSpec (var f : AnUnsafeFile) : pas_fileSpec;
   extern;
{This file has some hand changes, including making [global] [external] and
concatenation with tblmsg.pas}

[hidden] const
   maxModule = 31;
   maxVersion = 31;
   maxSymbol = 31;
   maxPsect = 255;
   tir = chr(OBJ$C_TIR);
                                    
[hidden] type
   uWord = [word] 0..2**16-1;
   twoBytes = packed array[1..2] of char;
   fourBytes = packed array[1..4] of char;
   psectPointer = ^psectContext;
   psectContext = record
      current: integer;
      alignment: integer;
      pflags: uWord;
      pName: varying[maxSymbol] of char;
      end;
   context = record
      psect: array[0..maxPsect] of psectPointer;
      currentPsect: integer;
      recSize: integer;
      f: text;
      end;
type
   TBL_context = @context;

const
   TBL_readOnly  = GPS$M_PIC+GPS$M_REL+GPS$M_RD+GPS$M_SHR+GPS$M_EXE;
   TBL_writeable = GPS$M_PIC+GPS$M_REL+GPS$M_RD+GPS$M_WRT;
   TBL_common    = TBL_writeable+GPS$M_OVR;

[hidden]
const
   newPsect = psectContext(
      0,		{Relocation counter starts at 0}
     -1,		{No alignment requested}
      TBL_readOnly,	{Psect is readonly by default}
      '');		{No psect name}

{@+ .doc .def}

[external]
procedure TBL_set_psect(
   context: TBL_context;
   ps: integer); extern;

{Sets the relocation counter to the current location in psect ps}

[hidden]
const
   defaultVersion = '01';
   defaultCreator = 'Table Writer V1.1, MCV/VCU';
   defaultRecSize = 512;

[external] 
procedure TBL_open_table(
    var context:    TBL_context;
           {pointer to context information}
        moduleName: [class_s] packed array[m1..mN: integer] of char;
           {module name string for object file header record}
        version:    [class_s,truncate] packed array[v1..vN: integer] of char;
           {Version string for object file header record}
           {default: defaultVersion}
        creator:    [class_s,truncate] packed array[c1..cN: integer] of char;
           {Creator name string for object file header record}
           {default: defaultCreator}
        fileName:   [class_s,truncate] packed array[f1..fN: integer] of char;
           {Name of object file}
           {default: moduleName+'OBJ'}
        inRecSize:  [truncate] integer); extern;
           {Maximum object file reocrd size}
           {default: defaultRecSize}

{Opens an object file and writes the header records;
 Sets the relocation counter to psect 0, byte 0}

[hidden]
const
   minAlign = 0;
   maxAlign = 9;

[external]
procedure TBL_align_counter(
   context: TBL_context;
   align: integer); extern;

{Sets the relocation counter to the least number greater than or equal to
 its present value that is evenly divisible by 2**align.
 Saves the maximum requested alignment for each psect. The alignment
 specified for the psect as whole will be this maximum alignment; if
 no alignment adjustment is requested for a psect, the alignment specified
 will be 2 (i.e. the psect will begin on an address divisible by 4}

[external]
procedure TBL_define_symbol(
   context:   TBL_context;
   gloSym:     [class_s] packed array[s0..sN: integer] of char); extern;

{Defines the global symbol gloSym as a relocatable symobl with a
 value corresonding to the relocation counter for the current psect}

[external]                                      
procedure TBL_store_data(
        context: TBL_context;
   %ref data:     [unsafe,readonly] packed array[lo..hi: integer] of char;
        dataSize: integer); extern;

{Writes dataSize bytes from data to the object file, breaking data up
 into as many TIR records as necessary. The data will start at the point
 of the current relocation counter, and the relocation counter will be
 increased by dataSize}

[external]
procedure TBL_set_psect_info(
   context:   TBL_context;
   flags:     uword;
   name:      [class_s,truncate] packed array[n0..nN: integer] of char); extern;

{Sets the psect flags (and psect name, if supplied) for the current psect}

{The most common flags combinations are supplied as the constants
 TBL_readOnly, TBL_writeable, and TBL_common.
 The default name for a psect depends on its flags. If the flags are equal
 to TBL_readOnly then the default pname is '$CODE'; if TBL_writeable then 
 '$LOCAL'; and if TBL_common then '$BLANK'. If an unorthodox flag combination
 is used and a psect name is not supplied, then an arbitrary name dependant
 on the flags and the psect alignment will be used.}

const
   TBL_success = 0;
   TBL_warning = 1;
   TBL_error = 2;
   TBL_abort = 3;

[external]
procedure TBL_close_table(
   context: TBL_context;
   error: [truncate] integer); extern;

{Closes the object file.
 If error is not supplied it defaults to TBL_success; the values
 TBL_warning, TBL_error, and TBL_abort can be used to indicate a
 'compile' time error to the linker, which will issue an appropriate
 message and in the case of TBL_error will refuse to create the executable
 file, and in the case of TBL_abort, will abort the link operation
 without reading any other object files}

var
TBL__SYMBOLTRUNC: [external, value] integer;
TBL__PSECTRUNC: [external, value] integer;
TBL__CREATORTRUNC: [external, value] integer;
TBL__VERSIONTRUNC: [external, value] integer;
TBL__MODULETRUNC: [external, value] integer;
TBL__STATUSNUMBER: [external, value] integer;
TBL__ALIGNMENT: [external, value] integer;
TBL__RECORDSIZE: [external, value] integer;
TBL__PSECTNUMBER: [external, value] integer;
TBL$_FACILITY: [external, value] integer;
