[inherit('sys$library:starlet'),check(all)]
module pas_getFileSpec;

{@+ mcvlib}

type
    pas_FileSpec = varying [NAM$C_MAXRSS] of char;

[hidden] type
    AnUnsafeFile = [unsafe] file of char;
{@- mcvlib}
    APointerToFAB = ^fab$type;
    APointerToNAM = ^nam$type;
    String = packed array [1..NAM$C_MAXRSS] of char;
    StringPointer = ^String;

[hidden,external] function pas$fab (var f : AnUnsafeFile) : APointerToFAB;
    external;

{@+ mcvlib

[external] function pas_getFileSpec (var f : AnUnsafeFile) : pas_fileSpec;
   extern;
{@- mcvlib}

[global] function pas_getFileSpec (var f : AnUnsafeFile) : pas_fileSpec;
var
    fab : APointerToFAB;
    nam : APointerToNAM;
    len : [byte] 0..255;
    str : StringPointer;
begin
fab := pas$fab (f);
nam := fab^.fab$l_nam :: APointerToNAM;
len := nam^.nam$b_rsl;
str := nam^.nam$l_rsa :: StringPointer;
pas_getFileSpec := substr (str^, 1, len)
end;	{ pas_getFileSpec }

end.
