{+++
	This program demonstrates the use of the `listings' facility.
	It reads the file `input', and writes the text there into the
	file `listfile.lis', with line numbers added, using the default
	page size.  There is a simple page header on each page.

	Bob Langford
	MCV Academic Computing
	Medical College of Virginia
	March, 1986
---}
[inherit('listings')]
program ListingDemo (input, output);

var
    list : aListingControlBlock;	{ The LCB, of course. }
    line : varying [132] of char;	{ Holds the data line read in. }
    n : integer := 0;			{ Counts the # of records. }


	{ Page header routine.  Called by FlushListing, not by
	  this program.  Note that it can use static or global 
	  variables.						}
[asynchronous] function Header : integer;
var PageNumber : [static,volatile] integer := 0;	{ Page number }
begin
PageNumber := PageNumber + 1;
			{ Note that the <FF> must be written explicitly. }
writeln (list.OutFile, chr(12)+'Heading for Page '+dec(PageNumber,5,1));
writeln (list.Outfile);
writeln (list.Outfile);
header := 3			{ Signal that Header wrote 3 lines. }
end;	{ header }


begin
OpenListing (list, 'listfile', iaddress(header));
while not eof(input) do begin
    readln (input, line);
    n := n + 1;
    WriteListing (list, {dec(n,5,1)+'	'+}line);
    end;
FlushListing (list)
end.
