{	Run-time Library interface to Pascal V3			}
{	Bob Langford and Fritz, Academic Computing, MCV		}

[environment('rtl')] module RTL;

{*****			System-wide definitions			*****}

type
	$bit = [bit(1), unsafe] boolean;
	$byte = [byte] -128..127;
	$word = [word] -32768..32767;
	$long = [long] integer;
	$quad = [quad, unsafe] record
			l0:unsigned; l1:integer
		end;
	$octa = [octa, unsafe] record
			l0, l1, l2:unsigned; l3:integer
		end;
	$ubyte = [byte] 0..255;
	$uword = [word] 0..65535;
	$ulong = [long] unsigned;
	$uquad = [quad, unsafe] record
			l0, l1:unsigned
		end;
	$uocta = [octa, unsafe] record
			l0, l1, l2, l3:unsigned
		end;
	$iosb = [quad] record
			status : $word;		{ I/O status }
			count : $uword;		{ Byte count of transfer }
			dev_dep : unsigned	{ Device-dependent info. }
		end;
	SCR$BUFFER_TYPE = packed array [1..2000] of char;

{*****	module CLI$	*****}
{ command interpreter call-back routines and values }

const
	CLI$_ABSENT = 229872;		{ a failure status }
	CLI$_CONCAT = 261417;			{ a success status }
	CLI$_DEFAULTED = 261409;		{ a success status }
	CLI$_NEGATED = 229880;		{ a failure status }
	CLI$_PRESENT = 261401;			{ a success status }
var
	CLI$_LOCPRES, CLI$_LOCNEG : [external,value] integer;

[EXTERNAL]
function CLI$GET_VALUE (
	name : [readonly, class_s] packed array [a..b:integer] of char;
 %descr retbuf : varying [c] of char
	) : integer;	external;

[EXTERNAL]
function CLI$PRESENT (
	name : [readonly,class_s] packed array [a..b:integer] of char
	) : integer;	external;

{*****	module DSC$	*****}
{DELETED since it now exists in STARLET as of VMS V4}


{*****	module FOR$	*****}
{ Routines in the Fortran support library. }

[EXTERNAL]
function FOR$CVT_D_TD (
	%ref val : double;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_G_TD (
	%ref val : double;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_H_TD (
	%ref val : quadruple;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_D_TE (
	%ref val : double;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_G_TE (
	%ref val : double;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_H_TE (
	%ref val : quadruple;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_D_TF (
	%ref val : double;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_G_TF (
	%ref val : double;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_H_TF (
	%ref val : quadruple;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_D_TG (
	%ref val : double;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_G_TG (
	%ref val : double;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function FOR$CVT_H_TG (
	%ref val : quadruple;
	var out_str : [class_s] packed array [a..b:integer] of char;
	%immed digits_in_fract : integer;
	%immed scale_factor : integer := %immed 0;
	%immed digits_in_exp : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

{*****	module LIB$	*****}
{ Routines that are part of the Run-time Library }

[EXTERNAL,ASYNCHRONOUS]
function LIB$ADDX(
   %ref a,b: [unsafe,readonly] array[l..h: integer] of integer;
   %ref c:   [unsafe] array[l2..h2: integer] of integer;
        len: integer := 2): integer; extern;

[EXTERNAL,ASYNCHRONOUS]
function LIB$ASN_WTH_MBX(
   var dev_nam: [readonly,class_s] packed array[l..h: integer] of char;
       max_msg,buf_quo: integer;
   var dev_chn,mbx_chn: $uword): integer; extern;

[EXTERNAL, ASYNCHRONOUS]
function LIB$CALLG (
    %ref arglist : [unsafe, readonly] array [a..b:integer] of integer;
    %ref proc : [unsafe, readonly] integer
	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$DATE_TIME (
    %stdescr dst_str : [unsafe] packed array [a..b:integer] of char
	) : integer; external;
         
[EXTERNAL, ASYNCHRONOUS]
function LIB$DAY(
   var  day_number: integer;
        user_time: [readonly] $quad := %immed 0;
   %ref day_time: integer := %immed 0): integer; extern;

[EXTERNAL, ASYNCHRONOUS]
function LIB$DAY_OF_WEEK(
       time: [readonly] $quad := %immed 0;
   var day_num: integer): integer; extern;

[EXTERNAL, ASYNCHRONOUS]
function LIB$DISABLE_CTRL(
   var disable_msk: [readonly] unsigned;
   var old_msk: [truncate] unsigned
   ): integer; extern;

[EXTERNAL, ASYNCHRONOUS]
function LIB$DO_COMMAND(
   var cmd_txt: [readonly,class_s] packed array[l..h: integer] of char
        ): integer; extern;

[EXTERNAL, ASYNCHRONOUS]
function LIB$EMUL(
        multiplier,multiplicand,addend: integer;
   var  product: $quad
	): integer; extern;

[EXTERNAL, ASYNCHRONOUS]
function LIB$ENABLE_CTRL(
   var disable_msk: [readonly] unsigned;
   var old_msk: [truncate] unsigned
   ): integer; extern;

[EXTERNAL]
function LIB$ERASE_LINE (
  %ref line_no : integer := %immed 0;
  %ref col_no : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function LIB$FIND_FILE (
         file_name : [readonly, class_s] packed array [a..b:integer] of char;
     var result_name : varying [c] of char;
     var context : integer;
         default_name : [readonly, class_s] packed array [e..f:integer] of char
				:=%immed 0;
         related_name : [readonly, class_s] packed array [g..h:integer] of char
				:=%immed 0;
     var stv_addr : integer := %immed 0;
	 user_flags : unsigned := 0
	) : integer; external;

[EXTERNAL]
function LIB$FIND_IMAGE_SYMBOL (
	filename : [readonly,class_s] packed array [a..b:integer] of char;
	symbol_desc : [readonly,class_s] packed array [c..d:integer] of char;
    var symbol_val : integer
	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$FREE_EF (
	event: integer
	): integer; external;

[EXTERNAL]
function LIB$GET_COMMAND (
%stdescr get_str : packed array [a..b:integer] of char;
%stdescr prompt_str : packed array [c..d:integer] of char := %immed 0;
    %ref out_len : $uword := %immed 0
	) : integer; external;

[EXTERNAL]
function LIB$GETDVI (
       item_code: integer;
       channel: $uword := %immed 0;
       device_name: [class_s] packed array[a..b: integer] of char := %immed 0;
   var out_value: [unsafe] unsigned := %immed 0;
   var out_string: varying[c] of char := %immed 0):integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$GET_EF (
	var event : integer
	) : integer; external;

[EXTERNAL]
function LIB$GET_FOREIGN (
%stdescr get_str : packed array [a..b:integer] of char;
%stdescr user_prompt : packed array [c..d:integer] of char := %immed 0;
    %ref out_len : $word := %immed 0;
    %ref force_prompt : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function LIB$GET_INPUT (
%stdescr get_str : packed array [a..b:integer] of char;
%stdescr prompt_str : packed array [c..d:integer] of char := %immed 0;
    %ref out_len : $uword := %immed 0
	) : integer; external;

[EXTERNAL]
function LIB$GETJPI (
       item_code: integer;
   var process_id: $uword := %immed 0;
       process_name: [class_s] packed array[a..b: integer] of char := %immed 0;
   var out_value: [unsafe] unsigned := %immed 0;
   var out_string: varying[c] of char := %immed 0):integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$GET_SYMBOL (
   	symbol: packed array [sl..sh: integer] of char;
    var ret_buf: packed array [rl..rh: integer] of char;
    var ret_len: $uword := %immed 0;
        tbl_ind: integer := %immed 0): integer; extern;

[EXTERNAL]
function LIB$GET_VM (
	num_bytes : unsigned; var base_adr : integer
	) : integer; external;

[EXTERNAL]
function LIB$LOOKUP_KEY (
%stdescr search_str : packed array [a..b:integer] of char;
    %ref key_table : [unsafe] integer;
    %ref key_value : integer := %immed 0;
%stdescr full_str : packed array [c..d:integer] of char := %immed 0;
    %ref out_len : $word := %immed 0
	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$LP_LINES : integer;
    external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$MATCH_COND (
    %ref cond_val : [readonly, unsafe] integer;
    %ref cond_val_i : [readonly, unsafe, list] integer
	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
procedure LIB$MOVC3 (
	length : integer;
   %ref source : [readonly,unsafe] array[ll..hh: integer] of $ubyte;
   %ref dest :   [unsafe] array[ll2..hh2: integer] of $ubyte
	); external;

[hidden]
type
   translation_table = packed array[1..256] of char;
   {Should be array[char] of char but Pascal won't let us pass that
    as CLASS_S}

[EXTERNAL,ASYNCHRONOUS]
function LIB$MOVTC(
       src_str:   [CLASS_S] packed array[l1..h1: integer] of char;
       fill_char: [CLASS_S] char;
       trans_tbl: [CLASS_S,UNSAFE] translation_table;
   var dst_str:   [CLASS_S] packed array[l4..h4: integer] of char
   ): integer; extern;

[EXTERNAL,ASYNCHRONOUS]
function LIB$MOVTUC(
       src_str:   [CLASS_S] packed array[l1..h1: integer] of char;
       stop_char: [CLASS_S] char;
       trans_tbl: [CLASS_S,UNSAFE] translation_table;
   var dst_str:   [CLASS_S] packed array[l4..h4: integer] of char;
       fill_char: [CLASS_S,TRUNCATE] char
   ): integer; extern;

   {Note: This function does not return a condition code but the postion
    in src_str of the first stop_char, or zero if none}

[EXTERNAL]
function LIB$PUT_BUFFER (
  %immed old_buffer : integer := 0
	) : integer; external;

[EXTERNAL]
function LIB$PUT_OUTPUT (
%stdescr msg_str : [readonly, class_s] packed array [a..b:integer] of char
	) : integer; external;

[EXTERNAL]
function LIB$PUT_SCREEN (
%stdescr txt : packed array [lo..hi:integer] of char;
    %ref line_no : integer := %immed 0;
    %ref col_no : integer := %immed 0;
    %ref flags : integer := %immed 0
	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$SCOPY_DXDX (
%stdescr src_str : packed array [a..b:integer] of char;
%stdescr dst_str : packed array [c..d:integer] of char
	) : integer; external;

[EXTERNAL]
function LIB$SET_BUFFER (
%stdescr buffer : SCR$BUFFER_TYPE := %immed 0;
  %immed old_buffer : integer := 0
	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$SET_LOGICAL (
        log_nam: packed array[lnl..lnh: integer] of char;
        value:   packed array[vl..vh: integer] of char
        ) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$SET_SYMBOL (
   	symbol: packed array[sl..sh: integer] of char;
   	value:  packed array[vl..vh: integer] of char;
        table:  integer := %immed 0
   	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$SIGNAL (
  %immed cond : integer := %immed 1;
  %immed params : [list] integer := %immed 0
	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$SKPC(
   %descr c: char;
          str: [readonly,class_s] packed array[l..h: integer] of char
          ): integer; extern;

[EXTERNAL, ASYNCHRONOUS]
function LIB$STOP (
  %immed cond : integer := %immed 1;
  %immed params : [list] integer := %immed 0
	) : integer; external;

[EXTERNAL,ASYNCHRONOUS]
function LIB$SUBX(
   %ref a,b: [unsafe,readonly] array[l..h: integer] of integer;
   %ref c:   [unsafe] array[l2..h2: integer] of integer;
        len: [readonly] integer := 2): integer; extern;

[EXTERNAL]
function LIB$SYS_TRNLOG (
%stdescr logical_name : packed array [a..b:integer] of char;
     var dst_len : $word := %immed 0;
%stdescr dst_str : packed array [c..d:integer] of char;
         table : integer;
         acc_mode : integer := %immed 0;
         dsb_msk : integer := %immed 0
	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$TRA_EBC_ASC (
%stdescr source, dest :	packed array [a..b:integer] of char
	) : integer; external;

[EXTERNAL, ASYNCHRONOUS]
function LIB$TRIM_FILESPEC (
	 in_file : [class_s,readonly] packed array [a..b:integer] of char;
%stdescr out_file : packed array [c..d:integer] of char;
         width : [readonly,truncate] $uword;
     var out_len : [readonly,truncate] $uword
	) : integer; external;

{*****	module MTH$	*****}
{ Miscelaneous math routines. }

[EXTERNAL]
function MTH$JMAX0 (
	%ref num : [list] integer
	) : integer; external;

[EXTERNAL]
function MTH$JMIN0 (
	%ref num : [list] integer
	) : integer; external;

[EXTERNAL]
function MTH$RANDOM (
	%ref seed : [unsafe] integer
	) : real; external;

{*****	module OTS$	*****}


[EXTERNAL]		{ Convert signed decimal integer string to longword. }
function OTS$CVT_TI_L (
	inp_str : [readonly, class_s] packed array [a..b:integer] of char;
	var value_ : [unsafe] integer;
	%immed value_size : integer := %immed 4;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function OTS$CVT_T_D (
	inp_str : [readonly, class_s] packed array [a..b:integer] of char;
	var value_ : double;			{ [nog_floating] }
	%immed digits_in_fract : integer := %immed 0;
	%immed scale_factor : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function OTS$CVT_T_F (
	inp_str : [readonly, class_s] packed array [a..b:integer] of char;
	var value_ : real;
	%immed digits_in_fract : integer := %immed 0;
	%immed scale_factor : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function OTS$CVT_T_G (
	inp_str : [readonly, class_s] packed array [a..b:integer] of char;
	var value_ : double;			{ [g_floating] }
	%immed digits_in_fract : integer := %immed 0;
	%immed scale_factor : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

[EXTERNAL]
function OTS$CVT_T_H (
	inp_str : [readonly, class_s] packed array [a..b:integer] of char;
	var value_ : quadruple;
	%immed digits_in_fract : integer := %immed 0;
	%immed scale_factor : integer := %immed 0;
	%immed flags : integer := %immed 0
	) : integer; external;

{*****  module SOR$	*****}
var				{ Condition values and constants. }

	SORT$_FACILITY, SOR$_MISS_KEY, SOR$_WORK_DEV, SOR$_NO_WRK,
	SOR$_VM_FAIL, SOR$_WS_FAIL, SOR$_SORT_ON, SOR$_BAD_KEY,
	SOR$_NUM_KEY, SOR$_BAD_LEN, SOR$_ONE_IN, SOR$_IND_OVR,
	SOR$_INCONSIS, SOR$_VAR_FIX, SOR$_BAD_TYPE, SOR$_LRL_MISS,
	SOR$_BAD_SPEC, SOR$_BAD_LRL, SOR$_BAD_FILE, SOR$_BAD_ADR,
	SOR$_MAP, SOR$_EXTEND, SOR$_KEY_LEN, SOR$_CLEAN_UP,
	SOR$_BAD_MERGE, SOR$_BAD_ROUTIN, SOR$_INP_FILES, SOR$_BAD_ORDER,
	SOR$_DUP_OUTPUT, SOR$_MISS_PARAM, SOR$_END_SORT, SOR$_KEYED,
	SOR$_BAD_SRL, SOR$_NODUPEXC, SOR$_DELETE1, SOR$_DELETE2,
	SOR$_DELBOTH, SOR$_NYI, SOR$_RTNERROR, SOR$_KEYAMBINC,
	SOR$_OBS_0, SOR$_ROPRAND, SOR$_UNDOPTION, SOR$_STABLEEXC,
	SOR$_SRTIWA, SOR$_SPCOVR, SOR$_SPCMIS, SOR$_SPCSIS, SOR$_SPCIVP,
	SOR$_SPCIVS, SOR$_SPCIVC, SOR$_SPCIVF, SOR$_SPCIVD, SOR$_SPCIVX,
	SOR$_SPCIVK, SOR$_SPCIVI, SOR$_INCNOKEY, SOR$_INCNODATA,
	SOR$_INVFOLD, SOR$_OPERFAIL, SOR$_REQ_ALT, SOR$_USE_ALT,
	SOR$_COL_ADJ, SOR$_COL_CMPLX, SOR$_COL_CHAR, SOR$_COL_PAD,
	SOR$_COL_THREE, SOR$_BADDTYPE, SOR$_BADLENOFF, SOR$_BADOCCURS,
	SOR$_BADOVRLAY, SOR$_BADPROTCL, SOR$_CDDERROR, SOR$_ILLBASE,
	SOR$_ILLLITERL, SOR$_ILLSCALE, SOR$_INCDIGITS, SOR$_MISLENOFF,
	SOR$_MULTIDIM, SOR$_NOTRECORD, SOR$_SIGNCOMPQ, SOR$_UNSUPLEVL,
	SOR$GK_RECORD, SOR$GK_TAG, SOR$GK_INDEX, SOR$GK_ADDRESS,
	SOR$M_EBCDIC, SOR$M_MULTI, SOR$M_NODUPS, SOR$M_NOSIGNAL,
	SOR$M_SEQ_CHECK, SOR$M_STABLE, SOR$M_LOAD_FILL, SOR$V_EBCDIC,
	SOR$V_MULTI, SOR$V_NODUPS, SOR$V_NOSIGNAL, SOR$V_SEQ_CHECK,
	SOR$V_STABLE, SOR$V_LOAD_FILL, SOR$K_MAX_STAT, SOR$K_IDENT,
	SOR$K_REC_INP, SOR$K_REC_SOR, SOR$K_REC_OUT, SOR$K_LRL_INP,
	SOR$K_LRL_INT, SOR$K_LRL_OUT, SOR$K_NODES, SOR$K_INI_RUNS,
	SOR$K_MRG_ORDER, SOR$K_MRG_PASSES, SOR$K_WRK_ALQ, SOR$K_MBC_INP,
	SOR$K_MBC_OUT, SOR$K_MBF_INP, SOR$K_MBF_OUT
		: [external, value] integer;

type
    a_SOR$key_buffer = record			{ Key specification structure. }
	number_of_keys : [word] 1..255;
	key : array [1..255] of record	    { in major to minor order }
	    data_type : $uword;			{ a DSC$K_xxx value }
	    order : [word] 0..1;		{ Ascending=0, Descending=1 }
	    offset : $uword;			{ first byte = 0 }
	    key_length : $uword			{ # of bytes (digits) in key }
	    end
	end;

[external] function SOR$BEGIN_SORT (
    var key_buffer : [readonly] a_SOR$key_buffer;
    var irl : [readonly] $uword := %immed 0;
    var options : [readonly] integer := %immed 0;
    var file_alloc : [readonly] integer := %immed 0;
   %ref function user_compare (adrs1, adrs2, leng1, leng2, cntx : [reference] integer) : integer := %immed 0;
   %ref function user_equal (adrs1, adrs2, leng1, leng2, cntx : [reference] integer) : integer := %immed 0;
    var sort_process : [readonly] $byte := %immed 0;
    var work_files : [readonly] $byte := %immed 0;
    var context : integer := %immed 0
	) : integer; external;

[external] function SOR$END_SORT (
   var context : unsigned := %immed 0
	) : integer; external;

[external] function SOR$PASS_FILES (
    var inp_desc : [readonly, class_s] packed array [a..b:integer] of char := %immed 0;
    var out_desc : [readonly, class_s] packed array [c..d:integer] of char := %immed 0;
    var org : [readonly] $ubyte := %immed 0;
    var rfm : [readonly] $ubyte := %immed 0;
    var bks : [readonly] $ubyte := %immed 0;
    var bls : [readonly] $uword := %immed 0;
    var mrs : [readonly] $uword := %immed 0;
    var alq : [readonly] unsigned := %immed 0;
    var fop : [readonly] unsigned := %immed 0;
    var fsz : [readonly] $ubyte := %immed 0;
    var context : unsigned := %immed 0
	) : integer; external;

[external] function SOR$RELEASE_REC (
    var desc : [readonly, class_s] packed array [a..b:integer] of char;
    var context : unsigned := %immed 0
	) : integer; external;

[external] function SOR$RETURN_REC (
%stdescr desc : packed array [a..b:integer] of char;
     var len : $uword := %immed 0;
     var context : unsigned := %immed 0
	) : integer; external;

[external] function SOR$SORT_MERGE (
    var context : unsigned := %immed 0
	) : integer; external;

{*****	module STR$	*****}

[EXTERNAL]		{ <0 iff s1<s2, >0 iff s1>s2, =0 iff s1=s2 }
function STR$COMPARE (
	src1_str : [readonly, class_s] packed array [a..b:integer] of char;
	src2_str : [readonly, class_s] packed array [c..d:integer] of char
	) : integer; external;

[EXTERNAL]			{ =0 iff strings are equal }
function STR$COMPARE_EQL (
	src1_str : [readonly, class_s] packed array [a..b:integer] of char;
	src2_str : [readonly, class_s] packed array [c..d:integer] of char
	) : integer; external;

[EXTERNAL]
function STR$COPY_R (
    var dst_str : packed array [a..b:integer] of char;
        src_len : $uword;
        src_str : unsigned
	) : integer; external;

[EXTERNAL,ASYNCHRONOUS]
function STR$MATCH_WILD(
   cand_str: [CLASS_S] packed array[l1..h1: integer] of char;
   pattern_str: [CLASS_S] packed array[l2..h2: integer] of char
   ): integer; external;

[EXTERNAL,ASYNCHRONOUS] function STR$TRANSLATE(
   dst_str:   [CLASS_S] packed array[l1..h1: integer] of char;
   src_str:   [CLASS_S] packed array[l2..h2: integer] of char;
   trans_str: [CLASS_S] packed array[l3..h3: integer] of char;
   match_str: [CLASS_S] packed array[l4..h4: integer] of char
   ): integer; extern;

[EXTERNAL]
function STR$TRIM (
%stdescr dst_str : packed array [a..b:integer] of char;
%stdescr src_str : packed array [c..d:integer] of char;
    %ref out_len : $uword := %immed 0
	) : integer; external;

[EXTERNAL]
function STR$UPCASE (
%stdescr dst_str : packed array [a..b:integer] of char;
%stdescr src_str : [readonly] packed array [c..d:integer] of char
	) : integer; external;


{*****	module more RMS  *****}
{ Barely documented RMS routines}

[external(sys$setddir)] function $setddir(
   new: [class_s,readonly] packed array[nl..nh: integer] of char := %immed 0;
   var oldLen: $word := %immed 0;
   var old: [class_s] packed array[ol..oh: integer] of char := %immed 0
   ): integer; extern;


end.	{ General purpose library definitions. }
