$ v = f$verify(0)
$!
$! COMPARe DIRectories - Written by: J. B. Fischer / 27-Dec-1984
$!                                   MDSI / Ann Arbor,  Michigan
$!
$! This command procedure will examine two directories and
$! generate a report showing how the list of files in the
$! directories compare, and a command file that can be executed
$! (assuming sufficient privilege) to make the second directory
$! match the first. 
$! 
$! There are 3 sections to this procedure.
$! 
$! Section 1 determines the directory names to be examined and the
$! name of the report and command files to be generated. No
$! defaults exsist for the directories. The report default file
$! name is "COMPARDIR.RPT". The command file is defaulted to as
$! "REPAIRDIR.COM". 
$! 
$! Section 2 gathers the information about the contents of the two
$! directories by creating DIRECTORY output, rewrites the data to
$! remove superfluous data, then sorts the data. 
$! 
$! Section 3 reads the sorted data. Each file name in the sorted
$! file (duplicates ignored) is then looked-up in each of the
$! specified directories. Appropriate entries are then made in
$! each of the output files. 
$! 
$! GENERAL NOTES:
$! 
$! Currently, only the file NAME, TYPE, and VERSION are used to
$! determine a file name match. a difference in creation date,
$! size, protection, etc. are not (yet) used. 
$ goto section_1

$ section_1:
$ dir_1 = "''p1'"
$ dir_2 = "''p2'"
$ rpt_file = "''p3'"
$ com_file = "''p4'"
$!
$ if dir_1 .eqs. "" then $ inquire dir_1 "Enter base directory"
$ dir_1 = f$parse(dir_1,,,"NODE") + -
          f$parse(dir_1,,,"DEVICE") + -
          f$parse(dir_1,,,"DIRECTORY")
$!
$ if dir_2 .eqs. "" then $ inquire dir_2 "Enter secondary directory"
$ dir_2 = f$parse(dir_2,,,"NODE") + -
          f$parse(dir_2,,,"DEVICE") + -
          f$parse(dir_2,,,"DIRECTORY")
$!
$ if rpt_file .eqs. "" then $ inquire rpt_file "Enter report name"
$ rpt_file = f$parse(rpt_file,"compardir.rpt",)
$!
$ if com_file .eqs. "" then $ inquire com_file "Enter command file name"
$ com_file = f$parse(com_file,"repairdir.com",)
$!
$ goto section_2

$ section_2:
$!
$! Collect the directory content data - have DIR put the data into a file
$!
$ open/write dirs dirlist.lis
$ dir/col=1/notrail/nohead/nodate/nosize/noprotect/noown/out=dirs 'dir_1'
$ dir/col=1/notrail/nohead/nodate/nosize/noprotect/noown/out=dirs 'dir_2'
$ close dirs
$!
$! Rewrite the directory for use as a data file - remove DEVICE and DIRECTORY
$!
$ open/read foo_in dirlist.lis
$ open/write foo_out dirlist.dat
$ rewrite_dir_loop:
$ read/end=done foo_in fyl
$ if f$length(fyl) .eq. 0 then $ goto done
$ nm = f$parse(fyl,,,"NAME") + f$parse(fyl,,,"TYPE") + f$parse(fyl,,,"VERSION")
$ write foo_out "''nm'"
$ goto rewrite_dir_loop
$ done:
$ close foo_in
$ delete/nolog/noconfirm dirlist.lis;
$ close foo_out
$ done_rewriting:
$!
$! Sort the file names (note the VMS 4.0 file name length support)
$!
$ sort/key=(pos=1,size=85) dirlist.dat dirlist.dat
$ purge/nolog dirlist.dat
$ goto section_3

$ section_3:
$!
$! Open both output files and write headers.
$!
$ open/write compare_rpt 'rpt_file'
$ rpt = "write compare_rpt"
$ rpt " "
$ rpt "  COMPARE DIRECTORY REPORT - ''f$time()'"
$ rpt " "
$ line = f$fao("!1AS!50AS!4AS!50AS"," ",dir_1," |  ",dir_2," ")
$ rpt line
$ line = f$fao("!1AS!50AS!4AS!50AS"," ", " ", " |  ", " ", " ")
$ rpt line
$!
$ open/write repair_com 'com_file'
$ com = "write repair_com"
$ com "$!"
$ com "$! Directory Repair Command File - ''f$time()'"
$ com "$!"
$ com "$! The  Directory: ""''dir_2'"""
$ com "$! will look like: ""''dir_1'"""
$ com "$!"
$ goto reporting_loop

$ reporting_loop:
$!
$! Open the data file of sorted file names and see which directory
$! the file lives in (it's in one, the other, possibly both, but
$! never neither).
$!
$ open/read files dirlist.dat
$ last_file = ""
$ loop:
$ loc_1 = ""
$ loc_2 = ""
$ read /end=finished files file
$ if file .eqs. last_file then $ goto loop
$ last_file = file
$ file_1 = f$search(dir_1+file,0)
$ file_2 = f$search(dir_2+file,0)
$ if file_1 .nes. "" then $ loc_1 = file
$ if file_2 .nes. "" then $ loc_2 = file
$ line = f$fao("!1AS!50AS!4AS!50AS"," ",loc_1," |  ",loc_2," ")
$ rpt line       ! 105 column paper assumed - our special brand
$!
$ if "''file_1'" .eqs. "" then $ com "$ delete ''file_2'"
$ if "''file_2'" .eqs. "" then $ com "$ copy   ''file_1' ''dir_2'"
$ goto loop
$ finished:
$ close files
$ close compare_rpt
$ close repair_com
$ delete/nolog/noconfirm dirlist.dat;
$ if v then $ set verify
