	SUBROUTINE CHECK_QUALS (QUAL_USED, QUAL_VALUES)
C
C             Subroutine to determine which qualifiers were used
C              following the verb or a filename in the command.
C
	INCLUDE 'PERP.INC'
	INTEGER*4 RCODE
	INTEGER QUAL_USED (QUAL_COUNT)
C
	DO I = 1, QUAL_COUNT
C
C              Is qualifier present?
C
	  rcode = CLI$PRESENT(QUALS(I)(:QUAL_LTH(I)))
C
	  IF (rcode .eq. CLI$G_PRESENT) THEN 
C                   if used globally
              QUAL_USED (I) = USED_EXPLICITLY
C                   if qualifier needs a value
               IF ((QUAL_VALUE (I)).and.(.not.MULTI_VAL(I))) ICODE =
     *          CLI$GET_VALUE(QUALS(I)(:QUAL_LTH(I)),QUAL_VALUES(I))
C
               IF ((QUAL_VALUE (I)).and.(MULTI_VAL(I)))
     *          CALL MULTI_VALUE(QUAL_VALUES(I),I)
C                   
          ELSE IF (RCODE .EQ. CLI$L_PRESENT) THEN
C                   if used locally
	      QUAL_USED (I) = USED_LOC_EX
C                   if qualifier needs a value
               IF ((QUAL_VALUE (I)).and.(.not.MULTI_VAL(I))) ICODE =
     *          CLI$GET_VALUE(QUALS(I)(:QUAL_LTH(I)),QUAL_VALUES(I))
C
               IF ((QUAL_VALUE (I)).and.(MULTI_VAL(I)))
     *          CALL MULTI_VALUE(QUAL_VALUES(I),I)
C
	  ELSE IF (rcode .eq. CLI$G_NEGATED) THEN
C                   if globally negated
              QUAL_USED (I) = USED_NEGATED
C
          ELSE IF (RCODE .EQ. CLI$L_NEGATED) THEN
C                   if locally negated
              QUAL_USED (I) = USED_LOC_NEG
C
	  ELSE
            QUAL_USED (I) = USED_NOT
C
	  ENDIF
C
	ENDDO
	RETURN
	END
