C
C	Subroutine which is used to get the current BIN_DATE date,
C	convert a BIN_DATE date to DDMMYYYY format (or optionally to
C       DDMMMYYYY), or to convert DDMMYYYY (or optionally to DDMMMYYYY)
C       to a BIN_DATE date.
C
C	CALL CVDATE ( IDATE , BIN_DATE, CHAR_DATE [, IOPT ] )
C
C	  IDATE   => A three-word integer array which is defined as
C		     follows:
C		     IDATE (1) => Numeric day of month
C		     IDATE (2) => Numeric month
C		     IDATE (3) => Year
C	  BIN_DATE=> Contains the BIN_DATE date in seconds
C         CHAR_DATE=>ASCII date string (format DD-MMM-YYYY).
C	  IOPT    => For IOPT = 1, IDATE will be interpeted/returned
C                    as integer numbers; for IOPT = 2, IDATE will be
C                    interpeted/returned as integer and CHAR_DATE
C                    will be in the format of DD-MMM-YYYY; for IOPT = 3,
C	             BIN_DATE will be returned as the current date if
C	             BIN_DATE and IDATE(1) = 0. The default for IOPT is 1.
C
C	CVDATE is used as follows:
C		IDATE (1)	BIN_DATE	MEANING
C		---------	--------	-------
C		 .NE. 0				Convert IDATE to BIN_DATE
C		 .EQ. 0		 .EQ. 0		Return current BINARY date
C		 .EQ. 0		 .NE. 0		Convert BIN_DATE to IDATE
C
C	NOTE:  If a bad date is passed, CVDATE will return BIN_DATE and
C		IDATE (1) as zero.
C
	SUBROUTINE CVDATE(IDATE,BIN_DATE,CHAR_DATE,IOPT)
	IMPLICIT INTEGER (A-Z)
	INTEGER*4 BIN_DATE(2),MONTHS(12),MDATE
	INTEGER*4 IDATE(3),IOPT
	CHARACTER CHAR_DATE*11

	DATA MONTHS    /'JAN','FEB','MAR','APR','MAY','JUN',
     &                 'JUL','AUG','SEP','OCT','NOV','DEC'/

C
C	Check to see what type of date has been requested.
C
	IF (IDATE(1).NE.0) GOTO 300
	IF (BIN_DATE(1).NE.0) GOTO 300
C
C	Current date has been requested. Format can be integer based,
C	ASCII based, or binary based depending on OPT code. Default=1.
C

	IF ((IOPT.LT.1).OR.(IOPT.GT.3)) IOPT = 1

	CALL SYS$ASCTIM(,CHAR_DATE,)
	IF (IOPT.EQ.2) RETURN

	IF (IOPT.EQ.3) THEN
	CALL SYS$BINTIM(CHAR_DATE,BIN_DATE)
	RETURN
	END IF

	DECODE (3,40,CHAR_DATE(4:6)) MDATE
 40	FORMAT(A3)

	DECODE (2,45,CHAR_DATE(1:2)) IDATE(1)
 45	FORMAT(I2)
	DECODE (4,50,CHAR_DATE(8:11)) IDATE(3)
 50	FORMAT(I4)

	DO 100 I = 1,12
100	IF(MDATE .EQ. MONTHS(I)) GOTO 200
	I = 13
	IF (I.EQ.13)
     &  STOP'?Error converting from ASCII to integer month in CVDATE.'
200	IDATE(2) = I
	RETURN

C
C	Conversion from integer/ASCII date to binary date or conversion
C	to the opposite has been requested.
C

300	IF(IDATE(1).EQ.0) GOTO 800

C
C	Convert from integer/ASCII to binary date.
C

	IF((IOPT.LT.1).OR.(IOPT.GT.3)) IOPT = 1

	IF (IOPT.EQ.2) GOTO 700

	DO 500 I = 1,12
	IF(IDATE(2).EQ.I) MDATE = MONTHS(I)
500	IF(IDATE(2).EQ.I) GOTO 600
	I = 13

	IF (I.EQ.13)
     &  STOP'?Error converting from integer to ASCII month in CVDATE.'

600	ENCODE (11,650,CHAR_DATE) IDATE(1),MDATE,IDATE(3)
650	FORMAT(I2,'-',A3,'-',I4)

700	CONTINUE
	CALL SYS$BINTIM(CHAR_DATE,BIN_DATE)

	RETURN

C
C	Convert from binary date to integer date.
C

800	CONTINUE

	IF ((IOPT.LT.1).OR.(IOPT.GT.3)) IOPT = 1

	CALL SYS$ASCTIM(,CHAR_DATE,BIN_DATE,)
	IF (IOPT.EQ.2) RETURN

	DECODE (3,40,CHAR_DATE(4:6)) MDATE
	DECODE (2,45,CHAR_DATE(1:2)) IDATE(1)
	DECODE (4,50,CHAR_DATE(8:11)) IDATE(3)

	DO 1000 I = 1,12
1000	IF(MDATE .EQ. MONTHS(I)) GOTO 1100
	I = 13
	IF(I.EQ.13)
     &  STOP'?Error converting from ASCII to integer month in CVDATE.'
1100	IDATE(2) = I

	RETURN
	END
