	SUBROUTINE DAYPARSE(days)
	IMPLICIT INTEGER(A-Z)
	parameter CLI$_PRESENT_G   = '0003FD19'X
	parameter CLI$_PRESENT_L   = '0003FD31'X

	INTEGER*4 sys$position,beg_pos,end_pos,dash_pos
	INTEGER*4 cli$present, cli$get_value, icode, run_lth
	CHARACTER run_input*80
	CHARACTER run_check*55,run_range*3,dash*1
	CHARACTER*55 run_days(8)
	CHARACTER*3 day_name(7)
	LOGICAL days(7)


	DATA day_name /'SUN','MON','TUE','WED','THU','FRI','SAT'/

	index = 0
C
C	Get RUN_DAY information from the Command Language Interface.
C
	icode = cli$present('run_days')
	if (icode) then
	  do while (cli$get_value('run_days', run_input))
	    index = index + 1
	    icode = str$trim(run_days(index),run_input,run_lth)
	    call str$upcase(run_days(index),run_days(index))
	  enddo
	else
	index = 1
	run_days(index) = 'ALL'
	endif

	run_days(index+1) = 'DONE'

C
C	Did they specify ANY or ALL ?
C
	run_check = run_days(1)
	run_check = run_check(1:3)
	if ((run_check.EQ.'ALL').OR.(run_check.EQ.'ANY')) THEN
	DO 50 J = 1,7
	days(J) = .TRUE.
50	CONTINUE
	GOTO 1000
	end if

C
C	Is there a "-" at the start of a line? If so, the user wants
C	the days following to be excluded.
C

	if(run_check(1:1).EQ.'-') THEN
	EXCLUDE = .TRUE.
	DO 75 J = 1,7
	days(J) = .TRUE.
75	CONTINUE
	index = 1
	ELSE
	index = 0
	end if

C
C	Individual days were passed, so let's parse the string. Dashes
C	(-) in a given string infer ranges.
C

100	index = index + 1
	beg_pos = 1
	end_pos = LEN(run_days(index))
	dash    = '-'
	run_check = run_days(index)
	if(run_check.EQ.'DONE') GOTO 1000

	dash_pos  = str$position(run_check,dash)
	if(dash_pos.EQ.0) run_check = run_check(1:3)

C
C	No dashes mean only a single DAY has been requested.
C	Therefore, set the matched DAY = .true.
C

	if(dash_pos .EQ.0) THEN
	DO 200 I = 1,7
	if (run_check.EQ.day_name(I)) THEN
	if (.NOT.EXCLUDE) days(I) = .TRUE.
	if (EXCLUDE) days(I) = .FALSE.
	GOTO 250
	end if
200	CONTINUE
	STOP '%DAYPARSE-F-RUN_DAY Invalid day selected!'
250	CONTINUE
	GOTO 100
	end if


C
C	String has dashed ranges, but no commas. The selected DAY range
C	will simply be turned on, or off, depending on the exclude option.
C

	if(dash_pos .NE.0) THEN
	CALL STR$POS_EXTR(run_range,run_check,dash_pos+1,dash_pos+4)
300	CONTINUE
	DO 400 I = 1,7
	if (run_check(1:3).EQ.(day_name(I))) THEN
	  if (.NOT. EXCLUDE) days(I) = .TRUE.
	  if (EXCLUDE) days(I) = .FALSE.
	  GOTO 500
	end if
400	CONTINUE
	STOP '%DAYPARSE-F-RUN_DAY Invalid day range selected!'
500	run_check(1:3) = day_name(I+1)
	if( run_check(1:3).EQ.run_range ) THEN
	  if (.NOT. EXCLUDE) days(I+1) = .TRUE.
	  if (EXCLUDE) days(I+1) = .FALSE.
	GOTO 100
	ELSE
	GOTO 300
	end if !Run_check/run_range compare.

	end if !dash_pos
1000	CONTINUE
	RETURN
	end
