	SUBROUTINE CHECK_QUALS (QUAL_USED, QUAL_VALUES)
C
C             Subroutine to determine which qualifiers were used
C              following the verb or a filename in the command.
C
	INCLUDE 'NETPRINT.INC'
	INTEGER*4 RCODE
	INTEGER QUAL_USED (QUAL_COUNT)
C
	DO I = 1, QUAL_COUNT
C
C              Is qualifier present?
C
	  rcode = CLI$PRESENT(QUALS(I)(:QUAL_LTH(I)))
C
	  IF (rcode .eq. CLI$G_PRESENT) THEN 
C                   if used globally
              QUAL_USED (I) = USED_EXPLICITLY
C                   if qualifier needs a value
               IF (QUAL_VALUE (I)) ICODE =
     *          CLI$GET_VALUE(QUALS(I)(:QUAL_LTH(I)),QUAL_VALUES(I))
C                   
          ELSE IF (RCODE .EQ. CLI$L_PRESENT) THEN
C                   if used locally
	      QUAL_USED (I) = USED_LOC_EX
C                   if qualifier needs a value
	      IF (QUAL_VALUE(I)) ICODE = 
     *	        CLI$GET_VALUE(QUALS(I)(:QUAL_LTH(I)),QUAL_VALUES(I))
C
	  ELSE IF (rcode .eq. CLI$G_NEGATED) THEN
C                   if globally negated
              QUAL_USED (I) = USED_NEGATED
C
          ELSE IF (RCODE .EQ. CLI$L_NEGATED) THEN
C                   if locally negated
              QUAL_USED (I) = USED_LOC_NEG
C
	  ELSE
            QUAL_USED (I) = USED_NOT
C
	  ENDIF
C
	ENDDO
	RETURN
	END
C
C
	SUBROUTINE BUILD_LINE (LINE, LINE_LTH,
     *		GLOBAL_QUALS, LOCAL_QUALS, QUAL_VALUES)
C
C            Subroutine to build the qualifiers on a SUBMIT line.
C
	INCLUDE 'NETPRINT.INC'
	CHARACTER*132 LINE
	INTEGER	      LINE_LTH, VAL_LTH
	INTEGER       GLOBAL_QUALS(QUAL_COUNT), LOCAL_QUALS(QUAL_COUNT)
C
        VAL_LTH = 2
C
	DO I = 2, QUAL_COUNT-1
C   
C
	  IF ((LOCAL_QUALS(I) .EQ. USED_LOC_EX) .AND. 
     *            ( I .LT. PERP_QUAL)  .AND.
     *                (.NOT.(CLD_GLOB(I)))) THEN
	    LINE (LINE_LTH + 1 : LINE_LTH + 1) = '/'
	    LINE (LINE_LTH + 2 : LINE_LTH + QUAL_LTH(I) + 2)
     *					= QUALS (I) (:QUAL_LTH(I))
	    LINE_LTH = LINE_LTH + QUAL_LTH(I) + 1
C
C                     if qualifier needs a value
C
	    IF (QUAL_VALUE(I)) THEN
	      LINE (LINE_LTH + 1: LINE_LTH + 1) = '='
	      ICODE = STR$TRIM (QUAL_VALUES(I), QUAL_VALUES(I), VAL_LTH)
	      LINE (LINE_LTH + 2 : LINE_LTH + VAL_LTH + 2) =
     *						QUAL_VALUES(I)(:VAL_LTH)
	      LINE_LTH = LINE_LTH + VAL_LTH + 1
	    ENDIF
C
C                if used negated then add "NO"
C
          ELSE
           IF (LOCAL_QUALS(I) .EQ. USED_LOC_NEG) THEN
              LINE (LINE_LTH + 1 : LINE_LTH + 3) = '/NO'
              LINE (LINE_LTH + 4 : LINE_LTH + QUAL_LTH(I) + 4)
     *					= QUALS (I) (:QUAL_LTH(I))
              LINE_LTH = LINE_LTH + QUAL_LTH(I) + 3
            ENDIF
	  ENDIF
C
	ENDDO
	RETURN
        END
C
C
	SUBROUTINE GL_BLD_LINE (LINE, LINE_LTH,
     *		GLOBAL_QUALS, LOCAL_QUALS, QUAL_VALUES)
C
C               Subroutine to build the global qualifiers command line.
C            
	INCLUDE 'NETPRINT.INC'
	CHARACTER*132 LINE
	INTEGER	      LINE_LTH, VAL_LTH
	INTEGER       GLOBAL_QUALS(QUAL_COUNT), LOCAL_QUALS(QUAL_COUNT)
C
        VAL_LTH = 2
C
	DO I = 1, QUAL_COUNT-1
C
	  IF ((LOCAL_QUALS(I) .EQ. USED_EXPLICITLY)  .OR.
     *        (LOCAL_QUALS(I) .EQ. USED_LOC_EX)) THEN
	    LINE (LINE_LTH + 1 : LINE_LTH + 1) = '/'
	    LINE (LINE_LTH + 2 : LINE_LTH + QUAL_LTH(I) + 2)
     *						= QUALS (I) (:QUAL_LTH(I))
	    LINE_LTH = LINE_LTH + QUAL_LTH(I) + 1
C
C                   if qualifier need a value
C
	    IF (QUAL_VALUE(I)) THEN
	      LINE (LINE_LTH + 1: LINE_LTH + 1) = '='
	      ICODE = STR$TRIM (QUAL_VALUES(I), QUAL_VALUES(I), VAL_LTH)
	      LINE (LINE_LTH + 2 : LINE_LTH + VAL_LTH + 2) =
     *						QUAL_VALUES(I)(:VAL_LTH)
	      LINE_LTH = LINE_LTH + VAL_LTH + 1
	    ENDIF
C
C                   if used negated add "NO"
C
          ELSE
           IF ((LOCAL_QUALS(I) .EQ. USED_NEGATED) .OR.
     *         (LOCAL_QUALS(I) .EQ. USED_LOC_NEG)) THEN
              LINE (LINE_LTH + 1 : LINE_LTH + 3) = '/NO'
              LINE (LINE_LTH + 4 : LINE_LTH + QUAL_LTH(I) + 4)
     *					= QUALS (I) (:QUAL_LTH(I))
              LINE_LTH = LINE_LTH + QUAL_LTH(I) + 3
            ENDIF
	  ENDIF
C
	ENDDO
        RETURN
	END
