C  
C      Include file for PERP.FOR
C
C
C      Start of CLIDEF definitions
C
C             Return codes for CLI$PRESENT
C
        PARAMETER CLI$G_PRESENT   = '0003FD19'X
        PARAMETER CLI$L_PRESENT   = '0003FD31'X
        PARAMETER CLI$G_NEGATED   = '000381F8'X
        PARAMETER CLI$L_NEGATED   = '00038230'X
        PARAMETER CLI$_ABSENT     = '000381F0'X
C
C      End of CLIDEF definitions
C
        PARAMETER Qual_Count = 30     ! Number of qualifiers for SUBMIT.
C
        PARAMETER Qual_Size  = 15     ! Size of largest qualifier (in Chars)
C
        PARAMETER Value_Size = 512    ! Size of largest qualifier value
C
        PARAMETER Max_DOCMD_Length = 132
C
        PARAMETER Used_Explicitly = 1
C
        PARAMETER Used_Negated    = -1
C
        PARAMETER Used_Not        = 0
C  
        PARAMETER Used_Loc_Ex     = 2
C
        PARAMETER Used_Loc_Neg    = -2
C
        CHARACTER*(Qual_Size) Quals(Qual_Count)    ! Qualifier Names
        CHARACTER*(Value_Size) Qual_Values(Qual_Count) ! Qualifier Values
C
	INTEGER STR$TRIM
        INTEGER CLI$GET_VALUE
        INTEGER CLI$PRESENT
C
        INTEGER Qual_Lth(Qual_Count)          ! Lengths of qualifier names
C
        LOGICAL Qual_Value(Qual_Count)        ! Flag indicated if a 
                                              ! qualifier has values
        LOGICAL Cld_Glob(Qual_Count)          ! Flag indicating a global
                                              ! placement qualifier 
        LOGICAL Multi_Val(Qual_Count)         ! Flag indicating a multi
                                              ! value qualifier
C
C Standard SUBMIT Qualifier Lengths.
C
        DATA Qual_Lth /6, 6, 8, 15, 3, 7,  7, 7, 6, 7,  7, 4,
     *                 8, 4, 8,  8, 6, 4, 10, 7, 8, 5, 11, 7,
     *                 5, 3, 4,  8, 9, 7/
C
C Standard SUBMIT Qualifiers.
C
        DATA Quals /'BACKUP',            'BEFORE',      'BY_OWNER',
     *              'CHARACTERISTICS',   'CLI',         'CONFIRM',
     *              'CREATED',           'CPUTIME',     'DELETE',
     *              'EXCLUDE',           'EXPIRED',     'HOLD',
     *              'IDENTIFY',          'KEEP',        'LOG_FILE',
     *              'MODIFIED',          'NOTIFY',      'NAME',
     *              'PARAMETERS',        'PRINTER',     'PRIORITY',
     *              'QUEUE',             'RECORD_SIZE', 'RESTART',
     *              'SINCE',             'TAB',         'USER',
     *              'WSEXTENT',          'WSDEFAULT',   'WSQUOTA'/
C
C Standard SUBMIT Qualifiers with values.
C
        DATA Qual_Value /.FALSE.,    .TRUE.,     .TRUE.,
     *                   .TRUE.,     .TRUE.,     .FALSE.,
     *                   .TRUE.,     .TRUE.,     .FALSE.,
     *                   .TRUE.,     .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .TRUE.,
     *                   .FALSE.,    .FALSE.,    .TRUE.,
     *                   .TRUE.,     .TRUE.,     .TRUE.,
     *                   .TRUE.,     .TRUE.,     .FALSE.,
     *                   .TRUE.,     .FALSE.,     .TRUE.,
     *                   .TRUE.,     .TRUE.,     .TRUE./
C
C Standard SUBMIT Qualifiers that have multiple values.
C
	DATA Multi_Val  /.FALSE.,    .FALSE.,    .FALSE.,
     *                   .TRUE.,     .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .TRUE.,     .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .TRUE.,     .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE./
C
C Standard SUBMIT Qualifiers that are global.
C
        DATA Cld_Glob   /.FALSE.,    .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .TRUE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE.,
     *                   .FALSE.,    .TRUE.,     .FALSE.,
     *                   .FALSE.,    .TRUE.,     .FALSE.,
     *                   .FALSE.,    .FALSE.,    .FALSE./
C
C            End of include file
C
