	SUBROUTINE TIMEPARSE(time)
	IMPLICIT INTEGER(A-Z)
	parameter CLI$_PRESENT_G   = '0003FD19'X
	parameter CLI$_PRESENT_L   = '0003FD31'X

	INTEGER*4 current_time(2),binary_time(2),hold_time(2)
	INTEGER*4 str$position, beg_pos, end_pos, colon_pos, run_lth(24), count
	INTEGER*4 cli$present, cli$get_value, icode, hour, minute, check_count
	CHARACTER run_time(24)*17, time*5, run_input*17
	LOGICAL   delta_time, continue
	EXTERNAL  PERP_TIME,PERP_LIST

C
C	Get RUN_TIME information from the Command Language Interface.
C
	icode = cli$present('RUN_TIME')
	if (icode) then
	  count = 0
	  do while (cli$get_value('RUN_TIME', run_input))
	    count = count + 1
	    if (count.GT.24) CALL LIB$SIGNAL(PERP_LIST)
	    icode = str$trim(run_time(COUNT),run_input,run_lth(count))
	  enddo
	else
	time = ' '
	delta_time = .FALSE.
	goto 1000
	end if

C
C	Parse through string(s) and check for valid times.
C

	check_count = 0
	DO WHILE (check_count .lt. count)
	check_count = check_count + 1
C
C	Check for delta_time and convert to proper ASCII time.
C
	 IF (run_time(CHECK_COUNT)(1:1).EQ.'+') THEN
	   delta_time = .true.
	   IF (STR$POSITION(run_time(CHECK_COUNT)
     &     (1:run_lth(CHECK_COUNT)),' ').ne.0)
     &     CALL LIB$SIGNAL(PERP_TIME)
	   run_time(CHECK_COUNT) = '0 ' // run_time(CHECK_COUNT)(2:)
	   icode = SYS$GETTIM(current_time)
	   icode = SYS$BINTIM(run_time(CHECK_COUNT),hold_time)
	   icode = LIB$SUBX(current_time,hold_time,binary_time)
	   icode = SYS$ASCTIM(,run_input(1:8),binary_time,%val(1))
	    if (.not. icode) CALL LIB$SIGNAL(PERP_TIME)
	   run_time(CHECK_COUNT) = run_input(1:8)
	 ENDIF !Delta time check.
C
C	Check for valid time.
C
	run_input = '0 ' // run_time(CHECK_COUNT)(1:8)
	icode = SYS$BINTIM(run_input,binary_time)
	icode = SYS$ASCTIM(,run_input(1:8),binary_time,%val(1))
	if (.not. icode) CALL LIB$SIGNAL(PERP_TIME)
	run_time(CHECK_COUNT) = run_input(1:8)

	ENDDO !Time check.

C
C	Now sort the times.
C
	continue = .true.
	I = 0
	DO WHILE (continue)
	 I = I + 1
	  IF (I .lt. check_count) THEN
		DO J = I + 1, check_count
		   IF (run_time(I) .gt. run_time(J)) THEN
			run_input   = run_time(J)
			run_time(J) = run_time(I)
			run_time(I) = run_input
		   ENDIF !Sort_check.
		ENDDO !End of inner bubble of sort.
	  ELSE
	   continue = .false.
	  ENDIF ! Check_count.
	ENDDO !End of outer bubble of sort.
C
C	Now pick the time to use.
C
	continue = .true.
	count = 0
	icode = SYS$GETTIM(current_time)
	icode = SYS$ASCTIM(,run_input(1:8),current_time,%val(1))
	if (.not. icode) CALL LIB$SIGNAL(PERP_TIME)
	DO WHILE (continue)
	 IF ((count .eq. check_count).and.(continue)) THEN
	  count = 1
	  continue = .false.
	 ENDIF
	 IF (continue) THEN
	  count = count + 1
	  if (run_input .le. run_time(COUNT)) continue = .false.
	 ENDIF
	ENDDO !End of pick time.

	icode = str$trim(run_time(COUNT),run_time(COUNT),end_pos)
	time = run_time(COUNT)(1:end_pos)

1000	continue
	return
	end
