$!++ la50_print_queue.com
$!
$!     5 May 1986    J. R. Cutler
$!
$!    This procedure is called at boot time to initiate the 
$!    LA50 print queue.  The queue manager must be active
$!    before this procedure is invoked.
$!
$!    Inputs:
$!        la50_print_terminal    parameter 1
$!        la50_queue_name        parameter 2
$!        la50_queue_owner       parameter 3
$!
$!    Effects:
$!        o  Several forms are defined
$!        o  The terminal characteristics are set
$!        o  The terminal is set spooled
$!        o  The queue is defined and started
$!
$!--
$
$
$!        LA50 PRINTER DEVICE and QUEUE NAME
$
$    la50_print_terminal    = p1
$    la50_queue_name        = p2
$    la50_queue_owner       = p3
$
$    if la50_print_terminal .eqs. "" then exit 274
$    if la50_queue_name     .eqs. "" then exit 274
$    if la50_queue_owner    .eqs. "" then exit 274
$
$
$    define /form   DEFAULT  0 /stock=standard ! so mail will print
$
$!        LA50 DEVICE CONTROL LIBRARY
$
$    la50_library           = "LA50_DEVCTL"
$
$
$!        LA50 FORMS
$
$    form_number = 51    ! Arbitrary start
$
$    define /form   LA50_DEFAULT       'form_number' -
	    /description=" 96 col  Draft" -
	    /setup=(defaults) -
	    /stock=standard -
	    /notruncate -
	    /width=96
$    form_number = form_number + 1
$
$    define /form   BIG_PRINT          'form_number' -
	    /description=" 48 col  Letter  6 cpi 4 lpi" -
	    /setup=(cpi_6,lpi_4,density_enhanced,rendition_bold_on) -
	    /stock=standard -
	    /truncate -
	    /width=48
$    form_number = form_number + 1
$
$    define /form   DOCUMENT           'form_number' -
	    /description=" 96 col  Letter" -
	    /setup=(cpi_12,density_enhanced) -
	    /stock=standard -
	    /notruncate -
	    /width=96
$    form_number = form_number + 1
$
$    define /form   DOCUMENT_10        'form_number' -
	    /description=" 80 col  Letter" -
	    /setup=(cpi_10,density_enhanced) -
	    /stock=standard -
	    /notruncate -
	    /width=80
$    form_number = form_number + 1
$
$    define /form   DOCUMENT_16        'form_number' -
	    /description="132 col  Letter" -
	    /setup=(cpi_16,density_enhanced) -
	    /stock=standard -
	    /notruncate -
	    /width=132
$    form_number = form_number + 1
$
$    define /form   DRAFT              'form_number' -
	    /description=" 96 col  Draft" -
	    /setup=(cpi_12) -
	    /stock=standard -
	    /notruncate -
	    /width=96
$    form_number = form_number + 1
$
$    define /form   DRAFT_10           'form_number' -
	    /description=" 80 col  Draft" -
	    /setup=(cpi_10) -
	    /stock=standard -
	    /notruncate -
	    /width=80
$    form_number = form_number + 1
$
$    define /form   LINE_DRAWING       'form_number' -
	    /description=" 80 col  Bold    8 lpi" -
	    /setup=(cpi_10,lpi_8,rendition_bold_on) -
	    /stock=standard -
	    /width=80
$    form_number = form_number + 1
$
$    define /form   LISTING            'form_number' -
	    /description="132 col  Draft" -
	    /setup=(cpi_16) -
	    /stock=standard -
	    /width=132
$    form_number = form_number + 1
$
$    define /form   NOTEBOOK           'form_number' -
	    /description=" 96 col  Draft   LM 12" -
	    /margin=left=12 -
	    /setup=(cpi_12) -
	    /stock=standard -
	    /truncate -
	    /width=96
$    form_number = form_number + 1
$
$    define /form   NOTEBOOK_10        'form_number' -
	    /description=" 80 col  Draft   LM 10" -
	    /margin=left=10 -
	    /setup=(cpi_10) -
	    /stock=standard -
	    /truncate -
	    /width=80
$    form_number = form_number + 1
$
$    define /form   NOTEBOOK_16        'form_number' -
	    /description="132 col  Draft   LM 17" -
	    /margin=left=17 -
	    /setup=(cpi_16) -
	    /stock=standard -
	    /truncate -
	    /width=132
$    form_number = form_number + 1
$
$    define /form   PRETTY_NOTEBOOK    'form_number' -
	    /description=" 96 col  Letter  LM 12" -
	    /margin=left=12 -
	    /setup=(cpi_12,density_enhanced) -
	    /stock=standard -
	    /truncate -
	    /width=96
$    form_number = form_number + 1
$
$    define /form   PRETTY_NOTEBOOK_10 'form_number' -
	    /description=" 80 col  Letter  LM 10" -
	    /margin=left=10 -
	    /setup=(cpi_10,density_enhanced) -
	    /stock=standard -
	    /truncate -
	    /width=80
$    form_number = form_number + 1
$
$
$!        TERMINAL SETUP
$
$    set noon
$
$    set terminal 'la50_print_terminal': -
	 /perm /speed=4800 /device=la100 -
	 /modem /nohang /page=66 /width=132 -
	 /nowrap /nobroad /dma -
	 /noupper /noset_speed
$
$    set device /spooled=la50_print 'la50_print_terminal'
$
$
$!        QUEUE INITIALIZE/START
$
$    initialize /queue /start 'la50_queue_name' -
		/on='la50_print_terminal': -
		/form=la50_default -
		/default=(noburst,nofeed,noflag,notrailer) -
		/noenable_generic -
		/schedule=nosize -
		/library='la50_library' -
		/separate=reset=defaults -
		/owner='la50_queue_owner' -
		/protection=(s:rwed,o:rwed,g:rwed,w)
$
$    exit
