$!***************************************************************************
$!									    *
$!  COPYRIGHT (c) 1983                                                      *
$!  By TECHNOLOGY DEVELOPMENT CORP.					    *
$!     621 Six Flags Drive, 						    *
$!     Arlington, Tx.							    *
$!     76012								    *
$!     (817) 461-1242							    *
$! 									    *
$!  THIS SOFTWARE IS FURNISHED WITHOUT LICENSE AND MAY BE USED AND  COPIED  *
$!  ONLY WITH THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.		    *
$! 									    *
$!  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE  *
$!  AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY T.D.C.		    *
$! 									    *
$!  TECHNOLOGY DEVELOPMENT CORP. ASSUMES NO RESPONSIBILITY FOR THE USE OR   *
$!  RELIABILITY OF THIS SOFTWARE. 				    	    *
$!									    *
$!***************************************************************************
$ !
$ !	This command file will allow a quick way of checking how much space
$ !	is left on the disks you have on the system. Works V3.x and V4.x of
$ !     VMS.
$ !
$ !
$	ESC[0,8]==27			!Symbol for an Escape
$	REVERSE:=="''ESC'[7m"		!Reverse Video
$	REVERSE[24,8]==%O155
$	NORMAL:=="''ESC'[0m"		!Normal (Standard)
$	NORMAL[24,8]==%O155
$	BLINK:=="''ESC'[5m"		!Blinking Display
$	BOLD:=="''ESC'[1m"		!Bold Video
$       BELL[0,8]      = 7
$	SAY:==WRITE SYS$OUTPUT
$       FINAL_FREE_BLOCKS = 0
$       FINAL_FREE_BYTES = 0
$ 	FINAL_MAX_BLOCKS = 0
$	FINAL_PCT_USED = 0
$	FINAL_BLOCKS_USED = 0
$ !
$ ! BOLD_BLINK_ON  = ESC + "[1;5;m"
$ ! BOLD_BLINK_OFF = ESC + "[0;m"
$ !
$ ALERT = 85
$ !
$ SET TERM/WIDTH=80                     ! Clear screen
$ SAY "                    ",REVERSE+BOLD,"Disk Space Status",NORMAL
$ SAY ""
$ SAY ""
$ DEASSIGN SYS$OUTPUT
$ DEFINE SYS$OUTPUT DISK.TMP
$ SHOW DEVICES D
$ DEASSIGN SYS$OUTPUT
$ !
$ !
$ EXTRACT_START = 2
$ IF F$EXTRACT(0,2,F$GETSYI("VERSION")) .NES. "V3" THEN EXTRACT_START = 0
$ !
$ OPEN DISK DISK.TMP
$ READ/END=DONE DISK RECORD
$ READ/END=DONE DISK RECORD
$ READ/END=DONE DISK RECORD
$ !
$LOOP:
$ READ/END=DONE DISK RECORD
$ NAM = F$EXTRACT(EXTRACT_START,5,RECORD)
$ !
$ IF .NOT. F$GETDVI(NAM,"MNT") THEN GOTO NOT_MOUNTED
$ IF F$GETDVI(NAM,"FOR") THEN GOTO MOUNTED_FOREIGN
$ !
$ FREE_BLOCKS = F$GETDVI(NAM,"FREEBLOCKS")
$ FREE_BYTES  = FREE_BLOCKS * 512
$ !
$ MAX_BLOCKS  = F$GETDVI(NAM,"MAXBLOCK")
$ !
$ BLOCKS_USED = MAX_BLOCKS - FREE_BLOCKS
$ PCT_USED = BLOCKS_USED * 100 / MAX_BLOCKS
$ !
$ FINAL_FREE_BLOCKS = FINAL_FREE_BLOCKS + FREE_BLOCKS
$ FINAL_MAX_BLOCKS = FINAL_MAX_BLOCKS + MAX_BLOCKS
$ !
$ IF PCT_USED .GT. ALERT THEN GOTO ALARM
$ !
$ PHRASE = F$FAO(" !6AS!3SL Percent full, !7SL Blocks free (!10SL Bytes)",NAM,PCT_USED,FREE_BLOCKS,FREE_BYTES)
$ WRITE SYS$OUTPUT PHRASE
$ GOTO LOOP
$ !
$ALARM:
$ PHRASE = F$FAO(" !6AS!AS!3SL!AS Percent full, !AS!7SL!AS Blocks free (!10SL Bytes)",NAM,-
             BOLD+BLINK, PCT_USED,    NORMAL,-
             BOLD+BLINK, FREE_BLOCKS, NORMAL,FREE_BYTES)
$ WRITE SYS$OUTPUT PHRASE
$ GOTO LOOP
$ !
$NOT_MOUNTED:
$ WRITE SYS$OUTPUT " ''NAM' On line, but not mounted"
$ GOTO LOOP
$ !
$MOUNTED_FOREIGN:
$ WRITE SYS$OUTPUT " ''NAM' Mounted foreign"
$ GOTO LOOP
$ !
$DONE:
$ CLOSE DISK
$ !
$ FINAL_BLOCKS_USED = FINAL_MAX_BLOCKS - FINAL_FREE_BLOCKS
$ FINAL_PCT_USED = FINAL_BLOCKS_USED * 100/FINAL_MAX_BLOCKS
$ FINAL_FREE_BLOCKS = FINAL_MAX_BLOCKS - FINAL_BLOCKS_USED
$ FINAL_FREE_BYTES = FINAL_FREE_BLOCKS * 512
$ !
$ SAY ""
$ SAY "                    ",REVERSE+BOLD,"System Totals",NORMAL
$ SAY ""
$ SAY "Total percentage of disk space used..... ",BOLD,FINAL_PCT_USED,NORMAL," Percent"
$ SAY "Total number of free blocks............. ",BOLD,FINAL_FREE_BLOCKS,NORMAL
$ SAY "Total number of free bytes.............. ",BOLD,FINAL_FREE_BYTES,NORMAL
$ !
$ DELETE/NOCONFIRM/NOLOG DISK.TMP;
$ EXIT
