$! CHECK TO MAKE SURE PRINTER IS HOOKED UP AND TURNED ON OR ELSE
$! YOU WILL GET A HUNG PROCESS!!!!!!
$ LOOP_MARK:
$ WRITE SYS$OUTPUT "THE PRINTER MUST BE TURNED ON NOW"
$ WRITE SYS$OUTPUT " "
$ INQUIRE PRT_ON " IS YOUR PRINTER TURNED ON NOW? [Y/N]
$ IF .NOT. PRT_ON THEN GOTO LOOP_MARK
$ END:
$	verify = f$verify()
$	set noon
$!	set ver
$!*************************************************************************
$! SIDECAR.COM
$! 
$! This procedure displays a file specified by the user to the terminal
$! port (if it exists, otherwise the file will be displayed on the screen).
$! The procedure is meant to control printers of the LA100 series or the
$! equivalent.
$!
$!*************************************************************************
$!
$! Calling sequence:-
$!	$@procedure_name [par1 [par2 [par3 [par4 [par5 [par6 [par7]]]]]]]
$! where
$! 	par1 = file to be printed
$! 	par2 = copies to be printed
$!	par3 = print quality
$!	par4 = form length in inches
$!	par5 = form width in inches
$!	par6 = vertical pitch
$!	par7 = horizontal pitch
$!
$! A piece of code for debugging purposes is imbedded in this procedure.
$! This code will write out to a file 'MYPID'.TMP in which all user inputs and
$! final command strings to the printer are stored.  To invoke the debug
$! code, respond with DEBUG FILE to the first question (which inquires the
$! file to be printed).
$! 
$!*************************************************************************
$!
$!		Edit History
$!
$!************************************************************************
$!
$! Pick up the parameters
$	print_file = p1
$	copies = p2
$	print_quality = p3
$	form_length = p4
$	form_width = p5
$	v_pitch = p6
$	h_pitch = p7
$!
$! Define the defaults
$	def_copies = "1"			
$	def_print_quality = "1"			!code 1 = draft, 2 = letter
$	def_form_length = "11"			!11 inches
$	def_form_width = "8.5"			!8.5 inches
$	def_v_pitch = "1"			!code 1 = 6 lpi
$	def_h_pitch = "1"			!code 1 = 10 cpi
$	debug = 0				!default is no debug
$	printing_finished = 0			!will be set to 1 when done
$	calling_routine = "ask_file"		!first question to ask
$	lines_per_page_terminal = 24
$	errmsg = "Illegal input, default value used."
$!
$! Define horizontal pitch codes.  Each cpi value is multiplied by 100
$	h_pitch_1 = 1000			!code 1 = 10 cpi 
$	h_pitch_2 = 1200			!code 2 = 12 cpi 
$	h_pitch_3 = 1320			!code 3 = 13.2 cpi 
$	h_pitch_4 = 1650			!code 4 = 16.5 cpi 
$	h_pitch_5 = 500 			!code 5 = 5 cpi 
$	h_pitch_6 = 600 			!code 6 = 6 cpi 
$	h_pitch_7 = 660 	 		!code 7 = 6.6 cpi 
$	h_pitch_8 = 825 			!code 8 = 8.25 cpi 
$!
$! Define vertical pitch codes
$	v_pitch_1 = 6				!code 1 = 6 lpi
$	v_pitch_2 = 8				!code 2 = 8 lpi
$	v_pitch_3 = 12				!code 3 = 12 lpi
$	v_pitch_4 = 2				!code 4 = 2 lpi
$	v_pitch_5 = 3				!code 5 = 3 lpi
$	v_pitch_6 = 4				!code 6 = 4 lpi
$!
$! Define escape sequences to control the printer port and the printer
$! and the terminal.
$	esc[0,31] = 27				!define the escape character
$	esc = f$extract (0, 1, esc)		!strip the nulls
$	formfeed[0,31] = 12			!define the escape character
$	cursor_home = esc + "[H"		!cursor home position
$	clear_screen = esc + "[2J"		!clear entire screen
$	restrict_scroll_region = esc + "[22;24r"!restrict scrolling region
$	position_cursor = esc + "[23;H"		!position cursor at line 23
$	clear_scroll_region = esc + "[1;24r"	!clear all scroll region
$	set_reverse_video = esc + "[7m"		!start reverse video
$	reset_reverse_video = esc + "[0m"	!stop using reverse video
$	def_bottom_margin = 1000		!bottom margin 1 inch * 1000
$	def_right_margin = 500  		!right margin 1/2 inch * 1000
$	set_enter_printer_controller = esc + "[5i"	!output to printer only
$	set_exit_printer_controller = esc + "[4i"	!stop output to printer
$	set_font_pitch = esc + "[?29h"		!set to font pitch
$!						!can only print 5/6/10/12 cpi
$	set_all_pitch = esc + "[?29l"		!set to all pitch can print all
$	set_6lpi = esc + "[1z"			!set to 6 lines/inch
$	set_8lpi = esc + "[2z"			!set to 8 lines/inch
$	set_12lpi = esc + "[3z"			!set to 12 lines/inch
$	set_2lpi = esc + "[4z"			!set to 2 lines/inch
$	set_3lpi = esc + "[5z"			!set to 3 lines/inch
$	set_4lpi = esc + "[6z"			!set to 4 lines/inch
$	set_1000cpi = esc + "[1w"		!set to 10 lines/inch
$	set_1200cpi = esc + "[2w"		!set to 12 lines/inch
$	set_1320cpi = esc + "[3w"		!set to 13.2 lines/inch
$	set_1650cpi = esc + "[4w"		!set to 16.5 lines/inch
$	set_500cpi = esc + "[5w"		!set to 5 lines/inch
$	set_600cpi = esc + "[6w"		!set to 6 lines/inch
$	set_660cpi = esc + "[7w"		!set to 6.6 lines/inch
$	set_825cpi = esc + "[8w"		!set to 8.25 lines/inch
$	set_lqp = esc + "[2""z"			!set to letter quality
$	set_dqp = esc + "[1""z"			!set to draft quality
$!
$! In case the user control_y's set the terminal back to the normal mode.
$	on control_y then goto exit
$!
$! Get the current terminal width.
$	cur_width = f$getdvi ("sys$output","devbufsiz")
$!
$! Identify itself and give brief instructions.
$!
$ ask_questions:
$	write sys$output cursor_home, clear_screen
$	type sys$input
+-------------+    ^    Printer Quality Code	1 : Draft quality
|             |    |	====================	2 : Letter quality
|             |    |
|   PRINTER   |		Vertical Pitch Code	1 : 6  lpi	2 : 8 lpi
|             |   Form	===================	3 : 12 lpi	4 : 2 lpi
|             | length     lpi = lines/inch	5 : 3  lpi	6 : 4 lpi
|   PAPER     |
|             |    |
|             |    |	Vertical Pitch Code	1 : 10   cpi	2 : 12   cpi*
|             |    |	===================	3 : 13.2 cpi*#	4 : 16.5 cpi*
+-------------+    v	cpi = character/inch	5 : 5    cpi	6 : 6    cpi*
			* draft quality only	7 : 6.6  cpi*#	8 : 8.25 cpi*
<--  form  --->		# not for LA50
    width
$	write sys$output set_reverse_video, -
"DEFAULTS ARE SUPPLIED IN BRACKETS.                                           "
$	write sys$output -
"RETURN    indicates the use of default to the current question.              "
$	write sys$output -
"BACK      goes to ask the previous question.                                 "
$	write sys$output -
"END       uses defaults for the current and all upcoming questions.          "
$	write sys$output -
"CONTROL/C to abort.                                            HELP for help "
$	write sys$output reset_reverse_video
$!
$! Restrict the scrolling region
$	write sys$output restrict_scroll_region, position_cursor
$!
$! Go to the proper routine and start executing.
$	goto 'calling_routine'
$!
$! Find out which file to print.
$!
$ ask_file:
$	if print_file .nes. "" then goto ask_file1
$	inquire print_file "File to print to VDT printer [exit]"
$	if print_file .nes. "DEBUG FILE" then goto ask_file1
$!
$! User want to invoke the debug code.  Set the switch blank out the last
$! response and reprompt.
$	debug = 1
$	print_file = ""
$	goto ask_file
$!
$ ask_file1:
$	if print_file .eqs. "" then printing_finished = 2
$	if print_file .eqs. "" then goto exit
$	if f$parse (print_file) .eqs. "" then goto ask_file2
$	if f$search (print_file) .nes. "" then goto ask_copies
$!
$ ask_file2:
$	write sys$output "File (''print_file') not found."
$	print_file = ""
$	goto ask_file
$!
$! Find out the number of copies to print.
$!
$ ask_copies:
$	if copies .nes. "" then goto ask_copies1
$	inquire copies " Number of copies to be printed [''def_copies']"
$	char1 = f$extract (0, 1, copies)
$	if char1 .eqs. "H" .or. char1 .eqs. "B" then copies = p2
$	if char1 .eqs. "H" then calling_routine = "ask_copies"
$	if char1 .eqs. "H" then goto help
$	if char1 .eqs. "B" then print_file = ""
$	if char1 .eqs. "B" then goto ask_file
$	if char1 .eqs. "E" then goto ask_copies0
$!	def_copies = copies
$!	if print_quality .eqs. "" then print_quality = def_print_quality
$!	if form_length .eqs. "" then form_length = def_form_length
$!	if form_width .eqs. "" then form_width = def_form_width
$!	if v_pitch .eqs. "" then v_pitch = def_v_pitch
$!	if h_pitch .eqs. "" then h_pitch = def_h_pitch
$!
$ ask_copies0:
$	if copies .eqs. "" then copies = def_copies
$!
$ ask_copies1:
$	copies = f$integer ("''copies'")
$	if copies .ne. 0 then goto ask_quality
$	copies = 1
$	write sys$output errmsg
$!
$! Find out the print quality
$!
$ ask_quality:
$	if print_quality .nes. "" then goto ask_quality1
$	inquire print_quality " Print quality code [''def_print_quality']"
$	char1 = f$extract (0, 1, print_quality)
$	if char1 .eqs. "H" .or. char1 .eqs. "B" then print_quality = p3
$	if char1 .eqs. "H" then calling_routine = "ask_quality"
$	if char1 .eqs. "H" then goto help
$	if char1 .eqs. "B" then copies = ""
$	if char1 .eqs. "B" then goto ask_copies
$	if char1 .eqs. "E" then goto ask_quality0
$!	print_quality = def_print_quality
$!	if form_length .eqs. "" then form_length = def_form_length
$!	if form_width .eqs. "" then form_width = def_form_width
$!	if v_pitch .eqs. "" then v_pitch = def_v_pitch
$!	if h_pitch .eqs. "" then h_pitch = def_h_pitch
$!
$ ask_quality0:
$	if print_quality .eqs. "" then print_quality = def_print_quality
$!
$ ask_quality1:
$	if print_quality .eqs. "1" .or. print_quality .eqs. "2" then -
	goto ask_quality2
$	print_quality = def_print_quality
$	write sys$output errmsg
$!
$ ask_quality2:
$!
$! Set up printer control string for pitch select and density select.
$!
$	if print_quality .eqs. "1" then set_quality = set_dqp
$	if print_quality .eqs. "1" then set_pitch_select_mode = set_all_pitch
$	if print_quality .eqs. "2" then set_quality = set_lqp
$	if print_quality .eqs. "2" then set_pitch_select_mode = set_font_pitch
$!
$! Find out the form length in inches
$!
$ ask_form_length:
$	if form_length .nes. "" then goto ask_form_length1
$	inquire form_length "Form length in inches [''def_form_length']"
$	char1 = f$extract (0, 1, form_length)
$	if char1 .eqs. "H" .or. char1 .eqs. "B" then form_length = p4
$	if char1 .eqs. "H" then calling_routine = "ask_form_length"
$	if char1 .eqs. "H" then goto help
$	if char1 .eqs. "B" then print_quality = ""
$	if char1 .eqs. "B" then goto ask_quality
$	if char1 .eqs. "E" then goto ask_form_length0
$!	form_length = def_form_length
$!	if form_width .eqs. "" then form_width = def_form_width
$!	if v_pitch .eqs. "" then v_pitch = def_v_pitch
$!	if h_pitch .eqs. "" then h_pitch = def_h_pitch
$!
$ ask_form_length0:
$	if form_length .eqs. "" then form_length = def_form_length
$!
$ ask_form_length1:
$	form_length = "''form_length'000"	!Multiply the length by 1000
$						!because DCL wants integers
$	answer_length = f$length (form_length)
$	point_index = f$locate (".", form_length)
$	if point_index .eq. answer_length then goto ask_form_length2
$	form_length = f$extract ( 0, point_index, form_length) + f$extract (point_index + 1 , 3, form_length)
$!
$ ask_form_length2:
$	form_length = f$integer ("''form_length'")
$	if form_length .nes. "0" then goto ask_form_width
$	form_length = f$integer (def_form_length)
$	write sys$output errmsg
$!
$! Find out the form width in inches
$!
$ ask_form_width:
$	if form_width .nes. "" then goto ask_form_width1
$	inquire form_width "Form width in inches [''def_form_width']"
$	char1 = f$extract (0, 1, form_width)
$	if char1 .eqs. "H" .or. char1 .eqs. "B" then form_width = p5
$	if char1 .eqs. "H" then calling_routine = "ask_form_width"
$	if char1 .eqs. "H" then goto help
$	if char1 .eqs. "B" then form_length = ""
$	if char1 .eqs. "B" then goto ask_form_length
$	if char1 .eqs. "E" then goto ask_form_width0
$!	form_width = def_form_width
$!	if v_pitch .eqs. "" then v_pitch = def_v_pitch
$!	if h_pitch .eqs. "" then h_pitch = def_h_pitch
$!
$ ask_form_width0:
$	if form_width .eqs. "" then form_width = def_form_width
$!
$ ask_form_width1:
$	form_width = "''form_width'000"		!Multiply the length by 1000
$						!because DCL wants integers
$	answer_length = f$length (form_width)
$	point_index = f$locate (".", form_width)
$	if point_index .eq. answer_length then goto ask_form_width2
$	f_w = form_width
$	form_width = f$extract (0, point_index, f_w)
$	f99 = f$extract (point_index + 1 , 3, f_w)
$	form_width = form_width + f99
$!
$ ask_form_width2:
$	form_width = f$integer ("''form_width'")
$	if form_width .nes. "0" then goto ask_v_pitch
$	form_width = f$integer (def_form_width)
$	write sys$output errmsg
$!
$! Find out the vertical pitch
$!
$ ask_v_pitch:
$	if v_pitch .nes. "" then goto ask_v_pitch1
$	inquire v_pitch "Vertical pitch code [''def_v_pitch']"
$	char1 = f$extract (0, 1, v_pitch)
$	if char1 .eqs. "H" .or. char1 .eqs. "B" then v_pitch = p6
$	if char1 .eqs. "H" then calling_routine = "ask_v_pitch"
$	if char1 .eqs. "H" then goto help
$	if char1 .eqs. "B" then form_width = ""
$	if char1 .eqs. "B" then goto ask_form_width
$	if char1 .eqs. "E" then goto ask_v_pitch0
$!	v_pitch = def_v_pitch
$!	if h_pitch .eqs. "" then h_pitch = def_h_pitch
$!
$ ask_v_pitch0:
$	if v_pitch .eqs. "" then v_pitch = def_v_pitch
$!
$ ask_v_pitch1:
$	if v_pitch .ges. "1" .and. v_pitch .les. "6" then goto ask_v_pitch2
$	v_pitch = def_v_pitch
$	write sys$output errmsg
$!
$ ask_v_pitch2:
$	lpi = v_pitch_'v_pitch'
$	set_vertical_pitch = set_'lpi'lpi
$	physical_lpp = lpi * form_length
$	physical_lpp = physical_lpp / 1000	!Reset back to actual value
$	physical_lpp = f$string (physical_lpp)
$	bottom_margin = lpi * (form_length - def_bottom_margin)
$	bottom_margin = bottom_margin / 1000	!Reset back to actual value
$	bottom_margin = f$string (bottom_margin)
$!
$! Find out the horizontal pitch
$!
$ ask_h_pitch:
$	if h_pitch .nes. "" then goto ask_h_pitch1
$	inquire h_pitch "Horizontal pitch code [''def_h_pitch']"
$	char1 = f$extract (0, 1, h_pitch)
$	if char1 .eqs. "H" .or. char1 .eqs. "B" then h_pitch = p7
$	if char1 .eqs. "H" then calling_routine = "ask_h_pitch"
$	if char1 .eqs. "H" then goto help
$	if char1 .eqs. "B" then v_pitch = ""
$	if char1 .eqs. "B" then goto ask_v_pitch
$	if char1 .eqs. "E" then goto ask_h_pitch0
$!	h_pitch = def_h_pitch
$!
$ ask_h_pitch0:
$	if h_pitch .eqs. "" then h_pitch = def_h_pitch
$!
$ ask_h_pitch1:
$	if h_pitch .ges. "1" .and. h_pitch .les. "8" then goto ask_h_pitch2
$	h_pitch = def_h_pitch
$	write sys$output errmsg
$!
$ ask_h_pitch2:
$	cpi = h_pitch_'h_pitch'
$	set_horizontal_pitch = set_'cpi'cpi
$	columns_per_page = cpi * (form_width - def_right_margin)
$	columns_per_page = columns_per_page / 100000	!Reset to actual value
$!
$! Display some info to user
$!
$ print_it:
$!
$! Clear the terminal and clear the scrolling region restriction.
$	write sys$output clear_screen, clear_scroll_region
$!
$! Change the terminal characteristics before printing
$	set_physical_form_size = esc + "[" + physical_lpp + "t"
$	set_logical_form_size = esc + "[" + ";" + bottom_margin + "r"
$!
$! The following file creation is for debugging purposes only.
$ debug_code:
$	if debug .ne. 1 then goto end_debug_code
$	open /write out 'mypid'.tmp
$	write out "print_file ",print_file
$	write out "copies ",copies
$	write out "print_quality ",print_quality
$	write out "form_length ",form_length
$	write out "form_width ",form_width
$	write out "v_pitch ",v_pitch
$	write out "h_pitch ",h_pitch
$	write out "set_enter_printer_controller ", set_enter_printer_controller
$	write out "set_exit_printer_controller ", set_exit_printer_controller
$	write out "set_pitch_select_mode ",set_pitch_select_mode
$	write out "set_vertical_pitch ",set_vertical_pitch
$	write out "set_horizontal_pitch ",set_horizontal_pitch
$	write out "set_physical_form_size ",set physical_form_size
$	write out "set_logical_form_size ",set_logical_form_size
$	write out "set_quality ",set_quality
$	write out "physical_lines_per_page ",physical_lpp
$	write out "logical_lines_per_page ",bottom_margin
$	write out "columns_per_page ",columns_per_page
$	close out
$!
$ end_debug_code:
$!
$!******************************************************************************
$!******************************************************************************
$!
$! When the bug with setting to letter quality from a VT102/BT131 is fixed,
$! reinstate the following statement and delete the statement following that.
$!
$!******************************************************************************
$!******************************************************************************
$!	write sys$output set_enter_printer_controller, -
$!	set_pitch_select_mode, -
$!	set_vertical_pitch, -
$!	set_horizontal_pitch, -
$!	set_quality
$	write sys$output set_enter_printer_controller, -
	set_pitch_select_mode, -
	set_vertical_pitch, -
	set_horizontal_pitch
$	set terminal /page = 0 /width = 'columns_per_page' /form
$	write sys$output set_exit_printer_controller
$ ask_again:
$	inquire /nopunctuation answer-
	"Is the paper in the printer aligned? [Y/N] CONTROL/C to abort: "
$	if .not. answer then goto ask_again
$	write sys$output "Document being printed.  CONTROL/C to abort.", -
	set_enter_printer_controller, -
	set_physical_form_size, -
	set_logical_form_size
$!
$! Print as many copies as requested each one followed by a formfeed
$!
$ loop_copies:
$	type 'print_file'
$	write sys$output formfeed
$	copies = copies - 1
$	if copies .ne. 0 then goto loop_copies
$	write sys$output set_exit_printer_controller
$	printing_finished = 1
$ exit:
$!
$! Reset the terminal characteristics
$	write sys$output set_exit_printer_controller
$	set terminal /page = 'lines_per_page_terminal' /noform -
	/width = 'cur_width'
$	write sys$output reset_reverse_video
$!
$! Display appropriate information
$	if printing_finished .eq. 0 then write sys$output -
	"Aborted by a CONTROL/C." 
$	if printing_finished .eq. 1 then write sys$output -
	"Printing finished." 
$!
$ abort:
$	verify = f$verify (verify)
$	exit
$!
$ help:
$!
$!******************************************************************************
$!
$! The calling routine is stored in the variable CALLING_ROUTINE for future
$! reference.
$!
$!******************************************************************************
$!
$! User wants to get help.  Clear screen and display whatever help is available.
$	write sys$output cursor_home, clear_screen
$	type sys$input
Depending on the printer you have attached to your video display terminal, you
may or may not be able to obtain a letter quality printing.  Examples of 
printers that can produce a letter quality output are LA50 and LA100.

If you choose to produce a letter quality output (quality code 2), the number
of characters per inch (the horizontal pitch, cpi for short) is restricted to
only 5 or 10 cpi (horizontal pitch code 5 or 1 respectively).  There is no 
restriction on the vertical pitch selection.

LA50 cannot print with horizontal pitch of 6.6 or 13.2 cpi (code 7 or 3
respectively).

To print a 132 column report on a 8-1/2 wide paper, use a horizontal pitch of
16.5 cpi (code 4).  (Draft quality of course.)

To produce standard size overhead transparencies, the following choice setting
produces reasonable results
		length: 11.000	    width: 8.500     quality: 2
		vertical pitch: 6	    horizontal pitch: 5
The original text should contain no more than 40 characters per line.

$	goto help_exit
$!
$ help_exit:
$	inquire/nopunctuation answer " RETURN to cont. or CONTROL/C to abort. "
$	goto ask_questions
