$!++ setprint.com
$!
$!	13 Mar 1986	J. R. Cutler
$!
$!	LA50 Printer Control Command File
$!
$!	This command procedure controls an printer
$!	connected to a VT100 or VT200 class terminal
$!	with a printer port and uses LA50 sequences.
$!
$!	It controls horizontal and vertical pitch, character set
$!	selection, forms eject and set TOF, and print density.
$!
$!	Help is included as part of the procedure.
$!
$!	$  SETPRINT :== "@device:[directory]SETPRINT"
$!--
$
$	USER_INPUT = f$edit( p1, "UPCASE, COLLAPSE, TRIM" )
$
$	Bell[0, 8]	= 7
$	BF_Off_Flag	= 0
$	BF_On_Flag	= 0
$	CS_Flag		= 0
$	CSI[0, 8]	= 27
$	CSI[1, 1]	:= "["
$	Dsp_Flag	= 0
$	Enhanced_Print	= 0
$	Error_Msg	=  "%SETPRINT-E-??????, ''Bell'"
$	Form_Feed[0, 8] = 12
$	HP_Flag		= 0
$	Normal_Print	= 0
$	P1_Specified	= 0
$	Page_Length	= 11
$	Put		= "Write Sys$Output "
$	Set_Form	= 0
$	SKP_Flag	= 0
$	Terminal_Flag	= 0
$	To_Printer	= CSI + "5i"
$	To_Display	= CSI + "4i"
$	Vertical_Pitch	= 6
$	VP_Flag		= 0
$
$	if USER_INPUT .nes. "" then P1_Specified = 1
$!
$!		Get the user input (From User if no P1)
$Start:
$	if P1_specified then goto Parse_Initialize
	if USER_INPUT .eqs. "" then -
	    read /end=Quit /prompt="_Command: " SYS$Command USER_INPUT
$
$	USER_INPUT = f$edit( USER_INPUT, "UPCASE, COLLAPSE, TRIM, UNCOMMENT" )
$	if USER_INPUT .eqs. "" then goto Help
$
$!		Begin with null strings and then build them up
$
$Parse_Initialize:
$	Element_Number	= 0
$	Command_String	= ""
$	Printer_String	= ""
$Parse:
$	Command_String	= Command_String + Printer_String
$	Printer_String	= ""
$
$!		Tokenize, the only separator is `,'
$
$	Token	= f$element( Element_Number, ",", USER_INPUT )
$	If Token .eqs. "," then Token = ""
$	Element_Number	= Element_Number + 1
$
$!		Separate the token into value and command
$
$	Command	= f$element( 0, "=", Token )
$	Value	= f$element( 1, "=", Token )
$	If Value .eqs. "=" then Value = ""
$
$!
$dispatch_command:
$	Command_length	= f$length( Command )
$
$	if Command_Length .eq. -
	    0			then goto -
	    Do_Commands
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "BOLD" )		then goto -
	    Set_Bold_Print
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "CHARACTER_SET" )	then goto -
	    Set_Char_Set
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "DRAFT" )		then goto -
	    Set_Draft
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "EJECT_PAGE" )	then goto -
	    Skip_Page
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "EXIT" )		then exit
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "HORIZONTAL_PITCH" ) then goto -
	    Set_Horizontal
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "LETTER" )		then goto -
	    Set_Letter
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "NORMAL" )		then goto -
	    Set_Normal_Print
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "LOG" )		then goto -
	    Print_Log
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "SET_TOP_OF_FORM" )	then goto -
	    Set_Top
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "TERMINAL_ONLY" )	then goto -
	    Set_Terminal
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "VERTICAL_PITCH" )	then goto -
	    Set_Vertical
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "HELP" )		then goto -
	    Help
$
$	if  Command		.eqs. f$extract( 0, Command_Length, -
	    "?")		then goto -
	    Help
$
$	goto Error

$	Do_Commands:
$!SKIP
$	if SKP_Flag	then Command_String = Form_Feed + Command_String
$!BOLD
$	if BF_On_Flag	then Command_String = Command_String + CSI + "1m"
$	if BF_Off_Flag	then Command_String = Command_String + CSI + "22m"
$!TOF
$	if Set_Form	then Command_String = Command_String + CSI + -
				f$string(Page_Length * Vertical_Pitch) + "t"
$!LETTER
$	if Enhanced_Print then Command_String = Command_String + CSI + "2""z"
$	if Normal_Print then Command_String = Command_String + CSI + "0""z"
$!EXIT
$	if Command_String .eqs. "" then exit
$!/LOG
$	if .not. Dsp_Flag then goto No_Log
$!		Display the selected functions for the user
$	Put " Printer control functions selected"
$	Put " "
$	if BF_On_Flag	then Put	" Bold Face enable"
$	if BF_Off_Flag	then Put	" Bold Face disable"
$	if CS_Flag	then Put	" Character set"
$	if Normal_Print	then Put	" Draft quality"
$	if HP_Flag	then Put	" Horizontal pitch"
$	if Enhanced_Print then Put	" Letter quality"
$	if Set_Form	then Put	" Reset Top of Form"
$	if SKP_Flag	then Put	" Eject Page"
$	if VP_Flag	then Put	" Vertical pitch"
$	if Terminal_Flag then Put	" Terminal Only"
$	Put " "
$No_Log:
$	if Terminal_Flag then goto Terminal_Only
$	Put To_Printer, Command_String, To_Display
$	Goto Quit
$Terminal_Only:
$	Put To_Display, Command_String
$Quit:	Exit

$Set_Bold_Print:
$	BF_On_Flag	= 1
$	BF_Off_Flag	= 0
$	goto Parse
$
$Set_Draft:
$	Enhanced_Print	= 0
$	Normal_Print	= 1
$	goto Parse
$
$Set_Letter:
$	Enhanced_Print	= 1
$	Normal_Print	= 0
$	goto Parse
$
$Set_Normal_Print:
$	BF_On_Flag	= 0
$	BF_Off_Flag	= 1
$	goto Parse
$
$Print_Log:
$	Dsp_Flag	= 1
$	goto Parse
$
$Skip_Page:
$	SKP_Flag	= 1
$	goto Parse
$
$Set_Top:
$	Set_Form	= 1
$	goto Parse
$
$Set_Char_Set:
$	CS_String	= ""
$	if Value .nes. "" then goto Set_G0	! set named?
$	Put Error_Msg, "Value required to set character set"
$	goto Help
$
$Set_G0:	! Character set selection / Value confirmation
$	CS0[0, 8]	= 27
$	CS0[1, 1]	:= "("
$	CS1[0, 8]	= 27
$	CS1[1, 1]	:= ")"
$	CS2[0, 8]	= 27
$	CS2[1, 1]	:= "*"
$	CS3[0, 8]	= 27
$	CS3[1, 1]	:= "+"
$
$	if (Value .eqs. "1") .or. -	! ASCII
     (Value .eqs. f$extract( 0, f$length(Value), "ASCII")) then -
	CS_String = CS_String + CS0 + "B" + CS1 + "B" + CS2 + "B" + CS3 + "B"
$
$	if (Value .eqs. "2") .or. -	! U.K.
     (Value .eqs. f$extract( 0, f$length(Value), "BRITAIN")) then -
	CS_String = CS_String + CS0 + "A" + CS1 + "A" + CS2 + "A" + CS3 + "A"
$!
$	if (Value .eqs. "3") .or. -	! Finland
     (Value .eqs. f$extract( 0, f$length(Value), "FINLAND")) then -
	CS_String = CS_String + CS0 + "5" + CS1 + "5" + CS2 + "5" + CS3 + "5"
$
$	if Value .eqs. "4" then -	! Finland (again)
	CS_String = CS_String + CS0 + "C" + CS1 + "C" + CS2 + "C" + CS3 + "C"
$
$	if (Value .eqs. "5") .or. -	! France
     (Value .eqs. f$extract( 0, f$length(Value), "FRANCE")) then -
	CS_String = CS_String + CS0 + "R" + CS1 + "R" + CS2 + "R" + CS3 + "R"
$
$	if (Value .eqs. "6") .or. -	! French Canadian
     (Value .eqs. f$extract( 0, f$length(Value), "FRENCH_CANANDIAN")) then -
	CS_String = CS_String + CS0 + "9" + CS1 + "9" + CS2 + "9" + CS3 + "9"
$
$	if Value .eqs. "7" then -	! French Canadian (again)
	CS_String = CS_String + CS0 + "Q" + CS1 + "Q" + CS2 + "Q" + CS3 + "Q"
$
$	if (Value .eqs. "8") .or. -	! Germany
     (Value .eqs. f$extract( 0, f$length(Value), "GERMANY")) then -
	CS_String = CS_String + CS0 + "K" + CS1 + "K" + CS2 + "K" + CS3 + "K"
$
$	if (Value .eqs. "9") .or. -	! Italian
     (Value .eqs. f$extract( 0, f$length(Value), "ITALY")) then -
	CS_String = CS_String + CS0 + "Y" + CS1 + "Y" + CS2 + "Y" + CS3 + "Y"
$
$	if (Value .eqs. "10") .or. -	! Japanese / Roman
     (Value .eqs. f$extract( 0, f$length(Value), "JIS_ROMAN")) then -
	CS_String = CS_String + CS0 + "J" + CS1 + "J" + CS2 + "J" + CS3 + "J"
$
$	if (Value .eqs. "11") .or. -	! Japanese / Katakana
     (Value .eqs. f$extract( 0, f$length(Value), "JIS_KATAKANA")) then -
	CS_String = CS_String + CS0 + "I" + CS1 + "I" + CS2 + "I" + CS3 + "I"
$
$	if (Value .eqs. "12") .or. -	! Norwegian / Danish
     (Value .eqs. f$extract( 0, f$length(Value), "NORWAY/DENMARK")) then -
	CS_String = CS_String + CS0 + "6" + CS1 + "6" + CS2 + "6" + CS3 + "6"
$
$	if Value .eqs. "13" then -	! Norwegian / Danish (again)
	CS_String = CS_String + CS0 + "E" + CS1 + "E" + CS2 + "E" + CS3 + "E"
$
$	if (Value .eqs. "14") .or. -	! Spanish
     (Value .eqs. f$extract( 0, f$length(Value), "SPAIN")) then -
	CS_String = CS_String + CS0 + "Z" + CS1 + "Z" + CS2 + "Z" + CS3 + "Z"
$
$	if (Value .eqs. "15") .or. -	! Swedish
     (Value .eqs. f$extract( 0, f$length(Value), "SWEDEN")) then -
	CS_String = CS_String + CS0 + "7" + CS1 + "7" + CS2 + "7" + CS3 + "7"
$!
$	if Value .eqs. "16" then -	! Swedish (again)
	CS_String = CS_String + CS0 + "H" + CS1 + "H" + CS2 + "H" + CS3 + "H"
$
$	if (Value .eqs. "17") .or. -	! DEC Standard MultiNational
     (Value .eqs. f$extract( 0, f$length(Value), "MULTINATIONAL")) then -
	CS_String = CS_String + CS0 + "<" + CS1 + "<" + CS2 + "<" + CS3 + "<"
$
$	if (Value .eqs. "18") .or. -	! VT-100 Graphics
     (Value .eqs. f$extract( 0, f$length(Value), "VT100_GRAPHICS")) then -
	CS_String = CS_String + CS0 + "0" + CS1 + "0" + CS2 + "0" + CS3 + "0"
$
$	if (Value .eqs. "19") .or. -	! mixed
     (Value .eqs. f$extract( 0, f$length(Value), "MIXED")) then -
	CS_String = CS_String + CS0 + "B" + CS1 + "0" + CS2 + "0" + CS3 + "0"
$
$	if f$length(CS_String) .gt. 12 then goto Ambiguous_CS
$	Printer_String = CS_String
$	if Printer_String .nes. "" then CS_Flag = 1
$	if Printer_String .nes. "" then goto Parse
$
$	Put Error_Msg, "Illegal character set selection: ", Value
$	goto Help
$
$
$Ambiguous_CS:
$	Put Error_Msg, "Ambiguous character set name given: ", Value
$	goto Help

$Set_Horizontal:
$	if Value .nes. "" then goto Set_CPI
$	Put Error_Msg, "Value required to set horizontal pitch"
$	goto Help
$
$Set_CPI:
$	if Value .eqs. "5"	then Printer_String = CSI + "5w"
$	if Value .eqs. "6"	then Printer_String = CSI + "6w"
$	if Value .eqs. "8.25"	then Printer_String = CSI + "8w"
$	if Value .eqs. "10"	then Printer_String = CSI + "1w"
$	if Value .eqs. "12"	then Printer_String = CSI + "2w"
$	if Value .eqs. "16.5"	then Printer_String = CSI + "4w"
$
$	if Printer_String .nes. "" then HP_Flag = 1
$	if Printer_String .nes. "" then goto Parse
$
$	Put Error_Msg, "Illegal horizontal pitch Value: ", Value
$	goto Help
$
$Set_Vertical:
$	if Value .nes. "" then goto Set_LPI
$
$	Put Error_Msg, "Value required to set vertical pitch"
$	goto Help
$
$Set_LPI:
$	Vertical_Pitch = f$integer(Value)
$	if Vertical_Pitch .eq. 2	then Printer_String = CSI + "4z"
$	if Vertical_Pitch .eq. 3	then Printer_String = CSI + "5z"
$	if Vertical_Pitch .eq. 4	then Printer_String = CSI + "6z"
$	if Vertical_Pitch .eq. 6	then Printer_String = CSI + "1z"
$	if Vertical_Pitch .eq. 8	then Printer_String = CSI + "2z"
$	if Vertical_Pitch .eq. 12	then Printer_String = CSI + "3z"
$
$	if Printer_String .nes. "" then VP_Flag = 1
$	if Printer_String .nes. "" then goto Parse
$
$	Put Error_Msg, "Illegal vertical pitch Value: ", Value
$	goto Help

$Set_Terminal:
$	Terminal_Flag = 1
$	Goto Parse
$Error:
$	Put Error_Msg, "Unrecognized Command: ", Token
$Help:
$ type sys$input

 BOLD (inverse of NORMAL)
 CHARACTER_SET=set, where `set' is the name or number from
    1 ASCII             7 French_Canadian  13 Norway/Denmark  19 Mixed
    2 Britain           8 Germany          14 Spain
    3 Finland           9 Italy            15 Sweden
    4 Finland          10 JIS_Roman        16 Sweden
    5 France           11 JIS_Katakana     17 Multinational
    6 French_Canadian  12 Norway/Denmark   18 VT100 Graphics 
 DRAFT (inverse of LETTER)
 EJECT_PAGE (eject paper)
 EXIT (do not execute commands)
 HORIZONTAL_PITCH=cpi, where `cpi' = 5, 6, 8.25, 10, 12, or 16.5
 LETTER (inverse of DRAFT)
 LOG (show settings)
 NORMAL (inverse of BOLD)
 SET_TOP_OF_FORM (set hardware)
 TERMINAL_ONLY (don't touch printer)
 VERTICAL_PITCH=lpi, where `lpi' = 2, 3, 4, 6, 8, or 12

$
$	USER_INPUT = ""
$	goto Start
