$ save_ver = f$verify(0)
$!
$! This command file is used to distribute files to all nodes in the
$! supplied list of nodes.
$!
$! Parameters are:
$!
$!    p1      source_spec      Required - given to COPY - "" at start will
$!                             turn on prompt mode for all parameters.
$!    p2      destination_spec given to COPY - *.*;* is default)
$!    p3      nodes            If null then reference SHIP$NODES logical.
$!                             If not null, then use value as logical name
$!                             which points to desired nodes. If that is also
$!                             null, use value as list of nodes, rather than
$!                             a pointer to nodes.  If both the parameter and
$!                             then logical SHIP$NODES is null then ship to
$!                             all nodes currently in the current network area.
$!                             "*" implies all nodes currently in any area
$!                             on the network.
$!    p4      user             (given to COPY for alternate DECNET login)
$!    p5      password         (given to COPY for alternate DECNET login)
$!
$!
$! Version Author Date        Comment
$!
$! 1.0     JBF                Initial release
$! 1.1     JXR    12-Mar-1985 Added support for DECNET access strings.
$! 2.0     JBF    25-Mar-1985 Added 'select-a-node' logic, reference to
$!                            SHIP$NODES. Also, if destination is specified
$!                            then a COPY is made to the local node. If the
$!                            destination is not specified then it is assumed
$!                            the source file is already in the correct spot.
$!                            Became VMS 4.0 dependent. Changed error messages.
$! 2.1     JBF    16-May-1985 Allow SHIP$NODES to be multi-valued.
$! 2.2     JBF    28-May-1985 Allow P3 to be either desired node list, or a
$!                            logical name of a desired node list.
$! 2.3     JBF     6-Jun-1985 Modified 'copy to local node' logic to copy
$!                            only when local node is in the node list.
$!
$ goto start_of_ship

$ start_of_ship:
$ say = "write sys$output"
$ say ""
$ say "(SHIP Version 2.3  6-Jun-1985)"
$ say ""
$ if f$extract (0, 2, f$getsyi("VERSION")) .eqs. "V4" then $ goto ship_v4
$ say ""
$ say "%SHIP-F-IVV - Incorrect Version of VMS - 4.0 or later is required"
$ say ""
$ exit
$ ship_v4:
$ open_flag   = "F"
$ create_flag = "F"
$ ON CONTROL_Y THEN $ GOTO NOMORE
$ ON ERROR     THEN $ GOTO NOMORE
$ if "''p1'" .nes. "" then $ goto gotparm
$ inquire/nopunc p1 "Ship File: "
$ if "''p1'" .eqs. "" then $ say "As requested... no files shipped."
$ if "''p1'" .eqs. "" then $ goto nomore
$ inquire/nopunc p2 "Destination File: "
$ inquire/nopunc p3 "Destination Nodes: "
$ inquire/nopunc p4 "Username: "
$ if "''p4'" .eqs. "" then $ goto gotparm
$ inquire/nopunc p5 "Password: "
$ if "''p5'" .eqs. "" then $ say "Value REQUIRED! Aborting SHIP..."
$ if "''p5'" .eqs. "" then $ goto nomore
$gotparm:
$ dest = "''p2'"
$ ship_local = "F"
$ if "''dest'" .nes. "" then $ ship_local = "T"
$ if "''dest'" .eqs. "" then $ dest = "*.*;*"
$ dest_nodes    = "''p3'"
$ desired_nodes = "SHIP$NODES"
$ if "''dest_nodes'" .nes. "" then $ desired_nodes = dest_nodes
$ if "''dest_nodes'" .eqs. "" then $ goto do_logical
$ if f$trnlnm("''dest_nodes'",,,,,"ACCESS_MODE") .eqs. "" then $ goto have_dest
$ do_logical:
$ dest_nodes = f$trnlnm("''desired_nodes'",,,,,)
$ value_count = f$trnlnm("''desired_nodes'",,,,,"MAX_INDEX")
$ if value_count .eq. 0 then $ goto have_dest
$ current_value = 0
$ value_loop:
$ current_value = current_value + 1
$ dest_nodes = dest_nodes + "," + f$trnlnm("''desired_nodes'",,current_value,,,)
$ if current_value .ne. value_count then $ goto value_loop
$ have_dest:
$ dest_nodes = f$edit (dest_nodes, "COLLAPSE,UPCASE,TRIM")
$ user = "''p4'"
$ if "''user'" .eqs. "" then $ goto have_params
$ if "''p4'" .eqs. "" then $ inquire/nopunc p5 "Password: "
$ if "''p5'" .eqs. "" then $ say "Value REQUIRED! Aborting SHIP..."
$ if "''p5'" .eqs. "" then $ goto nomore
$ user = "''user'" + " ''p5'"
$ have_params:
$ goto start

$start:
$ if f$search ("ship.tmp",0) .nes. "" then $ delete/nolog ship.tmp;*
$ ncp = "$NCP"
$ ncp show known nodes to ship.tmp
$ create_flag = "T"
$ open nodes ship.tmp
$ open_flag = "T"
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ line = f$edit (line, "COMPRESS,TRIM")
$ local_adr  = f$element (3, " ", line)
$ local_adr  = f$extract (0, f$locate(".",local_adr), local_adr)
$ local_name = f$element (4, " ", line) - "(" - ")"
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ read /end=nomore nodes line
$ goto ship_files

$ ship_files:
$ okay_to_copy = "F"
$ if f$locate (f$trnlnm("sys_name"), dest_nodes) .lt. -
     f$length (dest_nodes) then $ okay_to_copy = "T"
$ if dest_nodes .eqs. "*" then $ okay_to_copy = "T"
$ if .not. ship_local then $ okay_to_copy = "F"
$ if .not. okay_to_copy then $ goto read_again
$ say "Copying: ''p1' to ''dest'"
$ COPY 'p1' 'dest'
$ read_again:
$ read /end=nomore nodes line
$ line = f$edit (line, "COMPRESS,TRIM")
$ line_lth = f$length(line)
$ end_text = f$locate("Total of",line)
$ if line_lth .ne. end_text then $ goto nomore
$ node_adr  = f$element (0, " ", line)
$ node_adr  = f$extract (0, f$locate (".", node_adr), node_adr)
$ node      = f$element (1, " ", line) - "(" - ")"
$ reachable = f$element (2, " ", line)
$ sendable = "F"
$ if f$locate (node, dest_nodes) .lt. -
     f$length (dest_nodes) then $ sendable = "T"
$ if dest_nodes .eqs. "*" then $ sendable = "T"
$ if (dest_nodes .eqs. "") .and. -
     (node_adr .eqs. local_adr) then $ sendable = "T"
$ if .not. sendable then $ goto read_again
$ if reachable .eqs. "reachable" then $ goto ship_vax
$ say "%SHIP-W-NSNR: Node ""''node'"" skipped - not reachable"
$ goto read_again
$ship_vax:
$ if user .eqs. "" then $ say "Copying: ''p1' to ''node'::''dest'"
$ if user .nes. "" then $ say "Copying: ''p1' to ''node'""''user'""::''dest'"
$ if user .eqs. "" then $ COPY 'p1' 'node'::'dest'
$ if user .nes. "" then $ COPY 'p1' 'node'"''user'"::'dest'
$ goto read_again
$ nomore:
$ if open_flag then $ close nodes
$ open_flag   = "F"
$ if create_flag then $ delete/noconfirm/nolog ship.tmp;*
$ create_flag = "F"
$ if save_ver then $ set verify
