$	ON CONTROL_Y THEN GOTO Stop_it		! Controlled exit, close file.
$	len_buffer = 256			! Standard VT2xx length.
$	IF Terminal_type .EQS. "GO250" .OR. -	! If you use a GraphOn, it can
	   Terminal_type .EQS. "GO240" THEN -	! define a much longer buffer,
		len_buffer = 800		! including control-functions.
$	term_type = F$GETDVI ( "TT:", "DEVTYPE" )
$	IF term_type .LT. 110 THEN GOTO Err_Term_Type	! Skip if not a VT2XX terminal.
$	ASSIGN/NOLOG/job TT: SYS$OUTPUT		! Force to TT:.
$	esc = ""				! Escape character.
$	dcs = esc + "P"				! 7-bit device control string.
$	st = esc + "\"				! 7-bit stop string.
$	pc = "1"				! Load new values, clear those only.
$	pl = "1"				! Do not lock definitions.
$!
$	check = F$SEARCH ( "SHIFT_KEY_DEF" )	! Check for file.
$	IF check .EQS. "" THEN GOTO No_File
$	OPEN/READ in_file SHIFT_KEY_DEF		! Define the logical in LOGIN.COM.
$!
$ Read_loop:					! This is the read loop.
$	data_line = ""
$	READ/END_OF_FILE=Stop_it in_file -
			    data_line		! Read a record.
$	loc_comment = F$LOCATE ( "!", data_line )
$	loc_slash = F$LOCATE ( "/", data_line )	! Find slash in definition.
$	IF loc_slash .GE. loc_comment THEN -	! If no slash, no command.
	    GOTO Read_loop			! Get next data line.
$	len_buffer = len_buffer - (loc_comment - loc_slash - 1)
$	IF len_buffer .LT. 0 THEN GOTO Too_much_data
$	data_line = F$EXTRACT ( 0, loc_comment, data_line )
$	key_name = F$EXTRACT ( 0, loc_slash+1, data_line )
$	loc_tilda = F$LOCATE ( "~", data_line )	! Find return indicator.
$	len_data = F$LENGTH ( data_line )
$	IF loc_tilda .LT. len_data THEN -
	    data_line = F$EXTRACT ( 0, loc_tilda, data_line )
$!	data_line = F$EDIT ( data_line, "UPCASE" )
$	i = loc_slash+1
$	line = ""
$ Loop:
$	tmp = F$EXTRACT ( i, 1, data_line )
$	line = line + F$EXTRACT ( 1, 1, F$FAO ( "!XB", F$CVUI ( 4, 4, tmp ) ) )
$	line = line + F$EXTRACT ( 1, 1, F$FAO ( "!XB", F$CVUI ( 0, 4, tmp ) ) )
$	i = i + 1
$	IF i .LE. F$LENGTH ( data_line ) - 1 THEN GOTO Loop
$!
$	IF loc_tilda .LT. len_data THEN -
	    line = line + "0D"
$	line = dcs + pc + ";" + pl + "|" + key_name + line + st
$	WRITE SYS$OUTPUT "''line'"		! Write line to terminal.
$	GOTO Read_loop				! Get next data line.
$!
$ Stop_it:
$	SET TERMINAL TT:/INQUIRE
$	CLOSE in_file				! Close data file.
$ Xit:
$	EXIT					! All done.
$!
$ No_File:
$	WRITE SYS$OUTPUT "%LOADTXT_F, No key definition file."
$	WRITE SYS$OUTPUT "Please define the symbol SHIFT_KEY_DEF for the"
$	WRITE SYS$OUTPUT "file containing text strings for the function keys."
$	GOTO Xit
$ Err_Term_Type:
$	WRITE SYS$OUTPUT "%LOADTXT_F, TT: is not a VT2xx terminal."
$	GOTO Xit
$ Too_much_data:
$	WRITE SYS$OUTPUT "%LOADTXT_F, Too many bytes of data, 256 byte limit."
$	GOTO Stop_it
$!
$! The logical name SHIFT_KEY_DEF must be defined as the device, directory, and
$! file name for the key definition file.
$!
$! If terminal_type is not a defined symbol, you will always work in 256
$! byte buffers.  If you have a terminal, as we do, that has more capability,
$! write a command file or program to set terminal_type to a useful value
$! and test against it as we do for the GO250 and GO240.
$!
$! Also, in this case, you can alternatively define SHIFT_KEY_DEF to one
$! of various files, so that you can have definitions correct for your
$! given terminal or even process.
$!
